
//
// Effect Browser
//

mw.create_effect_browser = function()
{
    this.effectsdlg = new QDialog( this );
    var vb = new QVBoxLayout( this.effectsdlg );

    this.effects = Factory.loadui( 'effectbrowser.ui', null, this.effectsdlg );
    vb.addWidget( this.effects );
}

mw.add_action = function( act )
{
    var lv = this.effects.child( 'effects' );
    var txt = act.text.replace( /&/g, '' );

    lv.insertItem( txt );
}

mw.browse_effects = function()
{
    this.effects.child('preview').pixmap = lbl.pixmap;

    this.effectsdlg.exec();
}

/**
 * Creates the actions for the image effects and defines the functions that
 * provide the implementations.
 */
mw.create_all_effects = function( mw, ac )
{
    this.imgfx = new ImageFX();
 
    //
    // Water color
    //
    var action = new KAction( ac, 'watercolor_action' );
    action.text = '&Water Color';
    action.icon = 'imageeffect';

    mw.apply_watercolor = function()
    {
	this.img.setPixmap( lbl.pixmap );

	this.img = this.imgfx.contrast(this.img, 200);
	this.img = this.imgfx.despeckle(this.img);
	this.img = this.imgfx.despeckle(this.img);
	this.img = this.imgfx.despeckle(this.img);
	this.img = this.imgfx.sharpen(this.img);
	
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_watercolor' );
    this.add_action( action );

    //
    // To Gray
    //
    action = new KAction( ac, 'togray_action' );
    action.text = '&Grayscale';
    action.icon = 'imageeffect';

    mw.apply_togray = function()
    {
	this.img = this.imgfx.toGray(this.img, false);
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_togray' );
    this.add_action( action );

    //
    // Charcoal
    //
    action = new KAction( ac, 'charcoal_action' );
    action.text = '&Charcoal';
    action.icon = 'imageeffect';

    mw.apply_charcoal = function()
    {
	this.img = this.imgfx.charcoal(this.img, 0.2);
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_charcoal' );
    this.add_action( action );

    //
    // Implode
    //
    var action = new KAction( ac, 'implode_action' );
    action.text = '&Implode';
    action.icon = 'imageeffect';

    mw.apply_implode = function()
    {
	this.img = this.imgfx.implode(this.img, 30, 'white');
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_implode' );
    this.add_action( action );

    //
    // Emboss
    //
    action = new KAction( ac, 'emboss_action' );
    action.text = '&Emboss';
    action.icon = 'imageeffect';

    mw.apply_emboss = function()
    {
	this.img = this.imgfx.emboss(this.img);
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_emboss' );
    this.add_action( action );

    //
    // Normalize
    //
    action = new KAction( ac, 'normalize_action' );
    action.text = '&Normalize';
    action.icon = 'imageeffect';

    mw.apply_normalize = function()
    {
	this.img = this.imgfx.normalize(this.img);
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_normalize' );
    this.add_action( action );

    //
    // Equalize
    //
    action = new KAction( ac, 'equalize_action' );
    action.text = 'Equa&lize';
    action.icon = 'imageeffect';

    mw.apply_equalize = function()
    {
	this.img = this.imgfx.equalize(this.img);
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_equalize' );
    this.add_action( action );

    //
    // Despeckle
    //
    action = new KAction( ac, 'despeckle_action' );
    action.text = '&Despeckle';
    action.icon = 'imageeffect';

    mw.apply_despeckle = function()
    {
	this.img = this.imgfx.despeckle(this.img);
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_despeckle' );
    this.add_action( action );
}

mw.create_image_operations = function( mw, ac )
{
    var action;

    //
    // Crop
    //
    action = new KAction( ac, 'crop_action' );
    action.text = 'Crop...';
    action.icon = 'crop';

    mw.crop_image = function()
    {
	lbl.mousePressEvent = function(ev)
	{
	    lbl.startx = ev.x;
	    lbl.starty = ev.y;
	    lbl.lastx = ev.x;
	    lbl.lasty = ev.y;
	}

	lbl.mouseMoveEvent = function(ev)
	{
	    if (
		( Math.abs( lbl.lastx - ev.x ) > 2  )
		|| ( Math.abs( lbl.lasty - ev.y ) > 2  )
		) {
		    this.repaint4( Math.min( lbl.lastx, lbl.startx ),
				   Math.min( lbl.lasty, lbl.starty ),
				   Math.abs( lbl.lastx - lbl.startx ),
				   Math.abs( lbl.lasty - lbl.starty ) );

		    this.drawLine( ev.x, ev.y, ev.x, lbl.starty );
		    this.drawLine( ev.x, lbl.starty, lbl.startx, lbl.starty );
		    this.drawLine( lbl.startx, lbl.starty, lbl.startx, ev.y );
		    this.drawLine( lbl.startx, ev.y, ev.x, ev.y );
		    lbl.lastx = ev.x;
		    lbl.lasty = ev.y;
		}
	}

	lbl.mouseReleaseEvent = function(ev)
	{
 	    lbl.mousePressEvent = function(ev) {};
 	    lbl.mouseMoveEvent = function(ev) {};
 	    lbl.mouseReleaseEvent = function(ev) {};

	    var pix = new Pixmap();
	    var w = Math.abs( ev.x - lbl.startx );
	    var h = Math.abs( ev.y - lbl.starty );
	    pix.resize( w, h );
	    
//	    var p = new Painter();
//	    p.setDevice( lbl );
//	    p.drawRect( w/2, h/2, w/4, h/4 );

	    mw.img.setPixmap( pix );
	    mw.update_view();

// 	    var pix = lbl.pixmap;
// 	    pix.resize( Math.abs( ev.x - lbl.startx ), Math.abs( ev.y - lbl.starty ) );
// 	    mw.img.setPixmap( pix );
// 	    mw.update_view();
	}

    }

    action.connect( action, 'activated()', this, 'crop_image' );

    //
    // Resize
    //
    action = new KAction( ac, 'resize_action' );
    action.text = 'Resize...';
    action.icon = 'transform';

    mw.resize_image = function()
    {
	var dlg = Factory.loadui( 'resizeparams.ui', null, this );
	if ( !dlg.exec() ) {
	    return;
	}
	this.img.smoothScale( dlg.child('width_input').value,
			      dlg.child('height_input').value );
	this.update_view();
    }

    action.connect( action, 'activated()', this, 'resize_image' );

    //
    // Rotate right
    //
    action = new KAction( ac, 'rotate_right_action' );
    action.text = 'Rotate &Right';
    action.icon = 'rotate_cw';

    mw.apply_rotate_right = function()
    {
	this.img = this.imgfx.rotate( this.img, this.imgfx.Rotate90 );
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_rotate_right' );

    //
    // Rotate left
    //
    action = new KAction( ac, 'rotate_left_action' );
    action.text = 'Rotate &Left';
    action.icon = 'rotate';

    mw.apply_rotate_left = function()
    {
	this.img = this.imgfx.rotate( this.img, this.imgfx.Rotate90 );
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_rotate_left' );

    //
    // Mirror Vertical
    //
    action = new KAction( ac, 'mirror_vertical_action' );
    action.text = 'Mirror &Vertical';

    mw.apply_mirror_vertical = function()
    {
	this.img.mirror( false, true );
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_mirror_vertical' );

    //
    // Mirror Horizontal
    //
    action = new KAction( ac, 'mirror_horizontal_action' );
    action.text = 'Mirror &Horizontal';

    mw.apply_mirror_horizontal = function()
    {
	this.img.mirror( true, false );
	this.update_view();
    }

    action.connect( action, 'activated()', mw, 'apply_mirror_horizontal' );
}
