// zoom.h
//
// Part of KVIEWSHELL - A framework for multipage text/gfx viewers
//
// (C) 2002 Stefan Kebekus
// Distributed under the GPL

// Add header files alphabetically

#ifndef ZOOM_H
#define ZOOM_H

#include <qobject.h>
#include <qstringlist.h>


class zoom : public QObject
{
Q_OBJECT

public:
  /** Initializs the zoom with a default of 100% */
  zoom();

  /** Returns a list like "33%", "100%", etc. If you call
      zoomNames(void) more than once, it is guaranteed that the same
      list of strings will be returned. */
  QStringList zoomNames(void) const {return valueNames;};

  float       zoomIn(void);
  float       zoomOut(void);
  float       value(void) const {return _zoomValue;};

public slots:
  void        setZoomValue(float);
  void        setZoomValue(const QString &);

signals:
  void        zoomNamesChanged(const QStringList &);
  void        zoomNameChanged(const QString &);
  void        valNoChanged(int);

private:
  float       _zoomValue;
  QStringList valueNames;
  int         valNo; // This will be the number of the current value in the generated QStringList.
};

#endif
