.TH sane-gt68xx 5 "29 May 2005" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-gt68xx
.SH NAME
sane-gt68xx \- SANE backend for GT-68XX based USB flatbed scanners
.SH DESCRIPTION
The
.B sane-gt68xx
library implements a SANE (Scanner Access Now Easy) backend that provides
access to USB flatbed scanners based on the Grandtech GT-6801 and GT-6816
chips.  A list of supported scanners can be found on the gt68xx backend
homepage: 
.IR http://www.meier-geinitz.de/sane/gt68xx/ .
.PP
This is BETA software. Especially if you test new or untested scanners, keep
your hand at the scanner's plug and unplug it, if the head bumps at the end of
the scan area.
.PP
If you own a scanner other than the ones listed on the gt68xx homepage that works with this
backend, please let me know this by sending the scanner's exact model name and
the USB vendor and device ids (e.g. from
.I sane-find-scanner
or syslog) to me. Even if the scanner's name is only slightly different from
the models already listed as supported, please let me know.
.PP
If you own a scanner that isn't detected by the gt68xx backend but has a GT-6801
or GT-6816 chipset, you can try to add it to the backend. Have a look at the
following web page: 
.I http://www.meier-geinitz.de/sane/gt68xx-backend/adding.html
.PP
.SH KERNEL ISSUES
Please use libusb-0.1.6 or later. Without libusb or with older libusb versions
all kinds of trouble can be expected. The scanner should be found by
sane-find-scanner without further actions. For setting permissions and general
USB information looks at
.BR sane\-usb (5).
.PP

.SH FIRMWARE FILE
You need a firmware file for your scanner. That's a small file containing
software that will be uploaded to the scanner's memory. It's usually named
*.usb, e.g. 
.IR PS1fw.usb .
It comes on the installation CD that was provided by the manufacturer, but it
may be packaged together with the installation program in an .exe file. For
Mustek scanners, the file can be dowloaded from the gt68xx backend homepage. For
other scanners, check the CD for .usb files. If you only find *.cab files, try
cabextract to unpack. If everything else fails, you must install the Windows
driver and get the firmware from there (usually in the
.I windows/system
or
.I system32
directories). Put that firmware file into
.IR @DATADIR@/sane/gt68xx/ .
Make sure that it's readable by everyone.

.SH CONFIGURATION
The contents of the
.I gt68xx.conf
file is a list of usb lines containing vendor and product ids that correspond
to USB scanners. The file can also contain option lines.  Empty lines and
lines starting with a hash mark (#) are ignored.  The scanners are
autodetected by
.B usb vendor_id product_id
statements which are already included into
.IR gt68xx.conf .
"vendor_id" and "product_id" are hexadecimal numbers that identfy the
scanner. 
.PP
The 
.BR override ,
.BR firmware ,
.BR vendor ,
.BR model ,
and
.B afe
options must be placed after the
.B usb
line they refer to.
.PP
Option
.B override
is used to override the default model parameters. That's necessary for some
scanners that use the same vendor/product ids but are different. For these
scanners there are already commented out override lines in the configuration
file. 
.B override "mustek-scanexpress-1200-ub-plus"
is necessary for the Mustek Scanexpress 1200 UB Plus, the
Medion/Lifetec/Tevion LT 9452, and the Trust Compact Scan USB 19200.
.B override "artec-ultima-2000"
is used for the Artec Ultima 2000, the Boeder SmartScan Slim Edition, the
Medion/ Lifetec/ Tevion/ Cytron MD/LT 9385, the Medion/ Lifetec/ Tevion MD
9458, and the Trust Flat Scan USB 19200.
.B override "mustek-bearpaw-2400-cu"
is necessary for the Mustek BearPaw 2400 CU and the Fujitsu 1200CUS. The
.B override
option must be the first one after the 
.B usb
line.
.PP
Option
.B firmware
selects the name and path of the firmware file. It's only necessary if the
default (or override) doesn't work. The default firmware directory is
.IR @DATADIR@/sane/gt68xx/ .
You may need to create this directory. If you want to place the firmware files
at a different path, use a
.B firmware
line.
.PP
The 
.B vendor
and
.B model
options are not absolutely necessary but for convenience. Quite a lot of
scanners from different manufacturers share the same vendor/product ids so you
can set the "correct" name here.
.PP
The
.B afe
option allows to set custom offset and gain values for the Analog FrontEnd of
the scanner. This option can be either used to select the AFE values if
automatic coarse calibration is disabled, or to make automatic coarse
calibration faster. For the latter usage, enable debug level 3 (see below),
scan an image and look for debug line string with "afe". Copy this line to
.IR gt68xx.conf .
The option has six parameters: red offset, red gain, green offset, green gain,
blue offset, and blue gain.
.PP
A sample configuration file is shown below:
.PP
.RS
usb 0x05d8 0x4002
.br
override "mustek-scanexpress-1200-ub-plus"
.br
firmware "/opt/gt68xx/SBfw.usb"
.br
vendor "Trust"
.br
model "Compact Scan USB 19200"
.br
afe 0x20 0x02 0x22 0x03 0x1f 0x04
.RE

.SH FILES
.TP
.I @CONFIGDIR@/gt68xx.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-gt68xx.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-gt68xx.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_GT68XX
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend.  Higher debug levels
increase the verbosity of the output. If the debug level is set to 1 or higher,
some debug options become available that are normally hidden. Handle them with
care.

Example: 
export SANE_DEBUG_GT68XX=4

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-usb (5),
.BR sane\-artec_eplus48u (5)
.BR sane\-plustek (5),
.BR sane\-ma1509 (5),
.BR sane\-mustek_usb (5),
.BR sane\-mustek (5),
.BR sane\-mustek_pp (5)
.br
.I @DOCDIR@/gt68xx/gt68xx.CHANGES
.br
.I http://www.meier-geinitz.de/sane/gt68xx

.SH AUTHOR
Henning Meier-Geinitz <henning@meier-geinitz.de>
.br
The original gt68xx driver was written by Sergey Vlasov, Andreas Nowack, and
David Stevenson. Thanks for sending patches and answering questions to them
and all the other contributors.

.SH BUGS
Currently scanning seems to only work reliably under Linux. With FreeBSD,
NetBSD and OpenBSD scanning works only once. Then the scanner isn't detected
anymore and has to be replugged.
.PP
The first few lines of the image are garbage for the 2400 TA
Plus.
.PP
Interpolation should be used instead of just copying data, when the X- and
Y-resolution differ.
.PP
Support for buttons is missing.
.PP
More detailed bug information is available at the gt68xx backend homepage
.IR http://www.meier-geinitz.de/sane/gt68xx .
Please contact me if you find a bug or missing feature:
<henning@meier-geinitz.de>. Please send a debug log if your scanner isn't
detected correctly (see SANE_DEBUG_GT68XX above).
