/*
 * Copyright (C) 2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define __MODULES_C__
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <gmodule.h>

#include "modules.h"



G_MODULE_EXPORT
GHashTable *module_hash=NULL;
typedef struct module_info_t {
    void *module_functions;
    GModule *module_cm;
} module_info_t;
    

G_MODULE_IMPORT
int extra_key_completion(gpointer extra_key_data);

G_MODULE_EXPORT
void *load_module(const gchar *librarydir,const gchar *module_name){
    module_info_t *module_info;
    void *(*module_init)(void);
    
    if (!module_hash){
	/* create hash */
	 module_hash = g_hash_table_new(g_str_hash, g_str_equal);
	 if (!module_hash) g_assert_not_reached();
    }
    module_info=g_hash_table_lookup(module_hash,module_name);
    if (module_info) {
	return module_info->module_functions;
    } else {
	gchar *full_libdir=g_build_filename (LIBDIR, "xfce4", librarydir,NULL);
	gchar *module = g_module_build_path(full_libdir, module_name);
	g_free(full_libdir);
	module_info=(module_info_t *)malloc(sizeof(module_info_t));
	if (!module_info) g_assert_not_reached();
	module_info->module_cm=g_module_open (module, 0);
	if (!module_info->module_cm) {
	    g_error("g_module_open(%s) == NULL\n",module);
	    exit(1);
	}
	if (!g_module_symbol (module_info->module_cm, "module_init",(gpointer) &(module_init)) ) {
	    g_error("g_module_symbol(module_init) != FALSE\n");
	    exit(1);
	}	
	module_info->module_functions = (*module_init)();
	g_hash_table_insert (module_hash,(gpointer)module_name,module_info);
	DBG ("xffm: module %s successfully loaded", module);	    
	g_free(module);
	return module_info->module_functions;                                      
    }
}

G_MODULE_EXPORT
void unload_module(const gchar *module_name){
    module_info_t *module_info;

    if (!module_hash) return;
    module_info = g_hash_table_lookup(module_hash,module_name);
    if (!module_info){
	   DBG("module %s is not loaded\n",module_name);
	   return;
    }

    if (!g_module_close(module_info->module_cm)){
	   g_warning("g_module_close (%s) failed\n",module_name);
    }
    else {
	   if (!g_hash_table_remove (module_hash,module_name)){
	      g_warning ("could not remove %s from module hash",module_name);
	   }	   
	   g_free(module_info);
           DBG ("module %s unloaded",module_name);
    }	   
}

G_MODULE_EXPORT
void unload_xfc(void){ return unload_module("xfce4_combo");}
G_MODULE_EXPORT
xfc_combo_functions *load_xfc(void){
    xfc_combo_functions *xfc_fun = (xfc_combo_functions *)load_module("modules","xfce4_combo");
    xfc_fun->extra_key_completion = extra_key_completion;
    xfc_fun->extra_key_data = NULL;
    return xfc_fun;
}

G_MODULE_EXPORT
void unload_mime_icon_module(void){return unload_module("xfce4_mime_icons");}
G_MODULE_EXPORT
xfmime_icon_functions *load_mime_icon_module(void){
    xfmime_icon_functions *xfmime_icon_fun=(xfmime_icon_functions *)load_module("modules","xfce4_mime_icons");
    return xfmime_icon_fun;
}

G_MODULE_EXPORT
void unload_mime_module(void){return unload_module("xfce4_mime");}
G_MODULE_EXPORT
xfmime_functions *load_mime_module(void){
    xfmime_functions *xfmime_fun=(xfmime_functions *)load_module("modules","xfce4_mime");
    return xfmime_fun;
}

/*********************************************************************************************/

/* properties */
static xfprop_functions *xfprop_fun=NULL;
G_MODULE_EXPORT
void unload_prop_module(void){
    unload_module("xffm_prop");
    g_free(xfprop_fun);
    xfprop_fun=NULL;
    return;
}
G_MODULE_EXPORT
xfprop_functions *load_prop_module(void){
    xfprop_functions *xfprop_fun = (xfprop_functions *)load_module("xffm","xffm_prop");
    return xfprop_fun;
}

/* find */
static xffind_functions *xffind_fun=NULL;
G_MODULE_EXPORT
void unload_find_module(void){
    unload_module("xffm_find");
    g_free(xffind_fun);
    xffind_fun=NULL;
    return;
}
G_MODULE_EXPORT
xffind_functions *load_find_module(void){
    if (!xffind_fun) xffind_fun=(xffind_functions *)load_module("xffm","xffm_find");
    return xffind_fun;
}

/* fstab */
static xffstab_functions *xffstab_fun=NULL;
G_MODULE_EXPORT
void unload_fstab_module(void){
    unload_module("xffm_fstab");
    g_free(xffstab_fun);
    xffstab_fun=NULL;
    return;
}
G_MODULE_EXPORT
xffstab_functions *load_fstab_module(void){
    if (!xffstab_fun) xffstab_fun=(xffstab_functions *)load_module("xffm","xffm_fstab");
    return xffstab_fun;
}

/* recent */
static xfrecent_functions *xfrecent_fun=NULL;
G_MODULE_EXPORT
void unload_recent_module(void){
    unload_module("xffm_recent");
    g_free(xfrecent_fun);
    xfrecent_fun=NULL;
    return;
}
G_MODULE_EXPORT
xfrecent_functions *load_recent_module(void){
    if (!xfrecent_fun) xfrecent_fun=(xfrecent_functions *)load_module("xffm","xffm_recent");
    return xfrecent_fun;
}

/* trash */
static xftrash_functions *xftrash_fun=NULL;
G_MODULE_EXPORT
void unload_trash_module(void){
    unload_module("xffm_trash");
    g_free(xftrash_fun);
    xftrash_fun=NULL;
    return;
}
G_MODULE_EXPORT
xftrash_functions *load_trash_module(void){
    if (!xftrash_fun) xftrash_fun=(xftrash_functions *)load_module("xffm","xffm_trash");
    return xftrash_fun;
}
/* book */
static xfbook_functions *xfbook_fun=NULL;
G_MODULE_EXPORT
void unload_book_module(void){
    unload_module("xffm_book");
    g_free(xfbook_fun);
    xfbook_fun=NULL;
    return;
}
G_MODULE_EXPORT
xfbook_functions *load_book_module(void){
    if (!xfbook_fun) xfbook_fun=(xfbook_functions *)load_module("xffm","xffm_book");
    return xfbook_fun;
}

/* smb */
#ifdef USE_SMB_BRANCH
static xfsmb_functions *xfsmb_fun=NULL;
G_MODULE_EXPORT
void unload_smb_module(void){
    unload_module("xffm_smb");
    g_free(xfsmb_fun);
    xfsmb_fun=NULL;
    return;
}
G_MODULE_EXPORT
xfsmb_functions *load_smb_module(void){
    if (!xfsmb_fun) xfsmb_fun=(xfsmb_functions *)load_module("xffm","xffm_smb");
    return xfsmb_fun;
}
#endif

