#!/usr/bin/env kjscmd

// Applies a water color effect filter to the image
function apply_watercolor( img )
{
    var imgfx = new ImageFX();
    img = imgfx.contrast(img, 200);
    img = imgfx.despeckle(img);
    img = imgfx.despeckle(img);
    img = imgfx.despeckle(img);
    img = imgfx.sharpen(img);
    return img;
}

if ( application.args.length == 0 ) {
    throw 'Usage:\n\timageviewer imgfile ...';
}
else {
    var loc = application.args[0];
    var lbl = new QLabel();

    var img = new Image();
    img.load( loc );
    if ( !img.isOk() ) {
        throw 'Failed to load image ' + loc;
    }

    println(img.isOk());
    img = apply_watercolor( img );

    lbl.pixmap = img.pixmap();
    lbl.resize(img.width(), img.height());
    lbl.show();
    application.exec();
}

/*
int watercolor(imgdes *srcimg, imgdes *resimg)
{
   imgdes tmpsrc;
   int cols, rows, rcode;
   double gamma = 0.7;

   cols = CALC_WIDTH(srcimg);
   rows = CALC_HEIGHT(srcimg);

   allocimage(&tmpsrc, cols, rows, srcimg->bmh->biBitCount);
   copyimage(srcimg, &tmpsrc);

   gammabrighten(gamma, &tmpsrc, &tmpsrc);
   removenoise(&tmpsrc, &tmpsrc);
   removenoise(&tmpsrc, &tmpsrc);
   removenoise(&tmpsrc, &tmpsrc);
   sharpen(&tmpsrc, &tmpsrc);

   rcode = copyimage(&tmpsrc, resimg);

   freeimage(&tmpsrc);


*/
