/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAddressBook.idl
 */

#ifndef __gen_nsIAddressBook_h__
#define __gen_nsIAddressBook_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIRDFCompositeDataSource_h__
#include "nsIRDFCompositeDataSource.h"
#endif

#ifndef __gen_nsIAddrDatabase_h__
#include "nsIAddrDatabase.h"
#endif

#ifndef __gen_nsISupportsArray_h__
#include "nsISupportsArray.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMWindow; /* forward declaration */

class nsIFileSpec; /* forward declaration */

class nsIAbDirectory; /* forward declaration */

class nsIAbCard; /* forward declaration */


/* starting interface:    nsIAddressBook */
#define NS_IADDRESSBOOK_IID_STR "a5996dae-92a0-4caf-8e3e-3cfa5ed5b555"

#define NS_IADDRESSBOOK_IID \
  {0xa5996dae, 0x92a0, 0x4caf, \
    { 0x8e, 0x3e, 0x3c, 0xfa, 0x5e, 0xd5, 0xb5, 0x55 }}

class NS_NO_VTABLE nsIAddressBook : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IADDRESSBOOK_IID)

  /* void newAddressBook (in nsIAbDirectoryProperties aProperties); */
  NS_IMETHOD NewAddressBook(nsIAbDirectoryProperties *aProperties) = 0;

  /* void modifyAddressBook (in nsIRDFDataSource aDS, in nsIAbDirectory aParentDir, in nsIAbDirectory aDirectory, in nsIAbDirectoryProperties aProperties); */
  NS_IMETHOD ModifyAddressBook(nsIRDFDataSource *aDS, nsIAbDirectory *aParentDir, nsIAbDirectory *aDirectory, nsIAbDirectoryProperties *aProperties) = 0;

  /* void deleteAddressBooks (in nsIRDFDataSource aDS, in nsISupportsArray aParentDir, in nsISupportsArray aResourceArray); */
  NS_IMETHOD DeleteAddressBooks(nsIRDFDataSource *aDS, nsISupportsArray *aParentDir, nsISupportsArray *aResourceArray) = 0;

  /* void exportAddressBook (in nsIDOMWindow aParentWin, in nsIAbDirectory aDirectory); */
  NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory) = 0;

  /**
   * Migrates a 4x ldif address book to our format.
   *
   * @param       aFileSpec       The source file to import
   *    
   * @param       aMigrating      If PR_TRUE then the preferences are not
   *                              created for the address book. If PR_FALSE,
   *                              then the preferences will be created for the
   *                              address book.
   *    
   * @param       aStoreLocAsHome If PR_TRUE then the location will be stored
   *                              as the home address, otherwise it will be
   *                              stored as the company address.
   *    
   */
  /* void migrate4xAb (in nsIFileSpec aFileSpec, in boolean aMigrating, in boolean aStoreLocAsHome); */
  NS_IMETHOD Migrate4xAb(nsIFileSpec *aFileSpec, PRBool aMigrating, PRBool aStoreLocAsHome) = 0;

  /**
   * Converts a Netscape NA2 file to an LDIF file. Will only work on Commercial
   * builds.
   *
   * @param       srcFileSpec     The source file to convert
   *
   * @param       dstFileSpec     The destination file for the conversion
   *
   */
  /* void convertNA2toLDIF (in nsIFileSpec srcFileSpec, in nsIFileSpec dstFileSpec); */
  NS_IMETHOD ConvertNA2toLDIF(nsIFileSpec *srcFileSpec, nsIFileSpec *dstFileSpec) = 0;

  /* nsIAddrDatabase getAbDatabaseFromURI (in string URI); */
  NS_IMETHOD GetAbDatabaseFromURI(const char *URI, nsIAddrDatabase **_retval) = 0;

  /* boolean mailListNameExists (in wstring name); */
  NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval) = 0;

  /* nsIAbCard escapedVCardToAbCard (in string escapedVCardStr); */
  NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval) = 0;

  /* string abCardToEscapedVCard (in nsIAbCard aCard); */
  NS_IMETHOD AbCardToEscapedVCard(nsIAbCard *aCard, char **_retval) = 0;

  /* void convert4xVCardPrefs (in string prefRoot, out string escapedVCardStr); */
  NS_IMETHOD Convert4xVCardPrefs(const char *prefRoot, char **escapedVCardStr) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIADDRESSBOOK \
  NS_IMETHOD NewAddressBook(nsIAbDirectoryProperties *aProperties); \
  NS_IMETHOD ModifyAddressBook(nsIRDFDataSource *aDS, nsIAbDirectory *aParentDir, nsIAbDirectory *aDirectory, nsIAbDirectoryProperties *aProperties); \
  NS_IMETHOD DeleteAddressBooks(nsIRDFDataSource *aDS, nsISupportsArray *aParentDir, nsISupportsArray *aResourceArray); \
  NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory); \
  NS_IMETHOD Migrate4xAb(nsIFileSpec *aFileSpec, PRBool aMigrating, PRBool aStoreLocAsHome); \
  NS_IMETHOD ConvertNA2toLDIF(nsIFileSpec *srcFileSpec, nsIFileSpec *dstFileSpec); \
  NS_IMETHOD GetAbDatabaseFromURI(const char *URI, nsIAddrDatabase **_retval); \
  NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval); \
  NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval); \
  NS_IMETHOD AbCardToEscapedVCard(nsIAbCard *aCard, char **_retval); \
  NS_IMETHOD Convert4xVCardPrefs(const char *prefRoot, char **escapedVCardStr); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIADDRESSBOOK(_to) \
  NS_IMETHOD NewAddressBook(nsIAbDirectoryProperties *aProperties) { return _to NewAddressBook(aProperties); } \
  NS_IMETHOD ModifyAddressBook(nsIRDFDataSource *aDS, nsIAbDirectory *aParentDir, nsIAbDirectory *aDirectory, nsIAbDirectoryProperties *aProperties) { return _to ModifyAddressBook(aDS, aParentDir, aDirectory, aProperties); } \
  NS_IMETHOD DeleteAddressBooks(nsIRDFDataSource *aDS, nsISupportsArray *aParentDir, nsISupportsArray *aResourceArray) { return _to DeleteAddressBooks(aDS, aParentDir, aResourceArray); } \
  NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory) { return _to ExportAddressBook(aParentWin, aDirectory); } \
  NS_IMETHOD Migrate4xAb(nsIFileSpec *aFileSpec, PRBool aMigrating, PRBool aStoreLocAsHome) { return _to Migrate4xAb(aFileSpec, aMigrating, aStoreLocAsHome); } \
  NS_IMETHOD ConvertNA2toLDIF(nsIFileSpec *srcFileSpec, nsIFileSpec *dstFileSpec) { return _to ConvertNA2toLDIF(srcFileSpec, dstFileSpec); } \
  NS_IMETHOD GetAbDatabaseFromURI(const char *URI, nsIAddrDatabase **_retval) { return _to GetAbDatabaseFromURI(URI, _retval); } \
  NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval) { return _to MailListNameExists(name, _retval); } \
  NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval) { return _to EscapedVCardToAbCard(escapedVCardStr, _retval); } \
  NS_IMETHOD AbCardToEscapedVCard(nsIAbCard *aCard, char **_retval) { return _to AbCardToEscapedVCard(aCard, _retval); } \
  NS_IMETHOD Convert4xVCardPrefs(const char *prefRoot, char **escapedVCardStr) { return _to Convert4xVCardPrefs(prefRoot, escapedVCardStr); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIADDRESSBOOK(_to) \
  NS_IMETHOD NewAddressBook(nsIAbDirectoryProperties *aProperties) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewAddressBook(aProperties); } \
  NS_IMETHOD ModifyAddressBook(nsIRDFDataSource *aDS, nsIAbDirectory *aParentDir, nsIAbDirectory *aDirectory, nsIAbDirectoryProperties *aProperties) { return !_to ? NS_ERROR_NULL_POINTER : _to->ModifyAddressBook(aDS, aParentDir, aDirectory, aProperties); } \
  NS_IMETHOD DeleteAddressBooks(nsIRDFDataSource *aDS, nsISupportsArray *aParentDir, nsISupportsArray *aResourceArray) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteAddressBooks(aDS, aParentDir, aResourceArray); } \
  NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExportAddressBook(aParentWin, aDirectory); } \
  NS_IMETHOD Migrate4xAb(nsIFileSpec *aFileSpec, PRBool aMigrating, PRBool aStoreLocAsHome) { return !_to ? NS_ERROR_NULL_POINTER : _to->Migrate4xAb(aFileSpec, aMigrating, aStoreLocAsHome); } \
  NS_IMETHOD ConvertNA2toLDIF(nsIFileSpec *srcFileSpec, nsIFileSpec *dstFileSpec) { return !_to ? NS_ERROR_NULL_POINTER : _to->ConvertNA2toLDIF(srcFileSpec, dstFileSpec); } \
  NS_IMETHOD GetAbDatabaseFromURI(const char *URI, nsIAddrDatabase **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAbDatabaseFromURI(URI, _retval); } \
  NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->MailListNameExists(name, _retval); } \
  NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->EscapedVCardToAbCard(escapedVCardStr, _retval); } \
  NS_IMETHOD AbCardToEscapedVCard(nsIAbCard *aCard, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AbCardToEscapedVCard(aCard, _retval); } \
  NS_IMETHOD Convert4xVCardPrefs(const char *prefRoot, char **escapedVCardStr) { return !_to ? NS_ERROR_NULL_POINTER : _to->Convert4xVCardPrefs(prefRoot, escapedVCardStr); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAddressBook : public nsIAddressBook
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIADDRESSBOOK

  nsAddressBook();

private:
  ~nsAddressBook();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAddressBook, nsIAddressBook)

nsAddressBook::nsAddressBook()
{
  /* member initializers and constructor code */
}

nsAddressBook::~nsAddressBook()
{
  /* destructor code */
}

/* void newAddressBook (in nsIAbDirectoryProperties aProperties); */
NS_IMETHODIMP nsAddressBook::NewAddressBook(nsIAbDirectoryProperties *aProperties)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void modifyAddressBook (in nsIRDFDataSource aDS, in nsIAbDirectory aParentDir, in nsIAbDirectory aDirectory, in nsIAbDirectoryProperties aProperties); */
NS_IMETHODIMP nsAddressBook::ModifyAddressBook(nsIRDFDataSource *aDS, nsIAbDirectory *aParentDir, nsIAbDirectory *aDirectory, nsIAbDirectoryProperties *aProperties)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteAddressBooks (in nsIRDFDataSource aDS, in nsISupportsArray aParentDir, in nsISupportsArray aResourceArray); */
NS_IMETHODIMP nsAddressBook::DeleteAddressBooks(nsIRDFDataSource *aDS, nsISupportsArray *aParentDir, nsISupportsArray *aResourceArray)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void exportAddressBook (in nsIDOMWindow aParentWin, in nsIAbDirectory aDirectory); */
NS_IMETHODIMP nsAddressBook::ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void migrate4xAb (in nsIFileSpec aFileSpec, in boolean aMigrating, in boolean aStoreLocAsHome); */
NS_IMETHODIMP nsAddressBook::Migrate4xAb(nsIFileSpec *aFileSpec, PRBool aMigrating, PRBool aStoreLocAsHome)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void convertNA2toLDIF (in nsIFileSpec srcFileSpec, in nsIFileSpec dstFileSpec); */
NS_IMETHODIMP nsAddressBook::ConvertNA2toLDIF(nsIFileSpec *srcFileSpec, nsIFileSpec *dstFileSpec)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAddrDatabase getAbDatabaseFromURI (in string URI); */
NS_IMETHODIMP nsAddressBook::GetAbDatabaseFromURI(const char *URI, nsIAddrDatabase **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean mailListNameExists (in wstring name); */
NS_IMETHODIMP nsAddressBook::MailListNameExists(const PRUnichar *name, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbCard escapedVCardToAbCard (in string escapedVCardStr); */
NS_IMETHODIMP nsAddressBook::EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string abCardToEscapedVCard (in nsIAbCard aCard); */
NS_IMETHODIMP nsAddressBook::AbCardToEscapedVCard(nsIAbCard *aCard, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void convert4xVCardPrefs (in string prefRoot, out string escapedVCardStr); */
NS_IMETHODIMP nsAddressBook::Convert4xVCardPrefs(const char *prefRoot, char **escapedVCardStr)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAddressBook_h__ */
