# - Try to find ASPELL
# Once done this will define
#
#  ASPELL_FOUND - system has ASPELL
#  ASPELL_INCLUDE_DIR - the ASPELL include directory
#  ASPELL_LIBRARIES - The libraries needed to use ASPELL
#  ASPELL_DEFINITIONS - Compiler switches required for using ASPELL

# Copyright (c) 2006, Alexander Neundorf, <neundorf@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


IF (ASPELL_INCLUDE_DIR AND ASPELL_LIBRARIES)
  # Already in cache, be silent
  SET(ASPELL_FIND_QUIETLY TRUE)
ENDIF (ASPELL_INCLUDE_DIR AND ASPELL_LIBRARIES)

FIND_PATH(ASPELL_INCLUDE_DIR aspell.h )

FIND_LIBRARY(ASPELL_LIBRARIES NAMES aspell aspell-15)

IF (ASPELL_INCLUDE_DIR AND ASPELL_LIBRARIES)
   SET(ASPELL_FOUND TRUE)
ELSE (ASPELL_INCLUDE_DIR AND ASPELL_LIBRARIES)
   SET(ASPELL_FOUND FALSE)
ENDIF (ASPELL_INCLUDE_DIR AND ASPELL_LIBRARIES)

IF (ASPELL_FOUND)
  IF (NOT ASPELL_FIND_QUIETLY)
    MESSAGE(STATUS "Found ASPELL: ${ASPELL_LIBRARIES}")
  ENDIF (NOT ASPELL_FIND_QUIETLY)
ELSE (ASPELL_FOUND)
  IF (ASPELL_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could NOT find ASPELL")
  ENDIF (ASPELL_FIND_REQUIRED)
ENDIF (ASPELL_FOUND)

MARK_AS_ADVANCED(ASPELL_INCLUDE_DIR ASPELL_LIBRARIES)
