/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif /* !HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <xfconf/xfconf.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/dialogs.h>

#include <libxfprint/printing-system.h>
#include <libxfprint/printer-list-window.h>

#define CHANNEL         "xfprint"

extern void mainwin_setup (void);

int
main (int argc, char **argv)
{
  XfconfChannel *channel;
  Display *dpy;
  int screen;
  PrintingSystem *ps = NULL;

  xfce_textdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");

  gtk_set_locale ();
  gtk_init (&argc, &argv);
  
  xfconf_init (NULL);

  /* Load the printing system module */
  dpy = GDK_DISPLAY ();
  screen = XDefaultScreen (dpy);

  channel = xfconf_channel_new (CHANNEL);
  if (channel) {

    if (xfconf_channel_has_property (channel, "/XfPrint/system")) {
      const gchar *system_name = xfconf_channel_get_string (channel, "/XfPrint/system", "none");
      if (g_ascii_strcasecmp (system_name, "none") != 0) {
        ps = printing_system_new (system_name);
        if (ps == NULL);
          g_warning ("Unable to load printing system module %s", system_name);
      }
    } else {
      g_warning ("%s: XfPrint/system is not set", PACKAGE);
    }
  }

  if (argc > 1 && (!strcmp (argv[1], "--version") || !strcmp (argv[1], "-V"))) {
    g_print ("\tThis is %s-manager version %s for Xfce %s\n", PACKAGE, VERSION, xfce_version_string ());
    g_print ("\tbuilt with GTK+-%d.%d.%d, ", GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
    g_print ("linked with GTK+-%d.%d.%d.\n", gtk_major_version, gtk_minor_version, gtk_micro_version);
    if (ps)
      g_print ("\tCurrently it uses the %s printing system.\n", ps->name);
    else
      g_print ("\tNo printing system is currently used.\n");
  } else if (argc > 1) {
    GtkWidget *dlg;

    dlg = printer_queue_window_new (ps, argv[1]);
    g_signal_connect (G_OBJECT (dlg), "delete-event", G_CALLBACK (gtk_main_quit), dlg);

    gtk_widget_show_all (dlg);

    gtk_main ();
  } else {
    GtkWidget *dlg;

    dlg = printer_list_window_new (ps);
    g_signal_connect (G_OBJECT (dlg), "delete-event", G_CALLBACK (gtk_main_quit), dlg);

    gtk_widget_show_all (dlg);

    gtk_main ();
  }

  xfconf_shutdown();

  return (EXIT_SUCCESS);
}
