/*-
 * Copyright (c) 1991 by Patrick J. Naughton.
 * Copyright (c) 1997 by David Bagley.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Revision History:
 * 28-Jun-2004: LIFE_NAMES compile-time option.
 * 14-Feb-2003: Added many more lifeforms from Stephen Silver's Life Lexicon
 *              http://www.argentum.freeserve.co.uk/lex_home.htm
 * 25-Jan-2003: File spawned from life.c
 *
 */

/*-
 * neighbors of 0 does not randomize.  All inappropriate
 * modes will be set at 8.  3, 5, 6, 7, 9, & 12 also available.
 */
#define MAXNEIGHBORS 12
#define MAXGROUPS 3		/* Eventually this may be MAXNEIGHBORS - 3 */
#define FIRSTGROUP 2		/* Need at least 2 to make a group */
#define MAXCOUNTNEIGHBORS 9	/* This restriction is because of base 10 */
#define NEIGHBORKINDS 8
#define NUMPTS 64

typedef struct {
	int survival, birth;
	int survivalGroup[MAXGROUPS];
	int birthGroup[MAXGROUPS];
} paramstruct;

static char plots[NEIGHBORKINDS] =
{
	3, 4, 5, 6, 7, 8, 9, 12	/* Neighborhoods */
};

static char maxgroups[NEIGHBORKINDS] =
{0, 0, 0, 3, 0, 0, 0, 0};
static char groupnumber[NEIGHBORKINDS][MAXGROUPS] =
{
	{0, 0, 0},		/* Triangular, would not make sense to use */
	{0, 0, 0},		/* MAXGROUP 2 */
	{0, 0, 0},
	{3, 3, 3},		/* Hexagonal */
	{0, 0, 0},
	{0, 0, 0},		/* MAXGROUP would have to expand... */
	{0, 0, 0},		/* Future improvement */
	{0, 0, 0}		/* Future improvement */
};

static char style6[64] =
{0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 1, 1, 0, 1, 0, 0,
 0, 1, 2, 1, 1, 2, 1, 1, 0, 1, 1, 2, 0, 1, 0, 0,
 0, 0, 1, 0, 2, 1, 1, 0, 1, 1, 2, 1, 1, 2, 1, 0,
 0, 0, 1, 0, 1, 1, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0};


/*-
 * Patterns have < NUMPTS pts (and should have a size of <= 32x32,
 * the Glider Gun is an exception)
 */

/* This group is for the overlap of both 8S23B3 and 8S23B36 */
static char patterns_8S23B3_6[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider"}, /* -- */
#endif
	{
		-1, -1, 0, -1, 1, -1,
		1, 0,
		0, 1,
		127
	}
#endif
#ifdef LIFE_NAMES
	{"almosymmetric, clock (flywheel), blinker (p2)"}, /* 0 */
#endif
	{
		-1, -4,
		-1, -3, 1, -3,
		-3, -2,
		2, -1, 3, -1,
		-4, 0, -3, 0,
		2, 1,
		-2, 2, 0, 2,
		0, 3,

		5, 3,
		3, 4, 4, 4,
		5, 5, 6, 5,
		4, 6,

		8, 0,
		8, 1,
		8, 2,
		127
	},
#ifdef LIFE_NAMES
	{"baker (c p4 fuse)"}, /* 126 */
#endif
	{
		6, -7, 7, -7,
		5, -6, 7, -6,
		4, -5,
		3, -4,
		2, -3,
		1, -2,
		0, -1,
		-1, 0,
		-2, 1,
		-3, 2,
		-4, 3,
		-5, 4,
		-8, 5, -7, 5, -6, 5,
		-7, 6,
		127
	},
#ifdef LIFE_NAMES
	{"barber's pole (p2)"}, /* 2 */
#endif
	{
		-6, -6, -5, -6,
		-6, -5, -4, -5,
		-4, -3, -2, -3,
		-2, -1, 0, -1,
		0, 1, 2, 1,
		2, 3, 4, 3,
		5, 4,
		4, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"bent keys (p3), from Lexicon"}, /* 3 */
#endif
	{
		-5, -2, 4, -2,
		-6, -1, -4, -1, 3, -1, 5, -1,
		-5, 0, -3, 0, -2, 0, 1, 0, 2, 0, 4, 0,
		-2, 1, 1, 1,
		-2, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"blinkers bit pole (p2), from Lexicon"}, /* 4 */
#endif
	{
		2, -3, 3, -3,
		-3, -2, -2, -2, -1, -2, 1, -2, 3, -2,
		-2, 0, 0, 0, 3, 0,
		-3, 1, 2, 1,
		-3, 2, -2, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"boat maker (c p4 fuse)"}, /* 5 */
#endif
	{
		7, -8, 8, -8,
		6, -7, 8, -7,
		5, -6,
		4, -5,
		3, -4,
		2, -3,
		1, -2,
		0, -1,
		-1, 0,
		-2, 1,
		-3, 2,
		-4, 3,
		-9, 4, -8, 4, -7, 4, -6, 4, -5, 4,
		-5, 5,
		-5, 6,
		-5, 7,
		-5, 8,
		127
	},
#ifdef LIFE_NAMES
	{"by flops (p2), from Lexicon"}, /* 6 */
#endif
	{
		0, -3,
		-2, -2, 0, -2,
		2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0,
		2, 1,
		-2, 2, 0, 2,
		0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"candlefrobra (p3), from Lexicon"}, /* 7 */
#endif
	{
		0, -2,
		-4, -1, -2, -1, -1, -1, 1, -1, 3, -1, 4, -1,
		-5, 0, -3, 0, 1, 0, 3, 0, 4, 0,
		-4, 1, 1, 1,
		0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"clock II (p4)"}, /* 8 */
#endif
	{
		-2, -6, -1, -6,
		-2, -5, -1, -5,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-6, -2, -5, -2, -3, -2, 0, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, -1, -1, 2, -1,
		-3, 0, -1, 0, 2, 0, 4, 0, 5, 0,
		-3, 1, 2, 1, 4, 1, 5, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		0, 4, 1, 4,
		0, 5, 1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"Coe's p8, from Lexicon"}, /* 9 */
#endif
	{
		-6, -3, -5, -3,
		-6, -2, -5, -2, -2, -2, -1, -2,
		-1, -1, 0, -1,
		-2, 0, 1, 0,
		1, 1, 4, 1, 5, 1,
		-1, 2, 1, 2, 4, 2, 5, 2,
		127
	},
#ifdef LIFE_NAMES
	{"confused eaters (p4), from Lexicon"}, /* 10 */
#endif
	{
		-5, -5,
		-5, -4, -4, -4, -3, -4,
		-2, -3,
		-3, -2,
		-3, -1, 0, -1,
		0, 0,
		-2, 1, 0, 1,
		-2, 2, -1, 2, 2, 2, 3, 2,
		2, 3, 4, 3,
		4, 4,
		4, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"cross (p3), from Lexicon"}, /* 11 */
#endif
	{
		-2, -4, -1, -4, 0, -4, 1, -4,
		-2, -3, 1, -3,
		-4, -2, -3, -2, -2, -2, 1, -2, 2, -2, 3, -2,
		-4, -1, 3, -1,
		-4, 0, 3, 0,
		-4, 1, -3, 1, -2, 1, 1, 1, 2, 1, 3, 1,
		-2, 2, 1, 2,
		-2, 3, -1, 3, 0, 3, 1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"cuphook (p3) (in compact form), from Lexicon"}, /* 12 */
#endif
	{
		1, -4, 2, -4,
		0, -3, 2, -3,
		0, -2,
		-3, -1, -2, -1, 0, -1,
		-3, 0, -2, 0, 0, 0, 3, 0,
		0, 1, 2, 1, 3, 1,
		0, 2,
		-1, 3, 0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"diehard (vanishes at 130, longest 7 cells)"}, /* 13 */
#endif
	{
		2, -1,
		-4, 0, -3, 0,
		-3, 1, 1, 1, 2, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"eater/bound frob (p4), from Lexicon"}, /* 14 */
#endif
	{
		-4, -5, -3, -5,
		-3, -4,
		-3, -3, -1, -3,
		-2, -2, 0, -2,
		0, -1, 1, -1, 3, -1, 4, -1,
		3, 0, 4, 0,
		-3, 1, -2, 1,
		-2, 2,
		-5, 3, -4, 3, -3, 3,
		-5, 4,
		127
	},
#ifdef LIFE_NAMES
	{"flotilla (school of fish, escort), from Lexicon"}, /* 15 */
#endif
	{
		-3, -8, -2, -8, -1, -8, 0, -8,
		-4, -7, -3, -7, -2, -7, -1, -7, 0, -7, 1, -7,
		-5, -6, -4, -6, -2, -6, -1, -6, 0, -6, 1, -6,
		-4, -5, -3, -5,
		4, -3, 5, -3,
		-6, -2, 7, -2,
		-7, -1,
		-7, 0, 7, 0,
		-7, 1, -6, 1, -5, 1, -4, 1, -3, 1, -2, 1, -1, 1, 0, 1, 1, 1,
			2, 1, 3, 1, 4, 1, 5, 1, 6, 1,
		-3, 4, -2, 4, -1, 4, 0, 4,
		-4, 5, -3, 5, -2, 5, -1, 5, 0, 5, 1, 5,
		-5, 6, -4, 6, -2, 6, -1, 6, 0, 6, 1, 6,
		-4, 7, -3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"fore and back (p2), from Lexicon"}, /* 16 */
#endif
	{
		-3, -3, -2, -3, 0, -3, 1, -3,
		-3, -2, -2, -2, 0, -2, 2, -2,
		3, -1,
		-3, 0, -2, 0, -1, 0, 1, 0, 2, 0, 3, 0,
		-3, 1,
		-2, 2, 0, 2, 2, 2, 3, 2,
		-1, 3, 0, 3, 2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"fox (p2), from Lexicon"}, /* 17 */
#endif
	{
		1, -3,
		1, -2,
		-1, -1, 2, -1,
		-3, 0, -2, 0,
		1, 1, 3, 1,
		-1, 2, 1, 2, 3, 2,
		3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"French kiss (p3), from Lexicon"}, /* 18 */
#endif
	{
		-5, -4,
		-5, -3, -4, -3, -3, -3,
		-2, -2,
		-3, -1, 0, -1, 1, -1,
		-3, 0, 2, 0,
		-2, 1, -1, 1, 2, 1,
		1, 2,
		2, 3, 3, 3, 4, 3,
		4, 4,
		127
	},
#ifdef LIFE_NAMES
	{"fumarole (p5), from Lexicon"}, /* 19 */
#endif
	{
		-1, -3, 0, -3,
		-3, -2, 2, -2,
		-3, -1, 2, -1,
		-3, 0, 2, 0,
		-2, 1, 1, 1,
		-4, 2, -2, 2, 1, 2, 3, 2,
		-4, 3, -3, 3, 2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"hammer (3 LWSS to 1 MWSS), from Lexicon"}, /* 20 */
#endif
	{
		-10, -3, -7, -3,
		-6, -2, -2, -2, -1, -2,
		-10, -1, -6, -1, -3, -1, -2, -1, -1, -1, 5, -1, 6, -1, 7, -1,
			8, -1,
		-9, 0, -8, 0, -7, 0, -6, 0, -3, 0, -2, 0, 0, 0, 5, 0, 9, 0,
		-2, 1, -1, 1, 0, 1, 5, 1,
		-1, 2, 6, 2, 9, 2,
		127
	},
#ifdef LIFE_NAMES
	{"harvester (c p4 fuse), from Lexicon"}, /* 21 */
#endif
	{
		7, -7, 8, -7,
		6, -6, 8, -6,
		5, -5,
		4, -4,
		3, -3,
		2, -2,
		1, -1,
		0, 0,
		-1, 1,
		-2, 2,
		-3, 3,
		-4, 4,
		-9, 5, -8, 5, -7, 5, -6, 5, -5, 5,
		-9, 6, -8, 6, -7, 6, -6, 6,
		-9, 7, -7, 7, -6, 7,
		127
	},
#ifdef LIFE_NAMES
	{"hivenudger (c/2 orthogonally, p4)"}, /* 22 */
#endif
	{
		-6, -6, -5, -6, -4, -6, -3, -6, 3, -6, 6, -6,
		-6, -5, -2, -5, 2, -5,
		-6, -4, 2, -4, 6, -4,
		-5, -3, -2, -3, 2, -3, 3, -3, 4, -3, 5, -3,
		-1, -1, 0, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1,
		-5, 3, -2, 3, 2, 3, 3, 3, 4, 3, 5, 3,
		-6, 4, 2, 4, 6, 4,
		-6, 5, -2, 5, 2, 5,
		-6, 6, -5, 6, -4, 6, -3, 6, 3, 6, 6, 6,
		127
	},
#ifdef LIFE_NAMES
	{"mazing (p4) (pulse1), from Lexicon"}, /* 23 */
#endif
	{
		0, -3, 1, -3,
		-2, -2, 0, -2,
		-3, -1, 3, -1,
		-2, 0, 2, 0, 3, 0,
		0, 2, 2, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"muttering moat (p2) (example), from Lexicon"}, /* 24 */
#endif
	{
		-3, -3, -2, -3,
		-3, -2, -1, -2, 1, -2, 2, -2,
		2, -1,
		-2, 0, 1, 0,
		-1, 1,
		-1, 2, 1, 2, 3, 2,
		2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator0 (p3), from HighLife"}, /* 25 */
#endif
	{
		0, -2,
		-4, -1, -2, -1, -1, -1, 1, -1, 3, -1, 4, -1,
		-5, 0, -3, 0, 1, 0, 3, 0, 4, 0,
		-4, 1, 1, 1,
		0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator1 (p3), from HighLife"}, /* 26 */
#endif
	{
		-3, -2,
		-3, -1, -2, -1, -1, -1, 3, -1, 5, -1, 6, -1, 7, -1,
		-4, 0, -2, 0, 2, 0, 4, 0,
		-7, 1, -6, 1, -5, 1, -3, 1, 1, 1, 2, 1, 3, 1,
		3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator4 (p4) (~HW emulator), from HighLife"}, /* 27 */
#endif
	{
		-9, -3, -8, -3, -6, -3, -5, -3, -2, -3, -1, -3, 0, -3, 1, -3,
			4, -3, 5, -3, 7, -3, 8, -3,
		-11, -2, -8, -2, -6, -2, -3, -2, -2, -2, -1, -2, 0, -2, 1, -2,
			2, -2, 5, -2, 7, -2, 10, -2,
		-11, -1, -10, -1, -5, -1, -4, -1, -3, -1, -2, -1, -1, -1,
			0, -1, 1, -1, 2, -1, 3, -1, 4, -1, 9, -1, 10, -1,
		-7, 0, -6, 0, 5, 0, 6, 0,
		-8, 1, -5, 1, 4, 1, 7, 1,
		-7, 2, -6, 2, 5, 2, 6, 2,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator0 (p6), from HighLife"}, /* 28 */
#endif
	{
		-3, -8, 3, -8,
		-3, -7, -2, -7, 2, -7, 3, -7,
		-3, -6, -2, -6, 2, -6, 3, -6,
		-2, -5, 2, -5,
		-1, -3, 0, -3, 1, -3,
		-2, -2, 2, -2,
		-2, 1, 2, 1,
		-1, 2, 0, 2, 1, 2,
		-2, 4, 2, 4,
		-3, 5, -2, 5, 2, 5, 3, 5,
		-3, 6, -2, 6, 2, 6, 3, 6,
		-3, 7, 3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"phoenix (example) (p2), from Lexicon"}, /* 29 */
#endif
	{
		0, -4,
		-2, -3, 0, -3,
		2, -2,
		-4, -1, -3, -1,
		2, 0, 3, 0,
		-3, 1,
		-1, 2, 1, 2,
		-1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"pinwheel (p4)"}, /* 30 */
#endif
	{
		-2, -6, -1, -6,
		-2, -5, -1, -5,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-3, -2, -1, -2, 2, -2, 4, -2, 5, -2,
		-3, -1, 1, -1, 2, -1, 4, -1, 5, -1,
		-6, 0, -5, 0, -3, 0, 0, 0, 2, 0,
		-6, 1, -5, 1, -3, 1, 2, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		0, 4, 1, 4,
		0, 5, 1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"pulsar quadrant (p3), from Lexicon"}, /* 31 */
#endif
	{
		1, -4,
		-1, -3, 0, -3, 1, -3,
		-2, -2, 2, -2, 3, -2,
		-4, -1, -1, -1, 2, -1,
		-4, 0, 0, 0, 2, 0,
		-4, 1, 1, 1,
		-2, 3, -1, 3, 0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"quad (p2), from Lexicon"}, /* 32 */
#endif
	{
		-3, -3, -2, -3, 1, -3, 2, -3,
		-3, -2, 0, -2, 2, -2,
		-2, -1,
		1, 0,
		-3, 1, -1, 1, 2, 1,
		-3, 2, -2, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"reverse fuse, from Lexicon"}, /* 33 */
#endif
	{
		6, -6, 7, -6,
		5, -5, 7, -5,
		4, -4,
		3, -3,
		2, -2,
		1, -1,
		0, 0,
		-1, 1,
		-2, 2,
		-3, 3,
		-4, 4,
		-5, 5,
		-7, 6, -6, 6,
		127
	},
#ifdef LIFE_NAMES
	{"revolver (p2)"}, /* 34 */
#endif
	{
		-7, -4, 6, -4,
		-7, -3, -6, -3, -5, -3, 0, -3, 4, -3, 5, -3, 6, -3,
		-4, -2, -2, -2, 0, -2, 3, -2,
		-5, -1, 2, -1, 4, -1,
		-5, 0, -3, 0, 4, 0,
		-4, 1, -1, 1, 1, 1, 3, 1,
		-7, 2, -6, 2, -5, 2, -1, 2, 4, 2, 5, 2, 6, 2,
		-7, 3, 6, 3,
		127
	},
#ifdef LIFE_NAMES
	{"rotator (p8), from Lexicon"}, /* 35 */
#endif
	{
		-6, -7,
		-6, -6, -5, -6, -4, -6, 5, -6, 6, -6,
		-3, -5, 5, -5,
		-4, -4, -3, -4, 3, -4, 5, -4,
		3, -3, 4, -3,
		-2, -1, -1, -1, 0, -1,
		-2, 0, 1, 0,
		-2, 1,
		-5, 2, -4, 2, -1, 2, 3, 2,
		-6, 3, -4, 3, 3, 3,
		-6, 4, 2, 4,
		-7, 5, -6, 5, 3, 5, 4, 5, 5, 5,
		5, 6,
		127
	},
#ifdef LIFE_NAMES
	{"ship smallest diagonal but 1 (c/4, p4) (25-cell)"}, /* 36 */
#endif
	{
		2, -6, 3, -6,
		1, -5, 2, -5,
		3, -4,
		5, -3, 6, -3,
		4, -2,
		3, 0, 6, 0,
		-5, 1, -4, 1, 2, 1, 3, 1,
		-6, 2, -5, 2, 1, 2,
		-4, 3, 1, 3, 3, 3,
		-2, 4, -1, 4, 2, 4,
		-2, 5, -1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"sidecar, from Lexicon"}, /* 37 */
#endif
	{
		-3, -5,
		-4, -4, 2, -4,
		-4, -3, 2, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 0, -2, 2, -2,
		0, 0, 1, 0,
		-2, 1, 3, 1,
		-3, 2,
		-3, 3, 3, 3,
		-3, 4, -2, 4, -1, 4, 0, 4, 1, 4, 2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"singular flip flop (p2), from Lexicon"}, /* 38 */
#endif
	{
		-1, -3,
		-1, -2, 1, -2,
		-3, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-1, 2, 0, 2,
		-1, 3, 0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"skewed quad (p2), from Lexicon"}, /* 39 */
#endif
	{
		-2, -3, -1, -3,
		-2, -2, 2, -2, 3, -2,
		-1, -1, 1, -1, 3, -1,
		-3, 1, -1, 1, 1, 1,
		-3, 2, -2, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"snake pit II (p3), from Lexicon"}, /* 40 */
#endif
	{
		0, -5, 1, -5,
		-1, -4, 2, -4,
		-1, -3, 1, -3, 2, -3,
		-4, -2, -3, -2, -1, -2,
		-5, -1, -3, -1, -1, -1, 1, -1, 2, -1, 3, -1, 4, -1,
		-5, 0, 5, 0,
		-4, 1, -3, 1, -2, 1, -1, 1, 1, 1, 3, 1, 5, 1,
		1, 2, 3, 2, 4, 2,
		-2, 3, -1, 3, 1, 3,
		-2, 4, 1, 4,
		-1, 5, 0, 5,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"spark coil (p2), from Lexicon"}, /* -- */
#endif
	{
		-4, -2, -3, -2, 2, -2, 3, -2,
		-4, -1, -2, -1, 1, -1, 3, -1,
		-2, 0, 1, 0,
		-4, 1, -2, 1, 1, 1, 3, 1,
		-4, 2, -3, 2, 2, 2, 3, 2,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"star (p3) (big cross), from Lexicon"}, /* 41 */
#endif
	{
		0, -5,
		-1, -4, 0, -4, 1, -4,
		-3, -3, -2, -3, -1, -3, 1, -3, 2, -3, 3, -3,
		-3, -2, 3, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, 4, 0, 5, 0,
		-4, 1, -3, 1, 3, 1, 4, 1,
		-3, 2, 3, 2,
		-3, 3, -2, 3, -1, 3, 1, 3, 2, 3, 3, 3,
		-1, 4, 0, 4, 1, 4,
		0, 5,
		127
	},
#ifdef LIFE_NAMES
	{"sym (p4)"}, /* 42 */
#endif
	{
		-6, -2, -5, -2, 4, -2, 5, -2,
		-6, -1, -5, -1, -3, -1, -2, -1, 1, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -2, 0, 1, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, -1, 1, 0, 1, 1, 1, 3, 1, 4, 1,
		127
	},
#ifdef LIFE_NAMES
	{"turtle (c/3, p3), from Lexicon"}, /* 43 */
#endif
	{
		-4, -5, -3, -5, -2, -5, 6, -5,
		-4, -4, -3, -4, 0, -4, 2, -4, 3, -4, 5, -4, 6, -4,
		-2, -3, -1, -3, 0, -3, 5, -3,
		-4, -2, -1, -2, 1, -2, 5, -2,
		-5, -1, 0, -1, 5, -1,
		-5, 0, 0, 0, 5, 0,
		-4, 1, -1, 1, 1, 1, 5, 1,
		-2, 2, -1, 2, 0, 2, 5, 2,
		-4, 3, -3, 3, 0, 3, 2, 3, 3, 3, 5, 3, 6, 3,
		-4, 4, -3, 4, -2, 4, 6, 4,
		127
	},
#ifdef LIFE_NAMES
	{"two eaters (p3), from Lexicon"}, /* 44 */
#endif
	{
		-4, -4, -3, -4,
		-3, -3,
		-3, -2, -1, -2,
		-2, -1, -1, -1,
		1, 0, 2, 0,
		1, 1, 3, 1,
		3, 2,
		3, 3, 4, 3,
		127
	},
#ifdef LIFE_NAMES
	{"two pulsar quadrants (p3) (pulsar 18-22-20)"}, /* 45 */
#endif
	{
		0, -4, 1, -4, 2, -4,
		-1, -2, 4, -2,
		-2, -1, 0, -1, 4, -1,
		-4, 0, -3, 0, -2, 0, 1, 0, 4, 0,
		2, 1,
		0, 2, 1, 2,
		0, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"why not (p2), from Lexicon"}, /* 46 */
#endif
	{
		0, -3,
		0, -2, 2, -2,
		-2, -1,
		-3, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-2, 1,
		0, 2, 2, 2,
		0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"windmill (p4), from Lexicon"}, /* 47 */
#endif
	{
		2, -9,
		0, -8, 1, -8, 3, -8,
		-2, -7, -1, -7,
		1, -6, 2, -6,
		-2, -5, -1, -5, 0, -5,
		-9, -3, -8, -3, -7, -3,
		-6, -2, -5, -2, -2, -2, -1, -2, 0, -2, 2, -2, 3, -2,
		1, -1, 2, -1, 3, -1, 4, -1, 5, -1, 6, -1, 7, -1,
		-8, 0, -7, 0, -6, 0, -5, 0, -4, 0, -3, 0, -2, 0,
		-4, 1, -3, 1, -1, 1, 0, 1, 1, 1, 4, 1, 5, 1,
		6, 2, 7, 2, 8, 2,
		-1, 4, 0, 4, 1, 4,
		-3, 5, -2, 5,
		0, 6, 1, 6,
		-4, 7, -2, 7, -1, 7,
		-3, 8,
		127
	},
#ifdef LIFE_NAMES
	{"worker bee (p9), from Lexicon"}, /* 48 */
#endif
	{
		-8, -5, -7, -5, 6, -5, 7, -5,
		-7, -4, 6, -4,
		-7, -3, -5, -3, 4, -3, 6, -3,
		-6, -2, -5, -2, 4, -2, 5, -2,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-6, 2, -5, 2, 4, 2, 5, 2,
		-7, 3, -5, 3, 4, 3, 6, 3,
		-7, 4, 6, 4,
		-8, 5, -7, 5, 6, 5, 7, 5,
		127
	}
};

static char patterns_8S23B3[][2 * NUMPTS + 1] =
{
	/* Lexicon 22-2-02 http://www.argentum.freeserve.co.uk/lex_home.htm */
#ifdef LIFE_NAMES
	{"101 (p5), from Lexicon"}, /* 49 */
#endif
	{
		-5, -6, -4, -6, 3, -6, 4, -6,
		-6, -5, -4, -5, 3, -5, 5, -5,
		-6, -4, 5, -4,
		-9, -3, -8, -3, -6, -3, 5, -3, 7, -3, 8, -3,
		-9, -2, -8, -2, -6, -2, -4, -2, -1, -2, 0, -2, 3, -2, 5, -2,
			7, -2, 8, -2,
		-6, -1, -4, -1, -2, -1, 1, -1, 3, -1, 5, -1,
		-6, 0, -4, 0, -2, 0, 1, 0, 3, 0, 5, 0,
		-9, 1, -8, 1, -6, 1, -4, 1, -1, 1, 0, 1, 3, 1, 5, 1, 7, 1,
			8, 1,
		-9, 2, -8, 2, -6, 2, 5, 2, 7, 2, 8, 2,
		-6, 3, 5, 3,
		-6, 4, -4, 4, 3, 4, 5, 4,
		-5, 5, -4, 5, 3, 5, 4, 5,
		127
	},
#ifdef LIFE_NAMES
	{"1-2-3 (p3), from Lexicon"}, /* 50 */
#endif
	{
		-3, -4, -2, -4,
		-5, -3, -2, -3,
		-5, -2, -4, -2, -2, -2, 0, -2, 1, -2,
		-4, -1, -2, -1, 1, -1,
		-4, 0, 1, 0, 3, 0, 4, 0,
		-3, 1, -2, 1, -1, 1, 1, 1, 3, 1, 4, 1,
		0, 2,
		-1, 3,
		-1, 4, 0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"1-2-3-4 (p4), from Lexicon"}, /* 51 */
#endif
	{
		0, -5,
		-1, -4, 1, -4,
		-2, -3, 0, -3, 2, -3,
		-2, -2, 2, -2,
		-5, -1, -4, -1, -2, -1, 0, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -3, 0, 3, 0, 5, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 3,
		-1, 4, 1, 4,
		0, 5,
		127
	},
#ifdef LIFE_NAMES
	{"Achim's p144, from Lexicon"}, /* 52 */
#endif
	{
		-14, -9, -13, -9, 12, -9, 13, -9,
		-14, -8, -13, -8, 12, -8, 13, -8,
		4, -7, 5, -7,
		3, -6, 6, -6,
		4, -5, 5, -5,
		-1, -3, 0, -3, 1, -3,
		-1, -2, 1, -2,
		-1, -1, 0, -1, 1, -1,
		-1, 0, 0, 0,
		-2, 1, -1, 1, 0, 1,
		-2, 2, 0, 2,
		-2, 3, -1, 3, 0, 3,
		-6, 5, -5, 5,
		-7, 6, -4, 6,
		-6, 7, -5, 7,
		-14, 8, -13, 8, 12, 8, 13, 8,
		-14, 9, -13, 9, 12, 9, 13, 9,
		127
	},
#ifdef LIFE_NAMES
	{"Achim's p16, from Lexicon"}, /* 53 */
#endif
	{
		1, -6, 2, -6,
		1, -5, 3, -5,
		-4, -4, 1, -4, 3, -4, 4, -4,
		-5, -3, -4, -3, 2, -3,
		-6, -2, -3, -2,
		-6, -1, -5, -1, -4, -1,
		4, 1, 5, 1, 6, 1,
		3, 2, 6, 2,
		-2, 3, 4, 3, 5, 3,
		-4, 4, -3, 4, -1, 4, 4, 4,
		-3, 5, -1, 5,
		-2, 6, -1, 6,
		127
	},
#ifdef LIFE_NAMES
	{"Achim (p4), from Lexicon"}, /* 54 */
#endif
	{
		-3, -4, -2, -4, 2, -4, 3, -4,
		-4, -3, -1, -3, 1, -3, 4, -3,
		-4, -2, -2, -2, -1, -2, 1, -2, 2, -2, 4, -2,
		-5, -1, -4, -1, 4, -1, 5, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-5, 1, -4, 1, 4, 1, 5, 1,
		-4, 2, -2, 2, -1, 2, 1, 2, 2, 2, 4, 2,
		-4, 3, -1, 3, 1, 3, 4, 3,
		-3, 4, -2, 4, 2, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"Achim's p5 (pseudo-barberpole), from Lexicon"}, /* 55 */
#endif
	{
		-6, -6, -5, -6,
		-6, -5,
		-4, -4,
		-4, -3, -2, -3,
		-2, -1, 0, -1,
		0, 1, 2, 1,
		2, 3, 3, 3,
		5, 4,
		4, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"Achim's p8 (asym), from Lexicon"}, /* 56 */
#endif
	{
		-3, -4, -2, -4,
		-4, -3,
		-3, -2, 1, -2,
		-3, -1, 1, -1, 2, -1,
		-1, 0, 1, 0,
		-2, 1, -1, 1, 3, 1,
		-1, 2, 3, 2,
		4, 3,
		2, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"acorn (stabilizes at 5206), from Lexicon"}, /* 58 */
#endif
	{
		-2, -1,
		0, 0,
		-3, 1, -2, 1, 1, 1, 2, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"A for All (p6), from Lexicon"}, /* 58 */
#endif
	{
		-1, -5, 0, -5,
		-2, -4, 1, -4,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-4, -2, -2, -2, 1, -2, 3, -2,
		-5, -1, 4, -1,
		-5, 0, 4, 0,
		-4, 1, -2, 1, 1, 1, 3, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		-2, 3, 1, 3,
		-1, 4, 0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"airforce (p7), from Lexicon"}, /* 59 */
#endif
	{
		0, -7,
		-1, -6, 1, -6,
		0, -5,
		-2, -3, -1, -3, 0, -3, 1, -3, 2, -3,
		-3, -2, 3, -2, 5, -2, 6, -2,
		-4, -1, -2, -1, -1, -1, 3, -1, 5, -1, 6, -1,
		-4, 0, -2, 0, 1, 0, 3, 0,
		-7, 1, -6, 1, -4, 1, 0, 1, 1, 1, 3, 1,
		-7, 2, -6, 2, -4, 2, 2, 2,
		-3, 3, -2, 3, -1, 3, 0, 3, 1, 3,
		-1, 5,
		-2, 6, 0, 6,
		-1, 7,
		127
	},
#ifdef LIFE_NAMES
	{"AK47 (almost a gun)"}, /* 60 */
#endif
	{
		-12, -6, -11, -6,
		-12, -5, -11, -5,
		11, -4, 12, -4,
		11, -3,
		3, -2, 4, -2, 5, -2, 9, -2, 11, -2,
		2, -1, 6, -1, 9, -1, 10, -1,
		-10, 0, -9, 0, 1, 0, 7, 0,
		-11, 1, -9, 1, 1, 1, 7, 1,
		-11, 2, 1, 2, 7, 2,
		-12, 3, -11, 3, 2, 3, 6, 3,
		3, 4, 4, 4, 5, 4, 11, 4, 12, 4,
		11, 5, 12, 5,
		127
	},
#ifdef LIFE_NAMES
	{"asym (p4)"}, /* 61 */
#endif
	{
		-4, -4, -2, -4,
		-4, -3, -1, -3,
		-1, -2,
		-2, -1, -1, -1, 0, -1, 3, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, 0, 0, 1, 0, 2, 0,
		1, 1,
		1, 2, 4, 2,
		2, 3, 4, 3,
		127
	},
#ifdef LIFE_NAMES
	{"asym 2 (p4)"}, /* 62 */
#endif
	{
		-3, -3, -1, -3, 2, -3, 4, -3, 5, -3, 6, -3,
		-4, -2, -1, -2, 1, -2, 3, -2, 5, -2,
		-4, -1,
		3, 0,
		-6, 1, -4, 1, -2, 1, 0, 1, 3, 1,
		-7, 2, -6, 2, -5, 2, -3, 2, 0, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"aVerage (p5), from Lexicon"}, /* 63 */
#endif
	{
		-3, -5, -2, -5,
		-2, -4, -1, -4, 0, -4,
		-4, -3, 1, -3,
		-5, -2, -3, -2, -2, -2, -1, -2, 0, -2, 2, -2,
		-5, -1, -3, -1, 2, -1, 5, -1,
		-6, 0, -5, 0, -3, 0, -2, 0, -1, 0, 2, 0, 4, 0, 6, 0,
		-5, 1, -3, 1, 2, 1, 5, 1,
		-5, 2, -3, 2, -2, 2, -1, 2, 0, 2, 2, 2,
		-4, 3, 1, 3,
		-2, 4, -1, 4, 0, 4,
		-3, 5, -2, 5,
		127
	},
#ifdef LIFE_NAMES
	{"babbling brook (4 cell rotor), from Lexicon"}, /* 64 */
#endif
	{
		-1, -5,
		-3, -4, -2, -4, -1, -4, 4, -4, 5, -4,
		-4, -3, 0, -3, 1, -3, 4, -3,
		-7, -2, -4, -2, -2, -2, -1, -2, 2, -2, 4, -2,
		-8, -1, -6, -1, -4, -1, 1, -1, 2, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, -3, 0, -2, 0, 3, 0, 5, 0, 7, 0,
		-5, 1, -3, 1, 0, 1, 1, 1, 3, 1, 6, 1,
		-5, 2, -2, 2, -1, 2, 3, 2,
		-6, 3, -5, 3, 0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"baker's dozen (p12), from Lexicon"}, /* 65 */
#endif
	{
		-11, -5, -10, -5, 0, -5, 1, -5,
		-11, -4, -10, -4, -9, -4, -8, -4, -6, -4, 0, -4, 1, -4,
		-11, -3, -9, -3, -6, -3, -5, -3, -4, -3,
		0, -2,
		-7, -1, -6, -1, -1, -1, 1, -1,
		-7, 0, -1, 0, 2, 0, 7, 0,
		0, 1, 1, 1, 6, 1, 7, 1,
		4, 3, 5, 3, 6, 3, 9, 3, 11, 3,
		-1, 4, 0, 4, 6, 4, 8, 4, 9, 4, 10, 4, 11, 4,
		-1, 5, 0, 5, 10, 5, 11, 5,
		127
	},
#ifdef LIFE_NAMES
	{"big glider 2 (c/4 iagonal, p4)"}, /* 66 */
#endif
	{
		0, -9, 1, -9,
		0, -8, 2, -8,
		0, -7,
		1, -6, 2, -6, 3, -6,
		1, -5, 3, -5, 4, -5, 5, -5,
		1, -4, 4, -4, 5, -4,
		3, -3, 5, -3, 7, -3, 8, -3,
		2, -2, 3, -2, 5, -2, 7, -2,
		1, -1, 2, -1, 7, -1,
		-9, 0, -8, 0, -7, 0,
		-9, 1, -6, 1, -5, 1, -4, 1, -1, 1, 3, 1, 4, 1,
		-8, 2, -6, 2, -2, 2, -1, 2,
		-6, 3, -5, 3, -3, 3, -2, 3, 1, 3,
		-5, 4, -4, 4, 1, 4,
		-5, 5, -4, 5, -3, 5, -2, 5,
		-3, 7, -2, 7, -1, 7,
		-3, 8,
		127
	},
#ifdef LIFE_NAMES
	{"big glider 3 (c4 diagonal, p4)"}, /* 67 */
#endif
	{
		-1, -8,
		-2, -7, -1, -7,
		-2, -6, 0, -6,
		0, -4, 2, -4,
		-2, -3, 0, -3, 2, -3,
		-7, -2, -3, -2, -2, -2, 0, -2, 2, -2, 3, -2,
		-8, -1, -7, -1, -6, -1, -5, -1, -2, -1, 4, -1,
		-8, 0, -5, 0, -4, 0, -2, 0, -1, 0, 3, 0, 4, 0,
		-6, 1, -5, 1, 0, 1,
		-4, 2, -3, 2, 1, 2,
		-3, 3, -2, 3, -1, 3, 2, 3, 4, 3, 5, 3, 6, 3, 7, 3,
		-3, 4, 0, 4, 3, 4, 4, 4, 5, 4,
		-1, 5, 0, 5, 1, 5,
		1, 6, 2, 6, 3, 6,
		2, 7, 3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"blockers (p8) (oscillator 7)"}, /* 68 */
#endif
	{
		-4, -2, -3, -2, -2, -2, -1, -2, 4, -2, 5, -2, 6, -2, 7, -2,
		-9, -1, -8, -1, 0, -1, 8, -1,
		-9, 0, -8, 0, -5, 0, -4, 0, 0, 0, 3, 0, 4, 0, 8, 0,
		-5, 1, -4, 1, -1, 1, 3, 1, 4, 1, 7, 1,
		127
	},
#ifdef LIFE_NAMES
	{"boss (p4), from Lexicon"}, /* 69 */
#endif
	{
		0, -7,
		-1, -6, 1, -6,
		-1, -5, 1, -5,
		-2, -4, -1, -4, 1, -4, 2, -4,
		-3, -3, 3, -3,
		-4, -2, -2, -2, 0, -2, 2, -2, 4, -2,
		-4, -1, -2, -1, 2, -1, 4, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-5, 1, -2, 1, 0, 1, 2, 1, 5, 1,
		-3, 2, 3, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		-1, 4, 1, 4,
		-1, 5, 1, 5,
		0, 6,
		127
	},
#ifdef LIFE_NAMES
	{"brain (c/3, p3)"}, /* 70 */
#endif
	{
		-3, -8, -2, -8, 4, -8,
		-5, -7, -4, -7, 4, -7,
		-5, -6, -4, -6, -2, -6, 1, -6, 2, -6, 4, -6,
		1, -5,
		-4, -4, -3, -4, -1, -4, 4, -4,
		-4, -3, -3, -3, 0, -3, 1, -3, 2, -3,
		-2, -2, 5, -2,
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1, 5, -1,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 3, 1, 5, 1,
		-2, 2, 5, 2,
		-4, 3, -3, 3, 0, 3, 1, 3, 2, 3,
		-4, 4, -3, 4, -1, 4, 4, 4,
		1, 5,
		-5, 6, -4, 6, -2, 6, 1, 6, 2, 6, 4, 6,
		-5, 7, -4, 7, 4, 7,
		-3, 8, -2, 8, 4, 8,
		127
	},
#ifdef LIFE_NAMES
	{"buckaroo (queen bee shuttle, piston) (p30)"}, /* 71 */
#endif
	{
		-10, -6,
		-12, -5, -10, -5,
		-11, -4, -10, -4,
		-1, -3,
		-3, -2, -1, -2,
		-4, -1, -2, -1,
		-5, 0, -2, 0, 10, 0, 11, 0,
		-4, 1, -2, 1, 10, 1, 11, 1,
		-9, 2, -8, 2, -3, 2, -1, 2,
		-10, 3, -8, 3, -1, 3,
		-10, 4,
		-11, 5, -10, 5,
		127
	},
#ifdef LIFE_NAMES
	{"bunnies (parent of rabbits, stabilizes at 17332)"}, /* 72 */
#endif
	{
		-4, -2, 2, -2,
		-2, -1, 2, -1,
		-2, 0, 1, 0, 3, 0,
		-3, 1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"burloaferimeter (p7), from Lexicon"}, /* 73 */
#endif
	{
		-1, -5, 0, -5,
		0, -4,
		-1, -3,
		-2, -2, 0, -2, 1, -2, 2, -2,
		-2, -1, 0, -1, 3, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, 3, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		-1, 4, 0, 4,
		-1, 5, 0, 5,
		127
	},
#ifdef LIFE_NAMES
	{"Canada goose (c/4, p4) (diagonal ship)"}, /* 74 */
#endif
	{
		-6, -6, -5, -6, -4, -6,
		-6, -5, 4, -5, 5, -5,
		-5, -4, 2, -4, 3, -4, 4, -4, 6, -4,
		-3, -3, -2, -3, 1, -3, 2, -3,
		-2, -2,
		2, -1,
		-2, 0, -1, 0, 3, 0,
		-3, 1, -1, 1, 1, 1, 2, 1,
		-3, 2, -1, 2, 2, 2, 4, 2, 5, 2,
		-4, 3, 1, 3, 2, 3,
		-4, 4, -3, 4,
		-4, 5, -3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"candelabra (p3), from Lexicon"}, /* 75 */
#endif
	{
		-4, -3, -3, -3, 2, -3, 3, -3,
		-7, -2, -4, -2, 3, -2, 6, -2,
		-8, -1, -6, -1, -4, -1, 3, -1, 5, -1, 7, -1,
		-7, 0, -4, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0, 6, 0,
		-4, 1, -2, 1, 1, 1, 3, 1,
		-3, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"carnival shuttle (p12) (w/ monograms, fencepost)"}, /* 76 */
#endif
	{
		14, -3, 18, -3,
		-19, -2, -18, -2, -14, -2, -13, -2, 14, -2, 15, -2, 16, -2,
			 17, -2, 18, -2,
		-18, -1, -16, -1, -14, -1, -10, -1, -7, -1, 0, -1, 1, -1,
			 5, -1, 8, -1, 16, -1,
		-18, 0, -17, 0, -15, 0, -14, 0, -11, 0, -10, 0, -6, 0, -5, 0,
			 0, 0, 1, 0, 4, 0, 5, 0, 9, 0, 10, 0, 15, 0, 17, 0,
		-18, 1, -16, 1, -14, 1, -10, 1, -7, 1, 0, 1, 1, 1, 5, 1, 8,
			 1, 16, 1,
		-19, 2, -18, 2, -14, 2, -13, 2, 14, 2, 15, 2, 16, 2, 17, 2,
			 18, 2,
		14, 3, 18, 3,
		127
	},
#ifdef LIFE_NAMES
	{"caterer (p3) (question), from Lexicon"}, /* 77 */
#endif
	{
		-2, -4, -1, -4, 0, -4,
		2, -3,
		-3, -2, 2, -2,
		1, -1,
		-2, 0, -1, 0,
		-2, 1,
		-2, 2,
		-2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"cauldron (p8), from Lexicon"}, /* 78 */
#endif
	{
		0, -6,
		-1, -5, 1, -5,
		0, -4,
		-2, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-5, -1, -3, -1, 3, -1, 5, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 2, 1,
		-2, 2, 2, 2,
		-1, 3, 0, 3, 1, 3,
		-1, 5, 0, 5, 2, 5,
		-1, 6, 1, 6, 2, 6,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"cavity (p2), from Lexicon"}, /* -- */
#endif
	{
		-4, -4, -3, -4,
		-3, -3,
		-3, -2, -1, -2, 0, -2,
		-2, -1, 1, -1,
		1, 0,
		0, 1,
		1, 2, 2, 2, 3, 2,
		3, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"chemist (p5), from Lexicon"}, /* 79 */
#endif
	{
		0, -6,
		0, -5, 1, -5, 2, -5,
		3, -4,
		-2, -3, -1, -3, 0, -3, 3, -3, 6, -3, 7, -3,
		-3, -2, -1, -2, 1, -2, 3, -2, 5, -2, 7, -2,
		-3, -1, 1, -1, 3, -1, 5, -1,
		-6, 0, -5, 0, -3, 0, 3, 0, 5, 0, 6, 0,
		-5, 1, -3, 1, -1, 1, 3, 1,
		-7, 2, -5, 2, -3, 2, -1, 2, 1, 2, 3, 2,
		-7, 3, -6, 3, -3, 3, 0, 3, 1, 3, 2, 3,
		-3, 4,
		-2, 5, -1, 5, 0, 5,
		0, 6,
		127
	},
#ifdef LIFE_NAMES
	{"Coe ship (c/2, p16), from Lexicon"}, /* 80 */
#endif
	{
		-1, -4, 0, -4, 1, -4, 2, -4, 3, -4, 4, -4,
		-3, -3, -2, -3, 4, -3,
		-5, -2, -4, -2, -2, -2, 4, -2,
		-1, -1, 3, -1,
		1, 0,
		1, 1, 2, 1,
		0, 2, 1, 2, 2, 2, 3, 2,
		0, 3, 1, 3, 3, 3, 4, 3,
		2, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"converter (using Kok's galaxy (p8) (turbine))"}, /* 81 */
#endif
	{
		-6, -6, -4, -6, -1, -6,
		-6, -5, -5, -5, -4, -5, -2, -5, 0, -5, 1, -5,
		-7, -4, 0, -4, 6, -4,
		-6, -3, 0, -3, 1, -3, 5, -3, 7, -3,
		6, -2, 7, -2,
		-7, -1, -6, -1, 0, -1,
		-6, 0, 1, 0,
		-7, 1, -6, 1, -4, 1, -2, 1, -1, 1, 0, 1,
		-5, 2, -2, 2, 0, 2,
		5, 3, 6, 3, 7, 3,
		5, 4, 7, 4,
		5, 5, 7, 5,
		127
	},
#ifdef LIFE_NAMES
	{"cousins (p3), from Lexicon"}, /* 82 */
#endif
	{
		-1, -3, 1, -3, 2, -3,
		-3, -2, -2, -2, -1, -2, 1, -2, 3, -2,
		-6, -1, -4, -1, 3, -1,
		-6, 0, -5, 0, -3, 0, -2, 0, 0, 0, 1, 0, 3, 0, 5, 0, 6, 0,
		-3, 1, -1, 1, 4, 1, 6, 1,
		-3, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		-2, 3, -1, 3, 1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"cross II (p3), from Lexicon"}, /* 83 */
#endif
	{
		-4, -6, -3, -6, -2, -6, -1, -6, 1, -6, 2, -6, 3, -6, 4, -6,
		-4, -5, -1, -5, 1, -5, 4, -5,
		-6, -4, -5, -4, -4, -4, -1, -4, 0, -4, 1, -4, 4, -4, 5, -4,
			6, -4,
		-6, -3, 6, -3,
		-6, -2, 6, -2,
		-6, -1, -5, -1, -4, -1, 4, -1, 5, -1, 6, -1,
		-4, 0, 4, 0,
		-6, 1, -5, 1, -4, 1, 4, 1, 5, 1, 6, 1,
		-6, 2, 6, 2,
		-6, 3, 6, 3,
		-6, 4, -5, 4, -4, 4, -1, 4, 0, 4, 1, 4, 4, 4, 5, 4, 6, 4,
		-4, 5, -1, 5, 1, 5, 4, 5,
		-4, 6, -3, 6, -2, 6, -1, 6, 1, 6, 2, 6, 3, 6, 4, 6,
		127
	},
#ifdef LIFE_NAMES
	{"crowd (p3), from Lexicon"}, /* 84 */
#endif
	{
		4, -7,
		2, -6, 3, -6, 4, -6,
		-2, -5, -1, -5, 1, -5,
		-2, -4, 2, -4,
		0, -3, 1, -3, 3, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 3, -2,
		-7, -1, -5, -1, 1, -1, 3, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, -4, 0, -2, 0, 4, 0, 6, 0,
		-4, 1, 0, 1, 1, 1, 2, 1, 3, 1,
		-4, 2, -2, 2, -1, 2,
		-3, 3, 1, 3,
		-2, 4, 0, 4, 1, 4,
		-5, 5, -4, 5, -3, 5,
		-5, 6,
		127
	},
#ifdef LIFE_NAMES
	{"dart (c/3, p3), from Lexicon"}, /* 85 */
#endif
	{
		3, -7,
		2, -6, 4, -6,
		1, -5, 2, -5,
		4, -4,
		0, -3, 4, -3,
		-3, -2, 0, -2,
		-4, -1, -2, -1, 1, -1, 2, -1, 3, -1, 4, -1,
		-5, 0, -2, 0,
		-4, 1, -2, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-3, 2, 0, 2,
		0, 3, 4, 3,
		4, 4,
		1, 5, 2, 5,
		2, 6, 4, 6,
		3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"diag sym (p4)"}, /* 86 */
#endif
	{
		-2, -4, 0, -4,
		-2, -3, 0, -3, 2, -3, 3, -3,
		-4, -2, -3, -2, 2, -2,
		0, -1, 1, -1, 2, -1,
		-4, 0, -3, 0, -1, 0, 2, 0,
		-1, 1, 2, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 1, 2,
		-3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"diamond ring (p3) (stargate repeater)"}, /* 87 */
#endif
	{
		0, -6,
		-1, -5, 1, -5,
		-2, -4, 0, -4, 2, -4,
		-2, -3, 2, -3,
		-4, -2, -3, -2, 0, -2, 3, -2, 4, -2,
		-5, -1, 0, -1, 5, -1,
		-6, 0, -4, 0, -2, 0, -1, 0, 1, 0, 2, 0, 4, 0, 6, 0,
		-5, 1, 0, 1, 5, 1,
		-4, 2, -3, 2, 0, 2, 3, 2, 4, 2,
		-2, 3, 2, 3,
		-2, 4, 0, 4, 2, 4,
		-1, 5, 1, 5,
		0, 6,
		127
	},
#ifdef LIFE_NAMES
	{"double ewe, from Lexicon"}, /* 88 */
#endif
	{
		-4, -10, -3, -10,
		-3, -9,
		-4, -8,
		-4, -7, -3, -7,
		-1, -6, 0, -6,
		-4, -5, -3, -5, -2, -5, 0, -5,
		-10, -4, -8, -4, -7, -4, -5, -4,
		-10, -3, -9, -3, -7, -3, -5, -3,
		-5, -2, -1, -2,
		-6, -1, -2, -1, -1, -1, 4, -1, 5, -1,
		-6, 0, -5, 0, 0, 0, 1, 0, 5, 0,
		0, 1, 4, 1,
		4, 2, 6, 2, 8, 2, 9, 2,
		4, 3, 6, 3, 7, 3, 9, 3,
		-1, 4, 1, 4, 2, 4, 3, 4,
		-1, 5, 0, 5,
		2, 6, 3, 6,
		3, 7,
		2, 8,
		2, 9, 3, 9,
		127
	},
#ifdef LIFE_NAMES
	{"dinner table (p12) (whirly thing), from Lexicon"}, /* 89 */
#endif
	{
		-5, -6,
		-5, -5, -4, -5, -3, -5, 5, -5, 6, -5,
		-2, -4, 5, -4,
		-3, -3, -2, -3, 3, -3, 5, -3,
		3, -2, 4, -2,
		0, -1, 1, -1,
		0, 0, 1, 0,
		0, 1, 1, 1,
		-4, 2, -3, 2,
		-5, 3, -3, 3, 2, 3, 3, 3,
		-5, 4, 2, 4,
		-6, 5, -5, 5, 3, 5, 4, 5, 5, 5,
		5, 6,
		127
	},
#ifdef LIFE_NAMES
	{"eater-bound pond (p3), from Lexicon"}, /* 90 */
#endif
	{
		-6, -6,
		-6, -5, -5, -5, -4, -5,
		-3, -4,
		-4, -3, -3, -3,
		-3, -2, -2, -2,
		-2, -1, -1, -1,
		-3, 0, 0, 0,
		-3, 1, 0, 1, 1, 1,
		-2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		2, 3, 4, 3,
		4, 4,
		4, 5, 5, 5,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"eater plug (p2), from Lexicon"}, /* -- */
#endif
	{
		3, -4,
		1, -3, 2, -3, 3, -3,
		0, -2,
		1, -1,
		-2, 0, 1, 0,
		-3, 1, -1, 1, 0, 1,
		-3, 2,
		-4, 3, -3, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"edge-repair spaceship (and Hershel) (c/3, p3)"}, /* 91 */
#endif
	{
		4, -3,
		-12, -2, 3, -2, 4, -2, 5, -2, 6, -2,
		-12, -1, -10, -1, -2, -1, 2, -1, 6, -1, 7, -1, 9, -1, 10, -1,
		-12, 0, -11, 0, -10, 0, -3, 0, -2, 0, -1, 0, 0, 0, 6, 0,
			9, 0, 10, 0,
		-10, 1, -4, 1, 0, 1, 8, 1, 11, 1,
		-3, 2, -1, 2, 2, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"Elkies' p5, from Lexicon"}, /* 92 */
#endif
	{
		-3, -4,
		-4, -3, -1, -3, 0, -3, 1, -3,
		-2, -2,
		-1, -1, 1, -1, 4, -1,
		-2, 0, -1, 0, 1, 0, 2, 0, 3, 0, 4, 0,
		0, 1,
		0, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"en retard (p3)"}, /* 93 */
#endif
	{
		0, -5,
		-1, -4, 1, -4,
		-5, -3, -4, -3, -2, -3, 0, -3, 2, -3, 4, -3, 5, -3,
		-4, -2, -2, -2, 2, -2, 4, -2,
		-5, -1, -2, -1, 0, -1, 2, -1, 5, -1,
		-4, 0, -3, 0, 3, 0, 4, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		-3, 4, -1, 4, 1, 4, 3, 4,
		-3, 5, -2, 5, 2, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"Eureka (p30) (a pre-pulsar shuttle)"}, /* 94 */
#endif
	{
		-8, -5, 7, -5,
		-9, -4, -7, -4, 1, -4, 2, -4, 6, -4, 8, -4,
		-8, -3, 0, -3, 1, -3, 2, -3, 7, -3,
		1, -2, 2, -2,
		1, 2, 2, 2,
		-8, 3, 0, 3, 1, 3, 2, 3, 7, 3,
		-9, 4, -7, 4, 1, 4, 2, 4, 6, 4, 8, 4,
		-8, 5, 7, 5,
		127
	},
#ifdef LIFE_NAMES
	{"extremely impressive (p6), from Lexicon"}, /* 95 */
#endif
	{
		-2, -5, -1, -5,
		-3, -4, -1, -4, 0, -4, 1, -4,
		-3, -3, 2, -3,
		-6, -2, -5, -2, -3, -2, 1, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, 3, -1, 4, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 5, 0,
		4, 1, 5, 1,
		0, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"Fast Forward Force Field with LWSS, from Lexicon"}, /* 96 */
#endif
	{
		-1, -3, 6, -3,
		0, -2, 7, -2, 8, -2,
		-6, -1, -5, -1, -2, -1, -1, -1, 0, -1, 6, -1, 7, -1,
		-8, 0, -7, 0, -5, 0, -4, 0,
		-8, 1, -7, 1, -6, 1, -5, 1, 5, 1,
		-7, 2, -6, 2, 4, 2, 5, 2,
		4, 3, 6, 3,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"figure-8 (p8), from Lexicon"}, /* -- */
#endif
	{
		-3, -3, -2, -3, -1, -3,
		-3, -2, -2, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 0, 1, 0, 2, 0,
		0, 1, 1, 1, 2, 1,
		0, 2, 1, 2, 2, 2,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"fountain (p4), from Lexicon"}, /* 97 */
#endif
	{
		0, -7,
		-6, -5, -5, -5, -3, -5, 3, -5, 5, -5, 6, -5,
		-6, -4, 0, -4, 6, -4,
		-5, -3, -4, -3, -2, -3, -1, -3, 1, -3, 2, -3, 4, -3, 5, -3,
		-3, -1, -2, -1, 2, -1, 3, -1,
		-9, 0, -8, 0, 8, 0, 9, 0,
		-9, 1, -6, 1, -2, 1, 0, 1, 2, 1, 6, 1, 9, 1,
		-8, 2, -7, 2, -6, 2, -4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2,
			2, 2, 3, 2, 4, 2, 6, 2, 7, 2, 8, 2,
		-5, 3, 0, 3, 5, 3,
		-6, 4, -5, 4, 5, 4, 6, 4,
		-6, 5, 6, 5,
		-4, 6, 4, 6,
		-5, 7, -4, 7, 4, 7, 5, 7,
		127
	},
#ifdef LIFE_NAMES
	{"frog II (p3), from Lexicon"}, /* 98 */
#endif
	{
		-3, -6, -2, -6, 2, -6, 3, -6,
		-3, -5, -1, -5, 1, -5, 3, -5,
		-1, -4, 1, -4,
		-2, -3, 0, -3, 2, -3,
		-2, -2, -1, -2, 1, -2, 2, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-5, 0, -2, 0, 0, 0, 2, 0, 5, 0,
		-4, 1, -2, 1, 2, 1, 4, 1,
		-5, 2, -4, 2, -2, 2, 2, 2, 4, 2, 5, 2,
		-1, 3, 0, 3, 1, 3,
		-2, 5, 0, 5, 1, 5,
		-2, 6, -1, 6, 1, 6,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"garden of eden 12x11"},
#endif
	{
		-5, -5, -3, -5, -2, -5, 0, -5, 1, -5, 4, -5,
		-4, -4, -2, -4, -1, -4, 0, -4, 2, -4, 3, -4, 4, -4,
		-4, -3, -3, -3, -1, -3, 0, -3, 1, -3, 3, -3, 5, -3,
		-5, -2, -3, -2, -2, -2, -1, -2, 1, -2, 2, -2, 3, -2, 5, -2,
		-6, -1, -5, -1, -4, -1, -3, -1, -2, -1, 1, -1, 2, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, -2, 0, -1, 0, 0, 0, 2, 0, 5, 0,
		-5, 1, -4, 1, -3, 1, -1, 1, 1, 1, 4, 1,
		-5, 2, -4, 2, -2, 2, -1, 2, 0, 2, 3, 2, 4, 2,
		-6, 3, -4, 3, -3, 3, -2, 3, 0, 3, 1, 3, 2, 3, 4, 3,
		-6, 4, -3, 4, -2, 4, 1, 4, 3, 4, 5, 4,
		4, 5
		127
	},
#endif
#ifdef LIFE_NAMES
	{"germ (p3), from Lexicon"}, /* 99 */
#endif
	{
		-1, -5, 0, -5,
		0, -4,
		-2, -3,
		-3, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-3, -1, 2, -1,
		-4, 0, -3, 0, -1, 0,
		-3, 1, -1, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-5, 2, -3, 2, -1, 2, 4, 2,
		-5, 3, -4, 3, 0, 3, 1, 3, 2, 3,
		2, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"glasses (p2), from Lexicon"}, /* 100 */
#endif
	{
		-5, -5, 4, -5,
		-7, -4, -6, -4, -5, -4, 4, -4, 5, -4, 6, -4,
		-8, -3, 7, -3,
		-8, -2, -5, -2, -4, -2, -3, -2, 2, -2, 3, -2, 4, -2, 7, -2,
		-9, -1, -8, -1, -6, -1, -2, -1, 1, -1, 5, -1, 7, -1, 8, -1,
		-6, 0, -2, 0, -1, 0, 0, 0, 1, 0, 5, 0,
		-6, 1, -2, 1, 1, 1, 5, 1,
		-5, 2, -4, 2, -3, 2, 2, 2, 3, 2, 4, 2,
		-5, 4, -4, 4, -2, 4, 1, 4, 3, 4, 4, 4,
		-5, 5, -3, 5, -2, 5, 1, 5, 2, 5, 4, 5,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"glider-block cycle, from Lexicon"}, /* -- */
#endif
	{
		-1, -3, 0, -3,
		-1, -2, 0, -2,
		-2, 1, 1, 1,
		-4, 2, -2, 2, 1, 2, 3, 2,
		-3, 3, -2, 3, 1, 3, 2, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"glider pusher, from Lexicon"}, /* 101 */
#endif
	{
		-3, -10, -2, -10,
		-3, -9, -2, -9,
		-2, -7,
		-3, -6, -1, -6,
		-3, -5, -1, -5,
		-2, -4,
		-5, -1, -4, -1, -2, -1, 0, -1, 1, -1,
		-5, 0, 1, 0,
		-4, 1, 0, 1,
		-11, 2, -3, 2, -2, 2, -1, 2,
		-10, 3,
		-12, 4, -11, 4, -10, 4,
		5, 7, 10, 7,
		3, 8, 4, 8, 6, 8, 7, 8, 8, 8, 9, 8, 11, 8, 12, 8,
		5, 9, 10, 9,
		127
	},
#ifdef LIFE_NAMES
	{"Gosper glider gun (p30)"}, /* 102 */
#endif
	{
		6, -4,
		5, -3, 6, -3,
		-6, -2, -5, -2, 8, -2, 9, -2, 16, -2,
		-7, -1, 8, -1, 9, -1, 10, -1, 16, -1, 17, -1,
		-18, 0, -17, 0, -8, 0, 8, 0, 9, 1,
		-17, 1, -8, 1, 5, 1, 6, 1,
		-8, 2, 6, 2,
		-7, 3,
		-6, 4, -5, 4,
		127
	},
#ifdef LIFE_NAMES
	{"Gray counter (p4), from Lexicon"}, /* 103 */
#endif
	{
		0, -4,
		-1, -3, 1, -3,
		-2, -2, 0, -2, 2, -2,
		-5, -1, -2, -1, 2, -1, 5, -1,
		-6, 0, -4, 0, -2, 0, 2, 0, 4, 0, 6, 0,
		-5, 1, -2, 1, 2, 1, 5, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"great on-off (p2), from Lexicon"}, /* --- */
#endif
	{
		-2, -4, -1, -4,
		-3, -3, 0, -3,
		-3, -2, -1, -2,
		-4, -1, -3, -1, -1, -1, 2, -1,
		0, 0, 1, 0, 3, 0,
		3, 1,
		0, 2, 1, 2, 2, 2,
		0, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"harbor (p5), from Lexicon"}, /* 104 */
#endif
	{
		-3, -8, -2, -8, 2, -8, 3, -8,
		-3, -7, -1, -7, 1, -7, 3, -7,
		-2, -6, 2, -6,
		-3, -4, -2, -4, 2, -4, 3, -4,
		-8, -3, -7, -3, -4, -3, -2, -3, 2, -3, 4, -3, 7, -3, 8, -3,
		-8, -2, -6, -2, -4, -2, -3, -2, 3, -2, 4, -2, 6, -2, 8, -2,
		-7, -1, 7, -1,
		-7, 1, 7, 1,
		-8, 2, -6, 2, -4, 2, -3, 2, 3, 2, 4, 2, 6, 2, 8, 2,
		-8, 3, -7, 3, -4, 3, -2, 3, 2, 3, 4, 3, 7, 3, 8, 3,
		-3, 4, -2, 4, 2, 4, 3, 4,
		-2, 6, 2, 6,
		-3, 7, -1, 7, 1, 7, 3, 7,
		-3, 8, -2, 8, 2, 8, 3, 8,
		127
	},
#ifdef LIFE_NAMES
	{"Hertz oscillator (p8)"}, /* 105 */
#endif
	{
		-2, -5, -1, -5,
		-2, -4, -1, -4,
		-7, -2, -6, -2, -2, -2, -1, -2, 0, -2, 1, -2, 5, -2, 6, -2,
		-7, -1, -5, -1, -3, -1, 2, -1, 4, -1, 6, -1,
		-5, 0, -3, 0, -2, 0, 2, 0, 4, 0,
		-6, 1, -5, 1, -3, 1, 2, 1, 4, 1, 5, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		-2, 4, -1, 4,
		-2, 5, -1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"hustler (p3), from Lexicon"}, /* 106 */
#endif
	{
		0, -6, 1, -6,
		0, -5, 1, -5,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-5, -2, -3, -2, 2, -2,
		-5, -1, -4, -1, -2, -1, 2, -1,
		-2, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 3, 1, 5, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		-1, 4, 0, 4,
		-1, 5, 0, 5,
		127
	},
#ifdef LIFE_NAMES
	{"hustler II (p4), from Lexicon"}, /* 107 */
#endif
	{
		-4, -6,
		-4, -5, -3, -5, -2, -5,
		-1, -4,
		-2, -3, 1, -3, 2, -3,
		-8, -2, -6, -2, -5, -2, -3, -2, -1, -2, 0, -2, 3, -2,
		-8, -1, -7, -1, -5, -1, -3, -1, 3, -1,
		-3, 0, 2, 0,
		-4, 1, 2, 1, 4, 1, 6, 1, 7, 1,
		-4, 2, -1, 2, 0, 2, 2, 2, 4, 2, 5, 2, 7, 2,
		-3, 3, -2, 3, 1, 3,
		0, 4,
		1, 5, 2, 5, 3, 5,
		3, 6,
		127
	},
#ifdef LIFE_NAMES
	{"HW emulator (p4), from Lexicon"}, /* 108 */
#endif
	{
		-1, -3, 0, -3,
		-6, -2, -5, -2, -3, -2, 2, -2, 4, -2, 5, -2,
		-6, -1, 5, -1,
		-5, 0, -4, 0, 3, 0, 4, 0,
		-8, 1, -7, 1, -6, 1, -3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
			5, 1, 6, 1, 7, 1,
		-8, 2, -5, 2, 4, 2, 7, 2,
		-7, 3, -6, 3, 5, 3, 6, 3,
		127
	},
#ifdef LIFE_NAMES
	{"infinite growth 1 (from smallest number)"}, /* 109 */
#endif
	{
		2, -3,
		0, -2, 2, -2, 3, -2,
		0, -1, 2, -1,
		0, 0,
		-2, 1,
		-4, 2, -2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"infinite growth 2 (from smallest area)"}, /* 110 */
#endif
	{
		-2, -2, -1, -2, 0, -2, 2, -2,
		-2, -1,
		1, 0, 2, 0,
		-1, 1, 0, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"infinite growth 3 (from 1 dimension)"}, /* 111 */
#endif
	{
		-19, 0, -18, 0, -17, 0, -16, 0, -15, 0, -14, 0, -13, 0,
			-12, 0, -10, 0, -9, 0, -8, 0, -7, 0, -6, 0, -2, 0,
			 -1, 0, 0, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0,
			 13, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
		127
	},
#ifdef LIFE_NAMES
	{"jack (p4), from Lexicon"}, /* 112 */
#endif
	{
		-3, -4, 3, -4,
		-3, -3, -2, -3, 2, -3, 3, -3,
		-6, -2, -3, -2, -2, -2, 2, -2, 3, -2, 6, -2,
		-6, -1, -5, -1, -4, -1, -1, -1, 1, -1, 4, -1, 5, -1, 6, -1,
		-1, 0, 1, 0,
		-6, 1, -5, 1, -4, 1, -1, 1, 1, 1, 4, 1, 5, 1, 6, 1,
		-6, 2, -3, 2, -2, 2, 2, 2, 3, 2, 6, 2,
		-3, 3, -2, 3, 2, 3, 3, 3,
		-3, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"jam (p3), from Lexicon"}, /* 113 */
#endif
	{
		0, -3, 1, -3,
		-1, -2, 2, -2,
		-3, -1, 0, -1, 2, -1,
		-3, 0, 1, 0,
		-3, 1,
		0, 2,
		-2, 3, -1, 3,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"Kok's galaxy (p8), from Lexicon"}, /* --- */
#endif
	{
		-4, -4, -3, -4, -2, -4, -1, -4, 0, -4, 1, -4, 3, -4, 4, -4,
		-4, -3, -3, -3, -2, -3, -1, -3, 0, -3, 1, -3, 3, -3, 4, -3,
		3, -2, 4, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-4, 0, -3, 0, 3, 0, 4, 0,
		-4, 1, -3, 1, 3, 1, 4, 1,
		-4, 2, -3, 2,
		-4, 3, -3, 3, -1, 3, 0, 3, 1, 3, 2, 3, 3, 3, 4, 3,
		-4, 4, -3, 4, -1, 4, 0, 4, 1, 4, 2, 4, 3, 4, 4, 4,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"Laputa (p2), from Lexicon"}, /* 114 */
#endif
	{
		-3, -3, -2, -3, 0, -3, 1, -3,
		-3, -2, -2, -2, 0, -2, 4, -2, 5, -2,
		2, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 2, 0, 3, 0, 4, 0,
		-6, 1, -3, 1, -1, 1,
		-6, 2, -5, 2, -1, 2, 1, 2, 2, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"light bulb (p2), from Lexicon"}, /* 115 */
#endif
	{
		-2, -4, -1, -4, 1, -4,
		-2, -3, 0, -3, 1, -3,
		-1, -1, 0, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1,
		-1, 2, 1, 2,
		-3, 3, -1, 3, 1, 3, 3, 3,
		-3, 4, -2, 4, 2, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"light bulb II (p2), from Lexicon"}, /* 116 */
#endif
	{
		-1, -4,
		-3, -3, -2, -3, -1, -3,
		-4, -2,
		-4, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1,
		2, 0,
		-2, 1, 2, 1,
		-2, 2, -1, 2, 1, 2,
		2, 3, 3, 3, 4, 3,
		4, 4,
		127
	},
#ifdef LIFE_NAMES
	{"loading dock (p3), from Lexicon"}, /* 117 */
#endif
	{
		0, -4,
		-2, -3, -1, -3, 0, -3,
		-3, -2, 1, -2, 2, -2,
		-4, -1, -2, -1, -1, -1, 3, -1,
		-3, 0, 1, 0, 2, 0, 4, 0,
		-2, 1, -1, 1, 3, 1,
		0, 2, 1, 2, 2, 2,
		0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"LW emulator (p4), from Lexicon"}, /* 118 */
#endif
	{
		-5, -3, -4, -3, -2, -3, 1, -3, 3, -3, 4, -3,
		-5, -2, 4, -2,
		-4, -1, -3, -1, 2, -1, 3, -1,
		-7, 0, -6, 0, -5, 0, -2, 0, -1, 0, 0, 0, 1, 0, 4, 0, 5, 0,
			6, 0,
		-7, 1, -4, 1, 3, 1, 6, 1,
		-6, 2, -5, 2, 4, 2, 5, 2,
		127
	},
#ifdef LIFE_NAMES
	{"mathematician (p5), from Lexicon"}, /* 119 */
#endif
	{
		0, -5,
		-1, -4, 1, -4,
		-1, -3, 1, -3,
		-2, -2, -1, -2, 1, -2, 2, -2,
		-4, -1, 4, -1,
		-4, 0, -3, 0, -2, 0, 2, 0, 3, 0, 4, 0,
		-4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		-4, 3, 4, 3,
		-1, 4, 0, 4, 1, 4, 2, 4,
		-1, 5, 2, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"metamorphosis, from Lexicon"}, /* 120 */
#endif
	{
		5, -9,
		6, -8,
		4, -7, 5, -7, 6, -7,
		-2, -1, 2, -1, 8, -1, 10, -1, 11, -1,
		-14, 0, -13, 0, -3, 0, 3, 0, 8, 0, 10, 0, 12, 0,
		-14, 1, -13, 1, -3, 1, 7, 1, 12, 1,
		-3, 2, -2, 2, 2, 2, 8, 2, 10, 2, 12, 2,
		-1, 3, 0, 3, 1, 3, 8, 3, 10, 3, 11, 3,
		-1, 5, 0, 5, 1, 5,
		-3, 6, -2, 6, 2, 6,
		-14, 7, -13, 7, -3, 7, 13, 7, 14, 7,
		-14, 8, -13, 8, -3, 8, 3, 8, 13, 8, 14, 8,
		-2, 9, 2, 9,
		127
	},
#ifdef LIFE_NAMES
	{"metamorphosis II, from Lexicon"}, /* 121 */
#endif
	{
		10, -15,
		9, -14,
		9, -13, 10, -13, 11, -13,
		-3, -10, -1, -10,
		-3, -9, 0, -9,
		-12, -8, -11, -8, 0, -8, 1, -8,
		-12, -7, -11, -7, -2, -7, 2, -7, 3, -7,
		-7, -6, -6, -6, 0, -6, 1, -6,
		-8, -5, -3, -5, 0, -5,
		-3, -4, -1, -4,
		4, 1,
		3, 2, 4, 2, 5, 2,
		2, 3, 3, 3, 4, 3, 5, 3, 6, 3,
		1, 4, 3, 4, 5, 4, 7, 4,
		1, 5, 2, 5, 6, 5, 7, 5,
		4, 8,
		3, 9, 5, 9,
		3, 10, 5, 10,
		4, 11,
		3, 12, 4, 12,
		3, 13, 4, 13,
		3, 14, 4, 14,
		127
	},
#ifdef LIFE_NAMES
	{"mini pressure cooker (p3), from Lexicon"}, /* 122 */
#endif
	{
		0, -5,
		-1, -4, 1, -4,
		-1, -3, 1, -3,
		-2, -2, -1, -2, 1, -2, 2, -2,
		-5, -1, -3, -1, 3, -1, 5, -1,
		-5, 0, -4, 0, -2, 0, 0, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"multum in parvo (stabilizes at 3933)"}, /* 123 */
#endif
	{
		0, -2, 1, -2, 2, -2,
		-1, -1, 2, -1,
		-2, 0,
		-3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"MW emulator (p4), from Lexicon"}, /* 124 */
#endif
	{
		-5, -3, -4, -3, -2, -3, 2, -3, 4, -3, 5, -3,
		-5, -2, 5, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-7, 0, -6, 0, -5, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 5, 0,
			6, 0, 7, 0,
		-7, 1, -4, 1, 4, 1, 7, 1,
		-6, 2, -5, 2, 5, 2, 6, 2,
		127
	},
#ifdef LIFE_NAMES
	{"MW volcano (p5), from Lexicon"}, /* 125 */
#endif
	{
		0, -6,
		-2, -5, 2, -5,
		-3, -3, 3, -3,
		-5, -2, -4, -2, -3, -2, -1, -2, 0, -2, 1, -2, 3, -2, 4, -2, 5, -2,
		-6, -1, -2, -1, -1, -1, 1, -1, 2, -1, 6, -1,
		-6, 0, -4, 0, -3, 0, -2, 0, 0, 0, 2, 0, 3, 0, 4, 0, 5, 0,
		-5, 1,
		-3, 2, -1, 2, 1, 2, 3, 2, 4, 2, 6, 2,
		-4, 3, -3, 3, -1, 3, 0, 3, 1, 3, 3, 3, 5, 3, 6, 3,
		-3, 4, -1, 4, 2, 4,
		-3, 5, 0, 5, 1, 5,
		-4, 6, -3, 6,
		127
	},
#ifdef LIFE_NAMES
	{"negentropy (p2), from Lexicon"}, /* 126 */
#endif
	{
		-2, -6, -1, -6, 1, -6,
		-2, -5, 0, -5, 1, -5,
		-1, -3, 0, -3, 1, -3,
		-2, -2, 0, -2, 2, -2, 4, -2, 5, -2,
		-2, -1, -1, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -2, 0, 2, 0,
		-5, 1, -4, 1, -2, 1, 2, 1,
		-1, 2, 0, 2, 1, 2,
		-1, 4, 0, 4, 2, 4,
		-1, 5, 1, 5, 2, 5,
		127
	},
#ifdef LIFE_NAMES
	{"new five (p3), from Lexicon"}, /* 127 */
#endif
	{
		-2, -4, -1, -4,
		-3, -3, 0, -3,
		-3, -2, -1, -2, 2, -2,
		-4, -1, -3, -1, -1, -1, 1, -1, 2, -1,
		-4, 0,
		-3, 1, -2, 1, -1, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		1, 2, 4, 2,
		-4, 3, -2, 3, -1, 3,
		-4, 4, -3, 4, -1, 4, 0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"Noah's ark (2 switch engines), from Lexicon"}, /* 128 */
#endif
	{
		3, -7, 5, -7,
		2, -6,
		3, -5, 6, -5,
		5, -4, 6, -4, 7, -4,
		-6, 2,
		-7, 3, -5, 3,
		-7, 5, -4, 5,
		-5, 6, -4, 6,
		-4, 7,
		127
	},
#ifdef LIFE_NAMES
	{"octagon II (p5) (shining flower)"}, /* 129 */
#endif
	{
		-1, -4, 0, -4,
		-2, -3, 1, -3,
		-3, -2, 2, -2,
		-4, -1, 3, -1,
		-4, 0, 3, 0,
		-3, 1, 2, 1,
		-2, 2, 1, 2,
		-1, 3, 0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"octagon IV (p4), from Lexicon"}, /* 130 */
#endif
	{
		-1, -8, 0, -8,
		-1, -7, 0, -7,
		-2, -5, -1, -5, 0, -5, 1, -5,
		-3, -4, 2, -4,
		-4, -3, 3, -3,
		-5, -2, 4, -2,
		-8, -1, -7, -1, -5, -1, 4, -1, 6, -1, 7, -1,
		-8, 0, -7, 0, -5, 0, 4, 0, 6, 0, 7, 0,
		-5, 1, 4, 1,
		-4, 2, 3, 2,
		-3, 3, 2, 3,
		-2, 4, -1, 4, 0, 4, 1, 4,
		-1, 6, 0, 6,
		-1, 7, 0, 7,
		127
	},
#ifdef LIFE_NAMES
	{"odd keys (p3), fom Lexicon"}, /* 131 */
#endif
	{
		4, -2,
		-5, -1, 3, -1, 5, -1,
		-6, 0, -4, 0, -3, 0, -2, 0, 1, 0, 2, 0, 4, 0,
		-5, 1, -2, 1, 1, 1,
		-2, 2, 1, 2,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"Orion (c/4 diagonal, p4) (big glider 1)"}, /* --- */
#endif
	{
		-4, -7, -3, -7,
		-4, -6, -2, -6,
		-4, -5,
		-7, -4, -6, -4, -4, -4,
		-7, -3, -2, -3,
		-7, -2, -5, -2, -4, -2, 3, -2, 4, -2, 5, -2,
		-2, -1, -1, -1, 0, -1, 5, -1, 6, -1,
		-1, 0, 0, 0, 1, 0, 3, 0, 5, 0,
		6, 1,
		-1, 2, 1, 2,
		-2, 3, -1, 3, 1, 3,
		-1, 4,
		-3, 5, -2, 5, 0, 5,
		0, 6,
		-2, 7, -1, 7,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"Orion (c/4 diagonal, p4) (smaller variant)"},
#endif
	{
		-5, -6, -4, -6,
		-6, -5, -5, -5,
		-4, -4,
		-2, -3, 3, -3, 4, -3, 5, -3,
		-2, -2, -1, -2, 0, -2, 5, -2, 6, -2,
		-1, -1, 0, -1, 1, -1, 3, -1, 5, -1,
		6, 0,
		-1, 1, 1, 1,
		-2, 2, -1, 2, 1, 2,
		-1, 3,
		-3, 4, -2, 4, 0, 4,
		0, 5,
		-2, 6, -1, 6,
		127
	},
#ifdef LIFE_NAMES
	{"p22 oscillator, from Lexicon"},
#endif
	{
		-13, -5, -12, -5,
		-12, -4,
		-12, -3, -10, -3, 5, -3, 6, -3,
		-11, -2, -10, -2, 3, -2, 4, -2, 7, -2,
		-7, -1, -6, -1, -5, -1, 3, -1, 4, -1, 6, -1, 7, -1,
		-7, 0, -6, 0, -4, 0, -3, 0, 5, 0, 6, 0, 7, 0,
		-7, 1, -4, 1, -3, 1, 10, 1, 11, 1,
		-6, 2, -5, 2, 10, 2, 12, 2,
		12, 3,
		12, 4, 13, 4,
		127
	},
#ifdef LIFE_NAMES
	{"p54 shuttle (piston3)"},
#endif
	{
		-14, -8, -13, -8, 13, -8, 14, -8,
		-13, -7, 13, -7,
		-13, -6, -11, -6, 11, -6, 13, -6,
		-12, -5, -11, -5, -1, -5, 11, -5, 12, -5,
		0, -4,
		-6, -3, -5, -3, 1, -3,
		-6, -2, -5, -2, -2, -2, 0, -2,
		-1, -1,
		-1, 1,
		-6, 2, -5, 2, -2, 2, 0, 2,
		-6, 3, -5, 3, 1, 3,
		0, 4,
		-12, 5, -11, 5, -1, 5, 11, 5, 12, 5,
		-13, 6, -11, 6, 11, 6, 13, 6,
		-13, 7, 13, 7,
		-14, 8, -13, 8, 13, 8, 14, 8,
		127
	},
#ifdef LIFE_NAMES
	{"pedestle (p5)"},
#endif
	{
		0, -8,
		-1, -7, 1, -7,
		-4, -6, -1, -6, 0, -6,
		-4, -5, -3, -5, -2, -5,
		0, -4, 1, -4, 2, -4,
		-2, -3, -1, -3, 3, -3,
		-3, -2, 2, -2, 5, -2,
		-4, -1, -2, -1, 0, -1, 2, -1, 4, -1, 5, -1,
		-4, 0, -2, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, 0, 1, 2, 1, 4, 1,
		-5, 2, -2, 2, 3, 2,
		-3, 3, 1, 3, 2, 3,
		-2, 4, -1, 4, 0, 4,
		2, 5, 3, 5, 4, 5,
		0, 6, 1, 6, 4, 6,
		-1, 7, 1, 7,
		0, 8,
		127
	},
#ifdef LIFE_NAMES
	{"penny lane (p4)"},
#endif
	{
		-4, -5, -3, -5, 3, -5, 4, -5,
		-4, -4, 4, -4,
		-7, -3, -6, -3, -4, -3, 4, -3, 6, -3, 7, -3,
		-7, -2, -6, -2, -4, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2,
			 4, -2, 6, -2, 7, -2,
		-3, -1, 0, -1, 3, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		0, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"pentadecathlon (p15), from Lexicon"},
#endif
	{
	/* -5, 0, -4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, */
		1, -4,
		1, -3, 3, -3,
		1, -2, 2, -2,
		-5, 0, -4, 0, -3, 0,
		-3, 1,
		-4, 2, 2, 2, 3, 2,
		3, 3, 4, 3,
		2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"pentant (p5), from Lexicon"},
#endif
	{
		-5, -6, -4, -6,
		-4, -5,
		-4, -4, -2, -4,
		-3, -3, -2, -3, 3, -3, 4, -3,
		4, -2,
		0, -1, 1, -1, 2, -1, 3, -1,
		0, 0,
		-3, 1, 1, 1, 2, 1, 3, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 3, 2,
		0, 3,
		-1, 4,
		-1, 5, 0, 5,
		127
	},
#ifdef LIFE_NAMES
	{"pentoad (p5), from Lexicon"},
#endif
	{
		5, -6, 6, -6,
		5, -5,
		3, -4, 5, -4,
		3, -3, 4, -3,
		-1, -2, 0, -2,
		0, -1,
		0, 0,
		0, 1, 1, 1,
		-4, 2, -3, 2,
		-5, 3, -3, 3,
		-5, 4,
		-6, 5, -5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"pi oscillator (p88)"},
#endif
	{
		6, -12,
		4, -11, 5, -11, 6, -11,
		3, -10,
		3, -9, 4, -9,
		-13, -8, -12, -8, 8, -8, 9, -8,
		-12, -7, 8, -7,
		-12, -6, -10, -6, 6, -6, 8, -6,
		-11, -5, -10, -5, 6, -5, 7, -5,
		0, -3, 1, -3, 2, -3,
		0, -2, 2, -2,
		0, -1, 2, -1,
		-7, 5, -6, 5, 10, 5, 11, 5,
		-8, 6, -6, 6, 10, 6, 12, 6,
		-8, 7, 12, 7,
		-9, 8, -8, 8, 12, 8, 13, 8,
		-4, 9, -3, 9,
		-3, 10,
		-6, 11, -5, 11, -4, 11,
		-6, 12,
		127
	},
#ifdef LIFE_NAMES
	{"pipsquirter (example) (p6), from Lexicon"},
#endif
	{
		-2, -7,
		-2, -6,
		-4, -4, 0, -4,
		-6, -3, -5, -3, -4, -3, -2, -3, 0, -3, 1, -3, 2, -3,
		-7, -2, -3, -2, -2, -2, 3, -2,
		-7, -1, -5, -1, -4, -1, -1, -1, 0, -1, 2, -1, 4, -1,
		-6, 0, -3, 0, -2, 0, 1, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -1, 1, 0, 1, 2, 1, 4, 1, 6, 1, 7, 1,
		-3, 2, 0, 2, 2, 2, 4, 2, 6, 2, 7, 2,
		-3, 3, -2, 3, -1, 3, 0, 3, 2, 3, 3, 3,
		1, 4,
		-1, 5, 1, 5,
		-1, 6, 0, 6,
		127
	},
#ifdef LIFE_NAMES
	{"pi ship with fuse (], near ship)"},
#endif
	{
		0, -2,
		-1, -1, 1, -1,
		-12, 0, -11, 0, -2, 0, -1, 0, 1, 0, 2, 0, 11, 0, 12, 0,
		-12, 1, -11, 1, 11, 1, 12, 1,
		127
	},
#ifdef LIFE_NAMES
	{"piston (p2)"},
#endif
	{
		-5, -2, -4, -2, 4, -2, 5, -2,
		-5, -1, -3, -1, 0, -1, 3, -1, 5, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 3, 0,
		-5, 1, -3, 1, 0, 1, 3, 1, 5, 1,
		-5, 2, -4, 2, 4, 2, 5, 2,
		127
	},
#ifdef LIFE_NAMES
	{"pre-pulsar oscillator (p28) (4 molds, flutter)"},
#endif
	{
		-9, -7, -7, -7, 7, -7, 9, -7,
		-6, -6, 6, -6,
		-10, -5, -7, -5, 7, -5, 10, -5,
		-11, -4, -9, -4, -7, -4, 7, -4, 9, -4, 11, -4,
		-11, -3, -8, -3, 8, -3, 11, -3,
		-10, -2, -9, -2, -4, -2, -3, -2, -2, -2,
		2, -2, 3, -2, 4, -2, 9, -2, 10, -2,
		-3, -1, 3, -1,
		-10, 1, -9, 1, 9, 1, 10, 1,
		-11, 2, -8, 2, 8, 2, 11, 2,
		-11, 3, -9, 3, -6, 3, 6, 3, 9, 3, 11, 3,
		-10, 4, 10, 4,
		-9, 5, -8, 5, -6, 5, 6, 5, 8, 5, 9, 5,
		-7, 6, 7, 6,
		127
	},
#ifdef LIFE_NAMES
	{"pressure cooker (p3)"},
#endif
	{
		0, -6,
		-1, -5, 1, -5,
		-1, -4, 1, -4,
		-2, -3, -1, -3, 1, -3, 2, -3,
		-5, -2, -3, -2, 3, -2, 5, -2,
		-5, -1, -4, -1, -2, -1, 0, -1, 2, -1, 4, -1, 5, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1,
		-1, 2, 0, 2, 1, 2,
		-2, 4, 0, 4, 1, 4,
		-2, 5, -1, 5, 1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"protein (p3), from Lexicon"},
#endif
	{
		-2, -6, -1, -6,
		-2, -5,
		0, -4,
		-4, -3, -3, -3, -2, -3, -1, -3, 1, -3, 3, -3, 4, -3,
		-5, -2, 1, -2, 3, -2, 6, -2,
		-5, -1, -2, -1, -1, -1, 1, -1, 3, -1, 5, -1, 6, -1,
		-6, 0, -5, 0, -3, 0, 3, 0,
		-3, 1, 0, 1, 1, 1, 3, 1,
		-3, 2, 2, 2,
		-2, 3, -1, 3, 0, 3, 1, 3,
		-2, 5, -1, 5,
		-2, 6, -1, 6,
		127
	},
#ifdef LIFE_NAMES
	{"puffer (example), from Lexicon"},
#endif
	{
		-12, -3, -11, -3, -10, -3, -3, -3, 3, -3, 10, -3, 11, -3,
			12, -3,
		-13, -2, -10, -2, -4, -2, -3, -2, -2, -2, 2, -2, 3, -2, 4,
			-2, 10, -2, 13, -2,
		-10, -1, -5, -1, -4, -1, -2, -1, 2, -1, 4, -1, 5, -1, 10, -1,
		-10, 0, 10, 0,
		-10, 1, -7, 1, 7, 1, 10, 1,
		-10, 2, -7, 2, -6, 2, 6, 2, 7, 2, 10, 2,
		-11, 3, -7, 3, -6, 3, 6, 3, 7, 3, 11, 3,
		127
	},
#ifdef LIFE_NAMES
	{"puffer train, from Lexicon"},
#endif
	{
		1, -9,
		2, -8,
		-2, -7, 2, -7,
		-1, -6, 0, -6, 1, -6, 2, -6,
		-2, -2,
		-1, -1, 0, -1,
		0, 0,
		0, 1,
		-1, 2,
		1, 5,
		2, 6,
		-2, 7, 2, 7,
		-1, 8, 0, 8, 1, 8, 2, 8,
		127
	},
#ifdef LIFE_NAMES
	{"pulsar (p3) (pulsar CP 48-56-72)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"pushalong (example), from Lexicon"},
#endif
	{
		-4, -6, -3, -6, -2, -6, 0, -6,
		-5, -5, -4, -5, -3, -5, -2, -5, 0, -5,
		-6, -4, -5, -4,
		-5, -3, -3, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		0, 3, 5, 3,
		0, 4,
		1, 5, 5, 5,
		3, 6,
		127
	},
#ifdef LIFE_NAMES
	{"pyrotechnecium (p8), from Lexicon"},
#endif
	{
		-1, -5,
		-3, -4, -2, -4, -1, -4, 0, -4, 1, -4,
		-4, -3, 2, -3,
		-7, -2, -4, -2, -2, -2, 0, -2, 1, -2, 3, -2,
		-8, -1, -6, -1, -4, -1, -2, -1, 3, -1, 6, -1,
		-7, 0, -4, 0, 1, 0, 3, 0, 5, 0, 7, 0,
		-4, 1, -2, 1, -1, 1, 1, 1, 3, 1, 6, 1,
		-3, 2, 3, 2,
		-2, 3, -1, 3, 0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"R2D2 (p8)"},
#endif
	{
		0, -5,
		-1, -4, 1, -4,
		-2, -3, 0, -3, 2, -3,
		-2, -2, 0, -2, 2, -2,
		-5, -1, -4, -1, -2, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"rake p20 backwards"},
#endif
	{
		0, -10, 1, -10, 10, -10,
		-1, -9, 0, -9, 1, -9, 2, -9, 11, -9,
		-1, -8, 0, -8, 2, -8, 3, -8, 7, -8, 11, -8,
		1, -7, 2, -7, 8, -7, 9, -7, 10, -7, 11, -7,
		6, -3, 7, -3,
		5, -2, 6, -2, 8, -2, 9, -2,
		6, -1, 9, -1,
		6, 0, 9, 0,
		7, 1, 8, 1,
		10, 4,
		11, 5,
		-8, 6, 7, 6, 11, 6,
		-7, 7, 8, 7, 9, 7, 10, 7, 11, 7,
		-11, 8, -7, 8,
		-10, 9, -9, 9, -8, 9, -7, 9,
		127
	},
#ifdef LIFE_NAMES
	{"rake p20 forwards"},
#endif
	{
		0, -10, 1, -10, 10, -10,
		-1, -9, 0, -9, 1, -9, 2, -9, 11, -9,
		-1, -8, 0, -8, 2, -8, 3, -8, 7, -8, 11, -8,
		1, -7, 2, -7, 8, -7, 9, -7, 10, -7, 11, -7,
		6, -3, 7, -3,
		5, -2, 6, -2, 8, -2, 9, -2,
		6, -1, 9, -1,
		6, 0, 9, 0,
		7, 1, 8, 1,
		10, 4,
		11, 5,
		7, 6, 11, 6,
		-9, 7, -8, 7, -7, 7, -6, 7, 8, 7, 9, 7, 10, 7, 11, 7,
		-10, 8, -6, 8,
		-6, 9,
		-7, 10,
		127
	},
#ifdef LIFE_NAMES
	{"rake p24 backwards"},
#endif
	{
		-5, -10,
		-4, -9,
		-10, -8, -4, -8,
		-9, -7, -8, -7, -7, -7, -6, -7, -5, -7, -4, -7,
		6, -6, 7, -6,
		5, -5, 6, -5, 7, -5, 8, -5,
		5, -4, 6, -4, 8, -4, 9, -4,
		7, -3, 8, -3,
		0, -2, 2, -2,
		-1, -1, 2, -1, 3, -1,
		0, 0, 2, 0,
		7, 1, 8, 1,
		5, 2, 6, 2, 8, 2, 9, 2,
		5, 3, 6, 3, 7, 3, 8, 3,
		6, 4, 7, 4,
		-5, 6, -4, 6,
		-9, 7, -8, 7, -7, 7, -6, 7, -4, 7, -3, 7,
		-9, 8, -8, 8, -7, 8, -6, 8, -5, 8, -4, 8,
		-8, 9, -7, 9, -6, 9, -5, 9,
		127
	},
#ifdef LIFE_NAMES
	{"rats (p6)"},
#endif
	{
		-1, -5, 0, -5,
		0, -4,
		-2, -3,
		-6, -2, -5, -2, -3, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, 3, -1, 5, -1,
		-3, 0, 0, 0, 1, 0, 2, 0, 4, 0, 5, 0,
		-3, 1, 2, 1,
		-2, 2, -1, 2, 0, 2, 2, 2,
		1, 3,
		0, 4,
		0, 5, 1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"reflector (figure-8 example), from Lexicon"},
#endif
	{
		-2, -7, -1, -7, 5, -7, 6, -7,
		-8, -6, -6, -6, -2, -6, -1, -6, 5, -6,
		-7, -5, -6, -5, 3, -5, 5, -5,
		-7, -4, 3, -4, 4, -4,
		-1, -3, 0, -3,
		-1, -2, 1, -2,
		0, -1,
		3, 1, 4, 1, 5, 1,
		3, 2, 4, 2, 5, 2,
		3, 3, 4, 3, 5, 3,
		6, 4, 7, 4, 8, 4,
		6, 5, 7, 5, 8, 5,
		6, 6, 7, 6, 8, 6,
		127
	},
#ifdef LIFE_NAMES
	{"relay (p(60+120n)), from Lexicon"},
#endif
	{
		10, -3, 15, -3,
		-1, -2, 0, -2, 8, -2, 9, -2, 11, -2, 12, -2, 13, -2, 14, -2,
			16, -2, 17, -2,
		0, -1, 1, -1, 10, -1, 15, -1,
		-1, 0,
		-15, 1, -10, 1,
		-17, 2, -16, 2, -14, 2, -13, 2, -12, 2, -11, 2, -9, 2, -8, 2,
		-15, 3, -10, 3,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"rephaser"},
#endif
	{
		-2, -3, 1, -3,
		-4, -2, -2, -2, 1, -2, 3, -2,
		-3, -1, -2, -1, 1, -1, 2, -1,
		-1, 2, 0, 2,
		-1, 3, 0, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"R-pentomino (stabilizes at 1103), from Lexicon"},
#endif
	{
		0, -1, 1, -1,
		-1, 0, 0, 0,
		0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"Schick engine (c/2, p12) (sym puffer)"},
#endif
	{
		1, -4, 2, -4, 3, -4, 4, -4,
		0, -3, 4, -3,
		4, -2,
		-4, -1, -3, -1, 0, -1, 3, -1,
		-4, 0, -3, 0, -2, 0,
		-4, 1, -3, 1, 0, 1, 3, 1,
		4, 2,
		0, 3, 4, 3,
		1, 4, 2, 4, 3, 4, 4, 4,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"scrubber (p2), from Lexicon"},
#endif
	{
		-1, -5,
		-3, -4, -2, -4, -1, -4,
		-4, -3,
		-4, -2, -1, -2, 0, -2, 1, -2,
		-5, -1, -4, -1, -2, -1, 2, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1, 4, 1, 5, 1,
		-1, 2, 0, 2, 1, 2, 4, 2,
		4, 3,
		1, 4, 2, 4, 3, 4,
		1, 5,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"ship smallest known c/3, p3"},
#endif
	{
		0, -8,
		-1, -7, 1, -7,
		-1, -6, 1, -6,
		-1, -5,
		-2, -3, -1, -3,
		-1, -2, 1, -2,
		-2, -1, 0, -1,
		-2, 0, -1, 0, 0, 0,
		-1, 2, 1, 2,
		-1, 3, 0, 3,
		0, 4,
		0, 5, 2, 5,
		0, 6, 2, 6,
		1, 7,
		127
	},
#ifdef LIFE_NAMES
	{"ship smallest known 2c/5, p5"},
#endif
	{
		0, -6,
		-3, -5, -2, -5, 0, -5, 1, -5,
		-4, -4, -2, -4, 0, -4,
		-5, -3, -4, -3, 0, -3,
		-4, -2, -2, -2, 1, -2,
		-3, -1, -2, -1, 0, -1,
		1, 1, 2, 1,
		0, 2, 2, 2, 3, 2, 4, 2,
		-1, 3, 3, 3, 4, 3, 5, 3,
		0, 4, 2, 4,
		1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"ship 2nd smallest known 2c/5, p5"},
#endif
	{
		1, -7, 3, -7,
		-2, -6, 3, -6,
		-3, -5, -2, -5, -1, -5, 4, -5,
		-4, -4, -2, -4,
		-5, -3, -4, -3, -1, -3, 0, -3, 5, -3,
		-4, -2, -3, -2, 0, -2, 1, -2, 2, -2, 3, -2, 4, -2,
		-4, 2, -3, 2, 0, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		-5, 3, -4, 3, -1, 3, 0, 3, 5, 3,
		-4, 4, -2, 4,
		-3, 5, -2, 5, -1, 5, 4, 5,
		-2, 6, 3, 6,
		1, 7, 3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"ship smallest known c/4, p4, from col of small ss"},
#endif
	{
		-4, -9, -3, -9, -2, -9,
		-5, -8, -1, -8, 0, -8,
		2, -7,
		-5, -6, -1, -6, 3, -6, 4, -6,
		-5, -5, -1, -5, 2, -5,
		-1, -4, 0, -4,
		-5, -3, -1, -3,
		-5, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		-3, 1, -2, 1, -1, 1,
		-5, 2, -1, 2,
		-5, 3, -1, 3,
		-1, 4, 0, 4,
		-5, 5, -1, 5, 2, 5,
		-5, 6, -1, 6, 3, 6, 4, 6,
		2, 7,
		-5, 8, -1, 8, 0, 8,
		-4, 9, -3, 9, -2, 9,
		127
	},
#ifdef LIFE_NAMES
	{"ship2 (c/2, p4)"},
#endif
	{
		-4, -7, -3, -7, -1, -7, 0, -7, 1, -7, 2, -7, 3, -7, 4, -7,
		-5, -6, -4, -6, -3, -6, -2, -6, 5, -6,
		-6, -5, -5, -5,
		-5, -4, 5, -4,
		-4, -3, -3, -3, -2, -3, 0, -3,
		-2, -2,
		-2, -1,
		-1, 0,
		-2, 1,
		-2, 2,
		-4, 3, -3, 3, -2, 3, 0, 3,
		-5, 4, 5, 4,
		-6, 5, -5, 5,
		-5, 6, -4, 6, -3, 6, -2, 6, 5, 6,
		-4, 7, -3, 7, -1, 7, 0, 7, 1, 7, 2, 7, 3, 7, 4, 7,
		127
	},
#ifdef LIFE_NAMES
	{"short keys (p3), from Lexicon"},
#endif
	{
		-5, -2, 4, -2,
		-6, -1, -4, -1, -3, -1, -2, -1, 1, -1, 2, -1, 3, -1, 5, -1,
		-5, 0, -2, 0, 1, 0, 4, 0,
		-2, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"shower tub (p8) (part of oscillators)"},
#endif
	{
		-3, -6, -2, -6, 2, -6, 3, -6,
		-4, -5, -2, -5, 2, -5, 4, -5,
		-4, -4, 4, -4,
		-7, -3, -6, -3, -4, -3, -3, -3, 3, -3, 4, -3, 6, -3, 7, -3,
		-7, -2, -6, -2, -4, -2, 0, -2, 4, -2, 6, -2, 7, -2,
		-4, -1, -2, -1, 2, -1, 4, -1,
		-4, 0, -2, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, 2, 1, 4, 1, 5, 1,
		-4, 2, -1, 2, 0, 2, 1, 2, 4, 2,
		-4, 3, 4, 3, 6, 3,
		-3, 4, -2, 4, -1, 4, 5, 4, 6, 4,
		-1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"side-shooting gun (portion), from Lexicon"},
#endif
	{
		6, -10, 7, -10,
		6, -9, 7, -9,
		0, -8, 1, -8, 2, -8,
		2, -7,
		1, -6, 7, -6, 8, -6,
		6, -5, 8, -5,
		8, -4,
		-7, 7,
		-7, 8, -6, 8,
		-8, 9, -6, 9,
		127
	},
#ifdef LIFE_NAMES
	{"siesta (p5), from Lexicon"},
#endif
	{
		3, -6, 4, -6,
		-5, -5, -4, -5, 2, -5, 4, -5,
		-5, -4, -3, -4, 2, -4,
		-3, -3, 1, -3, 2, -3, 4, -3,
		-5, -2, -3, -2, -2, -2, 4, -2, 5, -2, 6, -2,
		-7, -1, -6, -1, -5, -1, 1, -1, 3, -1, 7, -1,
		-8, 0, -4, 0, -2, 0, 4, 0, 5, 0, 6, 0,
		-7, 1, -6, 1, -5, 1, 1, 1, 2, 1, 4, 1,
		-5, 2, -3, 2, -2, 2, 2, 2,
		-3, 3, 2, 3, 4, 3,
		-5, 4, -3, 4, 3, 4, 4, 4,
		-5, 5, -4, 5,
		127
	},
#ifdef LIFE_NAMES
	{"six Ls (p3), from Lexicon"},
#endif
	{
		0, -4,
		-2, -3, -1, -3, 0, -3, 3, -3,
		-3, -2, 1, -2, 2, -2, 3, -2,
		-3, -1, -2, -1, -1, -1,
		1, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, -1, 1, 3, 1,
		-3, 2, 0, 2, 1, 2, 2, 2,
		0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"smiley (p8), from Lexicon"},
#endif
	{
		-3, -3, -2, -3, -1, -3, 1, -3, 2, -3, 3, -3,
		-2, -2, 0, -2, 2, -2,
		-2, 0, 2, 0,
		-3, 2, -1, 2, 1, 2, 3, 2,
		-1, 3, 1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"snacker (p9), from Lexicon"},
#endif
	{
		-10, -5, -9, -5, 8, -5, 9, -5,
		-9, -4, 8, -4,
		-9, -3, -7, -3, 6, -3, 8, -3,
		-8, -2, -7, -2, 6, -2, 7, -2,
		-3, -1, 2, -1,
		-5, 0, -4, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0, 4, 0,
		-3, 1, 2, 1,
		-8, 2, -7, 2, 6, 2, 7, 2,
		-9, 3, -7, 3, 6, 3, 8, 3,
		-9, 4, 8, 4,
		-10, 5, -9, 5, 8, 5, 9, 5,
		127
	},
#ifdef LIFE_NAMES
	{"sombreros (p6), from Lexicon"},
#endif
	{
		-6, -5, -5, -5, 4, -5, 5, -5,
		-6, -4, -4, -4, 3, -4, 5, -4,
		-4, -3, 3, -3,
		-6, -2, -4, -2, -3, -2, 2, -2, 3, -2, 5, -2,
		-8, -1, -7, -1, -6, -1, 5, -1, 6, -1, 7, -1,
		-9, 0, -5, 0, -3, 0, 2, 0, 4, 0, 8, 0,
		-8, 1, -7, 1, -6, 1, 5, 1, 6, 1, 7, 1,
		-6, 2, -4, 2, -3, 2, 2, 2, 3, 2, 5, 2,
		-4, 3, 3, 3,
		-6, 4, -4, 4, 3, 4, 5, 4,
		-6, 5, -5, 5, 4, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"spider (c/5, p5), from col. of small spaceships"},
#endif
	{
		0, -13, 1, -13,
		-3, -12, -2, -12, 1, -12,
		-3, -11, -2, -11, 1, -11,
		2, -10,
		-3, -9, -1, -9, 0, -9, 1, -9, 2, -9,
		-4, -8, -3, -8, -1, -8,
		0, -7, 1, -7, 2, -7,
		1, -6,
		1, -5, 2, -5,
		3, -4,
		2, -3,
		2, -2,
		-2, -1, -1, -1, 0, -1,
		-2, 1, -1, 1, 0, 1,
		2, 2,
		2, 3,
		3, 4,
		1, 5, 2, 5,
		1, 6,
		0, 7, 1, 7, 2, 7,
		-4, 8, -3, 8, -1, 8,
		-3, 9, -1, 9, 0, 9, 1, 9, 2, 9,
		2, 10,
		-3, 11, -2, 11, 1, 11,
		-3, 12, -2, 12, 1, 12,
		0, 13, 1, 13,
		127
	},
#ifdef LIFE_NAMES
	{"stillater (p3), from Lexicon"},
#endif
	{
		-1, -4,
		-2, -3, 0, -3, 2, -3, 3, -3,
		-2, -2, 0, -2, 1, -2, 3, -2,
		-4, -1, -3, -1,
		-3, 0, -1, 0, 1, 0, 2, 0,
		-3, 1, -1, 1, 2, 1,
		-2, 2, 1, 2,
		-1, 3, 0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"surprise (p3), from Lexicon"},
#endif
	{
		-2, -4, 3, -4, 4, -4,
		-2, -3, -1, -3, 0, -3, 3, -3,
		-4, -2, -3, -2, 1, -2, 3, -2,
		-5, -1, -2, -1, -1, -1, 1, -1, 3, -1, 4, -1,
		-4, 0, 3, 0,
		-5, 1, -4, 1, -2, 1, 0, 1, 1, 1, 4, 1,
		-4, 2, -2, 2, 2, 2, 3, 2,
		-4, 3, -1, 3, 0, 3, 1, 3,
		-5, 4, -4, 4, 1, 4,
		127
	},
#ifdef LIFE_NAMES
	{"swan (c/4, p4) (small diagonal sparker)"},
#endif
	{
		1, -11,
		0, -10, 1, -10,
		-2, -8, -1, -8, 0, -8,
		-2, -7, -1, -7, 0, -7,
		-3, -4, -2, -4, -1, -4,
		-3, -3, -2, -3,
		-4, -2, -1, -2, 0, -2, 1, -2, 3, -2,
		-4, -1, -3, -1, -1, -1, 3, -1,
		-4, 0, -3, 0, -1, 0, 0, 0, 2, 0, 3, 0,
		-4, 1, -3, 1, -2, 1,
		-4, 2, -3, 2,
		-4, 3,
		-4, 4, -3, 4,
		-3, 5, -1, 5,
		1, 6,
		-1, 7, 2, 7,
		0, 8, 3, 8,
		0, 9,
		3, 10,
		1, 11, 2, 11, 3, 11,
		127
	},
#ifdef LIFE_NAMES
	{"switch engine (c/12, p288 diagonal puffer)"},
#endif
	{
		-12, -3, -10, -3,
		-13, -2,
		-12, -1, -9, -1,
		-10, 0, -9, 0, -8, 0,
		13, 2, 14, 2,
		13, 3,
	},
#ifdef LIFE_NAMES
	{"technician (p5), from Lexicon"},
#endif
	{
		0, -6,
		-1, -5, 1, -5,
		-1, -4, 0, -4,
		-3, -3, -2, -3,
		-4, -2, 0, -2, 1, -2, 2, -2,
		-5, -1, -2, -1, -1, -1, 3, -1, 5, -1,
		-4, 0, -3, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 0, 1, 2, 1,
		-2, 2, 2, 2,
		-1, 3, 0, 3, 1, 3,
		1, 4, 3, 4,
		2, 5, 3, 5,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"test tube baby (p2), from Lexicon"},
#endif
	{
		-4, -2, -3, -2, 2, -2, 3, -2,
		-4, -1, -2, -1, 1, -1, 3, -1,
		-2, 0, 1, 0,
		-2, 1, 1, 1,
		-1, 2, 0, 2,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"timebomb (glider producing switch engine (p384))"},
#endif
	{
		-6, -3, 6, -3, 7, -3,
		-7, -2, -5, -2, 0, -2, 7, -2,
		0, -1, 5, -1,
		-5, 0, -2, 0, 2, 0, 5, 0,
		-5, 1, -4, 1, 3, 1,
		-4, 2,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"titanic toroidal traveler (p16/unknown)"},
#endif
	{
		-3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, -1, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"T-nosed p4, from Lexicon"},
#endif
	{
		0, -6,
		0, -5,
		-1, -4, 0, -4, 1, -4,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-3, 1, -1, 1, 0, 1, 1, 1, 3, 1,
		-3, 2, -1, 2, 1, 2, 3, 2,
		-4, 3, -3, 3, -1, 3, 1, 3, 3, 3, 4, 3,
		-5, 4, -2, 4, -1, 4, 1, 4, 2, 4, 5, 4,
		-5, 5, -4, 5, 4, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"T-nosed p6, from Lexicon"},
#endif
	{
		-3, -5, -2, -5, 2, -5, 3, -5,
		-3, -4, -1, -4, 1, -4, 3, -4,
		-2, -3, 2, -3,
		-7, -1, -5, -1, -3, -1, 3, -1, 5, -1, 7, -1,
		-9, 0, -8, 0, -7, 0, -5, 0, -3, 0, -2, 0, 2, 0, 3, 0, 5, 0,
			7, 0, 8, 0, 9, 0,
		-7, 1, -5, 1, -3, 1, 3, 1, 5, 1, 7, 1,
		-2, 3, 2, 3,
		-3, 4, -1, 4, 1, 4, 3, 4,
		-3, 5, -2, 5, 2, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"toad-flipper, from Lexicon"},
#endif
	{
		-8, -5, 7, -5,
		-8, -4, 7, -4,
		-9, -3, -7, -3, 6, -3, 8, -3,
		-8, -2, 7, -2,
		-8, -1, -1, -1, 7, -1,
		-8, 0, -1, 0, 0, 0, 7, 0,
		-8, 1, -1, 1, 0, 1, 7, 1,
		-9, 2, -7, 2, 0, 2, 6, 2, 8, 2,
		-8, 3, 7, 3,
		-8, 4, 7, 4,
		127
	},
#ifdef LIFE_NAMES
	{"toad-sucker, from Lexicon"},
#endif
	{
		-8, -5,
		-8, -4, 7, -4,
		-9, -3, -7, -3, 7, -3,
		-8, -2, 6, -2, 8, -2,
		-8, -1, -1, -1, 7, -1,
		-8, 0, -1, 0, 0, 0, 7, 0,
		-8, 1, -1, 1, 0, 1, 7, 1,
		-9, 2, -7, 2, 0, 2, 7, 2,
		-8, 3, 6, 3, 8, 3,
		-8, 4, 7, 4,
		7, 5,
		127
	},
#ifdef LIFE_NAMES
	{"toaster (p5), from Lexicon"},
#endif
	{
		-3, -6, 4, -6, 5, -6,
		-4, -5, -2, -5, 0, -5, 1, -5, 4, -5,
		-4, -4, -2, -4, 0, -4, 2, -4, 4, -4,
		-5, -3, -4, -3, -2, -3, 2, -3, 4, -3, 5, -3,
		-7, -2, -3, -2, -2, -2, 0, -2, 2, -2, 3, -2, 7, -2,
		-4, -1, 4, -1,
		-4, 0, 4, 0,
		-7, 1, -3, 1, -2, 1, 0, 1, 2, 1, 3, 1, 7, 1,
		-5, 2, -4, 2, -2, 2, 2, 2, 4, 2, 5, 2,
		-4, 3, -2, 3, 0, 3, 2, 3, 4, 3,
		-4, 4, -2, 4, 0, 4, 1, 4, 4, 4,
		-3, 5, 4, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"transparent block reaction, from Lexicon"},
#endif
	{
		-7, -2,
		-7, -1, -6, -1, 5, -1, 6, -1,
		-6, 0, -5, 0, 5, 0, 6, 0,
		-7, 1, -6, 1,
		127
	},
#ifdef LIFE_NAMES
	{"trice tongs (p3), from Lexicon"},
#endif
	{
		-1, -3,
		-1, -2, 0, -2, 1, -2,
		-3, -1, -2, -1, 2, -1,
		-2, 0, 0, 0, 2, 0,
		-2, 1,
		-1, 2, 0, 2, 3, 2,
		2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"triple caterer (p3), from Lexicon"},
#endif
	{
		-3, -5, -2, -5,
		-4, -4, -1, -4, 2, -4, 3, -4,
		-4, -3, -3, -3, -1, -3, 3, -3,
		-2, -2, 0, -2, 1, -2, 2, -2, 7, -2,
		-6, -1, -5, -1, -4, -1, -2, -1, 0, -1, 5, -1, 6, -1, 7, -1,
		-7, 0, -4, 0, -1, 0, 4, 0,
		-8, 1, -6, 1, -3, 1, 1, 1, 4, 1, 5, 1,
		-7, 2,
		-6, 3, -5, 3, -3, 3, -2, 3, 0, 3, 1, 3, 3, 3, 4, 3,
		-5, 4, -1, 4, 3, 4,
		-5, 5, -1, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"tritoad (p3), from Lexicon"},
#endif
	{
		0, -7, 1, -7,
		0, -6,
		1, -5, 4, -5, 5, -5,
		-2, -4, -1, -4, 0, -4, 2, -4, 5, -4,
		-3, -3, 2, -3, 3, -3, 5, -3, 7, -3, 8, -3,
		-3, -2, -1, -2, 0, -2, 3, -2, 5, -2, 7, -2, 8, -2,
		-6, -1, -5, -1, -3, -1, 1, -1, 2, -1, 5, -1,
		-6, 0, -3, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-9, 1, -8, 1, -6, 1, -4, 1, -1, 1, 0, 1, 2, 1,
		-9, 2, -8, 2, -6, 2, -4, 2, -3, 2, 2, 2,
		-6, 3, -3, 3, -1, 3, 0, 3, 1, 3,
		-6, 4, -5, 4, -2, 4,
		-1, 5,
		-2, 6, -1, 6,
		127
	},
#ifdef LIFE_NAMES
	{"tubber (p3), from Lexicon"},
#endif
	{
		-2, -6, 0, -6,
		-2, -5, -1, -5, 1, -5,
		1, -4, 2, -4, 3, -4,
		-2, -3, -1, -3, 4, -3,
		-6, -2, -5, -2, -3, -2, 0, -2, 1, -2, 4, -2,
		-5, -1, -3, -1, 2, -1, 4, -1, 5, -1,
		-6, 0, -2, 0, 2, 0, 6, 0,
		-5, 1, -4, 1, -2, 1, 3, 1, 5, 1,
		-4, 2, -1, 2, 0, 2, 3, 2, 5, 2, 6, 2,
		-4, 3, 1, 3, 2, 3,
		-3, 4, -2, 4, -1, 4,
		-1, 5, 1, 5, 2, 5,
		0, 6, 2, 6,
		127
	},
#ifdef LIFE_NAMES
	{"tumbler (p14) (pump), from Lexicon"},
#endif
	{
		-2, -3, -1, -3, 1, -3, 2, -3,
		-2, -2, -1, -2, 1, -2, 2, -2,
		-1, -1, 1, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-3, 1, -1, 1, 1, 1, 3, 1,
		-3, 2, -2, 2, 2, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"tumbling T-tetson (p8)"},
#endif
	{
		-9, -5, -8, -5, -7, -5,
		-10, -4, 9, -4, 10, -4,
		-10, -3, -6, -3, 7, -3, 9, -3, 10, -3,
		-10, -2, -7, -2, -5, -2, 6, -2,
		-8, -1, -6, -1, -3, -1, 9, -1,
		-7, 0, -3, 0, 5, 0, 6, 0, 8, 0,
		-3, 1, 5, 1, 6, 1,
		-6, 2, -5, 2, -4, 2, 1, 2,
		-1, 3, 0, 3,
		1, 4,
		127
	},
#ifdef LIFE_NAMES
	{"twin bees shuttle (p46) (piston2)"},
#endif
	{
		-12, -8, -11, -8,
		-12, -7, -11, -7,
		2, -5,
		-13, -4, -12, -4, 2, -4, 3, -4, 12, -4, 13, -4,
		-13, -3, -12, -3, 3, -3, 4, -3, 12, -3, 13, -3,
		-2, -2, -1, -2, 2, -2, 3, -2,
		-2, 2, -1, 2, 2, 2, 3, 2,
		-13, 3, -12, 3, 3, 3, 4, 3,
		-13, 4, -12, 4, 2, 4, 3, 4,
		2, 5,
		-12, 7, -11, 7,
		-12, 8, -11, 8,
		127
	},
#ifdef LIFE_NAMES
	{"twirling T-tetsons II (p60), from Lexicon"},
#endif
	{
		-5, -12, -4, -12, 0, -12, 1, -12,
		-6, -11, 2, -11,
		-3, -10, -1, -10,
		-5, -9, -4, -9, 0, -9, 1, -9,
		9, -5, 10, -5, 11, -5,
		8, -4, 9, -4, 10, -4,
		1, -3,
		-12, -2, -11, -2, -10, -2, 0, -2, 1, -2, 2, -2,
		-11, -1, -10, -1, -9, -1,
		8, 0, 9, 0, 10, 0,
		9, 1, 10, 1, 11, 1,
		-11, 3, -10, 3, -9, 3,
		-12, 4, -11, 4, -10, 4, 0, 4, 1, 4, 2, 4,
		1, 5,
		-2, 8, -1, 8, 3, 8, 4, 8,
		0, 9, 2, 9,
		-3, 10, 5, 10,
		-2, 11, -1, 11, 3, 11, 4, 11,
		127
	},
#ifdef LIFE_NAMES
	{"unix (p6) (pulse2), from Lexicon"},
#endif
	{
		0, -4, 1, -4,
		-4, -3, -3, -3, -1, -3,
		-4, -2, -3, -2, 0, -2, 3, -2,
		1, -1, 3, -1,
		2, 0,
		1, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"washerwoman (2c/3, p18 fuse), from Lexicon"},
#endif
	{
		-16, -2,
		-16, -1, -15, -1, -10, -1, -4, -1, 2, -1, 8, -1, 14, -1,
		-16, 0, -15, 0, -14, 0, -11, 0, -9, 0, -5, 0, -3, 0, 1, 0,
			3, 0, 7, 0, 9, 0, 13, 0, 15, 0,
		-16, 1, -15, 1, -10, 1, -4, 1, 2, 1, 8, 1, 14, 1,
		-16, 2,
		127
	},
#ifdef LIFE_NAMES
	{"washing machine (p2), from Lexicon"},
#endif
	{
		-2, -3, -1, -3, 1, -3, 2, -3,
		-3, -2, -1, -2, 0, -2, 3, -2,
		-3, -1, -2, -1, 3, -1,
		-2, 0, 2, 0,
		-3, 1, 2, 1, 3, 1,
		-3, 2, 0, 2, 1, 2, 3, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"wasp (c/3, p3), from Lexicon"},
#endif
	{
		-1, -5, 0, -5, 2, -5, 3, -5,
		-3, -4, -2, -4, 0, -4, 2, -4, 3, -4, 5, -4, 6, -4,
		-6, -3, -5, -3, -4, -3, -2, -3, 1, -3, 2, -3, 3, -3, 6, -3,
			7, -3, 8, -3, 9, -3,
		-10, -2, -9, -2, -8, -2, -3, -2, -2, -2, -1, -2, 5, -2, 10, -2,
		-11, -1, -9, -1, -7, -1, -5, -1, -4, -1, -3, -1, -1, -1,
			8, -1, 9, -1,
		-11, 0, -9, 0, -7, 0, -5, 0, -4, 0, -3, 0, -2, 0,
		-10, 1, -8, 1, -3, 1, 0, 1,
		-1, 2,
		-9, 3,
		-9, 4,
		127
	},
#ifdef LIFE_NAMES
	{"wavefront (p4), from Lexicon"},
#endif
	{
		2, -6, 3, -6,
		2, -5,
		3, -4,
		2, -3, 3, -3,
		-1, -2, 0, -2, 4, -2, 5, -2,
		-2, -1, 1, -1, 2, -1, 3, -1, 6, -1,
		-2, 0, 4, 0, 5, 0,
		-1, 1, 3, 1,
		-6, 2, -5, 2, -3, 2, -1, 2, 3, 2,
		-6, 3, -4, 3, -3, 3, -1, 3, 1, 3, 2, 3,
		-2, 4, 0, 4,
		-2, 5, 0, 5,
		-1, 6,
		127
	},
#ifdef LIFE_NAMES
	{"weekender (2c/7, p7), from Lexicon"},
#endif
	{
		-7, -5, 6, -5,
		-7, -4, 6, -4,
		-8, -3, -6, -3, 5, -3, 7, -3,
		-7, -2, 6, -2,
		-7, -1, 6, -1,
		-6, 0, -2, 0, -1, 0, 0, 0, 1, 0, 5, 0,
		-2, 1, -1, 1, 0, 1, 1, 1,
		-6, 2, -5, 2, -4, 2, -3, 2, 2, 2, 3, 2, 4, 2, 5, 2,
		-4, 4, 3, 4,
		-3, 5, -2, 5, 1, 5, 2, 5,
		127
	},
#ifdef LIFE_NAMES
	{"x66 (c/2, p4) (ship1), from Lexicon"},
#endif
	{
		-3, -5,
		-4, -4, -3, -4, -2, -4, -1, -4, 0, -4,
		-5, -3, -4, -3, 0, -3, 1, -3, 3, -3,
		-4, -2, 4, -2,
		-3, -1, -2, -1, 1, -1, 3, -1,
		-3, 1, -2, 1, 1, 1, 3, 1,
		-4, 2, 4, 2,
		-5, 3, -4, 3, 0, 3, 1, 3, 3, 3,
		-4, 4, -3, 4, -2, 4, -1, 4, 0, 4,
		-3, 5,
		127
	}
};

static char patterns_8S23B36[][2 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"replicator"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-2, -1,
		-2, 0,
		-2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bomber"},
#endif
	{
		-4, -3, -3, -3, -2, -3,
		-5, -2,
		-5, -1,
		-5, 0, 4, 0,
		4, 1,
		4, 2,
		127
	},
#ifdef LIFE_NAMES
	{"growing ship"},
#endif
	{
		-8, -7, -7, -7, -6, -7,
		-9, -6, -6, -6,
		-10, -5, -6, -5,
		-10, -4, -7, -4,
		-10, -3, -9, -3, -8, -3,
		7, 6, 8, 6, 9, 6,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"gun"},
#endif
	{
		3, -11,
		1, -10, 2, -10, 3, -10,
		0, -9,
		0, -8, 1, -8,
		-3, 0, -2, 0, -1, 0,
		-3, 1, -1, 1,
		-3, 2, -2, 2, -1, 2,
		-2, 3,
		17, 4, 18, 4,
		-18, 5, -17, 5, 17, 5,
		-17, 6, 15, 6, 17, 6,
		-17, 7, -15, 7, 6, 7, 15, 7, 16, 7,
		-16, 8, -15, 8, 6, 8,
		-6, 9, -5, 9, 5, 9, 7, 9, 8, 9,
		-7, 10, -6, 10, -4, 10, 6, 10,
		-6, 11, -5, 11, 6, 11,
		127
	},
#ifdef LIFE_NAMES
	{"tug of war"},
#endif
	{
		-12, -13, -11, -13, -10, -13,
		-13, -12,
		-13, -11,
		-13, -10,
		0, -6,
		0, -5,
		0, -4,
		4, 1,
		3, 2, 4, 2,
		2, 3, 4, 3,
		1, 4, 2, 4, 3, 4,
		11, 10, 12, 10, 13, 10,
		10, 11, 12, 11,
		10, 12, 11, 12,
		10, 13,
		127
	},
#ifdef LIFE_NAMES
	{"unpredictable tug of war"},
#endif
	{
		-16, -17, -15, -17, -14, -17,
		-17, -16,
		-17, -15,
		-17, -14,
		-4, -10,
		-4, -9,
		-4, -8,
		16, 13,
		15, 14, 16, 14,
		14, 15, 16, 15,
		13, 16, 14, 16, 15, 16,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"puffer train 1"},
#endif
	{
		4, -10, 5, -10, 6, -10,
		3, -9, 7, -9,
		2, -8, 7, -8,
		1, -7, 4, -7, 7, -7,
		1, -6, 6, -6,
		1, -5, 5, -5,
		2, -4, 3, -4, 4, -4,
		7, 0,
		7, 1,
		7, 2,
		-5, 4, -4, 4, -3, 4,
		-6, 5, -3, 5,
		-7, 6, -3, 6,
		-7, 7, -4, 7,
		-7, 8, -6, 8, -5, 8,
		2, 9, 3, 9, 4, 9,
		127
	},
#ifdef LIFE_NAMES
	{"puffer train 2"},
#endif
	{
		2, -10, 3, -10,
		3, -9, 4, -9,
		0, -8, 2, -8, 3, -8,
		0, -7, 1, -7, 2, -7,
		1, -6, 10, -6,
		10, -5,
		10, -4,
		-7, -2,
		-8, -1, -7, -1,
		-9, 0, -7, 0,
		-10, 1, -9, 1, -8, 1,
		-5, 7,
		-5, 8,
		-5, 9,
		127
	},
#ifdef LIFE_NAMES
	{"period 96 rake"},
#endif
	{
		-8, -6, -7, -6, -6, -6,
		-5, -5,
		-10, -4, -8, -4, -4, -4,
		-10, -3, -3, -3,
		-10, -2, -2, -2,
		-9, -1, -2, -1,
		-8, 0, -4, 0, -2, 0,
		-7, 1, 6, 1, 7, 1, 8, 1,
		-6, 2, -5, 2, -4, 2, 9, 2,
		9, 3,
		0, 4, 9, 4,
		0, 5,
		0, 6,
		127
	},
#ifdef LIFE_NAMES
	{"another c/3, p3 spaceship"},
#endif
	{
		-2, -3, 2, -3,
		-3, -2, -1, -2, 1, -2, 3, -2,
		-3, -1, -2, -1, -1, -1, 1, -1, 2, -1, 3, -1,
		-9, 0, -8, 0, -7, 0, -6, 0, -5, 0, -3, 0, 3, 0, 5, 0, 6, 0,
			7, 0, 8, 0, 9, 0,
		-9, 1, -8, 1, -5, 1, -4, 1, 0, 1, 4, 1, 5, 1, 8, 1, 9, 1,
		-7, 2, -6, 2, -5, 2, 0, 2, 5, 2, 6, 2, 7, 2,
		-7, 3, 7, 3,
		127
	},
#ifdef LIFE_NAMES
	{"mold (p4), from Lexicon"},
#endif
	{
		0, -3, 1, -3,
		-1, -2, 2, -2,
		-3, -1, 0, -1, 2, -1,
		1, 0,
		-3, 1, -1, 1, 0, 1,
		-2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"monogram (p4), from Lexicon"},
#endif
	{
		-3, -2, -2, -2, 2, -2, 3, -2,
		-2, -1, 0, -1, 2, -1,
		-2, 0, -1, 0, 1, 0, 2, 0,
		-2, 1, 0, 1, 2, 1,
		-3, 2, -2, 2, 2, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p3)"},
#endif
	{
		0, -4, 1, -4,
		-1, -3, 2, -3,
		1, -2, 3, -2,
		-3, -1, -1, -1, 3, -1,
		-4, 0, 0, 0, 2, 0,
		-4, 1, -2, 1,
		-3, 2, 0, 2,
		-2, 3, -1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator0 DH (p4)"},
#endif
	{
		1, -5, 2, -5,
		0, -4, 2, -4,
		-5, -3, -4, -3, 0, -3,
		-5, -2, -2, -2, 0, -2, 1, -2,
		-4, -1, -3, -1, -2, -1,
		1, 0, 2, 0, 3, 0,
		-2, 1, -1, 1, 1, 1, 4, 1,
		-1, 2, 3, 2, 4, 2,
		-3, 3, -1, 3,
		-3, 4, -2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator1 DH (p4)"},
#endif
	{
		0, -7, 1, -7,
		0, -6, 1, -6,
		-2, -4, -1, -4, 0, -4, 1, -4,
		-3, -3, 2, -3,
		-4, -2, -2, -2, 0, -2, 1, -2, 3, -2, 5, -2, 6, -2,
		-4, -1, -2, -1, 3, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, -4, 0, 1, 0, 3, 0,
		-7, 1, -6, 1, -4, 1, -2, 1, -1, 1, 1, 1, 3, 1,
		-3, 2, 2, 2,
		-2, 3, -1, 3, 0, 3, 1, 3,
		-2, 5, -1, 5,
		-2, 6, -1, 6,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p7)"},
#endif
	{
		-3, -2, -2, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		1, 0, 2, 0, 3, 0,
		1, 1, 2, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p9) "},
#endif
	{
		-11, -5, -10, -5, 10, -5, 11, -5,
		-10, -4, 10, -4,
		-10, -3, -8, -3, 8, -3, 10, -3,
		-9, -2, -8, -2, 8, -2, 9, -2,
		-6, 0, -5, 0, -4, 0, -3, 0, -2, 0, -1, 0, 1, 0, 2, 0, 3, 0,
			4, 0, 5, 0, 6, 0,
		-9, 2, -8, 2, 8, 2, 9, 2,
		-10, 3, -8, 3, 8, 3, 10, 3,
		-10, 4, 10, 4,
		-11, 5, -10, 5, 10, 5, 11, 5,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p10)"},
#endif
	{
		-2, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p12)"},
#endif
	{
		-3, -3, -2, -3, 1, -3, 3, -3,
		-1, -2, 1, -2, 3, -2,
		-3, -1, -2, -1, 2, -1,
		-2, 1, 2, 1, 3, 1,
		-3, 2, -1, 2, 1, 2,
		-3, 3, -1, 3, 2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p14)"},
#endif
	{
		-2, -5, -1, -5, 0, -5,
		-3, -4, -1, -4, 0, -4, 2, -4,
		-4, -3, 3, -3,
		-2, -2, 1, -2, 4, -2,
		-5, -1, -4, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, 3, 0, 4, 0,
		-5, 1, -2, 1, 1, 1,
		-4, 2, 3, 2,
		-3, 3, -1, 3, 0, 3, 2, 3,
		-1, 4, 0, 4, 1, 4,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p20)"},
#endif
	{
		-1, -5,
		-3, -4, -2, -4, -1, -4,
		-4, -3, -1, -3,
		-4, -2, -2, -2,
		-5, -1, -4, -1, -3, -1,
		2, 0, 3, 0, 4, 0,
		1, 1, 3, 1,
		0, 2, 3, 2,
		0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator DH (p28)"},
#endif
	{
		-6, -4, 6, -4,
		-6, -3, -4, -3, 4, -3, 6, -3,
		-9, -2, -6, -2, -5, -2, 5, -2, 6, -2, 9, -2,
		-10, -1, -9, -1, -8, -1, 8, -1, 9, -1, 10, -1,
		-11, 0, -10, 0, -8, 0, -7, 0, 7, 0, 8, 0, 10, 0, 11, 0,
		-10, 1, -9, 1, -8, 1, 8, 1, 9, 1, 10, 1,
		-9, 2, -6, 2, -5, 2, 5, 2, 6, 2, 9, 2,
		-6, 3, -4, 3, 4, 3, 6, 3,
		-6, 4, 6, 4,
		127
	},
#ifdef LIFE_NAMES
	{"shuttle DH (p24)"},
#endif
	{
		-3, -3, -2, -3,
		-3, -2, -1, -2, 1, -2, 3, -2,
		-3, -1, -2, -1,
		-9, 0, -8, 0, 7, 0, 8, 0,
		-10, 1, -8, 1, 7, 1, 9, 1,
		-10, 2, 9, 2,
		-11, 3, -10, 3, 9, 3, 10, 3,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"oscillator NT (p48)"},
#endif
	{
		-9, -13, -8, -13, -7, -13, 7, -13, 8, -13, 9, -13,
		-9, -12, -6, -12, 6, -12, 9, -12,
		-9, -11, -5, -11, 5, -11, 9, -11,
		-8, -10, -5, -10, 5, -10, 8, -10,
		-7, -9, -6, -9, -5, -9, 5, -9, 6, -9, 7, -9,
		-11, -2, 11, -2,
		-12, -1, -10, -1, 10, -1, 12, -1,
		-14, 0, -13, 0, 13, 0, 14, 0,
		-12, 1, -10, 1, 10, 1, 12, 1,
		-11, 2, 11, 2,
		-7, 9, -6, 9, -5, 9, 5, 9, 6, 9, 7, 9,
		-8, 10, -5, 10, 5, 10, 8, 10,
		-9, 11, -5, 11, 5, 11, 9, 11,
		-9, 12, -6, 12, 6, 12, 9, 12,
		-9, 13, -8, 13, -7, 13, 7, 13, 8, 13, 9, 13,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"simple oscillator DH (p48)"},
#endif
	{
		-11, -11,
		-11, -10, -10, -10, -9, -10,
		-8, -9,
		-9, -8, -8, -8,
		-1, -5, 0, -5, 1, -5,
		-2, -4, 1, -4,
		-3, -3, 1, -3,
		-3, -2, 0, -2,
		-3, -1, -2, -1, -1, -1,
		8, 8, 9, 8,
		8, 9, 10, 9,
		10, 10,
		10, 11, 11, 11,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator HE (p96)"},
#endif
	{
		-13, -13, -12, -13,
		-13, -12, -12, -12,
		7, -4,
		6, -3, 7, -3,
		5, -2, 7, -2,
		4, -1, 5, -1, 6, -1,
		10, 1, 11, 1, 12, 1,
		9, 2, 11, 2,
		9, 3, 10, 3,
		9, 4,
		12, 12, 13, 12,
		12, 13, 13, 13,
		127
	}
};

static char patterns_8S34678B3678[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"I (p3) "},
#endif
	{
		-2, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-2, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"OO (p3)"},
#endif
	{
		-2, -2, -1, -2, 1, -2, 2, -2,
		-3, -1, -1, -1, 1, -1, 3, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"rocket predecessor"},
#endif
	{
		-3, -2, -2, -2,
		-4, -1, -2, -1, -1, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-4, 1, -2, 1, -1, 1,
		-3, 2, -2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"2 rockets and junk"},
#endif
	{
		-1, -2,
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"c/2, p2 even spaceship"},
#endif
	{
		0, -4, 1, -4, 2, -4,
		-2, -3, 0, -3, 1, -3,
		-3, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2, 4, -2,
		-4, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1,
		-2, 2, 0, 2, 1, 2,
		0, 3, 1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"c/2, p2 odd spaceship"},
#endif
	{
		0, -3, 1, -3, 2, -3,
		-2, -2, 0, -2, 1, -2,
		-3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 4, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1,
		-2, 2, 0, 2, 1, 2,
		0, 3, 1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"c/2, p4 odd spaceship"},
#endif
	{
		1, -3,
		-1, -2, 1, -2,
		-2, -1, -1, -1, 0, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0,
		-2, 1, -1, 1, 0, 1,
		-1, 2, 1, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"c/2, p4 even spaceship"},
#endif
	{
		1, -4,
		-1, -3, 1, -3,
		-2, -2, -1, -2, 0, -2,
		-3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 3, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0,
		-2, 1, -1, 1, 0, 1,
		-1, 2, 1, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"c/2, p32 spaceship"},
#endif
	{
		-1, -3,
		-3, -2, -2, -2, -1, -2,
		-4, -1, -2, -1, -1, -1, 0, -1, 2, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 2, 0, 3, 0,
		-4, 1, -2, 1, -1, 1, 0, 1, 2, 1,
		-3, 2, -2, 2, -1, 2,
		-1, 3,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"c/3, p3 diagonal butterfly"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-2, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0,
		-2, 1, -1, 1,
		-1, 2,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"c/7, p14 snail"},
#endif
	{
		0, -2,
		-2, -1, 0, -1, 1, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, 0, 1, 1, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"asym c/2, p4 spaceship"},
#endif
	{
		-7, -3, -6, -3, 1, -3, 2, -3,
		-8, -2, -7, -2, -6, -2, -4, -2, -3, -2, -2, -2, -1, -2, 1, -2,
			2, -2, 4, -2, 5, -2, 6, -2, 7, -2,
		-9, -1, -7, -1, -6, -1, -2, -1, 1, -1, 3, -1, 4, -1, 5, -1, 6,
			-1, 8, -1,
		-8, 0, -7, 0, -6, 0, -5, 0, 0, 0, 2, 0, 4, 0, 6, 0, 7, 0, 8, 0,
		-6, 2, 6, 2, 7, 2,
		-8, 3,
		127
	},
#ifdef LIFE_NAMES
	{"small doomed ship"},
#endif
	{
		-1, -2, 0, -2,
		-2, -1, -1, -1, 0, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 2, 1,
		-1, 2, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"p6 oscillator 0"},
#endif
	{
		0, -2,
		-1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-1, 1, 0, 1,
		-1, 2, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"p6 oscillator 1"},
#endif
	{
		0, -2,
		-1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-1, 1, 0, 1, 1, 1, 2, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"p6 oscillator 2"},
#endif
	{
		-3, -3, -2, -3, -1, -3,
		-3, -2, -2, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 0, 1, 0, 2, 0,
		0, 1, 1, 1, 2, 1,
		0, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"p6 oscillator 3"},
#endif
	{
		-3, -4, 1, -4,
		-3, -3, -2, -3, -1, -3, 2, -3, 3, -3,
		-4, -2, -2, -2, 1, -2, 2, -2,
		-1, -1, 0, -1, 2, -1,
		-3, 0, -1, 0, 0, 0,
		-3, 1, -2, 1, 1, 1, 3, 1,
		-4, 2, -3, 2, 0, 2, 1, 2, 2, 2,
		-2, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"7 oscillator"},
#endif
	{
		-1, -3, 0, -3, 1, -3,
		0, -2, 1, -2, 2, -2,
		-3, -1, 0, -1, 1, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-2, 2, 0, 2, 1, 2, 2, 2, 3, 2,
		2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"odd 8 oscillator"},
#endif
	{
		0, -3,
		-2, -1, 2, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 1, 0, 2, 0, 3, 0, 4, 0,
		-4, 1, -3, 1, -2, 1, -1, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-2, 2, -1, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"even 8 oscillator"},
#endif
	{
		-1, -3, 0, -3,
		-3, -1, 2, -1,
		-5, 0, -4, 0, -3, 0, -2, 0, 1, 0, 2, 0, 3, 0, 4, 0,
		-5, 1, -4, 1, -3, 1, -2, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-3, 2, -2, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"13 oscillator"},
#endif
	{
		-1, -3,
		-1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 0,
		1, 1, 2, 1, 3, 1,
		1, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"14 oscillator"},
#endif
	{
		3, -3,
		3, -2,
		2, -1, 3, -1,
		2, 0,
		-2, 1,
		-3, 2, -2, 2, -1, 2,
		-1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"16 oscillator"},
#endif
	{
		0, -2,
		-1, -1, 0, -1,
		-1, 0,
		-1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"36 oscillator"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-2, -1, 0, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, 0, 1,
		-1, 2, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"42 oscillator"},
#endif
	{
		-3, -5, 2, -5,
		-4, -4, -3, -4, -2, -4, 1, -4, 2, -4, 3, -4,
		-5, -3, -4, -3, -3, -3, -2, -3, 1, -3, 2, -3, 3, -3, 4, -3,
		-4, -2, -3, -2, -1, -2, 0, -2, 2, -2, 3, -2,
		-2, -1, -1, -1, 0, -1, 1, -1,
		-2, 0, -1, 0, 0, 0, 1, 0,
		-4, 1, -3, 1, -1, 1, 0, 1, 2, 1, 3, 1,
		-5, 2, -4, 2, -3, 2, -2, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		-4, 3, -3, 3, -2, 3, 1, 3, 2, 3, 3, 3,
		-3, 4, 2, 4,
		127
	}
};

static char patterns_8S245B3[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-2, 0, -1, 0, 0, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"big blinker (p2)"},
#endif
	{
		-2, -1, -2, 0,
		-1, -1, -1, 0,
		0, -1, 0, 0,
		1, -1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"x (p2)"},
#endif
	{
		-1, 0,
		0, -1, 0, 0, 0, 1,
		1, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"double x (p2)"},
#endif
	{
		-2, -1, -1, -1, 1, -1, 0, -1,
		-3, 0, -2, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"checker (p2)"},
#endif
	{
		-2, -2, 0, -2,
		-1, -1, 1, -1,
		-2, 0, 0, 0, 2, 0,
		-1, 1, 1, 1,
		0, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"small square dance (p4)"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		0, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		0, 1,
		-1, 2, 0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"clock (p4)"},
#endif
	{
		-1, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"warped clock (p4)"},
#endif
	{
		0, -1,
		-2, 0, 0, 0, -1, 0,
		-1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"talker (p5)"},
#endif
	{
		1, -4, 0, -4,
		1, -3,
		-1, -2, 0, -2, 1, -2,
		-2, -1, 3, -1, 2, -1, 0, -1, 4, -1,
		-4, 0, -2, 0, -1, 0, 1, 0, 2, 0, 4, 0,
		-4, 1, -3, 1, -2, 1, 0, 1, 2, 1,
		-1, 2, 0, 2, 1, 2,
		-1, 3,
		-1, 4, 0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"square dance (p6)"},
#endif
	{
		-3, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2, 3, -2,
		0, -1,
		-5, 0, -1, 0, 1, 0, 5, 0,
		0, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 2, 2, 1, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"tumbler (p8)"},
#endif
	{
		2, -4,
		-1, -3, 3, -3,
		-1, -2, 0, -2, 3, -2,
		-3, -1, -2, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0, 1, 0,
		-1, 1, 0, 1,
		-4, 2, -1, 2,
		-3, 3, -2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"give and receive (p12)"},
#endif
	{
		-2, -1, 3, -1,
		-3, 0, -1, 0, 1, 0, -2, 0, 2, 0, 3, 0,
		-2, 1, 2, 1,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"jelly fish (diag c7, p7)"},
#endif
	{
		-1, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#endif
};

static char patterns_8S245B36[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-2, 0, -1, 0, 0, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"big blinker (p2)"},
#endif
	{
		-2, -1, -2, 0,
		-1, -1, -1, 0,
		0, -1, 0, 0,
		1, -1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"x (p2)"},
#endif
	{
		-1, 0,
		0, -1, 0, 0, 0, 1,
		1, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"double x (p2)"},
#endif
	{
		-2, -1, -1, -1, 1, -1, 0, -1,
		-3, 0, -2, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"checker (p2)"},
#endif
	{
		-2, -2, 0, -2,
		-1, -1, 1, -1,
		-2, 0, 0, 0, 2, 0,
		-1, 1, 1, 1,
		0, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"small square dance (p4)"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		0, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		0, 1,
		-1, 2, 0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"key (p4)"},
#endif
	{
		-1, -2, 0, -2,
		-2, -1, 1, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"clock (p4)"},
#endif
	{
		-1, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"warped clock (p4)"},
#endif
	{
		0, -1,
		-2, 0, 0, 0, -1, 0,
		-1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"square dance (p6)"},
#endif
	{
		-3, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2, 3, -2,
		0, -1,
		-5, 0, -1, 0, 1, 0, 5, 0,
		0, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 2, 2, 1, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"give and receive (p12)"},
#endif
	{
		-2, -1, 3, -1,
		-3, 0, -1, 0, 1, 0, -2, 0, 2, 0, 3, 0,
		-2, 1, 2, 1,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"jelly fish (diag c7, p7)"},
#endif
	{
		-1, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#endif
};

/*-
 * This assumes Callahan's "/" notation
 *    ABC		   A B C
 *    DEF	  ->      D E F
 *    GHI		 G H I
 */

/* CALLAHAN */
static char patterns_6S2b34B2a[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (p4)"},
#endif
	{
		0, -2,
		1, -1,
		-2, 0, 1, 0,
		1, 1,
		1, 2,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"3 oscillator glider gun (p42)"},
#endif
	{
		5, -6, 6, -6,
		6, -5, 7, -5, 9, -5,
		6, -4, 8, -4, 9, -4,
		7, -3, 8, -3, 10, -3, 11, -3,
		8, -2, 10, -2,
		8, -1, 10, -1, 11, -1,
		8, 0, 9, 0, 10, 0, 12, 0,
		10, 1,

		-10, -5,
		-11, -4, -10, -4, -8, -4,
		-12, -3, -11, -3, -9, -3, -8, -3, -7, -3,
		-10, -2, -8, -2, -6, -2,
		-10, -1, -9, -1, -7, -1, -6, -1, -5, -1, -4, -1,
		-10, 0, -8, 0, -7, 0, -5, 0,

		0, -1, 1, -1,
		1, 0, 2, 0, 3, 0,
		1, 1, 3, 1,
		0, 2, 1, 2, 2, 2, 3, 2,
		0, 3, 4, 3,
		1, 4, 2, 4, 3, 4, 4, 4, 5, 4,
		3, 5,
		3, 6,
		127
	},
#ifdef LIFE_NAMES
	{"another gun (p20)"},
#endif
	{
		-2, -7, -1, -7,
		-2, -6,

		-8, -2,
		-9, -1, -8, -1, -7, -1, -6, -1, -5, -1,
		-8, 0, -6, 0, -5, 0,
		-7, 1, -6, 1,
		-8, 2, -7, 2,
		-10, 3, -9, 3, -8, 3,
		-8, 4,
		-9, 5, -8, 5, -7, 5,
		-6, 6,

		4, 0,
		3, 1, 4, 1, 5, 1, 10, 1,
		3, 2, 4, 2, 6, 2, 7, 2, 10, 2,
		5, 3, 6, 3, 8, 3, 9, 3, 10, 3, 11, 3,
		7, 4, 10, 4, 12, 4,
		11, 5,
		127
	},
#ifdef LIFE_NAMES
	{"ship (p48)"},
#endif
	{
		-3, -2, -1, -2,
		-2, -1, -1, -1,
		-2, 0, -1, 0, 0, 0, 2, 0,
		-1, 1, 0, 1, 3, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"ship (p15)"},
#endif
	{
		-3, -5, -1, -5,
		-2, -4, -1, -4, 0, -4,
		-4, -3, -3, -3, -2, -3, 0, -3,
		-2, -2, 0, -2,
		-1, -1, 0, -1,
		0, 1, 1, 1,
		0, 2, 2, 2,
		-1, 3, 0, 3, 1, 3, 3, 3,
		2, 4, 3, 4, 4, 4,
		2, 5, 4, 5,
		127
	},
#ifdef LIFE_NAMES
	{"ship by a collision of 3 gliders (p15)"},
#endif
	{
		7, -4,
		8, -3,
		8, -2, 10, -2,
		-11, -1, -10, -1, 1, -1, 2, -1, 3, -1, 4, -1, 9, -1, 11, -1,
		-9, 0, 1, 0, 10, 0,
		-8, 1,
		-7, 2, 5, 2,
		-9, 3,
		127
	},
#ifdef LIFE_NAMES
	{"stalk (p8)"},
#endif
	{
		-2, -4,
		-3, -3, -2, -3,
		-3, -2, -1, -2, 0, -2,
		-3, -1, -2, -1, -1, -1, 1, -1,
		0, 0, 1, 0,
		0, 1, 2, 1,
		0, 2, 1, 2, 2, 2,
		2, 3, 3, 3, 4, 3,
		127
	},
#ifdef LIFE_NAMES
	{"stalk by a collision of 3 gliders"},
#endif
	{
		-8, -9,
		-5, -8,
		-5, -7,
		-5, -6,
		-6, -5, -5, -5,
		-3, 1,
		-4, 2, -2, 2,
		-3, 3, -1, 3,
		-1, 4,
		0, 5, 5, 5,
		5, 6,
		5, 7, 8, 7,
		5, 8,
		6, 9,
		127
	},
#ifdef LIFE_NAMES
	{"stalk by a collision of 2 gilders and eater"},
#endif
	{
		3, -6,
		3, -5,
		-5, -4, 4, -4, 7, -4,
		-4, -3, -3, -3, 5, -3,
		6, -2,
		-7, 1, -6, 1,
		-5, 2,
		-4, 3,
		-3, 4,
		-5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p42)"},
#endif
	{
		-2, -3, -1, -3,
		-2, -2, 0, -2,
		-3, -1, -2, -1, -1, -1, 0, -1,
		-3, 0, 1, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 2,
		0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"tentacle (p66)"},
#endif
	{
		-3, -3, -2, -3,
		-5, -2, -4, -2, -3, -2, -1, -2,
		-5, -1, -3, -1, -1, -1,
		-4, 0, -3, 0, -1, 0, 0, 0,
		-4, 1, -2, 1, -1, 1, 1, 1, 3, 1,
		0, 2, 1, 2, 3, 2, 4, 2, 5, 2,
		2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"rotating oscillator (p42)"},
#endif
	{
		0, -2, 1, -2,
		-1, -1, 0, -1, 1, -1,
		1, 0,
		-2, 1, -1, 1, 0, 1, 1, 1,
		-2, 2, -1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"internal oscillator (p7)"},
#endif
	{
		-3, -6,
		-4, -5, -3, -5,
		-5, -4, -4, -4, -2, -4, -1, -4, 1, -4,
		-3, -3, -1, -3, 0, -3, 1, -3,
		-6, -2, -4, -2, -3, -2, -1, -2, 2, -2, 3, -2,
		-5, -1, -4, -1, -2, -1, 2, -1,
		-6, 0, -5, 0, -3, 0, -2, 0, -1, 0, 0, 0, 3, 0,
		-4, 1, -3, 1, 1, 1, 3, 1,
		-4, 2, -2, 2, 0, 2, 1, 2, 4, 2,
		-4, 3, -3, 3, -2, 3, 0, 3, 1, 3, 3, 3, 4, 3, 5, 3,
		-1, 4, 0, 4, 2, 4, 3, 4,
		1, 5, 2, 5,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p7)"},
#endif
	{
		-6, -7,
		-6, -6,
		-5, -5, -4, -5,
		-4, -4, -3, -4, -2, -4,
		-5, -3, -4, -3, -1, -3, 0, -3, 2, -3,
		-5, -2, 0, -2, 1, -2, 2, -2,
		-4, -1, 2, -1,
		3, 0,
		2, 1, 3, 1,
		2, 2,
		3, 3, 5, 3,
		2, 4, 3, 4, 4, 4, 5, 4,
		5, 5,
		6, 6,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p9)"},
#endif
	{
		-2, -6, -1, -6,
		-4, -5, -3, -5, -2, -5, 0, -5,
		-3, -4, -1, -4, 0, -4,
		-3, -3, -2, -3, -1, -3, 1, -3,
		0, -2, 1, -2,
		0, -1,
		-1, 0, 0, 0, 1, 0,
		-1, 1, 2, 1,
		-2, 2, -1, 2, 0, 2, 2, 2,
		-2, 3, 0, 3, 3, 3,
		-1, 4, 0, 4, 2, 4, 3, 4,
		1, 5, 2, 5,
		2, 6,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator1 (p11)"},
#endif
	{
		-4, -5,
		-5, -4, -4, -4,
		-4, -3, -3, -3, -1, -3,
		-6, -2, -5, -2, -4, -2, -2, -2, 0, -2,
		-4, -1, -2, -1, 1, -1, 2, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0, 4, 0, 5, 0,
		-4, 1, 0, 1, 1, 1, 4, 1,
		2, 2, 3, 2, 4, 2,
		4, 3,
		5, 4,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator2 (p11)"},
#endif
	{
		-3, -3, -2, -3, 0, -3,
		-3, -2, 0, -2, 1, -2,
		-1, -1, 0, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 1, 0, 2, 0,
		-2, 1, 0, 1, 1, 1, 3, 1,
		-1, 2, 0, 2, 2, 2, 3, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p14)"},
#endif
	{
		-2, -3, -1, -3, 0, -3,
		-3, -2, -2, -2, 0, -2,
		-3, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, 0, 0, 1, 0,
		-1, 1, 0, 1, 2, 1, 3, 1,
		-1, 2, 1, 2, 2, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p17)"},
#endif
	{
		-3, -6,
		-3, -5,
		-5, -4, -4, -4, -3, -4, -2, -4, -1, -4, 0, -4,
		-3, -3, -1, -3, 0, -3,
		-2, -2, -1, -2,
		-2, 0, -1, 0, 2, 0,
		-3, 1, -2, 1, 0, 1, 1, 1,
		-3, 2, 0, 2, 2, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		0, 4, 1, 4, 3, 4, 4, 4,
		2, 5, 3, 5,
		2, 6,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p18)"},
#endif
	{
		-5, -4, -3, -4,
		-4, -3, -3, -3, -2, -3,
		-5, -2, -4, -2, -2, -2,
		-6, -1, -5, -1, -3, -1, -2, -1, 0, -1, 1, -1, 2, -1, 4, -1,
		-6, 0, -4, 0, -3, 0, -1, 0, 1, 0, 3, 0, 4, 0, 5, 0, 6, 0,
		-5, 1, -4, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1,
		-3, 2, -2, 2, 0, 2, 2, 2, 3, 2, 4, 2, 6, 2,
		-3, 3, -1, 3, 4, 3,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p19)"},
#endif
	{
		-6, -4, -2, -4,
		-7, -3, -6, -3, -3, -3, -2, -3, -1, -3, 1, -3,
		-7, -2, -5, -2, -4, -2, -2, -2, 0, -2, 1, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 3, -1,
		-6, 0, -4, 0, -3, 0, 0, 0, 2, 0, 3, 0,
		-4, 1, -2, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1,
		0, 2, 1, 2, 3, 2, 4, 2, 5, 2,
		1, 3, 2, 3, 3, 3, 6, 3,
		3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p22)"},
#endif
	{
		-5, -5,
		-4, -4,
		-6, -3, -5, -3, -4, -3, -3, -3, -2, -3,
		-4, -2, -2, -2,
		-4, -1, -3, -1, -2, -1, -1, -1, 0, -1,
		-3, 0, -1, 0, 1, 0, 2, 0,
		0, 1, 1, 1, 2, 1, 3, 1,
		0, 2, 1, 2,
		4, 4,
		5, 5, 6, 5,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p26)"},
#endif
	{
		-5, -7,
		-5, -6, -3, -6,
		-6, -5, -5, -5, -4, -5, -3, -5, -2, -5,
		-5, -4, -3, -4, -1, -4, 0, -4,
		-5, -3, -2, -3, -1, -3, 1, -3,
		-3, -2, -2, -2, 1, -2,
		-1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		1, 0, 3, 0,
		-1, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-4, 2, -3, 2, -1, 2, 1, 2, 3, 2, 5, 2,
		-2, 3, 0, 3, 1, 3, 3, 3,
		2, 4, 3, 4, 4, 4,
		2, 5, 5, 5,
		5, 6,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p29)"},
#endif
	{
		-2, -6,
		-2, -5, -1, -5,
		-3, -4, -2, -4, 0, -4, 1, -4,
		-5, -3, -4, -3, -3, -3, 2, -3, 3, -3, 4, -3,
		-4, -2, -2, -2, 2, -2, 4, -2,
		-3, -1, -2, -1, -1, -1, 0, -1, 3, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, -2, 0, 1, 0, 2, 0, 3, 0,
		-5, 1, -4, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-4, 2, -3, 2, -2, 2, 0, 2, 2, 2,
		-3, 3, 0, 3,
		1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p46)"},
#endif
	{
		-2, -4,
		-2, -3, -1, -3, 0, -3,
		-4, -2, -3, -2, -2, -2, 0, -2,
		-5, -1, -3, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 3, 0,
		-3, 1, -1, 1, 1, 1, 4, 1,
		-4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2,
		-1, 3,
		-1, 4,
		127
	}
};

/* ANDREEN */
static char patterns_6S2a2b4aB2a3a4b[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"3 different gliders"},
#endif
	{
		-5, -9,
		-5, -8,
		-4, -7, -3, -7,
		-4, -6,
		-3, -5,
		-1, -2,
		-1, -1, 1, -1,
		-1, 0, 1, 0,
		0, 1,
		0, 2,
		2, 5,
		2, 6,
		2, 7,
		3, 8, 5, 8,
		3, 9,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"symmetric 4 glider gun"},
#endif
	{
		-2, -3, -1, -3, 0, -3,
		-3, -2, -2, -2, 3, -2,
		-2, -1, 0, -1, 1, -1,
		-2, 0, 0, 0, 2, 0, 3, 0,
		-1, 1,
		-1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"puffer (p18)"},
#endif
	{
		-2, -4,
		-3, -3, -2, -3, -1, -3, 0, -3,
		-2, -2, 0, -2,
		-2, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 2, 4, 2,
		-1, 3, 0, 3, 1, 3, 2, 3, 3, 3, 4, 3,
		0, 4, 1, 4, 3, 4, 4, 4,
		1, 5, 4, 5,
		127
	},
#ifdef LIFE_NAMES
	{"quasar (p10)"},
#endif
	{
		-2, -1, -1, -1, 0, -1,
		-1, 0, 0, 0,
		0, 1,
		127
	}
};

static char patterns_6S35B2[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/5, p5)"}, /* right */
#endif
	{
		-2, -3,
		0, -2,
		-3, -1, -1, -1, 2, -1,
		-2, 1, 0, 1, 3, 1,
		2, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"neutron star (p3)"},
#endif
	{
		-1, -1, 0, -1,
		-1, 0, 1, 0,
		0, 1, 1, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"binary star (p3)"},
#endif
	{
		-2, -3, -1, -3,
		-2, -2, 0, -2,
		-1, -1, 0, -1,
		0, 1, 1, 1,
		0, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"c (p4)"},
#endif
	{
		-1, -1, 0, -1,
		-1, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"s (p4)"},
#endif
	{
		-1, -2,
		-1, -1,
		0, 0,
		1, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"v dot (p4)"},
#endif
	{
		0, -2,
		-1, -1,
		-2, 0, 2, 0,
		0, 1,
		2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"drum (p4)"},
#endif
	{
		-3, -3, -2, -3,
		-2, -1, 0, -1,
		-1, 1, 1, 1,
		0, 3, 1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"broken umbrella (p4)"},
#endif
	{
		-3, -2, 2, -2,
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"spinner (p12)"},
#endif
	{
		-1, -2,
		-2, -1, 1, -1,
		-2, 0,
		2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"smiley (p12)"},
#endif
	{
		0, -2,
		-2, -1, 1, -1,
		2, 0,
		-1, 1, 2, 1,
		2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"arrow (p12)"},
#endif
	{
		-3, -4,
		-1, -3,
		0, -2,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		2, 2,
		2, 3,
		1, 4,
		127
	},
#ifdef LIFE_NAMES
	{"cephid (p15)"},
#endif
	{
		-2, -3, -1, -3,
		-3, -2, 1, -2,
		-3, -1, 2, -1,
		-2, 1, 3, 1,
		-1, 2, 3, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"supernova (remnant p3)"},
#endif
	{
		-3, -3, -2, -3, -1, -3, 0, -3,
		-3, -2, 1, -2,
		-3, -1, -1, -1, 0, -1, 2, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-2, 1, 0, 1, 1, 1, 3, 1,
		-1, 2, 3, 2,
		0, 3, 1, 3, 2, 3, 3, 3,
		127
	}
};

static char patterns_6S3B245[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/5, p10)"}, /* right */
#endif
	{
		-1, -3,
		-3, -2,
		-1, -1, 1, -1,
		-2, 0,
		0, 1, 2, 1,
		-1, 2,
		2, 3,
		127
	}
#endif
#ifdef LIFE_NAMES
	{"medium triangle (p2)"},
#endif
	{
		-1, -2,
		-1, 0, 1, 0,
		-1, 2, 1, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"static triangle (p2)"},
#endif
	{
		-1, -2,
		-1, -1, 0, -1,
		0, 0,
		-1, 1, 0, 1, 1, 1, 2, 1,
		-1, 2, 0, 2, 2, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"half divy (p4)"},
#endif
	{
		-2, -2, -1, -2, 0, -2, 1, -2,
		-1, 0, 2, 0,
		1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"big divy (p4)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1,
		-1, 1, 0, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"small triangle (p4)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1,
		-1, 0, 1, 0,
		0, 1, 1, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"snake (p4)"},
#endif
	{
		-2, -2,
		-2, -1,
		-1, 0, 0, 0,
		1, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"divy (p6)"},
#endif
	{
		-2, 0, -1, 0, 0, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"daisy (p8)"},
#endif
	{
		-2, -2,
		-3, -1, -2, -1,
		0, -1, 1, -1,
		0, 0,
		3, 1, 2, 1, 0, 1, -1, 1,
		2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"s (p13)"},
#endif
	{
		-2, -3, 0, -3,
		-3, -2,
		-3, -1, 0, -1, 1, -1,
		0, 0, 1, 0, 4, 0,
		4, 1,
		1, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"blossom (p57)"},
#endif
	{
		-1, -3,
		-2, -2, 1, -2,
		-2, -1, 2, -1,
		-1, 1, 3, 1,
		1, 2, 2, 2,
		127
	}
};

/* no glider, from Wikipedia */
static char patterns_6S34B2[][2 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"12 (p2)"},
#endif
	{
		-1, -1,
		-1, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"spinning triangle (p2)"},
#endif
	{
		0, -1,
		-1, 0,
		1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"hexagon (p3)"},
#endif
	{
		-1, -1, 0, -1,
		-1, 0, 1, 0,
		0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"c (p4)"},
#endif
	{
		-1, -1,
		-1, 0,
		0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"sad (p4)"},
#endif
	{
		-2, -2, -1, -2,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-3, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"clock (p4)"},
#endif
	{
		-2, -2,
		0, -1,
		-1, 0, 0, 0,
		-1, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"111 (p4)"},
#endif
	{
		-1, -2,
		0, 0,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"1121 (p4)"},
#endif
	{
		-2, -3,
		-1, -1,
		-1, 1, 1, 1,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"11211 (p4)"},
#endif
	{
		-2, -4,
		-1, -2,
		-1, 0, 1, 0,
		1, 2,
		2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"tree (p5)"},
#endif
	{
		-2, -6,
		-1, -4,
		-1, -3, 0, -3,
		0, -2,
		0, -1, 1, -1,
		1, 0,
		1, 1, 2, 1,
		2, 2,
		3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"hex (p5)"},
#endif
	{
		-1, -5,
		-1, -4,
		-3, -3, -1, -3, 0, -3, 1, -3, 2, -3, 3, -3,
		-2, -2, -1, -2, 2, -2,
		-1, -1, 3, -1,
		0, 0, 3, 0, 4, 0,
		-1, 1, 0, 1, 1, 1, 2, 1, 3, 1, 5, 1,
		3, 2,
		3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"121121 (p8)"},
#endif
	{
		-3, -5,
		-3, -3, -1, -3,
		-1, -1,
		0, 1,
		0, 3, 2, 3,
		2, 5,
		127
	},
#ifdef LIFE_NAMES
	{"1121121 (p8)"},
#endif
	{
		-3, -6,
		-2, -4,
		-2, -2, 0, -2,
		0, 0,
		1, 2,
		1, 4, 3, 4,
		3, 6,
		127
	},
#ifdef LIFE_NAMES
	{"11211211 (p8)"},
#endif
	{
		-4, -7,
		-3, -5,
		-3, -3, -1, -3,
		-1, -1,
		0, 1,
		0, 3, 2, 3,
		2, 5,
		3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"triangle (p12)"},
#endif
	{
		-3, -2, 2, -2,
		-1, -1, 1, -1,
		1, 1,
		2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"spinner (p12)"},
#endif
	{
		-1, -2,
		-2, -1,
		-1, 1,
		1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"chakar2 (p14)"},
#endif
	{
		-6, -6, -3, -6, 0, -6,
		-4, -5, -3, -5, -2, -5, -1, -5,
		-5, -4, -4, -4, -3, -4, -1, -4, 0, -4, 1, -4,
		-6, -3, -5, -3, -4, -3, 1, -3, 2, -3, 3, -3,
		-5, -2, -2, -2, 3, -2,
		-5, -1, -4, -1, 3, -1, 4, -1,
		-6, 0, -4, 0, 4, 0, 6, 0,
		-4, 1, -3, 1, 4, 1, 5, 1,
		-3, 2, 0, 2, 5, 2,
		-3, 3, -2, 3, -1, 3, 4, 3, 5, 3, 6, 3,
		-1, 4, 0, 4, 1, 4, 3, 4, 4, 4, 5, 4,
		1, 5, 2, 5, 3, 5, 4, 5,
		0, 6, 3, 6, 6, 6,
		127
	},
#ifdef LIFE_NAMES
	{"chakar (p18)"},
#endif
	{
		-6, -6, -3, -6, 0, -6,
		-4, -5, -3, -5, -2, -5, -1, -5,
		-5, -4, -4, -4, -3, -4, -1, -4, 0, -4, 1, -4,
		-6, -3, -5, -3, -4, -3, 1, -3, 2, -3, 3, -3,
		-5, -2, 3, -2,
		-5, -1, -4, -1, -2, -1, 1, -1, 3, -1, 4, -1,
		-6, 0, -4, 0, 0, 0, 4, 0, 6, 0,
		-4, 1, -3, 1, -1, 1, 2, 1, 4, 1, 5, 1,
		-3, 2, 5, 2,
		-3, 3, -2, 3, -1, 3, 4, 3, 5, 3, 6, 3,
		-1, 4, 0, 4, 1, 4, 3, 4, 4, 4, 5, 4,
		1, 5, 2, 5, 3, 5, 4, 5,
		0, 6, 3, 6, 6, 6,
		127
	},
#ifdef LIFE_NAMES
	{"ornament (p36)"},
#endif
	{
		-5, -7, -4, -7,
		-3, -4,
		-3, -3, -2, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 0, -2,
		-5, -1, -4, -1, -3, -1, 0, -1, 1, -1, 2, -1,
		-5, 0, -4, 0, 2, 0, 3, 0,
		-4, 1, -1, 1, 0, 1, 3, 1,
		-4, 2, -3, 2, -1, 2, 1, 2, 3, 2, 4, 2,
		-3, 3, 0, 3, 1, 3, 4, 3,
		-3, 4, -2, 4, 4, 4, 5, 4,
		-2, 5, -1, 5, 0, 5, 3, 5, 4, 5, 5, 5,
		0, 6, 1, 6, 2, 6, 3, 6, 4, 6,
		2, 7, 3, 7,
		127
	},
#ifdef LIFE_NAMES
	{"oscillator (p48)"},
#endif
	{
		-2, -2, -1, -2, 0, -2,
		-1, -1, 0, -1,
		0, 0,
		0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"triangle growth (remnant p10)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1,
		-1, 0, 0, 0, 1, 0,
		0, 1, 1, 1,
		1, 2,
		127
	},
};

/* Pentagonal, Cairo Tiling, 5 */
/* Pentagonal, Bagley, no glider found */
static char patterns_5S2B24[][2 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"snake checker (p4)"},
#endif
	{
		2, -2, 3, -2,
		1, -1, 4, -1,
		2, 0, 3, 0,
		1, 1, 4, 1,
		127
	},
#ifdef LIFE_NAMES
	{"small checker (p6)"},
#endif
	{
		-2, 0, -1, 0, 2, 0, 3, 0,
		127
	},
#ifdef LIFE_NAMES
	{"restricted checker (p6)"},
#endif
	{
		1, -5, 4, -5,
		2, -3, 3, -3,
		-5, -1, -1, -1, 2, -1, 3, -1, 7, -1, 11, -1,
		-6, 1, -2, 1, 2, 1, 3, 1, 6, 1, 10, 1,
		2, 3, 3, 3,
		1, 5, 4, 5,
		127
	},
#ifdef LIFE_NAMES
	{"bug (p8)"},
#endif
	{
		2, -3, 3, -3,
		2, -1, 3, -1,
		3, 1,
		-1, 2, 0, 2, 1, 2, 4, 2, 5, 2, 6, 2,
		1, 3, 4, 3,
		127
	},
#ifdef LIFE_NAMES
	{"trampoline (p8)"},
#endif
	{
		2, -2, 3, -2,
		0, -1, 5, -1,
		-2, 0, -1, 0, 6, 0, 7, 0,
		-3, 1, 0, 1, 5, 1, 8, 1,
		-1, 2, 2, 2, 3, 2, 6, 2,
		127
	},
#ifdef LIFE_NAMES
	{"checker (p14)"},
#endif
	{
		-2, -2, 3, -2,
		-6, 0, -5, 0, -2, 0, -1, 0, 2, 0, 3, 0, 6, 0, 7, 0,
		-2, 2, 3, 2,
		127
	},
};

/* Pentagonal, Bagley */
static char patterns_5S24B2[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/2, p4)"},
#endif
	{
		1, 0, 5, 0,
		3, 1, 4, 1,
		0, 2, 2, 2, 3, 2, 4, 2,
		2, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"ripple (p4)"},
#endif
	{
		2, -2, 3, -2,
		2, -1,
		-1, 0, 0, 0, 1, 0, 4, 0, 5, 0, 6, 0,
		3, 1,
		2, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"bird (p4)"},
#endif
	{
		-4, -1, 5, -1,
		-6, 0, -1, 0, 2, 0, 7, 0,
		-7, 1, -4, 1, -3, 1, 4, 1, 5, 1, 8, 1,
		127
	},
#ifdef LIFE_NAMES
	{"owl (p4)"},
#endif
	{
		-5, -1, 11, -1,
		-5, 0, -4, 0, -1, 0, 2, 0, 3, 0, 6, 0, 8, 0, 10, 0,
		1, 1, 4, 1,
		127
	},
#ifdef LIFE_NAMES
	{"heart (p8)"},
#endif
	{
		-3, -2, -2, -2, 1, -2, 3, -2, 5, -2,
		-3, -1, -2, -1, 2, -1, 4, -1,
		-2, 1, 2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"splitter (p6)"},
#endif
	{
		-5, -2, 6, -2,
		-7, -1, -3, -1, 4, -1, 8, -1,
		-5, 0, 0, 0, 6, 0,
		-2, 1, 2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"2 snakes (p8)"},
#endif
	{
		-3, -2, 1, -2,
		-2, -1, 2, -1,
		-1, 1, 3, 1,
		-4, 2, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"cyclone (p8)"},
#endif
	{
		2, -3, 3, -3,
		2, -2, 3, -2,
		-4, -1, -3, -1, -2, -1, -1, -1,
		4, 0, 5, 0, 6, 0, 7, 0,
		0, 1, 1, 1,
		0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"spiral (p10)"},
#endif
	{
		-1, -1, 0, -1,
		-1, 0, 0, 0,
		127
	},
};

/* Pentagonal, Cairo Tiling, 7 */
/* Pentagonal, Bays */
static char patterns_7S23B346[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/8, p48)"},
#endif
	{
		1, 0, 2, 0, 3, 0, 5, 0,
		0, 1,
		0, 2, 2, 2, 3, 2, 4, 2, 5, 2,
		2, 3, 4, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"clap hands (p2)"},
#endif
	{
		-1, -2, 2, -2,
		-2, -1, -1, -1, 2, -1, 3, -1,
		-1, 0, 1, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"dragonfly (p2)"},
#endif
	{
		0, -1, 1, -1,
		-1, 0, 0, 0, 1, 0, 2, 0,
		0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"blink (p2)"},
#endif
	{
		-1, -1, 0, -1, 1, -1, 3, -1,
		-2, 0, 0, 0, 1, 0, 3, 0,
		-2, 1, 0, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"asym blink (p2)"},
#endif
	{
		-1, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"spiral (p3)"},
#endif
	{
		-2, -2, -1, -2, 1, -2,
		-3, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, 2, 0,
		-2, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"hummingbird (p4)"},
#endif
	{
		1, -1,
		-1, 0, 0, 0, 2, 0,
		-2, 1, 0, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bird catch (p4)"},
#endif
	{
		-2, -1, 0, -1, 1, -1,
		-1, 0, 0, 0, 1, 0, 2, 0,
		0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"rotor (p4)"},
#endif
	{
		-1, -1,
		-2, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-2, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"generator (p4)"},
#endif
	{
		-2, -2, -1, -2,
		-3, -1, -2, -1, 0, -1,
		-3, 1, -1, 1, 0, 1,
		-2, 2, -1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"bowl (p4)"},
#endif
	{
		-3, -1, 0, -1, 1, -1, 4, -1,
		-4, 0, -3, 0, 4, 0, 5, 0,
		-3, 1, -1, 1, 3, 1, 4, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"rose (p4)"},
#endif
	{
		-2, 0, -1, 0, 0, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"exercise (p6)"},
#endif
	{
		-3, -1, -2, -1, 0, -1,
		-2, 0, -1, 0,
		-2, 1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"galaxy (p8)"},
#endif
	{
		0, -3, 1, -3, 3, -3,
		3, -2,
		-3, -1, 2, -1, 4, -1,
		-3, 0, 4, 0,
		-3, 1, -1, 1, 4, 1,
		-2, 2,
		-2, 3, 0, 3, 1, 3,
		127
	},
};

/* TRILIFE */
/* Trianglular, 9 Neighbors, Bagley */
static char patterns_9S3B34[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (3c/20, p20)"}, /* down */
#endif
	{
		2, 0, 3, 0,
		0, 1, 3, 1, 4, 1, 5, 1,
		0, 2, 3, 2, 4, 2, 5, 2,
		2, 3, 3, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"hexagon with legs (p3)"},
#endif
	{
		-3, -3, 2, -3, 4, -3,
		-4, -2, -3, -2, 0, -2, 1, -2, 2, -2,
		-4, -1, -3, -1, 4, -1,
		-7, 0, 4, 0, 5, 0, 6, 0,
		-6, 1, -5, 1, -4, 1, 7, 1,
		-4, 2, 3, 2, 4, 2,
		-2, 3, -1, 3, 0, 3, 3, 3, 4, 3,
		-4, 4, -2, 4, 3, 4,
		127
	},
#ifdef LIFE_NAMES
	{"fish (p4)"},
#endif
	{
		-2, -1, 1, -1,
		-2, 0, 0, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"kissing fish (p4)"},
#endif
	{
		-2, -1, 2, -1,
		-4, 0, -2, 0, 2, 0, 3, 0, 4, 0,
		-4, 1, -3, 1, -2, 1, 2, 1, 4, 1,
		-2, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"small spiral (p4)"},
#endif
	{
		-2, -2,
		-3, -1, -1, -1, 1, -1,
		-2, 0, 0, 0, 2, 0,
		-3, 1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"clock (p6)"},
#endif
	{
		-1, -1,
		-2, 0, -1, 0, 0, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"spiral (p10)"},
#endif
	{
		-4, -3, -1, -3, 0, -3, 3, -3,
		1, -2, 5, -2,
		-6, -1, -5, -1, -3, -1, 5, -1,
		4, 0, 7, 0,
		-7, 1, -4, 1,
		-5, 2, 3, 2, 5, 2, 6, 2,
		-5, 3, -1, 3,
		-3, 4, 0, 4, 1, 4, 4, 4,
		127
	},
#ifdef LIFE_NAMES
	{"shining star (p10)"},
#endif
	{
		0, -5,
		-1, -4, 1, -4,
		-4, -3, -3, -3, -1, -3, 1, -3, 3, -3, 4, -3,
		-8, -2, -6, -2, -5, -2, 5, -2, 6, -2, 8, -2,
		-7, -1, -6, -1, 6, -1, 7, -1,
		-7, 0, 7, 0,
		-7, 1, 7, 1,
		-7, 2, -6, 2, 6, 2, 7, 2,
		-8, 3, -6, 3, -5, 3, 5, 3, 6, 3, 8, 3,
		-4, 4, -3, 4, -1, 4, 1, 4, 3, 4, 4, 4,
		-1, 5, 1, 5,
		0, 6,
		127
	},
#ifdef LIFE_NAMES
	{"supernova (p19)"},
#endif
	{
		-6, -5, -5, -5, -3, -5, -2, -5, -1, -5, 0, -5, 1, -5, 2, -5, 3, -5, 5, -5, 6, -5,
		-7, -4, 7, -4,
		-8, -3, -7, -3, 7, -3, 8, -3,
		-9, -2, -8, -2, 8, -2, 9, -2,
		-10, -1, -9, -1, 9, -1, 10, -1,
		-11, 0, 11, 0,
		-11, 1, 11, 1,
		-10, 2, -9, 2, 9, 2, 10, 2,
		-9, 3, -8, 3, 8, 3, 9, 3,
		-8, 4, -7, 4, 7, 4, 8, 4,
		-7, 5, 7, 5,
		-6, 6, -5, 6, -3, 6, -2, 6, -1, 6, 0, 6, 1, 6, 2, 6, 3, 6, 5, 6, 6, 6,
		127
	},
};

static char patterns_9S34B3[][2 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
        {"replicator"},
#endif
        {
                -1, -1, 0, -1, 1, -1,
                -1, 0, 0, 0, 1, 0,
                127
        },
};

/* TRILIFE */
static char patterns_12S12B456[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/6, p12)"}, /* down */
#endif
	{
		1, 0, 4, 0, 5, 0,
		0, 2, 5, 2, 6, 2,
		2, 3, 3, 3, 4, 3, 5, 3,
		2, 4,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"s (p4)"},
#endif
	{
		-1, -1, 0, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"twist (p4)"},
#endif
	{
		-1, -1, 2, -1,
		-2, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"twist and untwist (p4)"},
#endif
	{
		-2, -1, 0, -1,
		0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"dangle (p4)"},
#endif
	{
		-1, -1,
		-1, 0,
		-1, 1, 2, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"greater and less (p4)"},
#endif
	{
		0, -1, 2, -1,
		-1, 0,
		0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"breakup (p4)"},
#endif
	{
		-1, 0, 0, 0, 2, 0,
		2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"carriage (p4)"},
#endif
	{
		-2, -1, -1, -1,
		-3, 0, 1, 0,
		-2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"wave (p4)"},
#endif
	{
		-3, -1, -1, -1, 1, -1, 3, -1,
		-2, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"4556 (p4)"},
#endif
	{
		-5, 0, -1, 0, 1, 0, 5, 0,
		-5, 1, -1, 1, 1, 1, 5, 1,
		127
	},
#ifdef LIFE_NAMES
	{"69_84_38_57 (p4)"},
#endif
	{
		-3, 0, 1, 0, 3, 0,
		-3, 1, 1, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"fishbowl (p4)"},
#endif
	{
		-2, -1, 2, -1,
		0, 0, 1, 0,
		0, 1, 1, 1,
		-2, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"asym ring (p4)"},
#endif
	{
		-3, -1, -1, -1,
		-3, 0, -1, 0, 2, 0,
		3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"wamu (p4)"},
#endif
	{
		-5, 0, -2, 0, 2, 0, 5, 0,
		-4, 1, -1, 1, 1, 1, 4, 1,
		127
	},
#ifdef LIFE_NAMES
	{"hiding monster (p4)"},
#endif
	{
		-4, 0, -3, 0, -1, 0, 1, 0, 3, 0, 4, 0,
		-4, 1, -3, 1, -2, 1, 0, 1, 2, 1, 3, 1, 4, 1,
		127
	},
#ifdef LIFE_NAMES
	{"inverting star (p4)"},
#endif
	{
		1, -2,
		-3, -1, -2, -1, -1, -1, 1, -1, 2, -1,
		-3, 0, 3, 0, 4, 0,
		-4, 1, -3, 1, 3, 1,
		-2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		-1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"hexagon and bowties (p4)"},
#endif
	{
		1, -3,
		3, -2,
		-4, -1, -1, -1, 0, -1, 1, -1,
		-4, 0, -1, 0, 0, 0, 1, 0,
		3, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"3 bows (p4)"},
#endif
	{
		-3, -3, -2, -3, 0, -3, 2, -3, 3, -3,
		0, -2,
		-5, -1, -4, -1, 0, -1, 4, -1, 5, -1,
		-3, 0, -2, 0, 2, 0, 3, 0,
		-2, 1, 2, 1,
		-2, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"compressor (p5)"},
#endif
	{
		-3, -1, -2, -1, -1, -1, 1, -1, 2, -1, 3, -1,
		-3, 2, -2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"flipping triangle (p6)"},
#endif
	{
		 -1, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 2, 0, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"asym flipping triangle (p6)"},
#endif
	{
		-1, -2, 0, -2,
		-4, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, 1, 0,
		-2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bracelet (p6)"},
#endif
	{
		-5, -1, -2, -1, 2, -1, 5, -1,
		-5, 0, -2, 0, 2, 0, 5, 0,
		127
	},
#ifdef LIFE_NAMES
	{"batman (p6)"},
#endif
	{
		1, -2,
		0, -1, 1, -1,
		-2, 0, -1, 0, 2, 0,
		-2, 1, -1, 1, 2, 1,
		0, 2, 1, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"dancing flame (p8)"},
#endif
	{
		-2, 0, -1, 0, 0, 0, 2, 0,
		2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"asym burner (p8)"},
#endif
	{
		-2, -3, 2, -3,
		-2, -2, 2, -2,
		-3, -1, -1, -1, 1, -1, 3, -1, 5, -1,
		-5, 5, -3, 5, -1, 5, 1, 5, 3, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"producer (p8)"},
#endif
	{
		3, -2,
		-3, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, 0, 0, 1, 0, 2, 0,
		3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"monster (p8)"},
#endif
	{
		-2, -1, 2, -1,
		-5, 0, -3, 0, 3, 0, 5, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-2, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"Zoro (p9)"},
#endif
	{
		2, -3,
		-1, -2, 2, -2,
		0, -1,
		0, 0,
		-2, 1, 1, 1,
		-2, 2,
		127
	},
};

/* sparse osc */
static char patterns_12S2B3[][2 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"glider (c/9, p36)"}, /* down */
#endif
	{
		-12, -1, -11, -1, 11, -1, 12, -1,
		-13, 0, -9, 0, 9, 0, 13, 0,
		-13, 1, 13, 1,
		-12, 2, -7, 2, 7, 2, 12, 2,
		-8, 3, -7, 3, 7, 3, 8, 3,
		127
	},
#ifdef LIFE_NAMES
	{"wave (p4)"},
#endif
	{
		-5, 0, -4, 0, -2, 0, 0, 0, 2, 0, 3, 0,
		127
	},
#ifdef LIFE_NAMES
	{"wave on wave (p4)"},
#endif
	{
		-4, -3, -3, -3, -1, -3, 1, -3, 3, -3, 4, -3,
		-4, 0, 4, 0,
		-3, 1, -2, 1, -1, 1, 1, 1, 2, 1, 3, 1,
		-2, 2, 2, 2,
		127
	},
};

/* no known glider */
static char patterns_12S23B3[][2 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"c (p4)"},
#endif
	{
		0, -1, 1, -1,
		-1, 0,
		-1, 1,
		0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"2 butterflies (p7)"},
#endif
	{
		1, -2,
		0, -1, 1, -1,
		-2, 1, -1, 1,
		-2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"l (p8)"},
#endif
	{
		0, -1,
		-1, 0, 0, 0,
		-1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"flame thrower (p18)"},
#endif
	{
		0, -3,
		-1, -2, 0, -2,
		-1, 3, 0, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"radiation (p24)"},
#endif
	{
		0, -1, 2, -1,
		-3, 0, 0, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"near replicator"},
#endif
	{
		-1, -1, 0, -1,
		-1, 0, 0, 0,
		127
	}
};

static char patterns_12S23B45[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/5, p5)"}, /* down */
#endif
	{
		5, 0,
		0, 1, 4, 1, 5, 1, 6, 1,
		0, 2, 4, 2, 5, 2, 6, 2,
		5, 3,
		127
	},
#endif
#if 0
#ifdef LIFE_NAMES
	{"eating alien (p2)"},
#endif
	{
		-1, -2, 1, -2, 2, -2, 3, -2,
		-3, -1, 3, -1,
		-5, 0, -4, 0, 4, 0,
		-5, 1, -4, 1, 4, 1,
		-3, 2, 3, 2,
		-1, 3, 1, 3, 2, 3, 3, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"hourglass3 (p3)"},
#endif
	{
		-2, -1, -1, -1, 1, -1, 2, -1,
		-4, 0, 4, 0,
		-4, 1, 4, 1,
		-2, 2, -1, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"hourglass4 (p4)"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-3, -1, 3, -1,
		-3, 0, 3, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"indecisive (p8)"},
#endif
	{
		1, -2, 2, -2, 3, -2,
		-2, -1, -1, -1, 4, -1,
		4, 0,
		-3, 1, 2, 1, 3, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"fat tumbler (p22)"},
#endif
	{
		-1, -2,
		-2, -1, -1, -1, 0, -1,
		-4, 0, -3, 0, 1, 0, 2, 0,
		-4, 1, 2, 1,
		-2, 2, 0, 2,
		127
	},
};

static char patterns_12S23B456[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/5, p5)"}, /* down */
#endif
	{
		5, 0,
		0, 1, 4, 1, 5, 1, 6, 1,
		0, 2, 4, 2, 5, 2, 6, 2,
		5, 3,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"hourglass4 (p4)"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-3, -1, 3, -1,
		-3, 0, 3, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"big hourglass (p4)"},
#endif
	{
		-1, -3, 1, -3,
		-1, -2, 0, -2, 1, -2,
		-4, -1, -1, -1, 0, -1, 1, -1, 4, -1,
		-4, 0, 4, 0,
		-4, 1, 4, 1,
		-4, 2, -1, 2, 0, 2, 1, 2, 4, 2,
		-1, 3, 0, 3, 1, 3,
		-1, 4, 1, 4,
		127
	},
#ifdef LIFE_NAMES
	{"water sprayer (p7)"},
#endif
	{
		3, -4,
		0, -3, 1, -3, 5, -3,
		-3, -2, 5, -2,
		-5, -1, 0, -1, 1, -1, 2, -1,
		-5, 0, 0, 0, 1, 0, 2, 0, 5, 0,
		-3, 1, -2, 1, 5, 1,
		1, 2, 5, 2,
		3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"bee (p10)"},
#endif
	{
		0, -1, 1, -1,
		0, 0,
		0, 1,
		0, 2, 1, 2,
		127
	},
};

static char patterns_12S24B46[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/4, p8)"}, /* right */
#endif
	{
		2, 1, 4, 1,
		0, 2, 1, 2, 2, 2, 3, 2,
		127
	},
#endif
#if 0
#ifdef LIFE_NAMES
	{"square (p2)"},
#endif
	{
		-2, -1, 0, -1, 2, -1,
		-1, 0, 1, 0,
		-1, 1, 1, 1,
		-2, 2, 0, 2, 2, 2,
		127
	}
#endif
#ifdef LIFE_NAMES
	{"diamond (p3)"},
#endif
	{
		-3, -1, -1, -1, 1, -1,
		-3, 0, -1, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"234 (p3)"},
#endif
	{
		-1, -1, 1, -1,
		-1, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"344 (p3)"},
#endif
	{
		0, -1,
		-3, 0, 0, 0, 3, 0,
		-3, 1, 0, 1, 3, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"big David (p3)"},
#endif
	{
		-2, -3, 0, -3, 2, -3,
		-4, -2, -1, -2, 0, -2, 1, -2, 4, -2,
		-5, -1, -4, -1, -3, -1, 3, -1, 4, -1, 5, -1,
		-6, 0, -4, 0, 4, 0, 6, 0,
		-6, 1, -4, 1, 4, 1, 6, 1,
		-5, 2, -4, 2, -3, 2, 3, 2, 4, 2, 5, 2,
		-4, 3, -1, 3, 0, 3, 1, 3, 4, 3,
		-2, 4, 0, 4, 2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"2 face (p4)"},
#endif
	{
		1, -1, 2, -1,
		0, 0, 1, 0, 2, 0,
		-2, 1, 0, 1,
		-2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
		-3, -2, -1, -2, 2, -2,
		-1, -1, 0, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, -2, 0, 2, 0, 5, 0,
		-5, 1, -2, 1, 2, 1, 3, 1, 4, 1,
		-3, 2, -2, 2, 0, 2, 1, 2,
		-2, 3, 1, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"skewed star (p7)"},
#endif
	{
		1, -4,
		1, -3,
		-6, -2, -5, -2, 1, -2,
		-3, -1, -2, -1, -1, -1, 1, -1, 2, -1, 6, -1, 7, -1,
		-3, -0, 3, -0, 4, -0,
		-4, 1, -3, 1, 3, 1,
		-7, 2, -6, 2, -2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		-1, 3, 5, 3, 6, 3,
		-1, 4,
		-1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"23443 (p10)"},
#endif
	{
		-5, -3, 5, -3,
		-6, -2, -5, -2, 5, -2, 6, -2,
		-1, -1, 1, -1,
		-1, 0, 1, 0,
		-6, 1, -5, 1, 5, 1, 6, 1,
		-5, 2, 5, 2,
		127
	},
};

static char patterns_12S246B46[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/10, p10)"}, /* down */
#endif
	{
		1, 0, 2, 0, 3, 0, 4, 0, 5, 0,
		1, 1, 3, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"234 (p3)"},
#endif
	{
		-1, -1, 1, -1,
		-1, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"344 (p3)"},
#endif
	{
		0, -1,
		-3, 0, 0, 0, 3, 0,
		-3, 1, 0, 1, 3, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"2 face (p4)"},
#endif
	{
		1, -1, 2, -1,
		0, 0, 1, 0, 2, 0,
		-2, 1, 0, 1,
		-2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
		-3, -2, -1, -2, 2, -2,
		-1, -1, 0, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, -2, 0, 2, 0, 5, 0,
		-5, 1, -2, 1, 2, 1, 3, 1, 4, 1,
		-3, 2, -2, 2, 0, 2, 1, 2,
		-2, 3, 1, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"shift (p4)"},
#endif
	{
		-1, -2,
		-2, -1, -1, -1, 0, -1, 1, -1,
		-3, 0, -2, 0,
		-2, 1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"skewed star (p7)"},
#endif
	{
		1, -4,
		1, -3,
		-6, -2, -5, -2, 1, -2,
		-3, -1, -2, -1, -1, -1, 1, -1, 2, -1, 6, -1, 7, -1,
		-3, -0, 3, -0, 4, -0,
		-4, 1, -3, 1, 3, 1,
		-7, 2, -6, 2, -2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		-1, 3, 5, 3, 6, 3,
		-1, 4,
		-1, 5,
		127
	},
#ifdef LIFE_NAMES
	{"dracula (p8)"},
#endif
	{
		-2, -1, 0, -1, 1, -1, 2, -1, 4, -1,
		-3, 0, -1, 0, 0, 0, 2, 0, 3, 0, 5, 0,
		1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"sailboat (p10)"},
#endif
	{
		-1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0,
		1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"23443 (p10)"},
#endif
	{
		-5, -3, 5, -3,
		-6, -2, -5, -2, 5, -2, 6, -2,
		-1, -1, 1, -1,
		-1, 0, 1, 0,
		-6, 1, -5, 1, 5, 1, 6, 1,
		-5, 2, 5, 2,
		127
	},
};

/* sparse so including p2 */
static char patterns_12S27B3[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/18, p18)"}, /* down */
#endif
	{
		3, 1, 4, 1,
		0, 2, 4, 2,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"throwing star (p2)"},
#endif
	{
		1, -1, 2, -1,
		-3, 0, -1, 0, 0, 0, 1, 0,
		-3, 1, -1, 1, 0, 1, 1, 1,
		1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"throwing star2 (p2)"},
#endif
	{
		-3, -2, 1, -2,
		-4, -1, -2, -1, -1, -1, 0, -1, 2, -1,
		-2, 0, -1, 0, 0, 0,
		-2, 1, 0, 1,
		127
	},

#ifdef LIFE_NAMES
	{"internal star (p2)"},
#endif
	{
		-4, -3, -3, -3, -1, -3, 1, -3, 3, -3, 4, -3,
		-5, -2, 5, -2,
		-5, -1, 5, -1,
		-4, 0, 4, 0,
		-3, 1, 3, 1,
		-2, 2, -1, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"star (p2)"},
#endif
	{
		0, -3,
		-3, -2, -2, -2, 2, -2, 3, -2,
		-5, -1, 5, -1,
		-5, 0, -1, 0, 0, 0, 1, 0, 5, 0,
		-5, 1, -1, 1, 0, 1, 1, 1, 5, 1,
		-5, 2, 5, 2,
		-3, 3, -2, 3, 2, 3, 3, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"tri spiral (p4)"},
#endif
	{
		0, -3, 2, -3,
		-4, -2, 4, -2,
		-4, -1, -1, -1, 1, -1,
		-3, 0, 0, 0, 3, 0,
		2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"worm mouth (p4)"},
#endif
	{
		-1, -3, 1, -3,
		-3, -2, -2, -2, 2, -2, 3, -2,
		-5, 0, 5, 0,
		-5, 1, 5, 1,
		-6, 2, 6, 2,
		-5, 3, -3, 3, -2, 3, 2, 3, 3, 3, 5, 3,
		127
	},
#ifdef LIFE_NAMES
	{"spinning glider (p36)"},
#endif
	{
		-1, -1, 1, -1, 2, -1,
		2, 0,
		0, 1, 1, 1, 2, 1,
		127
	},
};

/* sparse so including p2 */
static char patterns_12S278B3[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c3/20, p80)"}, /* down */
#endif
	{
		1, 0,
		1, 1, 2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"glider (c/18, p18)"}, /* down */
#endif
	{
		3, 1, 4, 1,
		0, 2, 4, 2,
		127
},
#endif
#ifdef LIFE_NAMES
	{"throwing star (p2)"},
#endif
	{
		1, -1, 2, -1,
		-3, 0, -1, 0, 0, 0, 1, 0,
		-3, 1, -1, 1, 0, 1, 1, 1,
		1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"throwing star2 (p2)"},
#endif
	{
		-3, -2, 1, -2,
		-4, -1, -2, -1, -1, -1, 0, -1, 2, -1,
		-2, 0, -1, 0, 0, 0,
		-2, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"internal star (p2)"},
#endif
	{
		-4, -3, -3, -3, -1, -3, 1, -3, 3, -3, 4, -3,
		-5, -2, 5, -2,
		-5, -1, 5, -1,
		-4, 0, 4, 0,
		-3, 1, 3, 1,
		-2, 2, -1, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"sunflower (p2)"},
#endif
	{
		-2, -6, 0, -6,
		-6, -5, -5, -5, 3, -5, 4, -5,
		-9, -4, -3, -4, -1, -4, 1, -4, 7, -4,
		-10, -3, -5, -3, 3, -3, 8, -3,
		-6, -2, 4, -2,
		-10, -1, -7, -1, -2, -1, -1, -1, 0, -1, 5, -1, 8, -1,
		-10, 0, -7, 0, -2, 0, -1, 0, 0, 0, 5, 0, 8, 0,
		-6, 1, 4, 1,
		8, 2, -10, 2, -5, 2, 3, 2,
		-9, 3, -3, 3, -1, 3, 1, 3, 7, 3,
		-6, 4, -5, 4, 3, 4, 4, 4,
		-2, 5, 0, 5,
		127
	},
#ifdef LIFE_NAMES
	{"hexagons (p3)"},
#endif
	{
		-4, -3, -3, -3, -2, -3, 2, -3, 3, -3, 4, -3,
		-4, -2, -3, -2, -2, -2, 2, -2, 3, -2, 4, -2,
		-7, 0, -6, 0, -5, 0, 5, 0, 6, 0, 7, 0,
		-7, 1, -6, 1, -5, 1, 5, 1, 6, 1, 7, 1,
		-4, 3, -3, 3, -2, 3, 2, 3, 3, 3, 4, 3,
		-4, 4, -3, 4, -2, 4, 2, 4, 3, 4, 4, 4,
		127
	},
#ifdef LIFE_NAMES
	{"tri spiral (p4)"},
#endif
	{
		0, -3, 2, -3,
		-4, -2, 4, -2,
		-4, -1, -1, -1, 1, -1,
		-3, 0, 0, 0, 3, 0,
		2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"worm mouth (p4)"},
#endif
	{
		-1, -3, 1, -3,
		-3, -2, -2, -2, 2, -2, 3, -2,
		-5, 0, 5, 0,
		-5, 1, 5, 1,
		-6, 2, 6, 2,
		-5, 3, -3, 3, -2, 3, 2, 3, 3, 3, 5, 3,
		127
	},
#ifdef LIFE_NAMES
	{"tri pulse (p26)"},
#endif
	{
		-6, -3, -5, -3, -4, -3, -3, -3,
		-6, -2, -3, -2, 4, -2, 5, -2,
		2, -1, 4, -1, 5, -1,
		4, 0,
		-2, 1,
		-4, 2, -3, 2,
		-3, 3, -2, 3, -1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"gunship1"},
#endif
	{
		2, -7, 4, -7,
		2, -6, 4, -6,
		1, -5,
		3, -4, 5, -4,
		3, -3, 4, -3, 5, -3,
		-3, 6,
		-3, 7, -2, 7,
		-4, 8,
		127
	},
#ifdef LIFE_NAMES
	{"gunship2"},
#endif
	{
		3, -6, 4, -6, 5, -6,
		2, -5, 6, -5,
		4, -4, 5, -4, 6, -4,
		-3, 6,
		-3, 7, -2, 7,
		-4, 8,
		127
	},
};

static char patterns_12S34B45[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/7, p7)"}, /* down */
#endif
	{
		1, 0, 2, 0, 4, 0, 5, 0,
		2, 1, 5, 1, 6, 1,
		2, 2, 3, 2, 5, 2, 6, 2,
		127
	},
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-1, 0, 0, 0, 1, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"switch (p2)"},
#endif
	{
		0, -1, 1, -1, 2, -1,
		-3, 0, 1, 0, 2, 0,
		-3, 1, -2, 1, -1, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"David (p2)"},
#endif
	{
		0, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"bat (p2)"},
#endif
	{
		0, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"eight (p2)"},
#endif
	{
		0, -3,
		-2, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, 3, 0,
		-3, 1, 3, 1,
		-2, 2, -1, 2, 0, 2, 1, 2, 2, 2,
		-2, 3, -1, 3, 0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"body (p2)"},
#endif
	{
		-1, -2, 1, -2,
		-1, -1, 1, -1,
		-1, 0, 0, 0, 1, 0,
		0, 1,
		-3, 2, -2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"gear (p2)"},
#endif
	{
		-1, -2,
		-1, -1, 2, -1, 3, -1,
		-4, 0, -3, 0,
		3, 1, 4, 1,
		-3, 2, -2, 2, 1, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"big gear (p2)"},
#endif
	{
		-3, -4, 1, -4,
		-3, -3, 1, -3, 4, -3, 5, -3,
		-6, -2, -5, -2,
		6, -1, 7, -1,
		-8, 0, -7, 0,
		7, 1, 8, 1,
		-7, 2, -6, 2,
		5, 3, 6, 3,
		-5, 4, -4, 4, -1, 4, 3, 4,
		-1, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"bumpy gear (p2)"},
#endif
	{
		0, -3,
		-4, -2, -3, -2, 0, -2, 3, -2, 4, -2,
		-3, 0, -2, 0, 2, 0, 3, 0,
		0, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"hexagon (p3)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, 2, 1, 3, 1,
		-2, 2, -1, 2, 0, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"big hexagon (p3)"},
#endif
	{
		-4, -3, -3, -3, -2, -3, -1, -3, 0, -3, 1, -3, 2, -3, 3, -3, 4, -3,
		-5, -2, -4, -2, 4, -2, 5, -2,
		-6, -1, -5, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, 6, 0, 7, 0,
		-7, 1, -6, 1, 6, 1, 7, 1,
		-6, 2, -5, 2, 5, 2, 6, 2,
		-5, 3, -4, 3, 4, 3, 5, 3,
		-4, 4, -3, 4, -2, 4, -1, 4, 0, 4, 1, 4, 2, 4, 3, 4, 4, 4,
		127
	},
#ifdef LIFE_NAMES
	{"jaws (p4)"},
#endif
	{
		-5, -2, -3, -2, -1, -2, 1, -2, 3, -2, 5, -2,
		-5, -1, -4, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1, 4, -1, 5, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1,
		-5, 2, -4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2, 2, 2, 3, 2, 4, 2, 5, 2,
		-5, 3, -3, 3, -1, 3, 1, 3, 3, 3, 5, 3,
		127
	},
#ifdef LIFE_NAMES
	{"flexagon (p5)"},
#endif
	{
		-1, -2, 0, -2, 1, -2, 2, -2, 3, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, 4, 0,
		-5, 1, -4, 1, 4, 1,
		-4, 2, -3, 2, 3, 2, 4, 2,
		-1, 3, 0, 3, 1, 3, 2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"hook clock (p6)"},
#endif
	{
		-2, 0, -1, 0, 0, 0, 1, 0,
		-2, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"blooms (p10)"},
#endif
	{
		1, -4, 2, -4, 3, -4, 4, -4, 5, -4,
		2, -3, 5, -3, 6, -3,
		-5, -2, -4, -2, 2, -2, 3, -2, 4, -2, 6, -2,
		-6, -1, -5, -1, -3, -1, -2, -1,
		-6, 0, -5, 0, -3, 0, -2, 0,
		-5, 1, -4, 1, 2, 1, 3, 1, 4, 1, 6, 1,
		2, 2, 5, 2, 6, 2,
		1, 3, 2, 3, 3, 3, 4, 3, 5, 3,
		127
	},
};

static char patterns_12S34B456[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/6, p12)"}, /* down */
#endif
	{
		2, 0, 4, 0, 6, 0, 8, 0, 9, 0,
		10, 1,
		0, 2, 1, 2, 3, 2, 10, 2,
		3, 3, 5, 3, 6, 3, 8, 3, 9, 3,
		127
	},
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-1, 0, 0, 0, 1, 0, 2, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"triangle (p2)"},
#endif
	{
		-2, -1, -1, -1, 1, -1, 2, -1,
		-2, 0, 2, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"David (p2)"},
#endif
	{
		0, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"bat (p2)"},
#endif
	{
		0, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"star eclipse (p2)"},
#endif
	{
		1, -2,
		-2, -1, -1, -1, 3, -1, 4, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 4, 0,
		-4, 1, -3, 1, -2, 1, -1, 1, 0, 1, 2, 1, 3, 1,
		-2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"double eclipse (p2)"},
#endif
	{
		-3, -2, 3, -2,
		-6, -1, -5, -1, -1, -1, 0, -1, 1, -1, 5, -1, 6, -1,
		-6, 0, -1, 0, 0, 0, 1, 0, 6, 0,
		-5, 1, -4, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"double bat (p2)"},
#endif
	{
		3, -2,
		0, -1, 1, -1, 5, -1, 6, -1,
		-5, 0, -4, 0, -2, 0, -1, 0, 0, 0, 1, 0, 6, 0,
		-6, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1,
		-6, 2, -5, 2, -1, 2, 0, 2,
		-3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"gear (p2)"},
#endif
	{
		-1, -2,
		-1, -1, 2, -1, 3, -1,
		-4, 0, -3, 0,
		3, 1, 4, 1,
		-3, 2, -2, 2, 1, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"big gear (p2)"},
#endif
	{
		-3, -4, 1, -4,
		-3, -3, 1, -3, 4, -3, 5, -3,
		-6, -2, -5, -2,
		6, -1, 7, -1,
		-8, 0, -7, 0,
		7, 1, 8, 1,
		-7, 2, -6, 2,
		5, 3, 6, 3,
		-5, 4, -4, 4, -1, 4, 3, 4,
		-1, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"bumpy gear (p2)"},
#endif
	{
		0, -3,
		-4, -2, -3, -2, 0, -2, 3, -2, 4, -2,
		-3, 0, -2, 0, 2, 0, 3, 0,
		0, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"Goliath (p3)"},
#endif
	{
	 	-1, -2, 0, -2, 1, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-4, 0, 4, 0,
		-4, 1, 4, 1,
		-4, 2, -3, 2, 3, 2, 4, 2,
		-1, 3, 0, 3, 1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"another mouth (p4)"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-2, -1, 1, -1,
		-2, 0, 1, 0,
		1, 1,
		-2, 2, -1, 2, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"mouth (p4)"},
#endif
	{
		-4, -1, -3, -1, -1, -1, 0, -1,
		-4, 0, 2, 0, 3, 0,
		-1, 1, 0, 1, 2, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"double hat (p5)"},
#endif
	{
		0, -3,
		-2, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-1, 0, 0, 0, 1, 0,
		-1, 1, 0, 1, 1, 1,
		-2, 3, -1, 3, 0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
#ifdef LIFE_NAMES
	{"fish clock (p6)"},
#endif
	{
		0, -2,
		-1, -1, 2, -1,
		-1, 0, 0, 0, 1, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"big fish clock (p6)"},
#endif
	{
		-2, -1, -1, -1, 1, -1, 2, -1,
		-2, 0, 1, 0, 2, 0,
		-2, 1, 0, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bloom (p8)"},
#endif
	{
		-5, -4, -4, -4, -2, -4, -1, -4,
		-6, -3, -1, -3, 0, -3,
		-6, -2, -5, -2, 0, -2, 1, -2, 2, -2, 3, -2, 4, -2, 5, -2,
		-5, -1, -4, -1, -2, -1, -1, -1, 0, -1, 6, -1,
		-5, 0, -4, 0, -2, 0, -1, 0, 0, 0, 6, 0,
		-6, 1, -5, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1,
		-6, 2, -1, 2, 0, 2,
		-5, 3, -4, 3, -2, 3, -1, 3,
		127
	},
};

/* no known glider */
static char patterns_12S345B4[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-1, 0, 0, 0, 1, 0, 2, 0,
		127
	},
#endif
#if 0
#ifdef LIFE_NAMES
	{"flipping triangle (p2)"},
#endif
	{
		0, -1,
		-1, 0, 1, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"hold (p3)"},
#endif
	{
		-3, 0, -2, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, 2, 1, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pinch (p3)"},
#endif
	{
		-2, 0, -1, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"doily (p3)"},
#endif
	{
		-2, -3, 2, -3,
		-4, -2, -3, -2, -2, -2, 2, -2, 3, -2, 4, -2,
		-6, 0, -5, 0, 5, 0, 6, 0,
		-6, 1, -5, 1, 5, 1, 6, 1,
		-4, 3, -3, 3, -2, 3, 2, 3, 3, 3, 4, 3,
		-2, 4, 2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"hold (p4)"},
#endif
	{
		-4, -1, -3, -1, 3, -1, 4, -1,
		-4, 0, -3, 0, 3, 0, 4, 0,
		127
	},
#ifdef LIFE_NAMES
	{"cradle (p4)"},
#endif
	{
		0, -3, 1, -3, 2, -3,
		2, -2,
		-2, 0, -1, 0,
		-2, 1, -1, 1,
		2, 3,
		0, 4, 1, 4, 2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"cannibal pacman (p8)"},
#endif
	{
		-3, -2, -2, -2, -1, -2, 0, -2, 2, -2, 3, -2,
		-4, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, 5, 0,
		-5, 1, 4, 1, 5, 1,
		-4, 2, -3, 2, 4, 2,
		-3, 3, -2, 3, 0, 3, 1, 3, 2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"boat (p9)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 2, 0,
		1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"skewed star (p26)"},
#endif
	{
		-2, -3, -1, -3, 0, -3,
		-3, -2, 2, -2, 4, -2, 5, -2,
		-6, -1, -5, -1, -1, -1, 2, -1, 5, -1,
		-6, 0, -3, 0, 5, 0,
		-5, 1, 3, 1, 6, 1,
		-5, 2, -2, 2, 1, 2, 5, 2, 6, 2,
		-5, 3, -4, 3, -2, 3, 3, 3,
		0, 4, 1, 4, 2, 4,
		127
	},
};

static char patterns_12S35B4[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/3, p3)"}, /* down */
#endif
	{
		1, 0,
		1, 1, 2, 1, 3, 1,
		1, 2, 2, 2, 3, 2,
		1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-1, -2,
		-1, -1, 0, -1,
		0, 0,
		127
	},
#endif
#if 0
#ifdef LIFE_NAMES
	{"12 (p2)"},
#endif
	{
		-1, -2, 0, -2, 1, -2,
		-1, -1,
		-1, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"doily (p3)"},
#endif
	{
		-2, -3, 2, -3,
		-4, -2, -3, -2, -2, -2, 2, -2, 3, -2, 4, -2,
		-6, 0, -5, 0, 5, 0, 6, 0,
		-6, 1, -5, 1, 5, 1, 6, 1,
		-4, 3, -3, 3, -2, 3, 2, 3, 3, 3, 4, 3,
		-2, 4, 2, 4,
		127
	},
#ifdef LIFE_NAMES
	{"2 butterflies (p4)"},
#endif
	{
		-2, -2, -1, -2,
		-3, -1, -2, -1,
		2, 0, 3, 0,
		1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"0231 (p4)"},
#endif
	{
		-4, -1, -3, -1, 3, -1, 4, -1,
		-4, 0, -3, 0, 3, 0, 4, 0,
		127
	},
#ifdef LIFE_NAMES
	{"teamwork (p4)"},
#endif
	{
		1, -4, 2, -4, 3, -4,
		1, -3, 2, -3, 3, -3,
		-2, -1, -1, -1, 0, -1,
		-2, 0, -1, 0, 0, 0,
		1, 2, 2, 2, 3, 2,
		1, 3, 2, 3, 3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"3 cats (p5)"},
#endif
	{
		-3, -3, -2, -3, -1, -3, 1, -3, 2, -3, 3, -3,
		-2, -2, 2, -2,
		-3, -1, -2, -1, 2, -1, 3, -1,
		-5, 1, -4, 1, 4, 1, 5, 1,
		-8, 2, -7, 2, -6, 2, 6, 2, 7, 2, 8, 2,
		-7, 3, -2, 3, 2, 3, 7, 3,
		-6, 4, -5, 4, -4, 4, -2, 4, 2, 4, 4, 4, 5, 4, 6, 4,
		-5, 5, 5, 5,
		127
	},
#ifdef LIFE_NAMES
	{"06_56_74_30_35_47 (p6)"},
#endif
	{
		-8, -1, -7, -1, -1, -1, 0, -1, 2, -1, 5, -1, 6, -1,
		-8, 0, -7, 0, -1, 0, 0, 0, 2, 0, 5, 0, 6, 0,
		127
	},
};

static char patterns_12S45B456[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/4, p8)"}, /* down */
#endif
	{
		1, 0, 2, 0, 3, 0, 4, 0, 5, 0,
		2, 1, 3, 1, 5, 1,
		2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-2, -1, -1, -1, 0, -1,
		0, 0, 1, 0, 2, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"pinch (p3)"},
#endif
	{
		-1, -1, 0, -1, 1, -1,
		-1, 0, 0, 0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"flipping s (p4)"},
#endif
	{
		0, -2, 1, -2,
		1, -1, 2, -1, 3, -1,
		-1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1,
		0, 2, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"triangle (p4)"},
#endif
	{
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, 3, 0,
		-3, 1, -2, 1, 2, 1, 3, 1,
		-2, 2, -1, 2, 1, 2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"pyramid clock (p6)"},
#endif
	{
		-2, -1, -1, -1, 1, -1,
		-2, 0, -1, 0, 0, 0,
		-1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"torso (p6)"},
#endif
	{
		-1, -2, 1, -2,
		-2, -1, -1, -1, 1, -1, 2, -1,
		-1, 0, 1, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"trapazoid (p18)"},
#endif
	{
		-3, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2, 3, -2,
		-4, -1, 4, -1,
		-4, 0, -3, 0, 3, 0, 4, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 3, 1,
		127
	},
};

static char patterns_12S456B4[][2 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"glider (c/3, p3)"}, /* down */
#endif
	{
		0, 0, 1, 0, 2, 0, 3, 0,
		0, 1, 1, 1, 2, 1, 3, 1,
		127
	},
#endif
#if 0
#ifdef LIFE_NAMES
	{"triangle blink (p2)"},
#endif
	{
		-2, 0, -1, 0, 1, 0, 2, 0,
		-1, 1, 0, 1, 1, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"wrench gadget (p3)"},
#endif
	{
		-3, -4,
		-5, -3, -4, -3, -3, -3, -1, -3, 0, -3,
		-5, -2, -1, -2, 0, -2, 1, -2, 2, -2, 3, -2,
		-5, -1, -4, -1, -3, -1, 1, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, 1, 0, 4, 0, 5, 0,
		-5, 1, -1, 1, 0, 1, 1, 1, 2, 1, 3, 1,
		-5, 2, -4, 2, -3, 2, -1, 2, 0, 2,
		-3, 3,
		127
	},
#ifdef LIFE_NAMES
	{"small change (p4)"},
#endif
	{
		-5, -2, -3, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2, 3, -2, 5, -2,
		-6, -1, -4, -1, 4, -1, 6, -1,
		-6, 0, -5, 0, -2, 0, -1, 0, 1, 0, 2, 0, 5, 0, 6, 0,
		-5, 1, -3, 1, -1, 1, 0, 1, 1, 1, 3, 1, 5, 1,
		127
	},
#ifdef LIFE_NAMES
	{"small change2 (p4)"},
#endif
	{
		-2, -5, 4, -5,
		-3, -4, -1, -4, 0, -4, 1, -4, 2, -4, 3, -4, 5, -4,
		-5, -3, -4, -3, 0, -3, 2, -3, 6, -3, 7, -3,
		-4, -2, -3, -2, 0, -2, 2, -2, 5, -2, 6, -2,
		-4, -1, -3, -1, -1, -1, 0, -1, 2, -1, 3, -1, 5, -1, 6, -1,
		-4, 0, -3, 0, -1, 0, 0, 0, 2, 0, 3, 0, 5, 0, 6, 0,
		-4, 1, -3, 1, 0, 1, 2, 1, 5, 1, 6, 1,
		-5, 2, -4, 2, 0, 2, 2, 2, 6, 2, 7, 2,
		-3, 3, -1, 3, 0, 3, 1, 3, 2, 3, 3, 3, 5, 3,
		-2, 4, 4, 4,
		127
	},
#ifdef LIFE_NAMES
	{"deformed fish (p6)"},
#endif
	{
		 1, -2, 2, -2,
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		-3, 0, -1, 0, 3, 0,
		-3, 1, -1, 1, 3, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 1, 2, 2, 2, 3, 2,
		1, 3, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"hairy hexagon (p6)"},
#endif
	{
		-2, -3, 1, -3,
		-5, -2, -3, -2, -2, -2, -1, -2, 1, -2, 2, -2, 3, -2, 4, -2,
		-3, -1, 3, -1, 6, -1,
		-6, 0, -5, 0, -4, 0, 4, 0, 5, 0,
		-5, 1, -4, 1, 4, 1, 5, 1, 6, 1,
		-6, 2, -3, 2, 3, 2,
		-4, 3, -3, 3, -2, 3, -1, 3, 1, 3, 2, 3, 3, 3, 5, 3,
		-1, 4, 2, 4,
		127
	},
#if 0
/* 66 cells */
#ifdef LIFE_NAMES
	{"dumb pacmen (p6)"},
#endif
	{
		 0, -5, 2, -5,
		0, -4, 1, -4, 2, -4, 3, -4,
		-7, -3, -6, -3, -5, -3,
		-8, -2, -7, -2, -6, -2, -2, -2, -1, -2, 0, -2, 1, -2, 3, -2, 7, -2, 8, -2,
		-4, -1, -3, -1, -1, -1, 2, -1, 3, -1, 4, -1, 7, -1, 8, -1, 9, -1,
		-5, 0, -4, 0, -3, 0, 4, 0, 8, 0,
		-8, 1, -4, 1, 3, 1, 4, 1, 5, 1,
		-9, 2, -8, 2, -7, 2, -4, 2, -3, 2, -2, 2, 1, 2, 3, 2, 4, 2,
		-8, 3, -7, 3, -3, 3, -1, 3, 0, 3, 1, 3, 2, 3, 6, 3, 7, 3, 8, 3,
		5, 4, 6, 4, 7, 4,
		-3, 5, -2, 5, -1, 5, 0, 5,
		-2, 6, 0, 6,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"big hexagon (p6)"},
#endif
	{
		-3, -4, 3, -4,
		-5, -3, -4, -3, -3, -3, -1, -3, 1, -3, 3, -3, 4, -3, 5, -3,
		-5, -2, 5, -2,
		-6, -1, 6, -1,
		-8, 0, -7, 0, 7, 0, 8, 0,
		-8, 1, -7, 1, 7, 1, 8, 1,
		-6, 2, 6, 2,
		-5, 3, 5, 3,
		-5, 4, -4, 4, -3, 4, -1, 4, 1, 4, 3, 4, 4, 4, 5, 4,
		-3, 5, 3, 5,
		127
	},
#ifdef LIFE_NAMES
	{"David (p9)"},
#endif
	{
		0, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"internal gear (p24)"},
#endif
	{
		 -1, -4, 1, -4,
		-4, -3, 0, -3, 1, -3, 3, -3,
		-6, -2, -5, -2, -2, -2, 3, -2, 6, -2,
		-7, -1, -5, -1, 0, -1, 5, -1, 6, -1, 7, -1,
		-5, 0, -2, 0, 2, 0, 7, 0,
		-7, 1, -2, 1, 2, 1, 5, 1,
		-7, 2, -6, 2, -5, 2, 0, 2, 5, 2, 7, 2,
		-6, 3, -3, 3, 2, 3, 5, 3, 6, 3,
		-3, 4, -1, 4, 0, 4, 4, 4,
		-1, 5, 1, 5,
		127
	},
};

#ifdef LIFE_NAMES
#define PAT_SPACE 2
#else
#define PAT_SPACE 1
#endif

static int patterns_5rules[] =
{
	(sizeof patterns_5S24B2 / sizeof patterns_5S24B2[0]) / PAT_SPACE,
	(sizeof patterns_5S2B24 / sizeof patterns_5S2B24[0]) / PAT_SPACE,
};

static int patterns_6rules[] =
{
	(sizeof patterns_6S2b34B2a / sizeof patterns_6S2b34B2a[0]) / PAT_SPACE,
	(sizeof patterns_6S2a2b4aB2a3a4b / sizeof patterns_6S2a2b4aB2a3a4b[0]) /PAT_SPACE,
	(sizeof patterns_6S35B2 / sizeof patterns_6S35B2[0]) / PAT_SPACE,
	(sizeof patterns_6S3B245 / sizeof patterns_6S3B245[0]) / PAT_SPACE,
	(sizeof patterns_6S34B2 / sizeof patterns_6S34B2[0]) / PAT_SPACE,
};

static int patterns_7rules[] =
{
	(sizeof patterns_7S23B346 / sizeof patterns_7S23B346[0]) / PAT_SPACE,
};

#define common_8size ((sizeof patterns_8S23B3_6 / sizeof patterns_8S23B3_6[0]) / PAT_SPACE)

static int patterns_8rules[] =
{
	(common_8size + (sizeof patterns_8S23B3 / sizeof patterns_8S23B3[0]) / PAT_SPACE),
	(common_8size + (sizeof patterns_8S23B36 / sizeof patterns_8S23B36[0]) / PAT_SPACE),
	(sizeof patterns_8S34678B3678 / sizeof patterns_8S34678B3678[0]) / PAT_SPACE,
	(sizeof patterns_8S245B3 / sizeof patterns_8S245B3[0]) / PAT_SPACE,
};

static int patterns_9rules[] =
{
	(sizeof patterns_9S3B34 / sizeof patterns_9S3B34[0]) / PAT_SPACE,
	(sizeof patterns_9S34B3 / sizeof patterns_9S34B3[0]) / PAT_SPACE,
};

static int patterns_12rules[] =
{
	(sizeof patterns_12S34B45 / sizeof patterns_12S34B45[0]) / PAT_SPACE,
	(sizeof patterns_12S45B456 / sizeof patterns_12S45B456[0]) / PAT_SPACE,
	(sizeof patterns_12S23B45 / sizeof patterns_12S23B45[0]) / PAT_SPACE,
	(sizeof patterns_12S23B456 / sizeof patterns_12S23B456[0]) / PAT_SPACE,
	(sizeof patterns_12S12B456 / sizeof patterns_12S12B456[0]) / PAT_SPACE,
	(sizeof patterns_12S24B46 / sizeof patterns_12S24B46[0]) / PAT_SPACE,
	(sizeof patterns_12S246B46 / sizeof patterns_12S246B46[0]) / PAT_SPACE,
	(sizeof patterns_12S34B456 / sizeof patterns_12S34B456[0]) / PAT_SPACE,
	(sizeof patterns_12S35B4 / sizeof patterns_12S35B4[0]) / PAT_SPACE,
	(sizeof patterns_12S456B4 / sizeof patterns_12S456B4[0]) / PAT_SPACE,
	(sizeof patterns_12S27B3 / sizeof patterns_12S27B3[0]) / PAT_SPACE,
	(sizeof patterns_12S278B3 / sizeof patterns_12S278B3[0]) / PAT_SPACE,
	(sizeof patterns_12S2B3 / sizeof patterns_12S2B3[0]) / PAT_SPACE,
	(sizeof patterns_12S23B3 / sizeof patterns_12S23B3[0]) / PAT_SPACE,
	(sizeof patterns_12S345B4 / sizeof patterns_12S345B4[0]) / PAT_SPACE,
};

/*static paramstruct param_3rules[] =
{
};

static paramstruct param_4rules[] =
{
};*/

static paramstruct param_5rules[] =
{
	{  /* LIFE_5S24B2 */
		0x14, 0x4,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{  /* LIFE_5S2B24 */
		0x4, 0x14,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
};

static paramstruct param_6rules[] =
{
	{ /* LIFE_6S2b34B2a */
		0x18, 0x0,
		{0x2, 0x0, 0x0},
		{0x1, 0x0, 0x0}
	}, /* LIFE_6S2a2b4aB2a3a4b */
	{
		0x0, 0x0,
		{0x3, 0x0, 0x1},
		{0x1, 0x1, 0x2}
	},
	{  /* LIFE_6S35B2 */
		0x28, 0x4,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_6S3B245 */
		0x8, 0x34,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_6S34B2 */
		0x18, 0x4,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
};

static paramstruct param_7rules[] =
{
	{  /* LIFE_7S23B346 */
		0xC, 0x58,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
};

static paramstruct param_8rules[] =
{
	{ /* LIFE_8S23B3 */
		0xC, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_8S23B36 */
		0xC, 0x48,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_8S34678B3678 */
		0x1D8, 0x1C8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_8S245B3 */
		0x34, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
};

static paramstruct param_9rules[] =
{
	{ /* LIFE_9S3B34 */
		0x8, 0x18,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_9S34B3 */
		0x18, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
};

static paramstruct param_12rules[] =
{
	{ /* LIFE_12S34B45 */
		0x18, 0x30,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S45B456 */
		0x30, 0x70,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S23B45 */
		0xC, 0x30,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S23B456 */
		0xC, 0x70,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S12B456 */
		0x6, 0x70,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S24B46 */
		0x14, 0x50,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S246B46 */
		0x54, 0x50,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S34B456 */
		0x18, 0x70,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S35B4 */
		0x28, 0x10,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S456B4 */
		0x70, 0x10,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S27B3 */
		0x84, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S278B3 */
		0x184, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S2B3 */
		0x4, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S23B3 */
		0xC, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{ /* LIFE_12S345B4 */
		0x38, 0x10,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
};

#define LIFE_5S24B2 0 /* BAGLEY */
#define LIFE_5GLIDERS 1
#define LIFE_5RULES (sizeof param_5rules / sizeof param_5rules[0])
#define LIFE_5S2B24 1
#define LIFE_6S2b34B2a 0 /* CALLAHAN */
#define LIFE_6S2a2b4aB2a3a4b 1 /* ANDREEN */
#define LIFE_6S35B2 2 /* BAYS */
#define LIFE_6S3B245 3 /* BAYSNONQUALIFY glider but not GL */
#define LIFE_6GLIDERS 4	/* GLIDER first in param_6rules */
#define LIFE_6S34B2 4 /* WIKIPEDIA */
#define LIFE_6RULES (sizeof param_6rules / sizeof param_6rules[0])
#define LIFE_7S23B346 0 /* BAYS */
#define LIFE_7GLIDERS 1
#define LIFE_7RULES (sizeof param_7rules / sizeof param_7rules[0])
#define LIFE_8S23B3 0 /* LIFE, CONWAY */
#define LIFE_8S23B36 1 /* HIGHLIFE, BELL */
#define LIFE_8S34678B3678 2 /* DAY_NIGHT, THOMPSON */
#define LIFE_8S245B3 3 /* BAYS */
#define LIFE_8GLIDERS 4	/* GLIDER rules are first in param_8rules */
#define LIFE_8RULES (sizeof param_8rules / sizeof param_8rules[0])
#define LIFE_9S3B34 0 /* BAGLEY */
#define LIFE_9GLIDERS 1
#define LIFE_9S34B3 1 /* replicator but too prolific */
#define LIFE_9RULES (sizeof param_9rules / sizeof param_9rules[0])
#define LIFE_6S2b34B2a 0 /* CALLAHAN */
#define LIFE_12S34B45 0 /* TRILIFE, BAYS */
#define LIFE_12S45B456 1 /* TRILIFE1, BAYS */
#define LIFE_12S23B45 2 /* TRILIFE2, BAYS */
#define LIFE_12S23B456 3
#define LIFE_12S12B456 4
#define LIFE_12S24B46 5
#define LIFE_12S246B46 6
#define LIFE_12S34B456 7
#define LIFE_12S35B4 8
#define LIFE_12S456B4 9
#define LIFE_12S27B3 10
#define LIFE_12S278B3 11
#define LIFE_12S2B3 12 /* sparse */
#define LIFE_12GLIDERS 13 /* GLIDER rules are first in param_12rules */
#define LIFE_12S23B3 13
#define LIFE_12S345B4 14
#define LIFE_12RULES (sizeof param_12rules / sizeof param_12rules[0])
