/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoOutputStream;

public class VirtuosoExplicitString {
    private int dtp;
    private byte[] bytes;
    private String str;
    private VirtuosoConnection con;

    protected VirtuosoExplicitString(byte[] byArray, int n) {
        this.dtp = n;
        this.bytes = byArray;
        this.str = null;
    }

    protected VirtuosoExplicitString(String string, int n, VirtuosoConnection virtuosoConnection) throws VirtuosoException {
        try {
            this.dtp = n;
            this.con = virtuosoConnection;
            if (n == 225 || n == 226 || n == 132) {
                this.bytes = string.getBytes("UTF8");
                this.dtp = this.bytes.length < 256 ? 225 : 226;
                this.str = string;
            } else if (n == 182 || n == 181 || n == 238 || n == 183 || n == 125) {
                if (virtuosoConnection != null && virtuosoConnection.charset_utf8) {
                    this.bytes = string.getBytes("UTF8");
                } else if (virtuosoConnection != null && virtuosoConnection.charset != null) {
                    this.bytes = virtuosoConnection.charsetBytes(string);
                } else {
                    this.cli_wide_to_narrow(string, virtuosoConnection != null ? virtuosoConnection.client_charset_hash : null);
                }
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            } else if (n == 131 || n == 222) {
                this.bytes = string.getBytes("8859_1");
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            } else if (!this.cli_wide_to_narrow(string, virtuosoConnection != null ? virtuosoConnection.client_charset_hash : null)) {
                this.bytes = string.getBytes("UTF8");
                this.dtp = this.bytes.length < 256 ? 225 : 226;
                this.str = string;
            } else {
                if (virtuosoConnection != null && virtuosoConnection.charset != null) {
                    this.bytes = virtuosoConnection.charsetBytes(string);
                }
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (virtuosoConnection != null && virtuosoConnection.charset != null) {
                this.bytes = virtuosoConnection.charsetBytes(string);
            } else {
                this.cli_wide_to_narrow(string, virtuosoConnection != null ? virtuosoConnection.client_charset_hash : null);
            }
            n = this.bytes.length < 256 ? 181 : 182;
        }
    }

    protected boolean cli_wide_to_narrow(String string, Hashtable hashtable) {
        boolean bl = true;
        if (string == null) {
            this.bytes = new byte[0];
            return true;
        }
        this.bytes = new byte[string.length()];
        if (hashtable == null) {
            int n = 0;
            while (n < string.length()) {
                this.bytes[n] = (byte)string.charAt(n);
                ++n;
            }
        } else {
            int n = 0;
            while (n < string.length()) {
                Byte by;
                Character c = new Character(string.charAt(n));
                Byte by2 = by = hashtable != null ? hashtable.get(c) : new Byte((byte)c.charValue());
                if (by == null) {
                    this.bytes[n] = 63;
                    bl = false;
                } else {
                    this.bytes[n] = (byte)by.intValue();
                }
                ++n;
            }
        }
        return bl;
    }

    protected boolean cli_wide_to_escaped(String string, Hashtable hashtable) {
        int n;
        boolean bl = true;
        if (string == null) {
            this.bytes = new byte[0];
            this.dtp = 181;
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            Byte by = null;
            if (hashtable != null) {
                Character c = new Character((char)n);
                by = (Byte)hashtable.get(c);
                if (by == null) {
                    stringBuffer.append("\\x");
                    stringBuffer.append(Integer.toString(c.charValue(), 16));
                } else {
                    stringBuffer.append((char)by.intValue());
                }
            } else if (n > 256) {
                stringBuffer.append("\\x");
                stringBuffer.append(Integer.toString(n, 16));
            } else {
                stringBuffer.append((char)n);
            }
            ++n2;
        }
        this.bytes = new byte[stringBuffer.length() + 1];
        n = 0;
        while (n < stringBuffer.length()) {
            this.bytes[n] = (byte)stringBuffer.charAt(n);
            ++n;
        }
        stringBuffer = null;
        this.dtp = this.bytes.length < 256 ? 181 : 182;
        return true;
    }

    protected int getDtp() {
        return this.dtp;
    }

    protected void write(VirtuosoOutputStream virtuosoOutputStream) throws IOException {
        virtuosoOutputStream.write(this.dtp);
        if (this.bytes.length < 256) {
            virtuosoOutputStream.write(this.bytes.length);
        } else {
            virtuosoOutputStream.writelongint(this.bytes.length);
        }
        if ((this.dtp == 225 || this.dtp == 226) && this.str != null) {
            int n = 0;
            while (n < this.str.length()) {
                byte[] byArray = this.str.substring(n, n + 1).getBytes("UTF8");
                if (byArray != null) {
                    virtuosoOutputStream.write(byArray, 0, byArray.length);
                    virtuosoOutputStream.flush();
                }
                ++n;
            }
        } else {
            virtuosoOutputStream.write(this.bytes, 0, this.bytes.length);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        if (this.str != null) {
            return this.str;
        }
        try {
            if (this.dtp == 225 || this.dtp == 226) {
                return new String(this.bytes, "UTF8");
            }
            if (this.con != null && this.con.charset != null) {
                return this.con.uncharsetBytes(new String(this.bytes, "8859_1"));
            }
            return new String(this.bytes, "8859_1");
        }
        catch (Exception var1_1) {
            var2_2 = new char[this.bytes.length];
            var3_3 = 0;
            ** while (var3_3 < this.bytes.length)
        }
lbl-1000:
        // 1 sources

        {
            var2_2[var3_3] = (char)(this.bytes[var3_3] & 255);
            ++var3_3;
            continue;
        }
lbl16:
        // 1 sources

        return new String(var2_2);
    }

    public String toParamString() {
        return this.toString().trim();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VirtuosoExplicitString) {
            VirtuosoExplicitString virtuosoExplicitString = (VirtuosoExplicitString)object;
            if (virtuosoExplicitString.dtp != this.dtp) {
                return false;
            }
            return virtuosoExplicitString.bytes.equals(this.bytes);
        }
        return false;
    }
}

