/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSErrorEvent.h"

#include "ErrorEvent.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSErrorEvent);

/* Hash table */

static const HashTableValue JSErrorEventTableValues[5] =
{
    { "message", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventMessage), (intptr_t)0 },
    { "filename", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventFilename), (intptr_t)0 },
    { "lineno", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventLineno), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSErrorEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSErrorEventTableValues, 0 };
#else
    { 9, 7, JSErrorEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSErrorEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSErrorEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSErrorEventConstructorTableValues, 0 };
#else
    { 1, 0, JSErrorEventConstructorTableValues, 0 };
#endif

class JSErrorEventConstructor : public DOMConstructorObject {
public:
    JSErrorEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSErrorEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSErrorEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSErrorEventConstructor::s_info = { "ErrorEventConstructor", 0, &JSErrorEventConstructorTable, 0 };

bool JSErrorEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSErrorEventConstructor, DOMObject>(exec, &JSErrorEventConstructorTable, this, propertyName, slot);
}

bool JSErrorEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSErrorEventConstructor, DOMObject>(exec, &JSErrorEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSErrorEventPrototypeTableValues[2] =
{
    { "initErrorEvent", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsErrorEventPrototypeFunctionInitErrorEvent), (intptr_t)6 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSErrorEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSErrorEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSErrorEventPrototypeTableValues, 0 };
#endif

static const HashTable* getJSErrorEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSErrorEventPrototypeTable);
}
const ClassInfo JSErrorEventPrototype::s_info = { "ErrorEventPrototype", 0, 0, getJSErrorEventPrototypeTable };

JSObject* JSErrorEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSErrorEvent>(exec, globalObject);
}

bool JSErrorEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSErrorEventPrototypeTable(exec), this, propertyName, slot);
}

bool JSErrorEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSErrorEventPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSErrorEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSErrorEventTable);
}
const ClassInfo JSErrorEvent::s_info = { "ErrorEvent", &JSEvent::s_info, 0, getJSErrorEventTable };

JSErrorEvent::JSErrorEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ErrorEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSErrorEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSErrorEventPrototype(JSErrorEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSErrorEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSErrorEvent, Base>(exec, getJSErrorEventTable(exec), this, propertyName, slot);
}

bool JSErrorEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSErrorEvent, Base>(exec, getJSErrorEventTable(exec), this, propertyName, descriptor);
}

JSValue jsErrorEventMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}

JSValue jsErrorEventFilename(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->filename());
    return result;
}

JSValue jsErrorEventLineno(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->lineno());
    return result;
}

JSValue jsErrorEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* domObject = static_cast<JSErrorEvent*>(asObject(slotBase));
    return JSErrorEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSErrorEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSErrorEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsErrorEventPrototypeFunctionInitErrorEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSErrorEvent::s_info))
        return throwError(exec, TypeError);
    JSErrorEvent* castedThisObj = static_cast<JSErrorEvent*>(asObject(thisValue));
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(0).toString(exec);
    bool canBubbleArg = args.at(1).toBoolean(exec);
    bool cancelableArg = args.at(2).toBoolean(exec);
    const UString& messageArg = args.at(3).toString(exec);
    const UString& filenameArg = args.at(4).toString(exec);
    unsigned linenoArg = args.at(5).toInt32(exec);

    imp->initErrorEvent(typeArg, canBubbleArg, cancelableArg, messageArg, filenameArg, linenoArg);
    return jsUndefined();
}


}

#endif // ENABLE(WORKERS)
