/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLButtonElement.h"

#include "HTMLButtonElement.h"
#include "HTMLFormElement.h"
#include "JSHTMLFormElement.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLButtonElement);

/* Hash table */

static const HashTableValue JSHTMLButtonElementTableValues[13] =
{
    { "form", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementForm), (intptr_t)0 },
    { "formNoValidate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormNoValidate), (intptr_t)setJSHTMLButtonElementFormNoValidate },
    { "validity", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValidity), (intptr_t)0 },
    { "accessKey", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementAccessKey), (intptr_t)setJSHTMLButtonElementAccessKey },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementDisabled), (intptr_t)setJSHTMLButtonElementDisabled },
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementAutofocus), (intptr_t)setJSHTMLButtonElementAutofocus },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementName), (intptr_t)setJSHTMLButtonElementName },
    { "type", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementType), (intptr_t)0 },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValue), (intptr_t)setJSHTMLButtonElementValue },
    { "willValidate", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementWillValidate), (intptr_t)0 },
    { "validationMessage", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValidationMessage), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLButtonElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLButtonElementTableValues, 0 };
#else
    { 34, 31, JSHTMLButtonElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLButtonElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLButtonElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLButtonElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLButtonElementConstructorTableValues, 0 };
#endif

class JSHTMLButtonElementConstructor : public DOMConstructorObject {
public:
    JSHTMLButtonElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLButtonElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLButtonElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLButtonElementConstructor::s_info = { "HTMLButtonElementConstructor", 0, &JSHTMLButtonElementConstructorTable, 0 };

bool JSHTMLButtonElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLButtonElementConstructor, DOMObject>(exec, &JSHTMLButtonElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLButtonElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLButtonElementConstructor, DOMObject>(exec, &JSHTMLButtonElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLButtonElementPrototypeTableValues[4] =
{
    { "checkValidity", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsHTMLButtonElementPrototypeFunctionCheckValidity), (intptr_t)0 },
    { "setCustomValidity", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsHTMLButtonElementPrototypeFunctionSetCustomValidity), (intptr_t)1 },
    { "click", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsHTMLButtonElementPrototypeFunctionClick), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLButtonElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLButtonElementPrototypeTableValues, 0 };
#else
    { 8, 7, JSHTMLButtonElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLButtonElementPrototype::s_info = { "HTMLButtonElementPrototype", 0, &JSHTMLButtonElementPrototypeTable, 0 };

JSObject* JSHTMLButtonElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLButtonElement>(exec, globalObject);
}

bool JSHTMLButtonElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLButtonElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLButtonElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLButtonElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLButtonElement::s_info = { "HTMLButtonElement", &JSHTMLElement::s_info, &JSHTMLButtonElementTable, 0 };

JSHTMLButtonElement::JSHTMLButtonElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLButtonElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLButtonElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLButtonElementPrototype(JSHTMLButtonElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLButtonElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLButtonElement, Base>(exec, &JSHTMLButtonElementTable, this, propertyName, slot);
}

bool JSHTMLButtonElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLButtonElement, Base>(exec, &JSHTMLButtonElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLButtonElementForm(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}

JSValue jsHTMLButtonElementFormNoValidate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->formNoValidate());
    return result;
}

JSValue jsHTMLButtonElementValidity(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->validity()));
    return result;
}

JSValue jsHTMLButtonElementAccessKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->accessKey());
    return result;
}

JSValue jsHTMLButtonElementDisabled(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->disabled());
    return result;
}

JSValue jsHTMLButtonElementAutofocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->autofocus());
    return result;
}

JSValue jsHTMLButtonElementName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}

JSValue jsHTMLButtonElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

JSValue jsHTMLButtonElementValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->value());
    return result;
}

JSValue jsHTMLButtonElementWillValidate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->willValidate());
    return result;
}

JSValue jsHTMLButtonElementValidationMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* castedThis = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->validationMessage());
    return result;
}

JSValue jsHTMLButtonElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLButtonElement* domObject = static_cast<JSHTMLButtonElement*>(asObject(slotBase));
    return JSHTMLButtonElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLButtonElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLButtonElement, Base>(exec, propertyName, value, &JSHTMLButtonElementTable, this, slot);
}

void setJSHTMLButtonElementFormNoValidate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    imp->setFormNoValidate(value.toBoolean(exec));
}

void setJSHTMLButtonElementAccessKey(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    imp->setAccessKey(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLButtonElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    imp->setDisabled(value.toBoolean(exec));
}

void setJSHTMLButtonElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    imp->setAutofocus(value.toBoolean(exec));
}

void setJSHTMLButtonElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLButtonElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLButtonElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLButtonElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionCheckValidity(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLButtonElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(asObject(thisValue));
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->checkValidity());
    return result;
}

JSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionSetCustomValidity(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLButtonElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(asObject(thisValue));
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());
    const UString& error = valueToStringWithUndefinedOrNullCheck(exec, args.at(0));

    imp->setCustomValidity(error);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionClick(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLButtonElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(asObject(thisValue));
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());

    imp->click();
    return jsUndefined();
}


}
