/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.SubstituteLoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.impl.StaticLoggerBinder;

public final class LoggerFactory {
    static ILoggerFactory loggerFactory;
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    private static final String[] API_COMPATIBILITY_LIST;

    private LoggerFactory() {
    }

    private static final void staticInitialize() {
        try {
            ArrayList loggerNameList = new ArrayList();
            loggerFactory = new SubstituteLoggerFactory(loggerNameList);
            loggerFactory = StaticLoggerBinder.SINGLETON.getLoggerFactory();
            LoggerFactory.emitSubstitureLoggerWarning(loggerNameList);
        }
        catch (NoClassDefFoundError ncde) {
            loggerFactory = null;
            String msg = ncde.getMessage();
            if (msg != null && msg.indexOf("org/slf4j/impl/StaticLoggerBinder") != -1) {
                Util.reportFailure("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.reportFailure("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            throw ncde;
        }
        catch (Exception e) {
            loggerFactory = null;
            Util.reportFailure("Failed to instantiate logger [" + StaticLoggerBinder.SINGLETON.getLoggerFactoryClassStr() + "]", e);
        }
    }

    private static final void emitSubstitureLoggerWarning(List loggerNameList) {
        if (loggerNameList.size() == 0) {
            return;
        }
        Util.reportFailure("The following loggers will not work becasue they were created");
        Util.reportFailure("during the default configuration phase of the underlying logging system.");
        Util.reportFailure("See also http://www.slf4j.org/codes.html#substituteLogger");
        for (int i = 0; i < loggerNameList.size(); ++i) {
            String loggerName = (String)loggerNameList.get(i);
            Util.reportFailure(loggerName);
        }
    }

    private static final void versionSanityCheck() {
        try {
            String requested = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean match = false;
            for (int i = 0; i < API_COMPATIBILITY_LIST.length; ++i) {
                if (!API_COMPATIBILITY_LIST[i].equals(requested)) continue;
                match = true;
            }
            if (!match) {
                Util.reportFailure("The requested version " + requested + " by your slf4j binding is not compatible with " + Arrays.toString(API_COMPATIBILITY_LIST));
                Util.reportFailure("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError nsfe) {
        }
        catch (Throwable e) {
            Util.reportFailure("Unexpected problem occured during version sanity check", e);
        }
    }

    public static Logger getLogger(String name) {
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
        }
        return loggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
        }
        return loggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        return loggerFactory;
    }

    static {
        API_COMPATIBILITY_LIST = new String[]{"1.5.5"};
        LoggerFactory.staticInitialize();
        LoggerFactory.versionSanityCheck();
    }
}

