.TH xcam 1 "11 April 2005"
.IX xcam
.SH NAME
xcam - a graphical camera frontend for SANE
.SH SYNOPSIS
.B xcam
.RB [ --buffer | -B  ]
.RB [ --version | -V ]
.RB [ --help | -h ]

.SH DESCRIPTION
.B xcam
provides a graphical user-interface to control an image
acquisition device such as a flatbed scanner or a camera.  It allows
scanning invidual images and can be invoked directly from the command-line.

.B xcam
acts as a stand-alone program that saves acquired images in a suitable
PNM format (PBM for black-and-white images, PGM for grayscale images,
and PPM for color images).

.B xcam
accesses image acquisition devices through the SANE (Scanner Access
Now Easy) interface.  The list of available devices depends on
installed hardware and configuration.

.B xcam
presents a menu listing of all known and available devices.

.SH OPTIONS
.PP
If the
.B --Buffer (-B)
option is given,
.B xcam 
will use a 1024 kByte input buffer instead of the default 32 kByte.
.PP
If the
.B --version (-V)
option is given, 
.B xcam
will output its version number.
.PP
The
.B --help (-h)
.B xcam
flag prints a short summary of options.
.PP
.TP
.B SANE_DEBUG_XCAM
This environment variable controls the debug level xscanimage.  Higher
debug levels increase the verbosity of the output.

              Value  Descsription
              0      print fatal errors
              1      print errors
              2      print warnings
              3      print information messages
              4      print everything

              Example:
              SANE_DEBUG_XCAM=3

.SH FILES
.TP
.I $HOME/.sane/xcam/devicename.rc
For each device, there is one rc-file that holds the saved settings
for that particular device.  Normally, this file should not be
manipulated directly.  Instead, the user should use the
.B xcam
interface to select appropriate values and then save the device
settings using the "Preferences->Save as default settings" menubar entry.

.SH "SEE ALSO"
sane(7), xscanimage(1), scanimage(1), sane\-dll(5) and the backend manpages
.SH AUTHOR
David Mosberger-Tang 

Gerard Klaver (2005 update)
