/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                          ValaBinaryOperator value);
static void vala_binary_expression_set_left (ValaBinaryExpression* self,
                                      ValaExpression* value);
static void vala_binary_expression_set_right (ValaBinaryExpression* self,
                                       ValaExpression* value);
static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);
static GType vala_binary_expression_get_type_once (void);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_operator;
	return result;
}

static void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp367_ = FALSE;
	gboolean _tmp368_ = FALSE;
	ValaDataType* _tmp369_;
	ValaDataType* _tmp370_;
	ValaExpression* _tmp407_;
	ValaExpression* _tmp408_;
	gboolean _tmp409_ = FALSE;
	gboolean _tmp410_ = FALSE;
	ValaExpression* _tmp411_;
	ValaExpression* _tmp412_;
	ValaDataType* _tmp413_;
	ValaDataType* _tmp414_;
	ValaExpression* _tmp432_;
	ValaExpression* _tmp433_;
	gboolean _tmp434_ = FALSE;
	gboolean _tmp435_ = FALSE;
	ValaExpression* _tmp436_;
	ValaExpression* _tmp437_;
	ValaDataType* _tmp438_;
	ValaDataType* _tmp439_;
	gboolean _tmp457_ = FALSE;
	ValaExpression* _tmp458_;
	ValaExpression* _tmp459_;
	ValaExpression* _tmp462_;
	ValaExpression* _tmp463_;
	ValaDataType* _tmp464_;
	ValaDataType* _tmp465_;
	gboolean _tmp470_ = FALSE;
	ValaBinaryOperator _tmp471_;
	gboolean _tmp480_ = FALSE;
	ValaExpression* _tmp481_;
	ValaExpression* _tmp482_;
	ValaDataType* _tmp483_;
	ValaDataType* _tmp484_;
	gboolean _tmp499_ = FALSE;
	ValaExpression* _tmp500_;
	ValaExpression* _tmp501_;
	ValaDataType* _tmp502_;
	ValaDataType* _tmp503_;
	ValaExpression* _tmp518_;
	ValaExpression* _tmp519_;
	ValaExpression* _tmp520_;
	ValaExpression* _tmp521_;
	ValaDataType* _tmp522_;
	ValaDataType* _tmp523_;
	ValaDataType* _tmp524_;
	ValaDataType* _tmp525_;
	ValaExpression* _tmp526_;
	ValaExpression* _tmp527_;
	ValaDataType* _tmp528_;
	ValaDataType* _tmp529_;
	ValaExpression* _tmp530_;
	ValaExpression* _tmp531_;
	ValaExpression* _tmp532_;
	ValaExpression* _tmp533_;
	ValaDataType* _tmp534_;
	ValaDataType* _tmp535_;
	ValaDataType* _tmp536_;
	ValaDataType* _tmp537_;
	ValaExpression* _tmp538_;
	ValaExpression* _tmp539_;
	ValaDataType* _tmp540_;
	ValaDataType* _tmp541_;
	gboolean _tmp542_ = FALSE;
	gboolean _tmp543_ = FALSE;
	ValaBinaryOperator _tmp544_;
	ValaBinaryOperator _tmp639_;
	ValaDataType* _tmp1206_;
	ValaDataType* _tmp1207_;
	gboolean _tmp1208_;
	gboolean _tmp1209_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaExpression* _tmp141_;
		ValaExpression* _tmp142_;
		gchar* temp_name = NULL;
		gchar* _tmp143_;
		ValaLocalVariable* right_local = NULL;
		const gchar* _tmp144_;
		ValaExpression* _tmp145_;
		ValaExpression* _tmp146_;
		ValaExpression* _tmp147_;
		ValaExpression* _tmp148_;
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaLocalVariable* _tmp151_;
		ValaDeclarationStatement* right_decl = NULL;
		ValaLocalVariable* _tmp152_;
		ValaExpression* _tmp153_;
		ValaExpression* _tmp154_;
		ValaSourceReference* _tmp155_;
		ValaSourceReference* _tmp156_;
		ValaDeclarationStatement* _tmp157_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaBlock* _tmp160_;
		ValaBlock* _tmp161_;
		ValaDeclarationStatement* _tmp162_;
		ValaBlock* _tmp163_;
		ValaLocalVariable* _tmp164_;
		ValaExpression* _tmp165_;
		ValaExpression* _tmp166_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp167_ = FALSE;
		ValaExpression* _tmp168_;
		ValaExpression* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		gboolean _tmp254_ = FALSE;
		gboolean _tmp255_ = FALSE;
		ValaDataType* _tmp256_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp268_;
		const gchar* _tmp269_;
		ValaExpression* _tmp270_;
		ValaExpression* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaLocalVariable* _tmp274_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp275_;
		ValaSourceReference* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaDeclarationStatement* _tmp278_;
		ValaSemanticAnalyzer* _tmp279_;
		ValaSemanticAnalyzer* _tmp280_;
		ValaBlock* _tmp281_;
		ValaDeclarationStatement* _tmp282_;
		ValaDeclarationStatement* _tmp283_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp284_;
		const gchar* _tmp285_;
		const gchar* _tmp286_;
		ValaExpression* _tmp287_;
		ValaExpression* _tmp288_;
		ValaSourceReference* _tmp289_;
		ValaSourceReference* _tmp290_;
		ValaMemberAccess* _tmp291_;
		ValaMemberAccess* _tmp292_;
		ValaExpression* _tmp293_;
		ValaExpression* _tmp294_;
		ValaExpression* _tmp295_;
		ValaExpression* _tmp296_;
		ValaSourceReference* _tmp297_;
		ValaSourceReference* _tmp298_;
		ValaAssignment* _tmp299_;
		ValaAssignment* _tmp300_;
		ValaExpression* _tmp301_;
		ValaExpression* _tmp302_;
		ValaSourceReference* _tmp303_;
		ValaSourceReference* _tmp304_;
		ValaExpressionStatement* _tmp305_;
		ValaExpressionStatement* _tmp306_;
		ValaBlock* _tmp307_;
		ValaLocalVariable* _tmp308_;
		ValaBlock* _tmp309_;
		ValaDeclarationStatement* _tmp310_;
		ValaExpressionStatement* _tmp311_;
		ValaExpressionStatement* _tmp312_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp313_;
		const gchar* _tmp314_;
		const gchar* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		ValaSourceReference* _tmp318_;
		ValaSourceReference* _tmp319_;
		ValaMemberAccess* _tmp320_;
		ValaMemberAccess* _tmp321_;
		ValaSourceReference* _tmp322_;
		ValaSourceReference* _tmp323_;
		ValaNullLiteral* _tmp324_;
		ValaNullLiteral* _tmp325_;
		ValaSourceReference* _tmp326_;
		ValaSourceReference* _tmp327_;
		ValaBinaryExpression* _tmp328_;
		ValaBinaryExpression* _tmp329_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp330_;
		ValaBlock* _tmp331_;
		ValaSourceReference* _tmp332_;
		ValaSourceReference* _tmp333_;
		ValaIfStatement* _tmp334_;
		ValaSemanticAnalyzer* _tmp335_;
		ValaSemanticAnalyzer* _tmp336_;
		ValaBlock* _tmp337_;
		ValaIfStatement* _tmp338_;
		ValaIfStatement* _tmp339_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp340_;
		ValaDataType* _tmp341_;
		ValaDataType* _tmp342_;
		ValaExpression* _tmp343_;
		gboolean _tmp344_ = FALSE;
		ValaCodeNode* _tmp363_;
		ValaCodeNode* _tmp364_;
		ValaExpression* _tmp365_;
		ValaExpression* _tmp366_;
		_tmp127_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp128_ = _tmp127_;
		if (_tmp128_ != NULL) {
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			ValaDataType* _tmp131_;
			ValaDataType* _tmp132_;
			ValaDataType* _tmp133_;
			ValaDataType* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			_tmp129_ = vala_binary_expression_get_left (self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_data_type_copy (_tmp132_);
			_tmp134_ = _tmp133_;
			vala_expression_set_target_type (_tmp130_, _tmp134_);
			_vala_code_node_unref0 (_tmp134_);
			_tmp135_ = vala_binary_expression_get_right (self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_data_type_copy (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_expression_set_target_type (_tmp136_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
		}
		_tmp141_ = vala_binary_expression_get_left (self);
		_tmp142_ = _tmp141_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp142_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp143_ = vala_code_node_get_temp_name ();
		temp_name = _tmp143_;
		_tmp144_ = temp_name;
		_tmp145_ = vala_binary_expression_get_right (self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_binary_expression_get_right (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_local_variable_new (NULL, _tmp144_, _tmp146_, _tmp150_);
		right_local = _tmp151_;
		_tmp152_ = right_local;
		_tmp153_ = vala_binary_expression_get_right (self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_declaration_statement_new ((ValaSymbol*) _tmp152_, _tmp156_);
		right_decl = _tmp157_;
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_block_new (_tmp159_);
		true_block = _tmp160_;
		_tmp161_ = true_block;
		_tmp162_ = right_decl;
		vala_block_add_statement (_tmp161_, (ValaStatement*) _tmp162_);
		_tmp163_ = true_block;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp163_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp164_ = right_local;
		_tmp165_ = vala_variable_get_initializer ((ValaVariable*) _tmp164_);
		_tmp166_ = _tmp165_;
		vala_binary_expression_set_right (self, _tmp166_);
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp168_ = vala_binary_expression_get_left (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_expression_get_value_type (_tmp169_);
		_tmp171_ = _tmp170_;
		if (VALA_IS_NULL_TYPE (_tmp171_)) {
			ValaExpression* _tmp172_;
			ValaExpression* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			_tmp172_ = vala_binary_expression_get_right (self);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_expression_get_value_type (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp167_ = _tmp175_ != NULL;
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSourceReference* _tmp178_;
			ValaSourceReference* _tmp179_;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaDataType* _tmp182_;
			ValaDataType* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			ValaExpression* _tmp186_;
			ValaExpression* _tmp187_;
			ValaDataType* _tmp188_;
			ValaDataType* _tmp189_;
			gboolean _tmp190_;
			gboolean _tmp191_;
			_tmp176_ = vala_binary_expression_get_left (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
			_tmp179_ = _tmp178_;
			vala_report_warning (_tmp179_, "left operand is always null");
			_tmp180_ = vala_binary_expression_get_right (self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_value_type (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_data_type_copy (_tmp183_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp184_;
			_tmp185_ = local_type;
			vala_data_type_set_nullable (_tmp185_, TRUE);
			_tmp186_ = vala_binary_expression_get_right (self);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_expression_get_value_type (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_data_type_get_nullable (_tmp189_);
			_tmp191_ = _tmp190_;
			if (!_tmp191_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp192_;
			ValaExpression* _tmp193_;
			ValaDataType* _tmp194_;
			ValaDataType* _tmp195_;
			_tmp192_ = vala_binary_expression_get_left (self);
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_expression_get_value_type (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_ != NULL) {
				ValaExpression* _tmp196_;
				ValaExpression* _tmp197_;
				ValaDataType* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				gboolean _tmp201_ = FALSE;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp196_ = vala_binary_expression_get_left (self);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_expression_get_value_type (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_data_type_copy (_tmp199_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp200_;
				_tmp202_ = vala_binary_expression_get_right (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				if (_tmp205_ != NULL) {
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					gboolean _tmp210_;
					gboolean _tmp211_;
					_tmp206_ = vala_binary_expression_get_right (self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_expression_get_value_type (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_data_type_get_value_owned (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp201_ = _tmp211_;
				} else {
					_tmp201_ = FALSE;
				}
				if (_tmp201_) {
					ValaDataType* _tmp212_;
					_tmp212_ = local_type;
					vala_data_type_set_value_owned (_tmp212_, TRUE);
				}
				_tmp213_ = vala_code_context_get_experimental_non_null (context);
				_tmp214_ = _tmp213_;
				if (_tmp214_) {
					ValaDataType* _tmp215_;
					gboolean _tmp216_;
					gboolean _tmp217_;
					_tmp215_ = local_type;
					_tmp216_ = vala_data_type_get_nullable (_tmp215_);
					_tmp217_ = _tmp216_;
					if (!_tmp217_) {
						ValaExpression* _tmp218_;
						ValaExpression* _tmp219_;
						ValaSourceReference* _tmp220_;
						ValaSourceReference* _tmp221_;
						gboolean _tmp222_ = FALSE;
						ValaExpression* _tmp223_;
						ValaExpression* _tmp224_;
						ValaDataType* _tmp225_;
						ValaDataType* _tmp226_;
						_tmp218_ = vala_binary_expression_get_left (self);
						_tmp219_ = _tmp218_;
						_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp219_);
						_tmp221_ = _tmp220_;
						vala_report_warning (_tmp221_, "left operand is never null");
						_tmp223_ = vala_binary_expression_get_right (self);
						_tmp224_ = _tmp223_;
						_tmp225_ = vala_expression_get_value_type (_tmp224_);
						_tmp226_ = _tmp225_;
						if (_tmp226_ != NULL) {
							ValaExpression* _tmp227_;
							ValaExpression* _tmp228_;
							ValaDataType* _tmp229_;
							ValaDataType* _tmp230_;
							gboolean _tmp231_;
							gboolean _tmp232_;
							_tmp227_ = vala_binary_expression_get_right (self);
							_tmp228_ = _tmp227_;
							_tmp229_ = vala_expression_get_value_type (_tmp228_);
							_tmp230_ = _tmp229_;
							_tmp231_ = vala_data_type_get_nullable (_tmp230_);
							_tmp232_ = _tmp231_;
							_tmp222_ = _tmp232_;
						} else {
							_tmp222_ = FALSE;
						}
						if (_tmp222_) {
							ValaDataType* _tmp233_;
							_tmp233_ = local_type;
							vala_data_type_set_nullable (_tmp233_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp234_ = FALSE;
						ValaExpression* _tmp235_;
						ValaExpression* _tmp236_;
						ValaDataType* _tmp237_;
						ValaDataType* _tmp238_;
						_tmp235_ = vala_binary_expression_get_right (self);
						_tmp236_ = _tmp235_;
						_tmp237_ = vala_expression_get_value_type (_tmp236_);
						_tmp238_ = _tmp237_;
						if (_tmp238_ != NULL) {
							ValaExpression* _tmp239_;
							ValaExpression* _tmp240_;
							ValaDataType* _tmp241_;
							ValaDataType* _tmp242_;
							gboolean _tmp243_;
							gboolean _tmp244_;
							_tmp239_ = vala_binary_expression_get_right (self);
							_tmp240_ = _tmp239_;
							_tmp241_ = vala_expression_get_value_type (_tmp240_);
							_tmp242_ = _tmp241_;
							_tmp243_ = vala_data_type_get_nullable (_tmp242_);
							_tmp244_ = _tmp243_;
							_tmp234_ = !_tmp244_;
						} else {
							_tmp234_ = FALSE;
						}
						if (_tmp234_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp245_;
				ValaExpression* _tmp246_;
				ValaDataType* _tmp247_;
				ValaDataType* _tmp248_;
				_tmp245_ = vala_binary_expression_get_right (self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_expression_get_value_type (_tmp246_);
				_tmp248_ = _tmp247_;
				if (_tmp248_ != NULL) {
					ValaExpression* _tmp249_;
					ValaExpression* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					_tmp249_ = vala_binary_expression_get_right (self);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_expression_get_value_type (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_data_type_copy (_tmp252_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp253_;
				}
			}
		}
		_tmp256_ = local_type;
		if (_tmp256_ != NULL) {
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			ValaDataType* _tmp259_;
			ValaDataType* _tmp260_;
			_tmp257_ = vala_binary_expression_get_right (self);
			_tmp258_ = _tmp257_;
			_tmp259_ = vala_expression_get_value_type (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp255_ = VALA_IS_VALUE_TYPE (_tmp260_);
		} else {
			_tmp255_ = FALSE;
		}
		if (_tmp255_) {
			ValaExpression* _tmp261_;
			ValaExpression* _tmp262_;
			ValaDataType* _tmp263_;
			ValaDataType* _tmp264_;
			gboolean _tmp265_;
			gboolean _tmp266_;
			_tmp261_ = vala_binary_expression_get_right (self);
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_expression_get_value_type (_tmp262_);
			_tmp264_ = _tmp263_;
			_tmp265_ = vala_data_type_get_nullable (_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp254_ = !_tmp266_;
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			ValaDataType* _tmp267_;
			_tmp267_ = local_type;
			vala_data_type_set_value_owned (_tmp267_, TRUE);
		}
		_tmp268_ = local_type;
		_tmp269_ = temp_name;
		_tmp270_ = vala_binary_expression_get_left (self);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_local_variable_new (_tmp268_, _tmp269_, _tmp271_, _tmp273_);
		local = _tmp274_;
		_tmp275_ = local;
		_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_declaration_statement_new ((ValaSymbol*) _tmp275_, _tmp277_);
		decl = _tmp278_;
		_tmp279_ = vala_code_context_get_analyzer (context);
		_tmp280_ = _tmp279_;
		_tmp281_ = _tmp280_->insert_block;
		_tmp282_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp281_, (ValaStatement*) _tmp282_);
		_tmp283_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp283_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp284_ = local;
		_tmp285_ = vala_symbol_get_name ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_binary_expression_get_right (self);
		_tmp288_ = _tmp287_;
		_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_member_access_new_simple (_tmp286_, _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp293_ = vala_binary_expression_get_right (self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_binary_expression_get_right (self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
		_tmp298_ = _tmp297_;
		_tmp299_ = vala_assignment_new ((ValaExpression*) _tmp292_, _tmp294_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp298_);
		_tmp300_ = _tmp299_;
		_tmp301_ = vala_binary_expression_get_right (self);
		_tmp302_ = _tmp301_;
		_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp302_);
		_tmp304_ = _tmp303_;
		_tmp305_ = vala_expression_statement_new ((ValaExpression*) _tmp300_, _tmp304_);
		_tmp306_ = _tmp305_;
		_vala_code_node_unref0 (_tmp300_);
		_vala_code_node_unref0 (_tmp292_);
		right_stmt = _tmp306_;
		_tmp307_ = true_block;
		_tmp308_ = right_local;
		vala_block_remove_local_variable (_tmp307_, _tmp308_);
		_tmp309_ = true_block;
		_tmp310_ = right_decl;
		_tmp311_ = right_stmt;
		vala_block_replace_statement (_tmp309_, (ValaStatement*) _tmp310_, (ValaStatement*) _tmp311_);
		_tmp312_ = right_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp312_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp313_ = local;
		_tmp314_ = vala_symbol_get_name ((ValaSymbol*) _tmp313_);
		_tmp315_ = _tmp314_;
		_tmp316_ = vala_binary_expression_get_left (self);
		_tmp317_ = _tmp316_;
		_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp320_ = vala_member_access_new_simple (_tmp315_, _tmp319_);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_null_literal_new (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp327_ = _tmp326_;
		_tmp328_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp321_, (ValaExpression*) _tmp325_, _tmp327_);
		_tmp329_ = _tmp328_;
		_vala_code_node_unref0 (_tmp325_);
		_vala_code_node_unref0 (_tmp321_);
		cond = _tmp329_;
		_tmp330_ = cond;
		_tmp331_ = true_block;
		_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_if_statement_new ((ValaExpression*) _tmp330_, _tmp331_, NULL, _tmp333_);
		if_stmt = _tmp334_;
		_tmp335_ = vala_code_context_get_analyzer (context);
		_tmp336_ = _tmp335_;
		_tmp337_ = _tmp336_->insert_block;
		_tmp338_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp337_, (ValaStatement*) _tmp338_);
		_tmp339_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp339_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp340_ = local;
		_tmp341_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp342_ = _tmp341_;
		_tmp343_ = vala_semantic_analyzer_create_temp_access (_tmp340_, _tmp342_);
		replace_expr = _tmp343_;
		if (cast_non_null) {
			ValaExpression* _tmp345_;
			ValaDataType* _tmp346_;
			ValaDataType* _tmp347_;
			_tmp345_ = replace_expr;
			_tmp346_ = vala_expression_get_target_type (_tmp345_);
			_tmp347_ = _tmp346_;
			_tmp344_ = _tmp347_ != NULL;
		} else {
			_tmp344_ = FALSE;
		}
		if (_tmp344_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp348_;
			ValaSourceReference* _tmp349_;
			ValaSourceReference* _tmp350_;
			ValaCastExpression* _tmp351_;
			ValaCastExpression* _tmp352_;
			ValaExpression* _tmp353_;
			ValaDataType* _tmp354_;
			ValaDataType* _tmp355_;
			ValaDataType* _tmp356_;
			ValaDataType* _tmp357_;
			ValaCastExpression* _tmp358_;
			ValaDataType* _tmp359_;
			ValaDataType* _tmp360_;
			ValaCastExpression* _tmp361_;
			ValaExpression* _tmp362_;
			_tmp348_ = replace_expr;
			_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_cast_expression_new_non_null (_tmp348_, _tmp350_);
			cast = _tmp351_;
			_tmp352_ = cast;
			_tmp353_ = replace_expr;
			_tmp354_ = vala_expression_get_target_type (_tmp353_);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_data_type_copy (_tmp355_);
			_tmp357_ = _tmp356_;
			vala_expression_set_target_type ((ValaExpression*) _tmp352_, _tmp357_);
			_vala_code_node_unref0 (_tmp357_);
			_tmp358_ = cast;
			_tmp359_ = vala_expression_get_target_type ((ValaExpression*) _tmp358_);
			_tmp360_ = _tmp359_;
			vala_data_type_set_nullable (_tmp360_, FALSE);
			_tmp361_ = cast;
			_tmp362_ = _vala_code_node_ref0 ((ValaExpression*) _tmp361_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp362_;
			_vala_code_node_unref0 (cast);
		}
		_tmp363_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp364_ = _tmp363_;
		_tmp365_ = replace_expr;
		vala_code_node_replace_expression (_tmp364_, (ValaExpression*) self, _tmp365_);
		_tmp366_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp366_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_decl);
		_vala_code_node_unref0 (right_local);
		_g_free0 (temp_name);
		return result;
	}
	_tmp369_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp370_ = _tmp369_;
	if (_tmp370_ != NULL) {
		ValaDataType* _tmp371_;
		ValaDataType* _tmp372_;
		ValaTypeSymbol* _tmp373_;
		ValaTypeSymbol* _tmp374_;
		_tmp371_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp372_ = _tmp371_;
		_tmp373_ = vala_data_type_get_type_symbol (_tmp372_);
		_tmp374_ = _tmp373_;
		_tmp368_ = VALA_IS_ENUM (_tmp374_);
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		gboolean _tmp375_ = FALSE;
		ValaBinaryOperator _tmp376_;
		_tmp376_ = self->priv->_operator;
		if (_tmp376_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp375_ = TRUE;
		} else {
			ValaBinaryOperator _tmp377_;
			_tmp377_ = self->priv->_operator;
			_tmp375_ = _tmp377_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp367_ = _tmp375_;
	} else {
		_tmp367_ = FALSE;
	}
	if (_tmp367_) {
		ValaExpression* _tmp378_;
		ValaExpression* _tmp379_;
		ValaDataType* _tmp380_;
		ValaDataType* _tmp381_;
		ValaDataType* _tmp382_;
		ValaDataType* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaDataType* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		_tmp378_ = vala_binary_expression_get_left (self);
		_tmp379_ = _tmp378_;
		_tmp380_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp381_ = _tmp380_;
		_tmp382_ = vala_data_type_copy (_tmp381_);
		_tmp383_ = _tmp382_;
		vala_expression_set_target_type (_tmp379_, _tmp383_);
		_vala_code_node_unref0 (_tmp383_);
		_tmp384_ = vala_binary_expression_get_right (self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_data_type_copy (_tmp387_);
		_tmp389_ = _tmp388_;
		vala_expression_set_target_type (_tmp385_, _tmp389_);
		_vala_code_node_unref0 (_tmp389_);
	} else {
		ValaBinaryOperator _tmp390_;
		_tmp390_ = self->priv->_operator;
		if (_tmp390_ == VALA_BINARY_OPERATOR_IN) {
			ValaExpression* _tmp391_;
			ValaExpression* _tmp392_;
			ValaExpression* _tmp393_;
			ValaExpression* _tmp394_;
			ValaDataType* _tmp395_;
			ValaDataType* _tmp396_;
			ValaTypeSymbol* _tmp397_;
			ValaTypeSymbol* _tmp398_;
			_tmp391_ = vala_binary_expression_get_right (self);
			_tmp392_ = _tmp391_;
			vala_code_node_check ((ValaCodeNode*) _tmp392_, context);
			_tmp393_ = vala_binary_expression_get_right (self);
			_tmp394_ = _tmp393_;
			_tmp395_ = vala_expression_get_value_type (_tmp394_);
			_tmp396_ = _tmp395_;
			_tmp397_ = vala_data_type_get_type_symbol (_tmp396_);
			_tmp398_ = _tmp397_;
			if (VALA_IS_ENUM (_tmp398_)) {
				ValaExpression* _tmp399_;
				ValaExpression* _tmp400_;
				ValaExpression* _tmp401_;
				ValaExpression* _tmp402_;
				ValaDataType* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				_tmp399_ = vala_binary_expression_get_left (self);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_binary_expression_get_right (self);
				_tmp402_ = _tmp401_;
				_tmp403_ = vala_expression_get_value_type (_tmp402_);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_data_type_copy (_tmp404_);
				_tmp406_ = _tmp405_;
				vala_expression_set_target_type (_tmp400_, _tmp406_);
				_vala_code_node_unref0 (_tmp406_);
			}
		}
	}
	_tmp407_ = vala_binary_expression_get_left (self);
	_tmp408_ = _tmp407_;
	vala_code_node_check ((ValaCodeNode*) _tmp408_, context);
	_tmp411_ = vala_binary_expression_get_left (self);
	_tmp412_ = _tmp411_;
	_tmp413_ = vala_expression_get_value_type (_tmp412_);
	_tmp414_ = _tmp413_;
	if (_tmp414_ != NULL) {
		ValaExpression* _tmp415_;
		ValaExpression* _tmp416_;
		ValaDataType* _tmp417_;
		ValaDataType* _tmp418_;
		ValaTypeSymbol* _tmp419_;
		ValaTypeSymbol* _tmp420_;
		_tmp415_ = vala_binary_expression_get_left (self);
		_tmp416_ = _tmp415_;
		_tmp417_ = vala_expression_get_value_type (_tmp416_);
		_tmp418_ = _tmp417_;
		_tmp419_ = vala_data_type_get_type_symbol (_tmp418_);
		_tmp420_ = _tmp419_;
		_tmp410_ = VALA_IS_ENUM (_tmp420_);
	} else {
		_tmp410_ = FALSE;
	}
	if (_tmp410_) {
		gboolean _tmp421_ = FALSE;
		ValaBinaryOperator _tmp422_;
		_tmp422_ = self->priv->_operator;
		if (_tmp422_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp421_ = TRUE;
		} else {
			ValaBinaryOperator _tmp423_;
			_tmp423_ = self->priv->_operator;
			_tmp421_ = _tmp423_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp409_ = _tmp421_;
	} else {
		_tmp409_ = FALSE;
	}
	if (_tmp409_) {
		ValaExpression* _tmp424_;
		ValaExpression* _tmp425_;
		ValaExpression* _tmp426_;
		ValaExpression* _tmp427_;
		ValaDataType* _tmp428_;
		ValaDataType* _tmp429_;
		ValaDataType* _tmp430_;
		ValaDataType* _tmp431_;
		_tmp424_ = vala_binary_expression_get_right (self);
		_tmp425_ = _tmp424_;
		_tmp426_ = vala_binary_expression_get_left (self);
		_tmp427_ = _tmp426_;
		_tmp428_ = vala_expression_get_value_type (_tmp427_);
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_data_type_copy (_tmp429_);
		_tmp431_ = _tmp430_;
		vala_expression_set_target_type (_tmp425_, _tmp431_);
		_vala_code_node_unref0 (_tmp431_);
	}
	_tmp432_ = vala_binary_expression_get_right (self);
	_tmp433_ = _tmp432_;
	vala_code_node_check ((ValaCodeNode*) _tmp433_, context);
	_tmp436_ = vala_binary_expression_get_right (self);
	_tmp437_ = _tmp436_;
	_tmp438_ = vala_expression_get_value_type (_tmp437_);
	_tmp439_ = _tmp438_;
	if (_tmp439_ != NULL) {
		ValaExpression* _tmp440_;
		ValaExpression* _tmp441_;
		ValaDataType* _tmp442_;
		ValaDataType* _tmp443_;
		ValaTypeSymbol* _tmp444_;
		ValaTypeSymbol* _tmp445_;
		_tmp440_ = vala_binary_expression_get_right (self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_expression_get_value_type (_tmp441_);
		_tmp443_ = _tmp442_;
		_tmp444_ = vala_data_type_get_type_symbol (_tmp443_);
		_tmp445_ = _tmp444_;
		_tmp435_ = VALA_IS_ENUM (_tmp445_);
	} else {
		_tmp435_ = FALSE;
	}
	if (_tmp435_) {
		gboolean _tmp446_ = FALSE;
		ValaBinaryOperator _tmp447_;
		_tmp447_ = self->priv->_operator;
		if (_tmp447_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp446_ = TRUE;
		} else {
			ValaBinaryOperator _tmp448_;
			_tmp448_ = self->priv->_operator;
			_tmp446_ = _tmp448_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp434_ = _tmp446_;
	} else {
		_tmp434_ = FALSE;
	}
	if (_tmp434_) {
		ValaExpression* _tmp449_;
		ValaExpression* _tmp450_;
		ValaExpression* _tmp451_;
		ValaExpression* _tmp452_;
		ValaDataType* _tmp453_;
		ValaDataType* _tmp454_;
		ValaDataType* _tmp455_;
		ValaDataType* _tmp456_;
		_tmp449_ = vala_binary_expression_get_left (self);
		_tmp450_ = _tmp449_;
		_tmp451_ = vala_binary_expression_get_right (self);
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_expression_get_value_type (_tmp452_);
		_tmp454_ = _tmp453_;
		_tmp455_ = vala_data_type_copy (_tmp454_);
		_tmp456_ = _tmp455_;
		vala_expression_set_target_type (_tmp450_, _tmp456_);
		_vala_code_node_unref0 (_tmp456_);
	}
	_tmp458_ = vala_binary_expression_get_left (self);
	_tmp459_ = _tmp458_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp459_, context)) {
		_tmp457_ = TRUE;
	} else {
		ValaExpression* _tmp460_;
		ValaExpression* _tmp461_;
		_tmp460_ = vala_binary_expression_get_right (self);
		_tmp461_ = _tmp460_;
		_tmp457_ = !vala_code_node_check ((ValaCodeNode*) _tmp461_, context);
	}
	if (_tmp457_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp462_ = vala_binary_expression_get_left (self);
	_tmp463_ = _tmp462_;
	_tmp464_ = vala_expression_get_value_type (_tmp463_);
	_tmp465_ = _tmp464_;
	if (_tmp465_ == NULL) {
		ValaExpression* _tmp466_;
		ValaExpression* _tmp467_;
		ValaSourceReference* _tmp468_;
		ValaSourceReference* _tmp469_;
		_tmp466_ = vala_binary_expression_get_left (self);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
		_tmp469_ = _tmp468_;
		vala_report_error (_tmp469_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp471_ = self->priv->_operator;
	if (_tmp471_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp472_;
		ValaExpression* _tmp473_;
		ValaDataType* _tmp474_;
		ValaDataType* _tmp475_;
		_tmp472_ = vala_binary_expression_get_right (self);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_expression_get_value_type (_tmp473_);
		_tmp475_ = _tmp474_;
		_tmp470_ = _tmp475_ == NULL;
	} else {
		_tmp470_ = FALSE;
	}
	if (_tmp470_) {
		ValaExpression* _tmp476_;
		ValaExpression* _tmp477_;
		ValaSourceReference* _tmp478_;
		ValaSourceReference* _tmp479_;
		_tmp476_ = vala_binary_expression_get_right (self);
		_tmp477_ = _tmp476_;
		_tmp478_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp477_);
		_tmp479_ = _tmp478_;
		vala_report_error (_tmp479_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp481_ = vala_binary_expression_get_left (self);
	_tmp482_ = _tmp481_;
	_tmp483_ = vala_expression_get_value_type (_tmp482_);
	_tmp484_ = _tmp483_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp484_)) {
		_tmp480_ = TRUE;
	} else {
		ValaExpression* _tmp485_;
		ValaExpression* _tmp486_;
		ValaDataType* _tmp487_;
		ValaDataType* _tmp488_;
		_tmp485_ = vala_binary_expression_get_left (self);
		_tmp486_ = _tmp485_;
		_tmp487_ = vala_expression_get_value_type (_tmp486_);
		_tmp488_ = _tmp487_;
		_tmp480_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp488_);
	}
	if (_tmp480_) {
		ValaExpression* _tmp489_;
		ValaExpression* _tmp490_;
		ValaSourceReference* _tmp491_;
		ValaSourceReference* _tmp492_;
		ValaExpression* _tmp493_;
		ValaExpression* _tmp494_;
		ValaSymbol* _tmp495_;
		ValaSymbol* _tmp496_;
		gchar* _tmp497_;
		gchar* _tmp498_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp489_ = vala_binary_expression_get_left (self);
		_tmp490_ = _tmp489_;
		_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_binary_expression_get_left (self);
		_tmp494_ = _tmp493_;
		_tmp495_ = vala_expression_get_symbol_reference (_tmp494_);
		_tmp496_ = _tmp495_;
		_tmp497_ = vala_symbol_get_full_name (_tmp496_);
		_tmp498_ = _tmp497_;
		vala_report_error (_tmp492_, "Access to instance member `%s' denied", _tmp498_);
		_g_free0 (_tmp498_);
		result = FALSE;
		return result;
	}
	_tmp500_ = vala_binary_expression_get_right (self);
	_tmp501_ = _tmp500_;
	_tmp502_ = vala_expression_get_value_type (_tmp501_);
	_tmp503_ = _tmp502_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp503_)) {
		_tmp499_ = TRUE;
	} else {
		ValaExpression* _tmp504_;
		ValaExpression* _tmp505_;
		ValaDataType* _tmp506_;
		ValaDataType* _tmp507_;
		_tmp504_ = vala_binary_expression_get_right (self);
		_tmp505_ = _tmp504_;
		_tmp506_ = vala_expression_get_value_type (_tmp505_);
		_tmp507_ = _tmp506_;
		_tmp499_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp507_);
	}
	if (_tmp499_) {
		ValaExpression* _tmp508_;
		ValaExpression* _tmp509_;
		ValaSourceReference* _tmp510_;
		ValaSourceReference* _tmp511_;
		ValaExpression* _tmp512_;
		ValaExpression* _tmp513_;
		ValaSymbol* _tmp514_;
		ValaSymbol* _tmp515_;
		gchar* _tmp516_;
		gchar* _tmp517_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp508_ = vala_binary_expression_get_right (self);
		_tmp509_ = _tmp508_;
		_tmp510_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp509_);
		_tmp511_ = _tmp510_;
		_tmp512_ = vala_binary_expression_get_right (self);
		_tmp513_ = _tmp512_;
		_tmp514_ = vala_expression_get_symbol_reference (_tmp513_);
		_tmp515_ = _tmp514_;
		_tmp516_ = vala_symbol_get_full_name (_tmp515_);
		_tmp517_ = _tmp516_;
		vala_report_error (_tmp511_, "Access to instance member `%s' denied", _tmp517_);
		_g_free0 (_tmp517_);
		result = FALSE;
		return result;
	}
	_tmp518_ = vala_binary_expression_get_left (self);
	_tmp519_ = _tmp518_;
	_tmp520_ = vala_binary_expression_get_left (self);
	_tmp521_ = _tmp520_;
	_tmp522_ = vala_expression_get_value_type (_tmp521_);
	_tmp523_ = _tmp522_;
	_tmp524_ = vala_data_type_copy (_tmp523_);
	_tmp525_ = _tmp524_;
	vala_expression_set_target_type (_tmp519_, _tmp525_);
	_vala_code_node_unref0 (_tmp525_);
	_tmp526_ = vala_binary_expression_get_left (self);
	_tmp527_ = _tmp526_;
	_tmp528_ = vala_expression_get_target_type (_tmp527_);
	_tmp529_ = _tmp528_;
	vala_data_type_set_value_owned (_tmp529_, FALSE);
	_tmp530_ = vala_binary_expression_get_right (self);
	_tmp531_ = _tmp530_;
	_tmp532_ = vala_binary_expression_get_right (self);
	_tmp533_ = _tmp532_;
	_tmp534_ = vala_expression_get_value_type (_tmp533_);
	_tmp535_ = _tmp534_;
	_tmp536_ = vala_data_type_copy (_tmp535_);
	_tmp537_ = _tmp536_;
	vala_expression_set_target_type (_tmp531_, _tmp537_);
	_vala_code_node_unref0 (_tmp537_);
	_tmp538_ = vala_binary_expression_get_right (self);
	_tmp539_ = _tmp538_;
	_tmp540_ = vala_expression_get_target_type (_tmp539_);
	_tmp541_ = _tmp540_;
	vala_data_type_set_value_owned (_tmp541_, FALSE);
	_tmp544_ = self->priv->_operator;
	if (_tmp544_ == VALA_BINARY_OPERATOR_PLUS) {
		ValaExpression* _tmp545_;
		ValaExpression* _tmp546_;
		ValaDataType* _tmp547_;
		ValaDataType* _tmp548_;
		_tmp545_ = vala_binary_expression_get_left (self);
		_tmp546_ = _tmp545_;
		_tmp547_ = vala_expression_get_value_type (_tmp546_);
		_tmp548_ = _tmp547_;
		_tmp543_ = !VALA_IS_POINTER_TYPE (_tmp548_);
	} else {
		_tmp543_ = FALSE;
	}
	if (_tmp543_) {
		ValaExpression* _tmp549_;
		ValaExpression* _tmp550_;
		ValaDataType* _tmp551_;
		ValaDataType* _tmp552_;
		ValaSemanticAnalyzer* _tmp553_;
		ValaSemanticAnalyzer* _tmp554_;
		ValaDataType* _tmp555_;
		_tmp549_ = vala_binary_expression_get_left (self);
		_tmp550_ = _tmp549_;
		_tmp551_ = vala_expression_get_value_type (_tmp550_);
		_tmp552_ = _tmp551_;
		_tmp553_ = vala_code_context_get_analyzer (context);
		_tmp554_ = _tmp553_;
		_tmp555_ = _tmp554_->string_type;
		_tmp542_ = vala_data_type_compatible (_tmp552_, _tmp555_);
	} else {
		_tmp542_ = FALSE;
	}
	if (_tmp542_) {
		gboolean _tmp556_ = FALSE;
		gboolean _tmp557_ = FALSE;
		gboolean _tmp558_ = FALSE;
		ValaExpression* _tmp559_;
		ValaExpression* _tmp560_;
		ValaDataType* _tmp561_;
		ValaDataType* _tmp562_;
		ValaSemanticAnalyzer* _tmp576_;
		ValaSemanticAnalyzer* _tmp577_;
		ValaDataType* _tmp578_;
		ValaDataType* _tmp579_;
		ValaDataType* _tmp580_;
		gboolean _tmp581_ = FALSE;
		ValaExpression* _tmp582_;
		ValaExpression* _tmp583_;
		ValaDataType* _tmp590_;
		ValaDataType* _tmp591_;
		gboolean _tmp592_;
		gboolean _tmp593_;
		_tmp559_ = vala_binary_expression_get_right (self);
		_tmp560_ = _tmp559_;
		_tmp561_ = vala_expression_get_value_type (_tmp560_);
		_tmp562_ = _tmp561_;
		if (_tmp562_ == NULL) {
			_tmp558_ = TRUE;
		} else {
			ValaExpression* _tmp563_;
			ValaExpression* _tmp564_;
			ValaDataType* _tmp565_;
			ValaDataType* _tmp566_;
			ValaSemanticAnalyzer* _tmp567_;
			ValaSemanticAnalyzer* _tmp568_;
			ValaDataType* _tmp569_;
			_tmp563_ = vala_binary_expression_get_right (self);
			_tmp564_ = _tmp563_;
			_tmp565_ = vala_expression_get_value_type (_tmp564_);
			_tmp566_ = _tmp565_;
			_tmp567_ = vala_code_context_get_analyzer (context);
			_tmp568_ = _tmp567_;
			_tmp569_ = _tmp568_->string_type;
			_tmp558_ = !vala_data_type_compatible (_tmp566_, _tmp569_);
		}
		if (_tmp558_) {
			_tmp557_ = TRUE;
		} else {
			ValaExpression* _tmp570_;
			ValaExpression* _tmp571_;
			_tmp570_ = vala_binary_expression_get_left (self);
			_tmp571_ = _tmp570_;
			_tmp557_ = VALA_IS_NULL_LITERAL (_tmp571_);
		}
		if (_tmp557_) {
			_tmp556_ = TRUE;
		} else {
			ValaExpression* _tmp572_;
			ValaExpression* _tmp573_;
			_tmp572_ = vala_binary_expression_get_right (self);
			_tmp573_ = _tmp572_;
			_tmp556_ = VALA_IS_NULL_LITERAL (_tmp573_);
		}
		if (_tmp556_) {
			ValaSourceReference* _tmp574_;
			ValaSourceReference* _tmp575_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp574_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp575_ = _tmp574_;
			vala_report_error (_tmp575_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp576_ = vala_code_context_get_analyzer (context);
		_tmp577_ = _tmp576_;
		_tmp578_ = _tmp577_->string_type;
		_tmp579_ = vala_data_type_copy (_tmp578_);
		_tmp580_ = _tmp579_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp580_);
		_vala_code_node_unref0 (_tmp580_);
		_tmp582_ = vala_binary_expression_get_left (self);
		_tmp583_ = _tmp582_;
		if (vala_expression_is_constant (_tmp583_)) {
			ValaExpression* _tmp584_;
			ValaExpression* _tmp585_;
			_tmp584_ = vala_binary_expression_get_right (self);
			_tmp585_ = _tmp584_;
			_tmp581_ = vala_expression_is_constant (_tmp585_);
		} else {
			_tmp581_ = FALSE;
		}
		if (_tmp581_) {
			ValaDataType* _tmp586_;
			ValaDataType* _tmp587_;
			_tmp586_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp587_ = _tmp586_;
			vala_data_type_set_value_owned (_tmp587_, FALSE);
		} else {
			ValaDataType* _tmp588_;
			ValaDataType* _tmp589_;
			_tmp588_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp589_ = _tmp588_;
			vala_data_type_set_value_owned (_tmp589_, TRUE);
		}
		_tmp590_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp591_ = _tmp590_;
		vala_code_node_check ((ValaCodeNode*) _tmp591_, context);
		_tmp592_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp593_ = _tmp592_;
		result = !_tmp593_;
		return result;
	} else {
		gboolean _tmp594_ = FALSE;
		ValaBinaryOperator _tmp595_;
		_tmp595_ = self->priv->_operator;
		if (_tmp595_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp596_;
			ValaExpression* _tmp597_;
			ValaDataType* _tmp598_;
			ValaDataType* _tmp599_;
			_tmp596_ = vala_binary_expression_get_left (self);
			_tmp597_ = _tmp596_;
			_tmp598_ = vala_expression_get_value_type (_tmp597_);
			_tmp599_ = _tmp598_;
			_tmp594_ = VALA_IS_ARRAY_TYPE (_tmp599_);
		} else {
			_tmp594_ = FALSE;
		}
		if (_tmp594_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp600_;
			ValaExpression* _tmp601_;
			ValaDataType* _tmp602_;
			ValaDataType* _tmp603_;
			ValaArrayType* _tmp604_;
			gboolean _tmp605_;
			gboolean _tmp606_;
			gboolean _tmp609_ = FALSE;
			ValaExpression* _tmp610_;
			ValaExpression* _tmp611_;
			ValaDataType* _tmp612_;
			ValaDataType* _tmp613_;
			ValaExpression* _tmp623_;
			ValaExpression* _tmp624_;
			ValaArrayType* _tmp625_;
			ValaDataType* _tmp626_;
			ValaDataType* _tmp627_;
			ValaDataType* _tmp628_;
			ValaDataType* _tmp629_;
			ValaArrayType* _tmp630_;
			ValaDataType* _tmp631_;
			ValaDataType* _tmp632_;
			ValaDataType* _tmp633_;
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			ValaDataType* _tmp636_;
			gboolean _tmp637_;
			gboolean _tmp638_;
			_tmp600_ = vala_binary_expression_get_left (self);
			_tmp601_ = _tmp600_;
			_tmp602_ = vala_expression_get_value_type (_tmp601_);
			_tmp603_ = _tmp602_;
			array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp603_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
			_tmp604_ = array_type;
			_tmp605_ = vala_array_type_get_inline_allocated (_tmp604_);
			_tmp606_ = _tmp605_;
			if (_tmp606_) {
				ValaSourceReference* _tmp607_;
				ValaSourceReference* _tmp608_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp607_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp608_ = _tmp607_;
				vala_report_error (_tmp608_, "Array concatenation not supported for fixed length arrays");
			}
			_tmp610_ = vala_binary_expression_get_right (self);
			_tmp611_ = _tmp610_;
			_tmp612_ = vala_expression_get_value_type (_tmp611_);
			_tmp613_ = _tmp612_;
			if (_tmp613_ == NULL) {
				_tmp609_ = TRUE;
			} else {
				ValaExpression* _tmp614_;
				ValaExpression* _tmp615_;
				ValaDataType* _tmp616_;
				ValaDataType* _tmp617_;
				ValaArrayType* _tmp618_;
				ValaDataType* _tmp619_;
				ValaDataType* _tmp620_;
				_tmp614_ = vala_binary_expression_get_right (self);
				_tmp615_ = _tmp614_;
				_tmp616_ = vala_expression_get_value_type (_tmp615_);
				_tmp617_ = _tmp616_;
				_tmp618_ = array_type;
				_tmp619_ = vala_array_type_get_element_type (_tmp618_);
				_tmp620_ = _tmp619_;
				_tmp609_ = !vala_data_type_compatible (_tmp617_, _tmp620_);
			}
			if (_tmp609_) {
				ValaSourceReference* _tmp621_;
				ValaSourceReference* _tmp622_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp621_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp622_ = _tmp621_;
				vala_report_error (_tmp622_, "Incompatible operand");
				result = FALSE;
				return result;
			}
			_tmp623_ = vala_binary_expression_get_right (self);
			_tmp624_ = _tmp623_;
			_tmp625_ = array_type;
			_tmp626_ = vala_array_type_get_element_type (_tmp625_);
			_tmp627_ = _tmp626_;
			_tmp628_ = vala_data_type_copy (_tmp627_);
			_tmp629_ = _tmp628_;
			vala_expression_set_target_type (_tmp624_, _tmp629_);
			_vala_code_node_unref0 (_tmp629_);
			_tmp630_ = array_type;
			_tmp631_ = vala_data_type_copy ((ValaDataType*) _tmp630_);
			_tmp632_ = _tmp631_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp632_);
			_vala_code_node_unref0 (_tmp632_);
			_tmp633_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp634_ = _tmp633_;
			vala_data_type_set_value_owned (_tmp634_, TRUE);
			_tmp635_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp636_ = _tmp635_;
			vala_code_node_check ((ValaCodeNode*) _tmp636_, context);
			_tmp637_ = vala_code_node_get_error ((ValaCodeNode*) self);
			_tmp638_ = _tmp637_;
			result = !_tmp638_;
			return result;
		}
	}
	_tmp639_ = self->priv->_operator;
	switch (_tmp639_) {
		case VALA_BINARY_OPERATOR_PLUS:
		case VALA_BINARY_OPERATOR_MINUS:
		case VALA_BINARY_OPERATOR_MUL:
		case VALA_BINARY_OPERATOR_DIV:
		{
			ValaExpression* _tmp640_;
			ValaExpression* _tmp641_;
			ValaDataType* _tmp642_;
			ValaDataType* _tmp643_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			ValaDataType* _tmp699_;
			ValaDataType* _tmp700_;
			_tmp640_ = vala_binary_expression_get_left (self);
			_tmp641_ = _tmp640_;
			_tmp642_ = vala_expression_get_value_type (_tmp641_);
			_tmp643_ = _tmp642_;
			if (VALA_IS_POINTER_TYPE (_tmp643_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp644_;
				ValaExpression* _tmp645_;
				ValaDataType* _tmp646_;
				ValaDataType* _tmp647_;
				ValaPointerType* _tmp648_;
				ValaDataType* _tmp649_;
				ValaDataType* _tmp650_;
				ValaStruct* offset_type = NULL;
				ValaExpression* _tmp653_;
				ValaExpression* _tmp654_;
				ValaDataType* _tmp655_;
				ValaDataType* _tmp656_;
				ValaTypeSymbol* _tmp657_;
				ValaTypeSymbol* _tmp658_;
				gboolean _tmp659_ = FALSE;
				ValaStruct* _tmp660_;
				_tmp644_ = vala_binary_expression_get_left (self);
				_tmp645_ = _tmp644_;
				_tmp646_ = vala_expression_get_value_type (_tmp645_);
				_tmp647_ = _tmp646_;
				pointer_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp647_, VALA_TYPE_POINTER_TYPE, ValaPointerType);
				_tmp648_ = pointer_type;
				_tmp649_ = vala_pointer_type_get_base_type (_tmp648_);
				_tmp650_ = _tmp649_;
				if (VALA_IS_VOID_TYPE (_tmp650_)) {
					ValaSourceReference* _tmp651_;
					ValaSourceReference* _tmp652_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp651_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp652_ = _tmp651_;
					vala_report_error (_tmp652_, "Pointer arithmetic not supported for `void*'");
					result = FALSE;
					return result;
				}
				_tmp653_ = vala_binary_expression_get_right (self);
				_tmp654_ = _tmp653_;
				_tmp655_ = vala_expression_get_value_type (_tmp654_);
				_tmp656_ = _tmp655_;
				_tmp657_ = vala_data_type_get_type_symbol (_tmp656_);
				_tmp658_ = _tmp657_;
				offset_type = VALA_IS_STRUCT (_tmp658_) ? ((ValaStruct*) _tmp658_) : NULL;
				_tmp660_ = offset_type;
				if (_tmp660_ != NULL) {
					ValaStruct* _tmp661_;
					_tmp661_ = offset_type;
					_tmp659_ = vala_struct_is_integer_type (_tmp661_);
				} else {
					_tmp659_ = FALSE;
				}
				if (_tmp659_) {
					gboolean _tmp662_ = FALSE;
					ValaBinaryOperator _tmp663_;
					_tmp663_ = self->priv->_operator;
					if (_tmp663_ == VALA_BINARY_OPERATOR_PLUS) {
						_tmp662_ = TRUE;
					} else {
						ValaBinaryOperator _tmp664_;
						_tmp664_ = self->priv->_operator;
						_tmp662_ = _tmp664_ == VALA_BINARY_OPERATOR_MINUS;
					}
					if (_tmp662_) {
						ValaExpression* _tmp665_;
						ValaExpression* _tmp666_;
						ValaDataType* _tmp667_;
						ValaDataType* _tmp668_;
						ValaDataType* _tmp669_;
						ValaDataType* _tmp670_;
						_tmp665_ = vala_binary_expression_get_left (self);
						_tmp666_ = _tmp665_;
						_tmp667_ = vala_expression_get_value_type (_tmp666_);
						_tmp668_ = _tmp667_;
						_tmp669_ = vala_data_type_copy (_tmp668_);
						_tmp670_ = _tmp669_;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp670_);
						_vala_code_node_unref0 (_tmp670_);
					}
				} else {
					ValaExpression* _tmp671_;
					ValaExpression* _tmp672_;
					ValaDataType* _tmp673_;
					ValaDataType* _tmp674_;
					_tmp671_ = vala_binary_expression_get_right (self);
					_tmp672_ = _tmp671_;
					_tmp673_ = vala_expression_get_value_type (_tmp672_);
					_tmp674_ = _tmp673_;
					if (VALA_IS_POINTER_TYPE (_tmp674_)) {
						ValaSemanticAnalyzer* _tmp675_;
						ValaSemanticAnalyzer* _tmp676_;
						ValaDataType* _tmp677_;
						_tmp675_ = vala_code_context_get_analyzer (context);
						_tmp676_ = _tmp675_;
						_tmp677_ = _tmp676_->size_t_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp677_);
					}
				}
			} else {
				ValaExpression* _tmp678_;
				ValaExpression* _tmp679_;
				ValaDataType* _tmp680_;
				ValaDataType* _tmp681_;
				ValaExpression* _tmp682_;
				ValaExpression* _tmp683_;
				ValaDataType* _tmp684_;
				ValaDataType* _tmp685_;
				_tmp678_ = vala_binary_expression_get_left (self);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_expression_get_target_type (_tmp679_);
				_tmp681_ = _tmp680_;
				vala_data_type_set_nullable (_tmp681_, FALSE);
				_tmp682_ = vala_binary_expression_get_right (self);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_expression_get_target_type (_tmp683_);
				_tmp685_ = _tmp684_;
				vala_data_type_set_nullable (_tmp685_, FALSE);
			}
			_tmp686_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp687_ = _tmp686_;
			if (_tmp687_ == NULL) {
				ValaSemanticAnalyzer* _tmp688_;
				ValaSemanticAnalyzer* _tmp689_;
				ValaExpression* _tmp690_;
				ValaExpression* _tmp691_;
				ValaDataType* _tmp692_;
				ValaDataType* _tmp693_;
				ValaExpression* _tmp694_;
				ValaExpression* _tmp695_;
				ValaDataType* _tmp696_;
				ValaDataType* _tmp697_;
				ValaDataType* _tmp698_;
				_tmp688_ = vala_code_context_get_analyzer (context);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_binary_expression_get_left (self);
				_tmp691_ = _tmp690_;
				_tmp692_ = vala_expression_get_target_type (_tmp691_);
				_tmp693_ = _tmp692_;
				_tmp694_ = vala_binary_expression_get_right (self);
				_tmp695_ = _tmp694_;
				_tmp696_ = vala_expression_get_target_type (_tmp695_);
				_tmp697_ = _tmp696_;
				_tmp698_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp689_, _tmp693_, _tmp697_);
				vala_expression_set_value_type ((ValaExpression*) self, _tmp698_);
			}
			_tmp699_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp700_ = _tmp699_;
			if (_tmp700_ == NULL) {
				ValaSourceReference* _tmp701_;
				ValaSourceReference* _tmp702_;
				ValaExpression* _tmp703_;
				ValaExpression* _tmp704_;
				ValaDataType* _tmp705_;
				ValaDataType* _tmp706_;
				gchar* _tmp707_;
				gchar* _tmp708_;
				ValaExpression* _tmp709_;
				ValaExpression* _tmp710_;
				ValaDataType* _tmp711_;
				ValaDataType* _tmp712_;
				gchar* _tmp713_;
				gchar* _tmp714_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp701_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp702_ = _tmp701_;
				_tmp703_ = vala_binary_expression_get_left (self);
				_tmp704_ = _tmp703_;
				_tmp705_ = vala_expression_get_value_type (_tmp704_);
				_tmp706_ = _tmp705_;
				_tmp707_ = vala_code_node_to_string ((ValaCodeNode*) _tmp706_);
				_tmp708_ = _tmp707_;
				_tmp709_ = vala_binary_expression_get_right (self);
				_tmp710_ = _tmp709_;
				_tmp711_ = vala_expression_get_value_type (_tmp710_);
				_tmp712_ = _tmp711_;
				_tmp713_ = vala_code_node_to_string ((ValaCodeNode*) _tmp712_);
				_tmp714_ = _tmp713_;
				vala_report_error (_tmp702_, "Arithmetic operation not supported for types `%s' and `%s'", _tmp708_, _tmp714_);
				_g_free0 (_tmp714_);
				_g_free0 (_tmp708_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			ValaExpression* _tmp715_;
			ValaExpression* _tmp716_;
			ValaDataType* _tmp717_;
			ValaDataType* _tmp718_;
			ValaExpression* _tmp719_;
			ValaExpression* _tmp720_;
			ValaDataType* _tmp721_;
			ValaDataType* _tmp722_;
			ValaSemanticAnalyzer* _tmp723_;
			ValaSemanticAnalyzer* _tmp724_;
			ValaExpression* _tmp725_;
			ValaExpression* _tmp726_;
			ValaDataType* _tmp727_;
			ValaDataType* _tmp728_;
			ValaExpression* _tmp729_;
			ValaExpression* _tmp730_;
			ValaDataType* _tmp731_;
			ValaDataType* _tmp732_;
			ValaDataType* _tmp733_;
			ValaDataType* _tmp734_;
			ValaDataType* _tmp735_;
			_tmp715_ = vala_binary_expression_get_left (self);
			_tmp716_ = _tmp715_;
			_tmp717_ = vala_expression_get_target_type (_tmp716_);
			_tmp718_ = _tmp717_;
			vala_data_type_set_nullable (_tmp718_, FALSE);
			_tmp719_ = vala_binary_expression_get_right (self);
			_tmp720_ = _tmp719_;
			_tmp721_ = vala_expression_get_target_type (_tmp720_);
			_tmp722_ = _tmp721_;
			vala_data_type_set_nullable (_tmp722_, FALSE);
			_tmp723_ = vala_code_context_get_analyzer (context);
			_tmp724_ = _tmp723_;
			_tmp725_ = vala_binary_expression_get_left (self);
			_tmp726_ = _tmp725_;
			_tmp727_ = vala_expression_get_target_type (_tmp726_);
			_tmp728_ = _tmp727_;
			_tmp729_ = vala_binary_expression_get_right (self);
			_tmp730_ = _tmp729_;
			_tmp731_ = vala_expression_get_target_type (_tmp730_);
			_tmp732_ = _tmp731_;
			_tmp733_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp724_, _tmp728_, _tmp732_);
			vala_expression_set_value_type ((ValaExpression*) self, _tmp733_);
			_tmp734_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp735_ = _tmp734_;
			if (_tmp735_ == NULL) {
				ValaSourceReference* _tmp736_;
				ValaSourceReference* _tmp737_;
				ValaExpression* _tmp738_;
				ValaExpression* _tmp739_;
				ValaDataType* _tmp740_;
				ValaDataType* _tmp741_;
				gchar* _tmp742_;
				gchar* _tmp743_;
				ValaExpression* _tmp744_;
				ValaExpression* _tmp745_;
				ValaDataType* _tmp746_;
				ValaDataType* _tmp747_;
				gchar* _tmp748_;
				gchar* _tmp749_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp736_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp737_ = _tmp736_;
				_tmp738_ = vala_binary_expression_get_left (self);
				_tmp739_ = _tmp738_;
				_tmp740_ = vala_expression_get_value_type (_tmp739_);
				_tmp741_ = _tmp740_;
				_tmp742_ = vala_code_node_to_string ((ValaCodeNode*) _tmp741_);
				_tmp743_ = _tmp742_;
				_tmp744_ = vala_binary_expression_get_right (self);
				_tmp745_ = _tmp744_;
				_tmp746_ = vala_expression_get_value_type (_tmp745_);
				_tmp747_ = _tmp746_;
				_tmp748_ = vala_code_node_to_string ((ValaCodeNode*) _tmp747_);
				_tmp749_ = _tmp748_;
				vala_report_error (_tmp737_, "Arithmetic operation not supported for types `%s' and `%s'", _tmp743_, _tmp749_);
				_g_free0 (_tmp749_);
				_g_free0 (_tmp743_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			gboolean _tmp750_ = FALSE;
			ValaExpression* _tmp751_;
			ValaExpression* _tmp752_;
			ValaDataType* _tmp753_;
			ValaDataType* _tmp754_;
			ValaSemanticAnalyzer* _tmp755_;
			ValaSemanticAnalyzer* _tmp756_;
			ValaDataType* _tmp757_;
			ValaSemanticAnalyzer* _tmp837_;
			ValaSemanticAnalyzer* _tmp838_;
			ValaDataType* _tmp839_;
			_tmp751_ = vala_binary_expression_get_left (self);
			_tmp752_ = _tmp751_;
			_tmp753_ = vala_expression_get_value_type (_tmp752_);
			_tmp754_ = _tmp753_;
			_tmp755_ = vala_code_context_get_analyzer (context);
			_tmp756_ = _tmp755_;
			_tmp757_ = _tmp756_->string_type;
			if (vala_data_type_compatible (_tmp754_, _tmp757_)) {
				ValaExpression* _tmp758_;
				ValaExpression* _tmp759_;
				ValaDataType* _tmp760_;
				ValaDataType* _tmp761_;
				ValaSemanticAnalyzer* _tmp762_;
				ValaSemanticAnalyzer* _tmp763_;
				ValaDataType* _tmp764_;
				_tmp758_ = vala_binary_expression_get_right (self);
				_tmp759_ = _tmp758_;
				_tmp760_ = vala_expression_get_value_type (_tmp759_);
				_tmp761_ = _tmp760_;
				_tmp762_ = vala_code_context_get_analyzer (context);
				_tmp763_ = _tmp762_;
				_tmp764_ = _tmp763_->string_type;
				_tmp750_ = vala_data_type_compatible (_tmp761_, _tmp764_);
			} else {
				_tmp750_ = FALSE;
			}
			if (_tmp750_) {
			} else {
				gboolean _tmp765_ = FALSE;
				ValaExpression* _tmp766_;
				ValaExpression* _tmp767_;
				ValaDataType* _tmp768_;
				ValaDataType* _tmp769_;
				_tmp766_ = vala_binary_expression_get_left (self);
				_tmp767_ = _tmp766_;
				_tmp768_ = vala_expression_get_value_type (_tmp767_);
				_tmp769_ = _tmp768_;
				if (VALA_IS_POINTER_TYPE (_tmp769_)) {
					ValaExpression* _tmp770_;
					ValaExpression* _tmp771_;
					ValaDataType* _tmp772_;
					ValaDataType* _tmp773_;
					_tmp770_ = vala_binary_expression_get_right (self);
					_tmp771_ = _tmp770_;
					_tmp772_ = vala_expression_get_value_type (_tmp771_);
					_tmp773_ = _tmp772_;
					_tmp765_ = VALA_IS_POINTER_TYPE (_tmp773_);
				} else {
					_tmp765_ = FALSE;
				}
				if (_tmp765_) {
				} else {
					ValaDataType* resulting_type = NULL;
					gboolean _tmp774_;
					ValaDataType* _tmp803_;
					gboolean _tmp818_;
					ValaExpression* _tmp824_;
					ValaExpression* _tmp825_;
					ValaDataType* _tmp826_;
					ValaDataType* _tmp827_;
					ValaDataType* _tmp828_;
					ValaExpression* _tmp829_;
					ValaExpression* _tmp830_;
					ValaDataType* _tmp831_;
					ValaDataType* _tmp832_;
					ValaExpression* _tmp833_;
					ValaExpression* _tmp834_;
					ValaDataType* _tmp835_;
					ValaDataType* _tmp836_;
					_tmp774_ = self->priv->_is_chained;
					if (_tmp774_) {
						ValaBinaryExpression* lbe = NULL;
						ValaExpression* _tmp775_;
						ValaExpression* _tmp776_;
						ValaBinaryExpression* _tmp777_;
						ValaSemanticAnalyzer* _tmp778_;
						ValaSemanticAnalyzer* _tmp779_;
						ValaBinaryExpression* _tmp780_;
						ValaExpression* _tmp781_;
						ValaExpression* _tmp782_;
						ValaDataType* _tmp783_;
						ValaDataType* _tmp784_;
						ValaExpression* _tmp785_;
						ValaExpression* _tmp786_;
						ValaDataType* _tmp787_;
						ValaDataType* _tmp788_;
						ValaDataType* _tmp789_;
						ValaDataType* _tmp790_;
						_tmp775_ = vala_binary_expression_get_left (self);
						_tmp776_ = _tmp775_;
						_tmp777_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp776_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
						lbe = _tmp777_;
						_tmp778_ = vala_code_context_get_analyzer (context);
						_tmp779_ = _tmp778_;
						_tmp780_ = lbe;
						_tmp781_ = vala_binary_expression_get_right (_tmp780_);
						_tmp782_ = _tmp781_;
						_tmp783_ = vala_expression_get_target_type (_tmp782_);
						_tmp784_ = _tmp783_;
						_tmp785_ = vala_binary_expression_get_right (self);
						_tmp786_ = _tmp785_;
						_tmp787_ = vala_expression_get_target_type (_tmp786_);
						_tmp788_ = _tmp787_;
						_tmp789_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp779_, _tmp784_, _tmp788_);
						_tmp790_ = _vala_code_node_ref0 (_tmp789_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp790_;
						_vala_code_node_unref0 (lbe);
					} else {
						ValaSemanticAnalyzer* _tmp791_;
						ValaSemanticAnalyzer* _tmp792_;
						ValaExpression* _tmp793_;
						ValaExpression* _tmp794_;
						ValaDataType* _tmp795_;
						ValaDataType* _tmp796_;
						ValaExpression* _tmp797_;
						ValaExpression* _tmp798_;
						ValaDataType* _tmp799_;
						ValaDataType* _tmp800_;
						ValaDataType* _tmp801_;
						ValaDataType* _tmp802_;
						_tmp791_ = vala_code_context_get_analyzer (context);
						_tmp792_ = _tmp791_;
						_tmp793_ = vala_binary_expression_get_left (self);
						_tmp794_ = _tmp793_;
						_tmp795_ = vala_expression_get_target_type (_tmp794_);
						_tmp796_ = _tmp795_;
						_tmp797_ = vala_binary_expression_get_right (self);
						_tmp798_ = _tmp797_;
						_tmp799_ = vala_expression_get_target_type (_tmp798_);
						_tmp800_ = _tmp799_;
						_tmp801_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp792_, _tmp796_, _tmp800_);
						_tmp802_ = _vala_code_node_ref0 (_tmp801_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp802_;
					}
					_tmp803_ = resulting_type;
					if (_tmp803_ == NULL) {
						ValaSourceReference* _tmp804_;
						ValaSourceReference* _tmp805_;
						ValaExpression* _tmp806_;
						ValaExpression* _tmp807_;
						ValaDataType* _tmp808_;
						ValaDataType* _tmp809_;
						gchar* _tmp810_;
						gchar* _tmp811_;
						ValaExpression* _tmp812_;
						ValaExpression* _tmp813_;
						ValaDataType* _tmp814_;
						ValaDataType* _tmp815_;
						gchar* _tmp816_;
						gchar* _tmp817_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp804_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp805_ = _tmp804_;
						_tmp806_ = vala_binary_expression_get_left (self);
						_tmp807_ = _tmp806_;
						_tmp808_ = vala_expression_get_value_type (_tmp807_);
						_tmp809_ = _tmp808_;
						_tmp810_ = vala_code_node_to_string ((ValaCodeNode*) _tmp809_);
						_tmp811_ = _tmp810_;
						_tmp812_ = vala_binary_expression_get_right (self);
						_tmp813_ = _tmp812_;
						_tmp814_ = vala_expression_get_value_type (_tmp813_);
						_tmp815_ = _tmp814_;
						_tmp816_ = vala_code_node_to_string ((ValaCodeNode*) _tmp815_);
						_tmp817_ = _tmp816_;
						vala_report_error (_tmp805_, "Relational operation not supported for types `%s' and `%s'", _tmp811_, _tmp817_);
						_g_free0 (_tmp817_);
						_g_free0 (_tmp811_);
						result = FALSE;
						_vala_code_node_unref0 (resulting_type);
						return result;
					}
					_tmp818_ = self->priv->_is_chained;
					if (!_tmp818_) {
						ValaExpression* _tmp819_;
						ValaExpression* _tmp820_;
						ValaDataType* _tmp821_;
						ValaDataType* _tmp822_;
						ValaDataType* _tmp823_;
						_tmp819_ = vala_binary_expression_get_left (self);
						_tmp820_ = _tmp819_;
						_tmp821_ = resulting_type;
						_tmp822_ = vala_data_type_copy (_tmp821_);
						_tmp823_ = _tmp822_;
						vala_expression_set_target_type (_tmp820_, _tmp823_);
						_vala_code_node_unref0 (_tmp823_);
					}
					_tmp824_ = vala_binary_expression_get_right (self);
					_tmp825_ = _tmp824_;
					_tmp826_ = resulting_type;
					_tmp827_ = vala_data_type_copy (_tmp826_);
					_tmp828_ = _tmp827_;
					vala_expression_set_target_type (_tmp825_, _tmp828_);
					_vala_code_node_unref0 (_tmp828_);
					_tmp829_ = vala_binary_expression_get_left (self);
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_expression_get_target_type (_tmp830_);
					_tmp832_ = _tmp831_;
					vala_data_type_set_nullable (_tmp832_, FALSE);
					_tmp833_ = vala_binary_expression_get_right (self);
					_tmp834_ = _tmp833_;
					_tmp835_ = vala_expression_get_target_type (_tmp834_);
					_tmp836_ = _tmp835_;
					vala_data_type_set_nullable (_tmp836_, FALSE);
					_vala_code_node_unref0 (resulting_type);
				}
			}
			_tmp837_ = vala_code_context_get_analyzer (context);
			_tmp838_ = _tmp837_;
			_tmp839_ = _tmp838_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp839_);
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			ValaProfile _tmp840_;
			ValaProfile _tmp841_;
			gboolean _tmp910_ = FALSE;
			ValaExpression* _tmp911_;
			ValaExpression* _tmp912_;
			ValaDataType* _tmp913_;
			ValaDataType* _tmp914_;
			ValaExpression* _tmp915_;
			ValaExpression* _tmp916_;
			ValaDataType* _tmp917_;
			ValaDataType* _tmp918_;
			ValaDataType* resulting_type = NULL;
			ValaSemanticAnalyzer* _tmp941_;
			ValaSemanticAnalyzer* _tmp942_;
			ValaExpression* _tmp943_;
			ValaExpression* _tmp944_;
			ValaDataType* _tmp945_;
			ValaDataType* _tmp946_;
			ValaExpression* _tmp947_;
			ValaExpression* _tmp948_;
			ValaDataType* _tmp949_;
			ValaDataType* _tmp950_;
			ValaDataType* _tmp951_;
			ValaDataType* _tmp952_;
			ValaDataType* _tmp953_;
			ValaExpression* _tmp964_;
			ValaExpression* _tmp965_;
			ValaDataType* _tmp966_;
			ValaDataType* _tmp967_;
			ValaExpression* _tmp968_;
			ValaExpression* _tmp969_;
			ValaDataType* _tmp970_;
			ValaDataType* _tmp971_;
			ValaExpression* _tmp972_;
			ValaExpression* _tmp973_;
			ValaDataType* _tmp974_;
			ValaDataType* _tmp975_;
			gboolean _tmp976_;
			gboolean _tmp977_;
			ValaExpression* _tmp978_;
			ValaExpression* _tmp979_;
			ValaDataType* _tmp980_;
			ValaDataType* _tmp981_;
			gboolean _tmp982_;
			gboolean _tmp983_;
			ValaSemanticAnalyzer* _tmp992_;
			ValaSemanticAnalyzer* _tmp993_;
			ValaDataType* _tmp994_;
			_tmp840_ = vala_code_context_get_profile (context);
			_tmp841_ = _tmp840_;
			if (_tmp841_ == VALA_PROFILE_GOBJECT) {
				ValaTypeSymbol* gvalue_type = NULL;
				ValaSemanticAnalyzer* _tmp842_;
				ValaSemanticAnalyzer* _tmp843_;
				ValaStructValueType* _tmp844_;
				ValaTypeSymbol* _tmp845_;
				ValaTypeSymbol* _tmp846_;
				ValaTypeSymbol* _tmp847_;
				gboolean _tmp848_ = FALSE;
				gboolean _tmp849_ = FALSE;
				ValaExpression* _tmp850_;
				ValaExpression* _tmp851_;
				ValaDataType* _tmp852_;
				ValaDataType* _tmp853_;
				ValaTypeSymbol* _tmp854_;
				ValaTypeSymbol* _tmp855_;
				ValaTypeSymbol* _tmp856_;
				_tmp842_ = vala_code_context_get_analyzer (context);
				_tmp843_ = _tmp842_;
				_tmp844_ = _tmp843_->gvalue_type;
				_tmp845_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp844_);
				_tmp846_ = _tmp845_;
				_tmp847_ = _vala_code_node_ref0 (_tmp846_);
				gvalue_type = _tmp847_;
				_tmp850_ = vala_binary_expression_get_left (self);
				_tmp851_ = _tmp850_;
				_tmp852_ = vala_expression_get_target_type (_tmp851_);
				_tmp853_ = _tmp852_;
				_tmp854_ = vala_data_type_get_type_symbol (_tmp853_);
				_tmp855_ = _tmp854_;
				_tmp856_ = gvalue_type;
				if (_tmp855_ == _tmp856_) {
					ValaExpression* _tmp857_;
					ValaExpression* _tmp858_;
					ValaDataType* _tmp859_;
					ValaDataType* _tmp860_;
					ValaTypeSymbol* _tmp861_;
					ValaTypeSymbol* _tmp862_;
					ValaTypeSymbol* _tmp863_;
					_tmp857_ = vala_binary_expression_get_right (self);
					_tmp858_ = _tmp857_;
					_tmp859_ = vala_expression_get_target_type (_tmp858_);
					_tmp860_ = _tmp859_;
					_tmp861_ = vala_data_type_get_type_symbol (_tmp860_);
					_tmp862_ = _tmp861_;
					_tmp863_ = gvalue_type;
					_tmp849_ = _tmp862_ != _tmp863_;
				} else {
					_tmp849_ = FALSE;
				}
				if (_tmp849_) {
					_tmp848_ = TRUE;
				} else {
					gboolean _tmp864_ = FALSE;
					ValaExpression* _tmp865_;
					ValaExpression* _tmp866_;
					ValaDataType* _tmp867_;
					ValaDataType* _tmp868_;
					ValaTypeSymbol* _tmp869_;
					ValaTypeSymbol* _tmp870_;
					ValaTypeSymbol* _tmp871_;
					_tmp865_ = vala_binary_expression_get_left (self);
					_tmp866_ = _tmp865_;
					_tmp867_ = vala_expression_get_target_type (_tmp866_);
					_tmp868_ = _tmp867_;
					_tmp869_ = vala_data_type_get_type_symbol (_tmp868_);
					_tmp870_ = _tmp869_;
					_tmp871_ = gvalue_type;
					if (_tmp870_ != _tmp871_) {
						ValaExpression* _tmp872_;
						ValaExpression* _tmp873_;
						ValaDataType* _tmp874_;
						ValaDataType* _tmp875_;
						ValaTypeSymbol* _tmp876_;
						ValaTypeSymbol* _tmp877_;
						ValaTypeSymbol* _tmp878_;
						_tmp872_ = vala_binary_expression_get_right (self);
						_tmp873_ = _tmp872_;
						_tmp874_ = vala_expression_get_target_type (_tmp873_);
						_tmp875_ = _tmp874_;
						_tmp876_ = vala_data_type_get_type_symbol (_tmp875_);
						_tmp877_ = _tmp876_;
						_tmp878_ = gvalue_type;
						_tmp864_ = _tmp877_ == _tmp878_;
					} else {
						_tmp864_ = FALSE;
					}
					_tmp848_ = _tmp864_;
				}
				if (_tmp848_) {
					ValaExpression* gvalue_expr = NULL;
					ValaDataType* target_type = NULL;
					ValaExpression* _tmp879_;
					ValaExpression* _tmp880_;
					ValaDataType* _tmp881_;
					ValaDataType* _tmp882_;
					ValaTypeSymbol* _tmp883_;
					ValaTypeSymbol* _tmp884_;
					ValaTypeSymbol* _tmp885_;
					ValaCastExpression* cast_expr = NULL;
					ValaExpression* _tmp902_;
					ValaDataType* _tmp903_;
					ValaExpression* _tmp904_;
					ValaSourceReference* _tmp905_;
					ValaSourceReference* _tmp906_;
					ValaCastExpression* _tmp907_;
					ValaExpression* _tmp908_;
					ValaCastExpression* _tmp909_;
					_tmp879_ = vala_binary_expression_get_left (self);
					_tmp880_ = _tmp879_;
					_tmp881_ = vala_expression_get_target_type (_tmp880_);
					_tmp882_ = _tmp881_;
					_tmp883_ = vala_data_type_get_type_symbol (_tmp882_);
					_tmp884_ = _tmp883_;
					_tmp885_ = gvalue_type;
					if (_tmp884_ == _tmp885_) {
						ValaExpression* _tmp886_;
						ValaExpression* _tmp887_;
						ValaExpression* _tmp888_;
						ValaExpression* _tmp889_;
						ValaExpression* _tmp890_;
						ValaDataType* _tmp891_;
						ValaDataType* _tmp892_;
						ValaDataType* _tmp893_;
						_tmp886_ = vala_binary_expression_get_left (self);
						_tmp887_ = _tmp886_;
						_tmp888_ = _vala_code_node_ref0 (_tmp887_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp888_;
						_tmp889_ = vala_binary_expression_get_right (self);
						_tmp890_ = _tmp889_;
						_tmp891_ = vala_expression_get_target_type (_tmp890_);
						_tmp892_ = _tmp891_;
						_tmp893_ = _vala_code_node_ref0 (_tmp892_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp893_;
					} else {
						ValaExpression* _tmp894_;
						ValaExpression* _tmp895_;
						ValaExpression* _tmp896_;
						ValaExpression* _tmp897_;
						ValaExpression* _tmp898_;
						ValaDataType* _tmp899_;
						ValaDataType* _tmp900_;
						ValaDataType* _tmp901_;
						_tmp894_ = vala_binary_expression_get_right (self);
						_tmp895_ = _tmp894_;
						_tmp896_ = _vala_code_node_ref0 (_tmp895_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp896_;
						_tmp897_ = vala_binary_expression_get_left (self);
						_tmp898_ = _tmp897_;
						_tmp899_ = vala_expression_get_target_type (_tmp898_);
						_tmp900_ = _tmp899_;
						_tmp901_ = _vala_code_node_ref0 (_tmp900_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp901_;
					}
					_tmp902_ = gvalue_expr;
					_tmp903_ = target_type;
					_tmp904_ = gvalue_expr;
					_tmp905_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp904_);
					_tmp906_ = _tmp905_;
					_tmp907_ = vala_cast_expression_new (_tmp902_, _tmp903_, _tmp906_);
					cast_expr = _tmp907_;
					_tmp908_ = gvalue_expr;
					_tmp909_ = cast_expr;
					vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp908_, (ValaExpression*) _tmp909_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					result = vala_code_node_check ((ValaCodeNode*) self, context);
					_vala_code_node_unref0 (cast_expr);
					_vala_code_node_unref0 (target_type);
					_vala_code_node_unref0 (gvalue_expr);
					_vala_code_node_unref0 (gvalue_type);
					return result;
				}
				_vala_code_node_unref0 (gvalue_type);
			}
			_tmp911_ = vala_binary_expression_get_right (self);
			_tmp912_ = _tmp911_;
			_tmp913_ = vala_expression_get_value_type (_tmp912_);
			_tmp914_ = _tmp913_;
			_tmp915_ = vala_binary_expression_get_left (self);
			_tmp916_ = _tmp915_;
			_tmp917_ = vala_expression_get_value_type (_tmp916_);
			_tmp918_ = _tmp917_;
			if (!vala_data_type_compatible (_tmp914_, _tmp918_)) {
				ValaExpression* _tmp919_;
				ValaExpression* _tmp920_;
				ValaDataType* _tmp921_;
				ValaDataType* _tmp922_;
				ValaExpression* _tmp923_;
				ValaExpression* _tmp924_;
				ValaDataType* _tmp925_;
				ValaDataType* _tmp926_;
				_tmp919_ = vala_binary_expression_get_left (self);
				_tmp920_ = _tmp919_;
				_tmp921_ = vala_expression_get_value_type (_tmp920_);
				_tmp922_ = _tmp921_;
				_tmp923_ = vala_binary_expression_get_right (self);
				_tmp924_ = _tmp923_;
				_tmp925_ = vala_expression_get_value_type (_tmp924_);
				_tmp926_ = _tmp925_;
				_tmp910_ = !vala_data_type_compatible (_tmp922_, _tmp926_);
			} else {
				_tmp910_ = FALSE;
			}
			if (_tmp910_) {
				ValaSourceReference* _tmp927_;
				ValaSourceReference* _tmp928_;
				ValaExpression* _tmp929_;
				ValaExpression* _tmp930_;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				gchar* _tmp933_;
				gchar* _tmp934_;
				ValaExpression* _tmp935_;
				ValaExpression* _tmp936_;
				ValaDataType* _tmp937_;
				ValaDataType* _tmp938_;
				gchar* _tmp939_;
				gchar* _tmp940_;
				_tmp927_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp928_ = _tmp927_;
				_tmp929_ = vala_binary_expression_get_right (self);
				_tmp930_ = _tmp929_;
				_tmp931_ = vala_expression_get_value_type (_tmp930_);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_code_node_to_string ((ValaCodeNode*) _tmp932_);
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_binary_expression_get_left (self);
				_tmp936_ = _tmp935_;
				_tmp937_ = vala_expression_get_value_type (_tmp936_);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_code_node_to_string ((ValaCodeNode*) _tmp938_);
				_tmp940_ = _tmp939_;
				vala_report_error (_tmp928_, "Equality operation: `%s' and `%s' are incompatible", _tmp934_, _tmp940_);
				_g_free0 (_tmp940_);
				_g_free0 (_tmp934_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp941_ = vala_code_context_get_analyzer (context);
			_tmp942_ = _tmp941_;
			_tmp943_ = vala_binary_expression_get_left (self);
			_tmp944_ = _tmp943_;
			_tmp945_ = vala_expression_get_target_type (_tmp944_);
			_tmp946_ = _tmp945_;
			_tmp947_ = vala_binary_expression_get_right (self);
			_tmp948_ = _tmp947_;
			_tmp949_ = vala_expression_get_target_type (_tmp948_);
			_tmp950_ = _tmp949_;
			_tmp951_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp942_, _tmp946_, _tmp950_);
			_tmp952_ = _vala_code_node_ref0 (_tmp951_);
			resulting_type = _tmp952_;
			_tmp953_ = resulting_type;
			if (_tmp953_ != NULL) {
				ValaExpression* _tmp954_;
				ValaExpression* _tmp955_;
				ValaDataType* _tmp956_;
				ValaDataType* _tmp957_;
				ValaDataType* _tmp958_;
				ValaExpression* _tmp959_;
				ValaExpression* _tmp960_;
				ValaDataType* _tmp961_;
				ValaDataType* _tmp962_;
				ValaDataType* _tmp963_;
				_tmp954_ = vala_binary_expression_get_left (self);
				_tmp955_ = _tmp954_;
				_tmp956_ = resulting_type;
				_tmp957_ = vala_data_type_copy (_tmp956_);
				_tmp958_ = _tmp957_;
				vala_expression_set_target_type (_tmp955_, _tmp958_);
				_vala_code_node_unref0 (_tmp958_);
				_tmp959_ = vala_binary_expression_get_right (self);
				_tmp960_ = _tmp959_;
				_tmp961_ = resulting_type;
				_tmp962_ = vala_data_type_copy (_tmp961_);
				_tmp963_ = _tmp962_;
				vala_expression_set_target_type (_tmp960_, _tmp963_);
				_vala_code_node_unref0 (_tmp963_);
			}
			_tmp964_ = vala_binary_expression_get_left (self);
			_tmp965_ = _tmp964_;
			_tmp966_ = vala_expression_get_target_type (_tmp965_);
			_tmp967_ = _tmp966_;
			vala_data_type_set_value_owned (_tmp967_, FALSE);
			_tmp968_ = vala_binary_expression_get_right (self);
			_tmp969_ = _tmp968_;
			_tmp970_ = vala_expression_get_target_type (_tmp969_);
			_tmp971_ = _tmp970_;
			vala_data_type_set_value_owned (_tmp971_, FALSE);
			_tmp972_ = vala_binary_expression_get_left (self);
			_tmp973_ = _tmp972_;
			_tmp974_ = vala_expression_get_value_type (_tmp973_);
			_tmp975_ = _tmp974_;
			_tmp976_ = vala_data_type_get_nullable (_tmp975_);
			_tmp977_ = _tmp976_;
			_tmp978_ = vala_binary_expression_get_right (self);
			_tmp979_ = _tmp978_;
			_tmp980_ = vala_expression_get_value_type (_tmp979_);
			_tmp981_ = _tmp980_;
			_tmp982_ = vala_data_type_get_nullable (_tmp981_);
			_tmp983_ = _tmp982_;
			if (_tmp977_ != _tmp983_) {
				ValaExpression* _tmp984_;
				ValaExpression* _tmp985_;
				ValaDataType* _tmp986_;
				ValaDataType* _tmp987_;
				ValaExpression* _tmp988_;
				ValaExpression* _tmp989_;
				ValaDataType* _tmp990_;
				ValaDataType* _tmp991_;
				_tmp984_ = vala_binary_expression_get_left (self);
				_tmp985_ = _tmp984_;
				_tmp986_ = vala_expression_get_target_type (_tmp985_);
				_tmp987_ = _tmp986_;
				vala_data_type_set_nullable (_tmp987_, TRUE);
				_tmp988_ = vala_binary_expression_get_right (self);
				_tmp989_ = _tmp988_;
				_tmp990_ = vala_expression_get_target_type (_tmp989_);
				_tmp991_ = _tmp990_;
				vala_data_type_set_nullable (_tmp991_, TRUE);
			}
			_tmp992_ = vala_code_context_get_analyzer (context);
			_tmp993_ = _tmp992_;
			_tmp994_ = _tmp993_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp994_);
			_vala_code_node_unref0 (resulting_type);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			ValaExpression* _tmp995_;
			ValaExpression* _tmp996_;
			ValaDataType* _tmp997_;
			ValaDataType* _tmp998_;
			ValaExpression* _tmp999_;
			ValaExpression* _tmp1000_;
			ValaDataType* _tmp1001_;
			ValaDataType* _tmp1002_;
			gboolean _tmp1003_ = FALSE;
			ValaExpression* _tmp1004_;
			ValaExpression* _tmp1005_;
			ValaDataType* _tmp1006_;
			ValaDataType* _tmp1007_;
			ValaSemanticAnalyzer* _tmp1008_;
			ValaSemanticAnalyzer* _tmp1009_;
			ValaDataType* _tmp1010_;
			_tmp995_ = vala_binary_expression_get_left (self);
			_tmp996_ = _tmp995_;
			_tmp997_ = vala_expression_get_target_type (_tmp996_);
			_tmp998_ = _tmp997_;
			vala_data_type_set_nullable (_tmp998_, FALSE);
			_tmp999_ = vala_binary_expression_get_right (self);
			_tmp1000_ = _tmp999_;
			_tmp1001_ = vala_expression_get_target_type (_tmp1000_);
			_tmp1002_ = _tmp1001_;
			vala_data_type_set_nullable (_tmp1002_, FALSE);
			_tmp1004_ = vala_binary_expression_get_left (self);
			_tmp1005_ = _tmp1004_;
			_tmp1006_ = vala_expression_get_value_type (_tmp1005_);
			_tmp1007_ = _tmp1006_;
			_tmp1008_ = vala_code_context_get_analyzer (context);
			_tmp1009_ = _tmp1008_;
			_tmp1010_ = _tmp1009_->bool_type;
			if (vala_data_type_compatible (_tmp1007_, _tmp1010_)) {
				ValaExpression* _tmp1011_;
				ValaExpression* _tmp1012_;
				ValaDataType* _tmp1013_;
				ValaDataType* _tmp1014_;
				ValaSemanticAnalyzer* _tmp1015_;
				ValaSemanticAnalyzer* _tmp1016_;
				ValaDataType* _tmp1017_;
				_tmp1011_ = vala_binary_expression_get_right (self);
				_tmp1012_ = _tmp1011_;
				_tmp1013_ = vala_expression_get_value_type (_tmp1012_);
				_tmp1014_ = _tmp1013_;
				_tmp1015_ = vala_code_context_get_analyzer (context);
				_tmp1016_ = _tmp1015_;
				_tmp1017_ = _tmp1016_->bool_type;
				_tmp1003_ = !vala_data_type_compatible (_tmp1014_, _tmp1017_);
			} else {
				_tmp1003_ = FALSE;
			}
			if (_tmp1003_) {
				ValaExpression* _tmp1018_;
				ValaExpression* _tmp1019_;
				ValaDataType* _tmp1020_;
				ValaDataType* _tmp1021_;
				ValaDataType* _tmp1022_;
				ValaDataType* _tmp1023_;
				_tmp1018_ = vala_binary_expression_get_right (self);
				_tmp1019_ = _tmp1018_;
				_tmp1020_ = vala_expression_get_target_type (_tmp1019_);
				_tmp1021_ = _tmp1020_;
				_tmp1022_ = vala_data_type_copy (_tmp1021_);
				_tmp1023_ = _tmp1022_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1023_);
				_vala_code_node_unref0 (_tmp1023_);
			} else {
				ValaExpression* _tmp1024_;
				ValaExpression* _tmp1025_;
				ValaDataType* _tmp1026_;
				ValaDataType* _tmp1027_;
				ValaDataType* _tmp1028_;
				ValaDataType* _tmp1029_;
				_tmp1024_ = vala_binary_expression_get_left (self);
				_tmp1025_ = _tmp1024_;
				_tmp1026_ = vala_expression_get_target_type (_tmp1025_);
				_tmp1027_ = _tmp1026_;
				_tmp1028_ = vala_data_type_copy (_tmp1027_);
				_tmp1029_ = _tmp1028_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1029_);
				_vala_code_node_unref0 (_tmp1029_);
			}
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		case VALA_BINARY_OPERATOR_OR:
		{
			gboolean _tmp1030_ = FALSE;
			ValaExpression* _tmp1031_;
			ValaExpression* _tmp1032_;
			ValaDataType* _tmp1033_;
			ValaDataType* _tmp1034_;
			ValaSemanticAnalyzer* _tmp1035_;
			ValaSemanticAnalyzer* _tmp1036_;
			ValaDataType* _tmp1037_;
			ValaExpression* _tmp1047_;
			ValaExpression* _tmp1048_;
			ValaDataType* _tmp1049_;
			ValaDataType* _tmp1050_;
			ValaExpression* _tmp1051_;
			ValaExpression* _tmp1052_;
			ValaDataType* _tmp1053_;
			ValaDataType* _tmp1054_;
			ValaSemanticAnalyzer* _tmp1055_;
			ValaSemanticAnalyzer* _tmp1056_;
			ValaDataType* _tmp1057_;
			_tmp1031_ = vala_binary_expression_get_left (self);
			_tmp1032_ = _tmp1031_;
			_tmp1033_ = vala_expression_get_value_type (_tmp1032_);
			_tmp1034_ = _tmp1033_;
			_tmp1035_ = vala_code_context_get_analyzer (context);
			_tmp1036_ = _tmp1035_;
			_tmp1037_ = _tmp1036_->bool_type;
			if (!vala_data_type_compatible (_tmp1034_, _tmp1037_)) {
				_tmp1030_ = TRUE;
			} else {
				ValaExpression* _tmp1038_;
				ValaExpression* _tmp1039_;
				ValaDataType* _tmp1040_;
				ValaDataType* _tmp1041_;
				ValaSemanticAnalyzer* _tmp1042_;
				ValaSemanticAnalyzer* _tmp1043_;
				ValaDataType* _tmp1044_;
				_tmp1038_ = vala_binary_expression_get_right (self);
				_tmp1039_ = _tmp1038_;
				_tmp1040_ = vala_expression_get_value_type (_tmp1039_);
				_tmp1041_ = _tmp1040_;
				_tmp1042_ = vala_code_context_get_analyzer (context);
				_tmp1043_ = _tmp1042_;
				_tmp1044_ = _tmp1043_->bool_type;
				_tmp1030_ = !vala_data_type_compatible (_tmp1041_, _tmp1044_);
			}
			if (_tmp1030_) {
				ValaSourceReference* _tmp1045_;
				ValaSourceReference* _tmp1046_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1045_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1046_ = _tmp1045_;
				vala_report_error (_tmp1046_, "Operands must be boolean");
			}
			_tmp1047_ = vala_binary_expression_get_left (self);
			_tmp1048_ = _tmp1047_;
			_tmp1049_ = vala_expression_get_target_type (_tmp1048_);
			_tmp1050_ = _tmp1049_;
			vala_data_type_set_nullable (_tmp1050_, FALSE);
			_tmp1051_ = vala_binary_expression_get_right (self);
			_tmp1052_ = _tmp1051_;
			_tmp1053_ = vala_expression_get_target_type (_tmp1052_);
			_tmp1054_ = _tmp1053_;
			vala_data_type_set_nullable (_tmp1054_, FALSE);
			_tmp1055_ = vala_code_context_get_analyzer (context);
			_tmp1056_ = _tmp1055_;
			_tmp1057_ = _tmp1056_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1057_);
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			gboolean _tmp1058_ = FALSE;
			ValaExpression* _tmp1059_;
			ValaExpression* _tmp1060_;
			ValaDataType* _tmp1061_;
			ValaDataType* _tmp1062_;
			ValaSemanticAnalyzer* _tmp1063_;
			ValaSemanticAnalyzer* _tmp1064_;
			ValaDataType* _tmp1065_;
			ValaSemanticAnalyzer* _tmp1201_;
			ValaSemanticAnalyzer* _tmp1202_;
			ValaDataType* _tmp1203_;
			_tmp1059_ = vala_binary_expression_get_left (self);
			_tmp1060_ = _tmp1059_;
			_tmp1061_ = vala_expression_get_value_type (_tmp1060_);
			_tmp1062_ = _tmp1061_;
			_tmp1063_ = vala_code_context_get_analyzer (context);
			_tmp1064_ = _tmp1063_;
			_tmp1065_ = _tmp1064_->int_type;
			if (vala_data_type_compatible (_tmp1062_, _tmp1065_)) {
				ValaExpression* _tmp1066_;
				ValaExpression* _tmp1067_;
				ValaDataType* _tmp1068_;
				ValaDataType* _tmp1069_;
				ValaSemanticAnalyzer* _tmp1070_;
				ValaSemanticAnalyzer* _tmp1071_;
				ValaDataType* _tmp1072_;
				_tmp1066_ = vala_binary_expression_get_right (self);
				_tmp1067_ = _tmp1066_;
				_tmp1068_ = vala_expression_get_value_type (_tmp1067_);
				_tmp1069_ = _tmp1068_;
				_tmp1070_ = vala_code_context_get_analyzer (context);
				_tmp1071_ = _tmp1070_;
				_tmp1072_ = _tmp1071_->int_type;
				_tmp1058_ = vala_data_type_compatible (_tmp1069_, _tmp1072_);
			} else {
				_tmp1058_ = FALSE;
			}
			if (_tmp1058_) {
				ValaExpression* _tmp1073_;
				ValaExpression* _tmp1074_;
				ValaDataType* _tmp1075_;
				ValaDataType* _tmp1076_;
				ValaExpression* _tmp1077_;
				ValaExpression* _tmp1078_;
				ValaDataType* _tmp1079_;
				ValaDataType* _tmp1080_;
				gboolean _tmp1081_ = FALSE;
				gboolean _tmp1082_ = FALSE;
				ValaExpression* _tmp1083_;
				ValaExpression* _tmp1084_;
				ValaDataType* _tmp1085_;
				ValaDataType* _tmp1086_;
				ValaTypeSymbol* _tmp1087_;
				ValaTypeSymbol* _tmp1088_;
				_tmp1073_ = vala_binary_expression_get_left (self);
				_tmp1074_ = _tmp1073_;
				_tmp1075_ = vala_expression_get_target_type (_tmp1074_);
				_tmp1076_ = _tmp1075_;
				vala_data_type_set_nullable (_tmp1076_, FALSE);
				_tmp1077_ = vala_binary_expression_get_right (self);
				_tmp1078_ = _tmp1077_;
				_tmp1079_ = vala_expression_get_target_type (_tmp1078_);
				_tmp1080_ = _tmp1079_;
				vala_data_type_set_nullable (_tmp1080_, FALSE);
				_tmp1083_ = vala_binary_expression_get_left (self);
				_tmp1084_ = _tmp1083_;
				_tmp1085_ = vala_expression_get_value_type (_tmp1084_);
				_tmp1086_ = _tmp1085_;
				_tmp1087_ = vala_data_type_get_type_symbol (_tmp1086_);
				_tmp1088_ = _tmp1087_;
				if (VALA_IS_ENUM (_tmp1088_)) {
					ValaExpression* _tmp1089_;
					ValaExpression* _tmp1090_;
					ValaDataType* _tmp1091_;
					ValaDataType* _tmp1092_;
					ValaTypeSymbol* _tmp1093_;
					ValaTypeSymbol* _tmp1094_;
					_tmp1089_ = vala_binary_expression_get_right (self);
					_tmp1090_ = _tmp1089_;
					_tmp1091_ = vala_expression_get_value_type (_tmp1090_);
					_tmp1092_ = _tmp1091_;
					_tmp1093_ = vala_data_type_get_type_symbol (_tmp1092_);
					_tmp1094_ = _tmp1093_;
					_tmp1082_ = VALA_IS_ENUM (_tmp1094_);
				} else {
					_tmp1082_ = FALSE;
				}
				if (_tmp1082_) {
					ValaExpression* _tmp1095_;
					ValaExpression* _tmp1096_;
					ValaDataType* _tmp1097_;
					ValaDataType* _tmp1098_;
					ValaTypeSymbol* _tmp1099_;
					ValaTypeSymbol* _tmp1100_;
					ValaExpression* _tmp1101_;
					ValaExpression* _tmp1102_;
					ValaDataType* _tmp1103_;
					ValaDataType* _tmp1104_;
					ValaTypeSymbol* _tmp1105_;
					ValaTypeSymbol* _tmp1106_;
					_tmp1095_ = vala_binary_expression_get_left (self);
					_tmp1096_ = _tmp1095_;
					_tmp1097_ = vala_expression_get_value_type (_tmp1096_);
					_tmp1098_ = _tmp1097_;
					_tmp1099_ = vala_data_type_get_type_symbol (_tmp1098_);
					_tmp1100_ = _tmp1099_;
					_tmp1101_ = vala_binary_expression_get_right (self);
					_tmp1102_ = _tmp1101_;
					_tmp1103_ = vala_expression_get_value_type (_tmp1102_);
					_tmp1104_ = _tmp1103_;
					_tmp1105_ = vala_data_type_get_type_symbol (_tmp1104_);
					_tmp1106_ = _tmp1105_;
					_tmp1081_ = _tmp1100_ != _tmp1106_;
				} else {
					_tmp1081_ = FALSE;
				}
				if (_tmp1081_) {
					ValaSourceReference* _tmp1107_;
					ValaSourceReference* _tmp1108_;
					ValaExpression* _tmp1109_;
					ValaExpression* _tmp1110_;
					ValaDataType* _tmp1111_;
					ValaDataType* _tmp1112_;
					gchar* _tmp1113_;
					gchar* _tmp1114_;
					ValaExpression* _tmp1115_;
					ValaExpression* _tmp1116_;
					ValaDataType* _tmp1117_;
					ValaDataType* _tmp1118_;
					gchar* _tmp1119_;
					gchar* _tmp1120_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1108_ = _tmp1107_;
					_tmp1109_ = vala_binary_expression_get_left (self);
					_tmp1110_ = _tmp1109_;
					_tmp1111_ = vala_expression_get_value_type (_tmp1110_);
					_tmp1112_ = _tmp1111_;
					_tmp1113_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1112_);
					_tmp1114_ = _tmp1113_;
					_tmp1115_ = vala_binary_expression_get_right (self);
					_tmp1116_ = _tmp1115_;
					_tmp1117_ = vala_expression_get_value_type (_tmp1116_);
					_tmp1118_ = _tmp1117_;
					_tmp1119_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1118_);
					_tmp1120_ = _tmp1119_;
					vala_report_error (_tmp1108_, "Cannot look for `%s' in `%s'", _tmp1114_, _tmp1120_);
					_g_free0 (_tmp1120_);
					_g_free0 (_tmp1114_);
				}
			} else {
				ValaExpression* _tmp1121_;
				ValaExpression* _tmp1122_;
				ValaDataType* _tmp1123_;
				ValaDataType* _tmp1124_;
				_tmp1121_ = vala_binary_expression_get_right (self);
				_tmp1122_ = _tmp1121_;
				_tmp1123_ = vala_expression_get_value_type (_tmp1122_);
				_tmp1124_ = _tmp1123_;
				if (VALA_IS_ARRAY_TYPE (_tmp1124_)) {
					ValaExpression* _tmp1125_;
					ValaExpression* _tmp1126_;
					ValaDataType* _tmp1127_;
					ValaDataType* _tmp1128_;
					ValaExpression* _tmp1129_;
					ValaExpression* _tmp1130_;
					ValaDataType* _tmp1131_;
					ValaDataType* _tmp1132_;
					ValaDataType* _tmp1133_;
					ValaDataType* _tmp1134_;
					_tmp1125_ = vala_binary_expression_get_left (self);
					_tmp1126_ = _tmp1125_;
					_tmp1127_ = vala_expression_get_value_type (_tmp1126_);
					_tmp1128_ = _tmp1127_;
					_tmp1129_ = vala_binary_expression_get_right (self);
					_tmp1130_ = _tmp1129_;
					_tmp1131_ = vala_expression_get_value_type (_tmp1130_);
					_tmp1132_ = _tmp1131_;
					_tmp1133_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1132_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp1134_ = _tmp1133_;
					if (!vala_data_type_compatible (_tmp1128_, _tmp1134_)) {
						ValaSourceReference* _tmp1135_;
						ValaSourceReference* _tmp1136_;
						ValaExpression* _tmp1137_;
						ValaExpression* _tmp1138_;
						ValaDataType* _tmp1139_;
						ValaDataType* _tmp1140_;
						gchar* _tmp1141_;
						gchar* _tmp1142_;
						ValaExpression* _tmp1143_;
						ValaExpression* _tmp1144_;
						ValaDataType* _tmp1145_;
						ValaDataType* _tmp1146_;
						gchar* _tmp1147_;
						gchar* _tmp1148_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1136_ = _tmp1135_;
						_tmp1137_ = vala_binary_expression_get_left (self);
						_tmp1138_ = _tmp1137_;
						_tmp1139_ = vala_expression_get_value_type (_tmp1138_);
						_tmp1140_ = _tmp1139_;
						_tmp1141_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1140_);
						_tmp1142_ = _tmp1141_;
						_tmp1143_ = vala_binary_expression_get_right (self);
						_tmp1144_ = _tmp1143_;
						_tmp1145_ = vala_expression_get_value_type (_tmp1144_);
						_tmp1146_ = _tmp1145_;
						_tmp1147_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1146_);
						_tmp1148_ = _tmp1147_;
						vala_report_error (_tmp1136_, "Cannot look for `%s' in `%s'", _tmp1142_, _tmp1148_);
						_g_free0 (_tmp1148_);
						_g_free0 (_tmp1142_);
					}
				} else {
					ValaMethod* contains_method = NULL;
					ValaExpression* _tmp1149_;
					ValaExpression* _tmp1150_;
					ValaDataType* _tmp1151_;
					ValaDataType* _tmp1152_;
					ValaSymbol* _tmp1153_;
					ValaMethod* _tmp1154_;
					ValaMethod* _tmp1155_;
					ValaMethod* _tmp1164_;
					ValaList* _tmp1165_;
					gint _tmp1166_;
					gint _tmp1167_;
					ValaMethod* _tmp1173_;
					ValaDataType* _tmp1174_;
					ValaDataType* _tmp1175_;
					ValaSemanticAnalyzer* _tmp1176_;
					ValaSemanticAnalyzer* _tmp1177_;
					ValaDataType* _tmp1178_;
					ValaMethodCall* contains_call = NULL;
					ValaExpression* _tmp1184_;
					ValaExpression* _tmp1185_;
					ValaSourceReference* _tmp1186_;
					ValaSourceReference* _tmp1187_;
					ValaMemberAccess* _tmp1188_;
					ValaMemberAccess* _tmp1189_;
					ValaSourceReference* _tmp1190_;
					ValaSourceReference* _tmp1191_;
					ValaMethodCall* _tmp1192_;
					ValaMethodCall* _tmp1193_;
					ValaMethodCall* _tmp1194_;
					ValaExpression* _tmp1195_;
					ValaExpression* _tmp1196_;
					ValaCodeNode* _tmp1197_;
					ValaCodeNode* _tmp1198_;
					ValaMethodCall* _tmp1199_;
					ValaMethodCall* _tmp1200_;
					_tmp1149_ = vala_binary_expression_get_right (self);
					_tmp1150_ = _tmp1149_;
					_tmp1151_ = vala_expression_get_value_type (_tmp1150_);
					_tmp1152_ = _tmp1151_;
					_tmp1153_ = vala_data_type_get_member (_tmp1152_, "contains");
					_tmp1154_ = VALA_IS_METHOD (_tmp1153_) ? ((ValaMethod*) _tmp1153_) : NULL;
					if (_tmp1154_ == NULL) {
						_vala_code_node_unref0 (_tmp1153_);
					}
					contains_method = _tmp1154_;
					_tmp1155_ = contains_method;
					if (_tmp1155_ == NULL) {
						ValaSourceReference* _tmp1156_;
						ValaSourceReference* _tmp1157_;
						ValaExpression* _tmp1158_;
						ValaExpression* _tmp1159_;
						ValaDataType* _tmp1160_;
						ValaDataType* _tmp1161_;
						gchar* _tmp1162_;
						gchar* _tmp1163_;
						_tmp1156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1157_ = _tmp1156_;
						_tmp1158_ = vala_binary_expression_get_right (self);
						_tmp1159_ = _tmp1158_;
						_tmp1160_ = vala_expression_get_value_type (_tmp1159_);
						_tmp1161_ = _tmp1160_;
						_tmp1162_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1161_);
						_tmp1163_ = _tmp1162_;
						vala_report_error (_tmp1157_, "`%s' does not have a `contains' method", _tmp1163_);
						_g_free0 (_tmp1163_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1164_ = contains_method;
					_tmp1165_ = vala_callable_get_parameters ((ValaCallable*) _tmp1164_);
					_tmp1166_ = vala_collection_get_size ((ValaCollection*) _tmp1165_);
					_tmp1167_ = _tmp1166_;
					if (_tmp1167_ != 1) {
						ValaSourceReference* _tmp1168_;
						ValaSourceReference* _tmp1169_;
						ValaMethod* _tmp1170_;
						gchar* _tmp1171_;
						gchar* _tmp1172_;
						_tmp1168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1169_ = _tmp1168_;
						_tmp1170_ = contains_method;
						_tmp1171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1170_);
						_tmp1172_ = _tmp1171_;
						vala_report_error (_tmp1169_, "`%s' must have one parameter", _tmp1172_);
						_g_free0 (_tmp1172_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1173_ = contains_method;
					_tmp1174_ = vala_callable_get_return_type ((ValaCallable*) _tmp1173_);
					_tmp1175_ = _tmp1174_;
					_tmp1176_ = vala_code_context_get_analyzer (context);
					_tmp1177_ = _tmp1176_;
					_tmp1178_ = _tmp1177_->bool_type;
					if (!vala_data_type_compatible (_tmp1175_, _tmp1178_)) {
						ValaSourceReference* _tmp1179_;
						ValaSourceReference* _tmp1180_;
						ValaMethod* _tmp1181_;
						gchar* _tmp1182_;
						gchar* _tmp1183_;
						_tmp1179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1180_ = _tmp1179_;
						_tmp1181_ = contains_method;
						_tmp1182_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1181_);
						_tmp1183_ = _tmp1182_;
						vala_report_error (_tmp1180_, "`%s' must return a boolean value", _tmp1183_);
						_g_free0 (_tmp1183_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1184_ = vala_binary_expression_get_right (self);
					_tmp1185_ = _tmp1184_;
					_tmp1186_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1187_ = _tmp1186_;
					_tmp1188_ = vala_member_access_new (_tmp1185_, "contains", _tmp1187_);
					_tmp1189_ = _tmp1188_;
					_tmp1190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1191_ = _tmp1190_;
					_tmp1192_ = vala_method_call_new ((ValaExpression*) _tmp1189_, _tmp1191_);
					_tmp1193_ = _tmp1192_;
					_vala_code_node_unref0 (_tmp1189_);
					contains_call = _tmp1193_;
					_tmp1194_ = contains_call;
					_tmp1195_ = vala_binary_expression_get_left (self);
					_tmp1196_ = _tmp1195_;
					vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp1194_, _tmp1196_);
					_tmp1197_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp1198_ = _tmp1197_;
					_tmp1199_ = contains_call;
					vala_code_node_replace_expression (_tmp1198_, (ValaExpression*) self, (ValaExpression*) _tmp1199_);
					_tmp1200_ = contains_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp1200_, context);
					_vala_code_node_unref0 (contains_call);
					_vala_code_node_unref0 (contains_method);
					return result;
				}
			}
			_tmp1201_ = vala_code_context_get_analyzer (context);
			_tmp1202_ = _tmp1201_;
			_tmp1203_ = _tmp1202_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1203_);
			break;
		}
		default:
		{
			ValaSourceReference* _tmp1204_;
			ValaSourceReference* _tmp1205_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1205_ = _tmp1204_;
			vala_report_error (_tmp1205_, "internal error: unsupported binary operator");
			result = FALSE;
			return result;
		}
	}
	_tmp1206_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1207_ = _tmp1206_;
	vala_code_node_check ((ValaCodeNode*) _tmp1207_, context);
	_tmp1208_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1209_ = _tmp1208_;
	result = !_tmp1209_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self,
                                      gpointer klass)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
static GType
vala_binary_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
	GType vala_binary_expression_type_id;
	vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
	ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
	return vala_binary_expression_type_id;
}

GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = vala_binary_expression_get_type_once ();
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_binary_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
	GType vala_binary_operator_type_id;
	vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
	return vala_binary_operator_type_id;
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = vala_binary_operator_get_type_once ();
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

