/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ext;

import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.LdapName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class StartTlsResponseImpl
extends StartTlsResponse {
    private static final boolean debug = false;
    private static final int DNSNAME_TYPE = 2;
    private transient Connection ldapConnection = null;
    private transient InputStream originalInputStream = null;
    private transient OutputStream originalOutputStream = null;
    private transient SSLSocket sslSocket = null;
    private transient SSLSocketFactory defaultFactory = null;
    private transient SSLSocketFactory currentFactory = null;
    private transient String[] suites = null;
    private transient HostnameVerifier verifier = null;
    private transient boolean isClosed = true;

    public void setEnabledCipherSuites(String[] stringArray) {
        this.suites = stringArray;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.verifier = hostnameVerifier;
    }

    public SSLSession negotiate() throws IOException {
        return this.negotiate(null);
    }

    public SSLSession negotiate(SSLSocketFactory sSLSocketFactory) throws IOException {
        SSLSession sSLSession;
        if (this.isClosed && this.sslSocket != null) {
            throw new IOException("TLS connection is closed.");
        }
        if (sSLSocketFactory == null) {
            sSLSocketFactory = this.getDefaultFactory();
        }
        if (this.verify(this.ldapConnection.host, sSLSession = this.startHandshake(sSLSocketFactory).getSession()) || this.verifier != null && this.verifier.verify(this.ldapConnection.host, sSLSession)) {
            this.isClosed = false;
            return sSLSession;
        }
        this.close();
        sSLSession.invalidate();
        throw new SSLPeerUnverifiedException("hostname of the server '" + this.ldapConnection.host + "' does not match the hostname in the " + "server's certificate.");
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.ldapConnection.replaceStreams(this.originalInputStream, this.originalOutputStream);
        this.sslSocket.close();
        this.isClosed = true;
    }

    public void setConnection(Connection connection) {
        this.ldapConnection = connection;
        this.originalInputStream = connection.inStream;
        this.originalOutputStream = connection.outStream;
    }

    private SSLSocketFactory getDefaultFactory() throws IOException {
        if (this.defaultFactory != null) {
            return this.defaultFactory;
        }
        this.defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return this.defaultFactory;
    }

    private SSLSocket startHandshake(SSLSocketFactory sSLSocketFactory) throws IOException {
        if (this.ldapConnection == null) {
            throw new IllegalStateException("LDAP connection has not been set. TLS requires an existing LDAP connection.");
        }
        if (sSLSocketFactory != this.currentFactory) {
            this.sslSocket = (SSLSocket)sSLSocketFactory.createSocket(this.ldapConnection.sock, this.ldapConnection.host, this.ldapConnection.port, false);
            this.currentFactory = sSLSocketFactory;
        }
        if (this.suites != null) {
            this.sslSocket.setEnabledCipherSuites(this.suites);
        }
        try {
            this.sslSocket.startHandshake();
            this.ldapConnection.replaceStreams(this.sslSocket.getInputStream(), this.sslSocket.getOutputStream());
        }
        catch (IOException iOException) {
            this.sslSocket.close();
            this.isClosed = true;
            throw iOException;
        }
        return this.sslSocket;
    }

    private boolean verify(String string, SSLSession sSLSession) {
        Certificate[] certificateArray = null;
        try {
            int n;
            Object object;
            certificateArray = sSLSession.getPeerCertificates();
            if (!(certificateArray[0] instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            boolean bl = true;
            if (collection != null) {
                object = collection.iterator();
                while (object.hasNext()) {
                    List<?> list = object.next();
                    if ((Integer)list.get(0) != 2) continue;
                    bl = false;
                    if (!StartTlsResponseImpl.matchNames(string, (String)list.get(1))) continue;
                    return true;
                }
            }
            if (bl && (n = ((LdapName)(object = new LdapName(((X509Certificate)certificateArray[0]).getSubjectDN().getName()))).size()) > 0) {
                String string2 = ((LdapName)object).get(n - 1);
                return string2.equalsIgnoreCase("cn=" + string);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            String string3 = sSLSession.getCipherSuite();
            if (string3 != null && string3.indexOf("_anon_") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean matchNames(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.startsWith("*.")) {
            return string2.substring(1).equalsIgnoreCase(string.substring(string.indexOf(46)));
        }
        return string2.equalsIgnoreCase(string);
    }
}

