/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherRC4;
import com.sun.net.ssl.internal.ssl.CipherRC4_40;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExportControl;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_e;
import com.sun.net.ssl.internal.ssl.SunJSSE_l;
import com.sun.net.ssl.internal.ssl.SunJSSE_v;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;

abstract class Handshaker
extends CipherSpec
implements ExportControl {
    SSLSocketImpl a;
    MessageDigest[] b;
    MessageDigest[] c;
    HandshakeInStream d;
    HandshakeOutStream e;
    int f;
    SSLContextImpl g;
    SunJSSE_l h;
    SunJSSE_l i;
    SSLSessionImpl j;
    boolean k;
    boolean l = true;
    byte[] m;
    byte[] n;
    byte[] o;
    byte[] p;
    byte[] q;
    byte[] r;
    static final Debug s = Debug.getInstance("ssl");

    Handshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, boolean bl) throws NoSuchAlgorithmException {
        this.a = sSLSocketImpl;
        this.k = false;
        this.j = null;
        this.b = this.a("MD5", bl);
        this.c = this.a("SHA", bl);
        ((CipherSpec)this).a = (byte)3;
        ((CipherSpec)this).b = 1;
        this.e = new HandshakeOutStream(((CipherSpec)this).a, ((CipherSpec)this).b, ((CipherSpec)this).c, sSLSocketImpl, this.b, this.c);
        this.d = new HandshakeInStream(((CipherSpec)this).a, ((CipherSpec)this).b, ((CipherSpec)this).c, ((CipherSpec)this).d);
        this.d.a(this.b, this.c);
        try {
            ((SSLInputStream)sSLSocketImpl.getInputStream()).a(this.b, this.c);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException(iOException.getMessage());
        }
        this.g = sSLContextImpl;
        this.f = -1;
    }

    void a(boolean bl) {
        this.l = bl;
    }

    abstract SunJSSE_e e() throws NoSuchAlgorithmException;

    abstract SunJSSE_e c() throws NoSuchAlgorithmException;

    abstract MAC f() throws NoSuchAlgorithmException;

    abstract MAC d() throws NoSuchAlgorithmException;

    private MessageDigest[] a(String string, boolean bl) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        try {
            messageDigest.clone();
            MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest};
            return messageDigestArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!bl) {
                MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest, MessageDigest.getInstance(string)};
                return messageDigestArray;
            }
            MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest, MessageDigest.getInstance(string), MessageDigest.getInstance(string)};
            return messageDigestArray;
        }
    }

    public boolean isDone() {
        return this.f == 20;
    }

    public SSLSessionImpl getSession() {
        return this.j;
    }

    protected void process_record(InputRecord inputRecord) throws IOException, NoSuchAlgorithmException {
        this.d.a(inputRecord);
        while (this.d.available() > 0) {
            this.d.mark(4);
            byte by = this.d.b();
            int n = this.d.d();
            if (this.d.available() < n) {
                this.d.reset();
                return;
            }
            if (by == 0) {
                this.d.reset();
                this.processMessage(by, n);
                this.d.a(4 + n);
                continue;
            }
            this.d.mark(n);
            this.processMessage(by, n);
            this.d.a();
        }
    }

    public boolean started() {
        return this.f >= 0;
    }

    protected void kickstart() throws IOException {
        if (this.f >= 0) {
            return;
        }
        HandshakeMessage handshakeMessage = this.getKickstartMessage();
        if (s != null && Debug.isOn("handshake")) {
            handshakeMessage.a(System.out);
        }
        handshakeMessage.write(this.e);
        this.e.flush();
        this.f = handshakeMessage.messageType();
    }

    protected abstract boolean canUseCipherSuite(String var1);

    protected abstract HandshakeMessage getKickstartMessage() throws SSLException;

    protected abstract void processMessage(byte var1, int var2) throws IOException, NoSuchAlgorithmException;

    abstract void b(byte var1) throws SSLProtocolException;

    abstract boolean a(int var1, boolean var2);

    boolean a(byte by, byte by2) {
        this.al = by;
        this.am = by2;
        try {
            if (by == 0) {
                switch (by2) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (!this.isEnabled("SSL_RSA_WITH_NULL_MD5")) {
                            return false;
                        }
                        if (!this.a(1, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = true;
                        ((CipherSpec)this).q = 1;
                        this.a(0);
                        this.b(1);
                        return true;
                    }
                    case 2: {
                        if (!this.isEnabled("SSL_RSA_WITH_NULL_SHA")) {
                            return false;
                        }
                        if (!this.a(1, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = true;
                        ((CipherSpec)this).q = 1;
                        this.a(0);
                        this.b(2);
                        return true;
                    }
                    case 3: {
                        if (!this.isEnabled("SSL_RSA_EXPORT_WITH_RC4_40_MD5")) {
                            return false;
                        }
                        if (!CipherRC4_40.e()) {
                            return false;
                        }
                        if (!this.a(2, true)) {
                            return false;
                        }
                        ((CipherSpec)this).h = true;
                        ((CipherSpec)this).q = 2;
                        this.a(1);
                        this.b(1);
                        return true;
                    }
                    case 4: {
                        if (!this.isEnabled("SSL_RSA_WITH_RC4_128_MD5")) {
                            return false;
                        }
                        if (!CipherRC4.e()) {
                            return false;
                        }
                        if (!this.a(1, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 1;
                        this.a(1);
                        this.b(1);
                        return true;
                    }
                    case 5: {
                        if (!this.isEnabled("SSL_RSA_WITH_RC4_128_SHA")) {
                            return false;
                        }
                        if (!CipherRC4.e()) {
                            return false;
                        }
                        if (!this.a(1, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 1;
                        this.a(1);
                        this.b(2);
                        return true;
                    }
                    case 9: {
                        if (!this.isEnabled("SSL_RSA_WITH_DES_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(1, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 1;
                        this.a(3);
                        this.b(2);
                        return true;
                    }
                    case 10: {
                        if (!this.isEnabled("SSL_RSA_WITH_3DES_EDE_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(1, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 1;
                        this.a(4);
                        this.b(2);
                        return true;
                    }
                    case 17: {
                        if (!this.isEnabled("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(6, true)) {
                            return false;
                        }
                        ((CipherSpec)this).h = true;
                        ((CipherSpec)this).q = 6;
                        this.a(5);
                        this.b(2);
                        return true;
                    }
                    case 18: {
                        if (!this.isEnabled("SSL_DHE_DSS_WITH_DES_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(6, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 6;
                        this.a(3);
                        this.b(2);
                        return true;
                    }
                    case 19: {
                        if (!this.isEnabled("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(6, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 6;
                        this.a(4);
                        this.b(2);
                        return true;
                    }
                    case 23: {
                        if (!this.isEnabled("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5")) {
                            return false;
                        }
                        if (!CipherRC4_40.e()) {
                            return false;
                        }
                        if (!this.a(7, true)) {
                            return false;
                        }
                        ((CipherSpec)this).h = true;
                        ((CipherSpec)this).q = 7;
                        this.a(1);
                        this.b(1);
                        return true;
                    }
                    case 24: {
                        if (!this.isEnabled("SSL_DH_anon_WITH_RC4_128_MD5")) {
                            return false;
                        }
                        if (!CipherRC4.e()) {
                            return false;
                        }
                        if (!this.a(7, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 7;
                        this.a(1);
                        this.b(1);
                        return true;
                    }
                    case 25: {
                        if (!this.isEnabled("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(7, true)) {
                            return false;
                        }
                        ((CipherSpec)this).h = true;
                        ((CipherSpec)this).q = 7;
                        this.a(5);
                        this.b(2);
                        return true;
                    }
                    case 26: {
                        if (!this.isEnabled("SSL_DH_anon_WITH_DES_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(7, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 7;
                        this.a(3);
                        this.b(2);
                        return true;
                    }
                    case 27: {
                        if (!this.isEnabled("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA")) {
                            return false;
                        }
                        if (!this.a(7, false)) {
                            return false;
                        }
                        ((CipherSpec)this).h = false;
                        ((CipherSpec)this).q = 7;
                        this.a(4);
                        this.b(2);
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendChangeCipherSpec(HandshakeMessage.Finished finished) throws IOException {
        this.e.flush();
        Object object = this.a.v;
        synchronized (object) {
            OutputRecord outputRecord = new OutputRecord(((CipherSpec)this).a, ((CipherSpec)this).b, 20);
            outputRecord.write(1);
            this.a.a(outputRecord);
            this.a.c();
            if (s != null && Debug.isOn("handshake")) {
                finished.a(System.out);
            }
            finished.write(this.e);
            this.e.flush();
        }
    }

    void a(byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2 = this.c(byArray);
        this.j.a(byArray2);
        this.b(byArray2);
    }

    private byte[] c(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
        byte[] byArray2 = new byte[48];
        if (s != null && Debug.isOn("keygen")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("SESSION KEYGEN:");
                System.out.println("PreMaster Secret:");
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (((CipherSpec)this).b == 0) {
            int n = 0;
            while (n < 3) {
                if (n != 0) {
                    messageDigest.reset();
                    messageDigest2.reset();
                }
                int n2 = 0;
                while (n2 <= n) {
                    messageDigest2.update((byte)(65 + n));
                    ++n2;
                }
                messageDigest2.update(byArray);
                messageDigest2.update(this.h.a);
                messageDigest2.update(this.i.a);
                messageDigest.update(byArray);
                messageDigest.update(messageDigest2.digest());
                System.arraycopy(messageDigest.digest(), 0, byArray2, 16 * n, 16);
                ++n;
            }
        } else {
            SunJSSE_v.a(byArray, "master secret", this.h.a, this.i.a, byArray2);
        }
        return byArray2;
    }

    void b(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        MessageDigest messageDigest2 = null;
        int n = this.ae.MAClen();
        int n2 = this.aa.a();
        int n3 = this.aa.c();
        int n4 = n + n2 + (((CipherSpec)this).h ? 0 : n3);
        byte[] byArray2 = new byte[n4 *= 2];
        if (((CipherSpec)this).b == 0) {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest2 = MessageDigest.getInstance("SHA");
            int n5 = 0;
            int n6 = n4;
            while (n6 > 0) {
                int n7 = 0;
                while (n7 <= n5) {
                    messageDigest2.update((byte)(65 + n5));
                    ++n7;
                }
                messageDigest2.update(byArray);
                messageDigest2.update(this.i.a);
                messageDigest2.update(this.h.a);
                messageDigest.update(byArray);
                messageDigest.update(messageDigest2.digest());
                System.arraycopy(messageDigest.digest(), 0, byArray2, n5 * 16, Math.min(n6, 16));
                messageDigest.reset();
                messageDigest2.reset();
                ++n5;
                n6 -= 16;
            }
        } else {
            SunJSSE_v.a(byArray, "key expansion", this.i.a, this.h.a, byArray2);
        }
        this.q = new byte[n];
        this.r = new byte[n];
        System.arraycopy(byArray2, 0, this.q, 0, n);
        System.arraycopy(byArray2, n, this.r, 0, n);
        this.m = new byte[n2];
        this.n = new byte[n2];
        System.arraycopy(byArray2, 2 * n, this.m, 0, n2);
        System.arraycopy(byArray2, 2 * n + n2, this.n, 0, n2);
        if (n3 != 0) {
            this.o = new byte[n3];
            this.p = new byte[n3];
            if (!((CipherSpec)this).h) {
                System.arraycopy(byArray2, 2 * (n + n2), this.o, 0, n3);
                System.arraycopy(byArray2, 2 * (n + n2) + n3, this.p, 0, n3);
            }
        } else {
            this.o = null;
            this.p = null;
        }
        if (((CipherSpec)this).h) {
            if (((CipherSpec)this).b == 0) {
                n2 = this.aa.b();
                messageDigest.reset();
                messageDigest.update(this.m);
                messageDigest.update(this.h.a);
                messageDigest.update(this.i.a);
                this.m = new byte[n2];
                System.arraycopy(messageDigest.digest(), 0, this.m, 0, n2);
                messageDigest.reset();
                messageDigest.update(this.n);
                messageDigest.update(this.i.a);
                messageDigest.update(this.h.a);
                this.n = new byte[n2];
                System.arraycopy(messageDigest.digest(), 0, this.n, 0, n2);
                if (n3 != 0) {
                    messageDigest.reset();
                    messageDigest.update(this.h.a);
                    messageDigest.update(this.i.a);
                    System.arraycopy(messageDigest.digest(), 0, this.o, 0, n3);
                    messageDigest.reset();
                    messageDigest.update(this.i.a);
                    messageDigest.update(this.h.a);
                    System.arraycopy(messageDigest.digest(), 0, this.p, 0, n3);
                }
            } else {
                n2 = this.aa.b();
                byte[] byArray3 = new byte[n2];
                SunJSSE_v.a(this.m, "client write key", this.h.a, this.i.a, byArray3);
                this.m = byArray3;
                byte[] byArray4 = new byte[n2];
                SunJSSE_v.a(this.n, "server write key", this.h.a, this.i.a, byArray4);
                this.n = byArray4;
                if (n3 != 0) {
                    byte[] byArray5 = new byte[2 * n3];
                    SunJSSE_v.a(null, "IV block", this.h.a, this.i.a, byArray5);
                    System.arraycopy(byArray5, 0, this.o, 0, n3);
                    System.arraycopy(byArray5, n3, this.p, 0, n3);
                }
            }
        }
        if (s != null && Debug.isOn("keygen")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                hexDumpEncoder.encodeBuffer(this.h.a, (OutputStream)System.out);
                System.out.println("Server Nonce:");
                hexDumpEncoder.encodeBuffer(this.i.a, (OutputStream)System.out);
                System.out.println("Master Secret:");
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
                System.out.println("Client MAC write Secret:");
                hexDumpEncoder.encodeBuffer(this.q, (OutputStream)System.out);
                System.out.println("Server MAC write Secret:");
                hexDumpEncoder.encodeBuffer(this.r, (OutputStream)System.out);
                System.out.println("Client write key:");
                hexDumpEncoder.encodeBuffer(this.m, (OutputStream)System.out);
                System.out.println("Server write key:");
                hexDumpEncoder.encodeBuffer(this.n, (OutputStream)System.out);
                if (this.o != null) {
                    System.out.println("Client write IV:");
                    hexDumpEncoder.encodeBuffer(this.o, (OutputStream)System.out);
                    System.out.println("Server write IV:");
                    hexDumpEncoder.encodeBuffer(this.p, (OutputStream)System.out);
                } else {
                    System.out.println("... no IV for cipher");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void a(byte by, byte by2, byte by3, boolean bl) throws IllegalArgumentException {
        ((CipherSpec)this).a = by;
        ((CipherSpec)this).b = by2;
        ((CipherSpec)this).c = by3;
        ((CipherSpec)this).d = bl;
        this.e.a(by, by2, by3);
        this.d.a(by, by2, by3, bl);
    }
}

