/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import sun.misc.BASE64Encoder;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.CertFileFilter;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateDialog;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

public class CertAllPanel
extends ActivatorSubPanel
implements ActionListener {
    private JList certList;
    private JButton removeButton;
    private JButton viewCertButton;
    private JButton exportButton;
    private JButton importButton;
    private String radioPos;
    private MessageHandler mh = new MessageHandler("cert");

    public CertAllPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.certList = new JList();
        this.certList.setSelectionMode(0);
        jPanel.add((Component)new JScrollPane(this.certList), "Center");
        this.removeButton = new JButton(this.mh.getMessage("remove_button"));
        this.removeButton.setMnemonic(82);
        this.removeButton.addActionListener(this);
        this.exportButton = new JButton(this.mh.getMessage("export_button"));
        this.exportButton.setMnemonic(69);
        this.exportButton.addActionListener(this);
        this.importButton = new JButton(this.mh.getMessage("import_button"));
        this.importButton.setMnemonic(73);
        this.importButton.addActionListener(this);
        this.viewCertButton = new JButton(this.mh.getMessage("details_button"));
        this.viewCertButton.setMnemonic(68);
        this.viewCertButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(this.importButton);
        jPanel2.add(this.exportButton);
        jPanel2.add(this.removeButton);
        jPanel2.add(this.viewCertButton);
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.certList.getSelectedIndex();
        String string = (String)this.certList.getSelectedValue();
        if (actionEvent.getSource() == this.removeButton) {
            if (this.getRadioPos() == this.mh.getMessage("SignedApplet_value")) {
                this.model.deactivateCertificate(string);
            } else {
                this.model.deactivateHttpsCertificate(string);
            }
            this.reset();
            return;
        }
        if (actionEvent.getSource() == this.viewCertButton) {
            X509Certificate x509Certificate = null;
            if (this.getRadioPos() == this.mh.getMessage("SignedApplet_value")) {
                x509Certificate = (X509Certificate)this.model.getCertificate(string);
            } else if (this.getRadioPos() == this.mh.getMessage("SecureSite_value")) {
                x509Certificate = (X509Certificate)this.model.getHttpsCertificate(string);
            } else if (this.getRadioPos() == this.mh.getMessage("SignerCA_value")) {
                x509Certificate = (X509Certificate)this.model.getRootCACertificate(string);
            } else if (this.getRadioPos() == this.mh.getMessage("SecureSiteCA_value")) {
                x509Certificate = (X509Certificate)this.model.getHttpsRootCACertificate(string);
            }
            Certificate[] certificateArray = new X509Certificate[]{x509Certificate};
            if (certificateArray.length > 0 && certificateArray[0] instanceof X509Certificate) {
                CertificateDialog certificateDialog = new CertificateDialog(certificateArray, 0);
                certificateDialog.DoModal();
                return;
            } else {
                X509Certificate x509Certificate2 = null;
                x509Certificate2 = this.getRadioPos() == this.mh.getMessage("SignedApplet_value") ? this.model.getImpCertificate(string) : this.model.getImpHttpsCertificate(string);
                Certificate[] certificateArray2 = new X509Certificate[]{x509Certificate2};
                CertificateDialog certificateDialog = new CertificateDialog(certificateArray2, 0);
                certificateDialog.DoModal();
            }
            return;
        }
        if (actionEvent.getSource() == this.importButton) {
            JFileChooser jFileChooser = new JFileChooser();
            CertFileFilter certFileFilter = new CertFileFilter();
            certFileFilter.addExtension("csr");
            certFileFilter.addExtension("p12");
            certFileFilter.setDescription("Certificate Files");
            jFileChooser.setFileFilter(certFileFilter);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogType(0);
            jFileChooser.setMultiSelectionEnabled(false);
            int n2 = jFileChooser.showOpenDialog(this);
            if (n2 == 0) {
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                try {
                    InputStream inputStream = System.in;
                    inputStream = new FileInputStream(file);
                    boolean bl = false;
                    bl = this.importCertificate(inputStream);
                    if (!bl) {
                        InputStream inputStream2 = System.in;
                        inputStream2 = new FileInputStream(file);
                        this.importPKCS12Certificate(inputStream2);
                    }
                }
                catch (Throwable throwable) {
                    Trace.printException(throwable);
                }
            }
            this.reset();
            return;
        }
        if (actionEvent.getSource() != this.exportButton) return;
        X509Certificate x509Certificate = null;
        if (this.getRadioPos() == this.mh.getMessage("SignedApplet_value")) {
            x509Certificate = (X509Certificate)this.model.getCertificate(string);
        } else if (this.getRadioPos() == this.mh.getMessage("SecureSite_value")) {
            x509Certificate = (X509Certificate)this.model.getHttpsCertificate(string);
        } else if (this.getRadioPos() == this.mh.getMessage("SignerCA_value")) {
            x509Certificate = (X509Certificate)this.model.getRootCACertificate(string);
        } else if (this.getRadioPos() == this.mh.getMessage("SecureSiteCA_value")) {
            x509Certificate = (X509Certificate)this.model.getHttpsRootCACertificate(string);
        }
        if (!(x509Certificate instanceof X509Certificate)) {
            x509Certificate = this.getRadioPos() == this.mh.getMessage("SignedApplet_value") ? this.model.getImpCertificate(string) : this.model.getImpHttpsCertificate(string);
        }
        if (x509Certificate != null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogType(1);
            jFileChooser.setMultiSelectionEnabled(false);
            int n3 = jFileChooser.showSaveDialog(this);
            if (n3 != 0) return;
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            PrintStream printStream = null;
            try {
                try {
                    printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                    this.exportCertificate(x509Certificate, printStream);
                }
                catch (Throwable throwable) {
                    Trace.printException(throwable);
                    Object var12_26 = null;
                    if (printStream == null) return;
                    printStream.close();
                    return;
                }
                Object var12_25 = null;
                if (printStream == null) return;
                printStream.close();
                return;
            }
            catch (Throwable throwable) {
                Object var12_27 = null;
                if (printStream == null) throw throwable;
                printStream.close();
                throw throwable;
            }
        } else {
            Object[] objectArray = new Object[]{CertAllPanel.getMessage("cert_export_dialog.caption")};
            DialogFactory.showMessageDialog(objectArray, CertAllPanel.getMessage("cert_export_dialog.title"));
        }
    }

    public void exportCertificate(X509Certificate x509Certificate, PrintStream printStream) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println("-----BEGIN CERTIFICATE-----");
        try {
            bASE64Encoder.encodeBuffer(x509Certificate.getEncoded(), (OutputStream)printStream);
        }
        catch (Throwable throwable) {
            Trace.printException(throwable);
        }
        printStream.println("-----END CERTIFICATE-----");
    }

    public void importPKCS12Certificate(InputStream inputStream) {
        block4: {
            KeyStore keyStore = null;
            String string = null;
            try {
                keyStore = KeyStore.getInstance("PKCS12");
                Object[] objectArray = new Object[]{CertAllPanel.getMessage("cert_password_dialog.caption")};
                string = DialogFactory.showInputDialog(objectArray, CertAllPanel.getMessage("cert_password_dialog.title"));
                char[] cArray = string.toCharArray();
                keyStore.load(inputStream, cArray);
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    X509Certificate x509Certificate = null;
                    String string2 = enumeration.nextElement();
                    x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
                    if (this.getRadioPos() == this.mh.getMessage("SignedApplet_value")) {
                        this.model.deactivateImpCertificate(x509Certificate);
                        continue;
                    }
                    if (this.getRadioPos() != this.mh.getMessage("SecureSite_value")) continue;
                    this.model.deactivateImpHttpsCertificate(x509Certificate);
                }
            }
            catch (Throwable throwable) {
                if (string == "uninitializedValue") break block4;
                Object[] objectArray = new Object[]{CertAllPanel.getMessage("import_password_dialog.caption")};
                DialogFactory.showMessageDialog(objectArray, CertAllPanel.getMessage("import_password_dialog.title"));
            }
        }
    }

    public boolean importCertificate(InputStream inputStream) {
        CertificateFactory certificateFactory = null;
        X509Certificate x509Certificate = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            if (this.getRadioPos() == this.mh.getMessage("SignedApplet_value")) {
                this.model.deactivateImpCertificate(x509Certificate);
            } else if (this.getRadioPos() == this.mh.getMessage("SecureSite_value")) {
                this.model.deactivateImpHttpsCertificate(x509Certificate);
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            return false;
        }
        catch (CertificateException certificateException) {
            Object[] objectArray = new Object[]{CertAllPanel.getMessage("import_format_dialog.caption")};
            DialogFactory.showMessageDialog(objectArray, CertAllPanel.getMessage("import_format_dialog.title"));
        }
        return true;
    }

    public void reset() {
        boolean bl;
        Collection collection = null;
        if (this.getRadioPos() == this.mh.getMessage("SignedApplet_value")) {
            collection = this.model.getCertificateAliases();
        } else if (this.getRadioPos() == this.mh.getMessage("SecureSite_value")) {
            collection = this.model.getHttpsCertificateAliases();
        } else if (this.getRadioPos() == this.mh.getMessage("SignerCA_value")) {
            collection = this.model.getRootCACertificateAliases();
        } else if (this.getRadioPos() == this.mh.getMessage("SecureSiteCA_value")) {
            collection = this.model.getHttpsRootCACertAliases();
        }
        if (collection == null || collection.size() == 0) {
            this.certList.setListData(new String[0]);
        } else {
            this.certList.setListData(collection.toArray());
        }
        boolean bl2 = bl = collection != null && collection.size() > 0;
        if (this.getRadioPos() == this.mh.getMessage("SignerCA_value") || this.getRadioPos() == this.mh.getMessage("SecureSiteCA_value")) {
            this.setEnabled(this.removeButton, false);
            this.setEnabled(this.exportButton, false);
            this.setEnabled(this.importButton, false);
            this.setEnabled(this.viewCertButton, bl);
        } else {
            this.setEnabled(this.removeButton, bl);
            this.setEnabled(this.exportButton, bl);
            this.setEnabled(this.importButton, true);
            this.setEnabled(this.viewCertButton, bl);
        }
        if (bl) {
            this.certList.setSelectedIndex(0);
        }
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }

    public void setRadioPos(String string) {
        this.radioPos = string;
    }

    private String getRadioPos() {
        if (this.radioPos == null) {
            return this.mh.getMessage("SignedApplet_value");
        }
        return this.radioPos;
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }
}

