/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;

public class SessionCertificateStore
implements CertificateStore {
    private Collection _certs = new HashSet();

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.loading"), 2);
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.loaded"), 2);
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.saving"), 2);
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.saved"), 2);
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.adding"), 2);
        this._certs.add(certificate);
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.added"), 2);
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.removing"), 2);
        this._certs.remove(certificate);
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.removed"), 2);
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.instore"), 2);
        return this._certs.contains(certificate);
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.canverify"), 2);
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("sessioncertstore.cert.iterator"), 2);
        return this._certs.iterator();
    }
}

