/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferUShort
extends DataBuffer {
    short[] data;
    short[][] bankdata;

    public DataBufferUShort(int n2) {
        super(1, n2);
        this.data = new short[n2];
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(int n2, int n3) {
        super(1, n2, n3);
        this.bankdata = new short[n3][];
        int n4 = 0;
        while (n4 < n3) {
            this.bankdata[n4] = new short[n2];
            ++n4;
        }
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[] sArray, int n2) {
        super(1, n2);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        this.data = sArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[] sArray, int n2, int n3) {
        super(1, n2, 1, n3);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        if (n2 + n3 > sArray.length) {
            throw new IllegalArgumentException("Length of dataArray is less  than size+offset.");
        }
        this.data = sArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[][] sArray, int n2) {
        super(1, n2, sArray.length);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        int n3 = 0;
        while (n3 < sArray.length) {
            if (sArray[n3] == null) {
                throw new NullPointerException("dataArray[" + n3 + "] is null");
            }
            ++n3;
        }
        this.bankdata = (short[][])sArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[][] sArray, int n2, int[] nArray) {
        super(1, n2, sArray.length, nArray);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        int n3 = 0;
        while (n3 < sArray.length) {
            if (sArray[n3] == null) {
                throw new NullPointerException("dataArray[" + n3 + "] is null");
            }
            if (n2 + nArray[n3] > sArray[n3].length) {
                throw new IllegalArgumentException("Length of dataArray[" + n3 + "] is less than size+" + "offsets[" + n3 + "].");
            }
            ++n3;
        }
        this.bankdata = (short[][])sArray.clone();
        this.data = this.bankdata[0];
    }

    public short[] getData() {
        return this.data;
    }

    public short[] getData(int n2) {
        return this.bankdata[n2];
    }

    public short[][] getBankData() {
        return (short[][])this.bankdata.clone();
    }

    public int getElem(int n2) {
        return this.data[n2 + this.offset] & 0xFFFF;
    }

    public int getElem(int n2, int n3) {
        return this.bankdata[n2][n3 + this.offsets[n2]] & 0xFFFF;
    }

    public void setElem(int n2, int n3) {
        this.data[n2 + this.offset] = (short)(n3 & 0xFFFF);
    }

    public void setElem(int n2, int n3, int n4) {
        this.bankdata[n2][n3 + this.offsets[n2]] = (short)(n4 & 0xFFFF);
    }
}

