/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos = 0;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    public CharArrayReader(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.pos = n2;
        this.count = Math.min(n2 + n3, cArray.length);
        this.markedPos = n2;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                this.ensureOpen();
                if (this.pos < this.count) break block4;
                int n2 = -1;
                return n2;
            }
            char c2 = this.buf[this.pos++];
            return c2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block10: {
                block9: {
                    block8: {
                        this.ensureOpen();
                        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        if (n3 != 0) break block8;
                        int n4 = 0;
                        return n4;
                    }
                    if (this.pos < this.count) break block9;
                    int n5 = -1;
                    return n5;
                }
                if (this.pos + n3 > this.count) {
                    n3 = this.count - this.pos;
                }
                if (n3 > 0) break block10;
                int n6 = 0;
                return n6;
            }
            System.arraycopy(this.buf, this.pos, cArray, n2, n3);
            this.pos += n3;
            int n7 = n3;
            return n7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                this.ensureOpen();
                if ((long)this.pos + l2 > (long)this.count) {
                    l2 = this.count - this.pos;
                }
                if (l2 >= 0L) break block5;
                long l3 = 0L;
                return l3;
            }
            this.pos = (int)((long)this.pos + l2);
            long l4 = l2;
            return l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl2 = this.count - this.pos > 0;
            return bl2;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.markedPos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.pos = this.markedPos;
        }
    }

    public void close() {
        this.buf = null;
    }
}

