/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = Class.getPrimitiveClass("long");
    private long value;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long l2, int n2) {
        boolean bl2;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        char[] cArray = new char[65];
        int n3 = 64;
        boolean bl3 = bl2 = l2 < 0L;
        if (!bl2) {
            l2 = -l2;
        }
        while (l2 <= (long)(-n2)) {
            cArray[n3--] = Integer.digits[(int)(-(l2 % (long)n2))];
            l2 /= (long)n2;
        }
        cArray[n3] = Integer.digits[(int)(-l2)];
        if (bl2) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 65 - n3);
    }

    public static String toHexString(long l2) {
        return Long.toUnsignedString(l2, 4);
    }

    public static String toOctalString(long l2) {
        return Long.toUnsignedString(l2, 3);
    }

    public static String toBinaryString(long l2) {
        return Long.toUnsignedString(l2, 1);
    }

    private static String toUnsignedString(long l2, int n2) {
        char[] cArray = new char[64];
        int n3 = 64;
        int n4 = 1 << n2;
        long l3 = n4 - 1;
        do {
            cArray[--n3] = Integer.digits[(int)(l2 & l3)];
        } while ((l2 >>>= n2) != 0L);
        return new String(cArray, n3, 64 - n3);
    }

    public static String toString(long l2) {
        return Long.toString(l2, 10);
    }

    public static long parseLong(String string, int n2) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n2 < 2) {
            throw new NumberFormatException("radix " + n2 + " less than Character.MIN_RADIX");
        }
        if (n2 > 36) {
            throw new NumberFormatException("radix " + n2 + " greater than Character.MAX_RADIX");
        }
        long l2 = 0L;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = string.length();
        if (n4 > 0) {
            int n5;
            long l3;
            if (string.charAt(0) == '-') {
                bl2 = true;
                l3 = Long.MIN_VALUE;
                ++n3;
            } else {
                l3 = -9223372036854775807L;
            }
            long l4 = l3 / (long)n2;
            if (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n2)) < 0) {
                    throw new NumberFormatException(string);
                }
                l2 = -n5;
            }
            while (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n2)) < 0) {
                    throw new NumberFormatException(string);
                }
                if (l2 < l4) {
                    throw new NumberFormatException(string);
                }
                if ((l2 *= (long)n2) < l3 + (long)n5) {
                    throw new NumberFormatException(string);
                }
                l2 -= (long)n5;
            }
        } else {
            throw new NumberFormatException(string);
        }
        if (bl2) {
            if (n3 > 1) {
                return l2;
            }
            throw new NumberFormatException(string);
        }
        return -l2;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static Long valueOf(String string, int n2) throws NumberFormatException {
        return new Long(Long.parseLong(string, n2));
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return new Long(Long.parseLong(string, 10));
    }

    public static Long decode(String string) throws NumberFormatException {
        Long l2;
        int n2 = 10;
        int n3 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            l2 = Long.valueOf(string.substring(n3), n2);
            l2 = bl2 ? new Long(-l2.longValue()) : l2;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl2 ? new String("-" + string.substring(n3)) : string.substring(n3);
            l2 = Long.valueOf(string2, n2);
        }
        return l2;
    }

    public Long(long l2) {
        this.value = l2;
    }

    public Long(String string) throws NumberFormatException {
        this.value = Long.parseLong(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.value == (Long)object;
        }
        return false;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, long l2) {
        Long l3 = Long.getLong(string, null);
        return l3 == null ? new Long(l2) : l3;
    }

    public static Long getLong(String string, Long l2) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Long.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    public int compareTo(Long l2) {
        long l3 = this.value;
        long l4 = l2.value;
        return l3 < l4 ? -1 : (l3 == l4 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Long)object);
    }
}

