/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractSpinnerModel;

public class SpinnerDateModel
extends AbstractSpinnerModel
implements Serializable {
    private Comparable start;
    private Comparable end;
    private Calendar value;
    private int calendarField;

    private boolean calendarFieldOK(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public SpinnerDateModel(Date date, Comparable comparable, Comparable comparable2, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!this.calendarFieldOK(n2)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (comparable != null && comparable.compareTo(date) > 0 || comparable2 != null && comparable2.compareTo(date) < 0) {
            throw new IllegalArgumentException("(start <= value <= end) is false");
        }
        this.value = Calendar.getInstance();
        this.start = comparable;
        this.end = comparable2;
        this.calendarField = n2;
        this.value.setTime(date);
    }

    public SpinnerDateModel() {
        this(new Date(), null, null, 5);
    }

    public void setStart(Comparable comparable) {
        if (comparable == null ? this.start != null : !comparable.equals(this.start)) {
            this.start = comparable;
            this.fireStateChanged();
        }
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setEnd(Comparable comparable) {
        if (comparable == null ? this.end != null : !comparable.equals(this.end)) {
            this.end = comparable;
            this.fireStateChanged();
        }
    }

    public Comparable getEnd() {
        return this.end;
    }

    public void setCalendarField(int n2) {
        if (!this.calendarFieldOK(n2)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (n2 != this.calendarField) {
            this.calendarField = n2;
            this.fireStateChanged();
        }
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public Object getNextValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.value.getTime());
        calendar.add(this.calendarField, 1);
        Date date = calendar.getTime();
        return this.end == null || this.end.compareTo(date) >= 0 ? date : null;
    }

    public Object getPreviousValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.value.getTime());
        calendar.add(this.calendarField, -1);
        Date date = calendar.getTime();
        return this.start == null || this.start.compareTo(date) <= 0 ? date : null;
    }

    public Date getDate() {
        return this.value.getTime();
    }

    public Object getValue() {
        return this.value.getTime();
    }

    public void setValue(Object object) {
        if (object == null || !(object instanceof Date)) {
            throw new IllegalArgumentException("null value");
        }
        if (!object.equals(this.value.getTime())) {
            this.value.setTime((Date)object);
            this.fireStateChanged();
        }
    }
}

