/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDragGestureRecognizer;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private PropertyChangeListener propertyChangeListener;
    private static final TableDragGestureRecognizer defaultDragRecognizer = new TableDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TableTransferHandler();

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        TransferHandler transferHandler;
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
        if ((transferHandler = this.table.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.table.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.table.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TableDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(defaultDragRecognizer);
        this.table.addMouseMotionListener(defaultDragRecognizer);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.table, actionMap);
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("Table.ancestorInputMap");
            if (this.table.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("Table.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Table.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Table.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectNextColumn", new NavigationalAction(1, 0, false, false, false));
        actionMapUIResource.put("selectPreviousColumn", new NavigationalAction(-1, 0, false, false, false));
        actionMapUIResource.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        actionMapUIResource.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        actionMapUIResource.put("selectNextColumnExtendSelection", new NavigationalAction(1, 0, false, true, false));
        actionMapUIResource.put("selectPreviousColumnExtendSelection", new NavigationalAction(-1, 0, false, true, false));
        actionMapUIResource.put("selectNextRowExtendSelection", new NavigationalAction(0, 1, false, true, false));
        actionMapUIResource.put("selectPreviousRowExtendSelection", new NavigationalAction(0, -1, false, true, false));
        actionMapUIResource.put("scrollUpChangeSelection", new PagingAction(false, false, true, false));
        actionMapUIResource.put("scrollDownChangeSelection", new PagingAction(false, true, true, false));
        actionMapUIResource.put("selectFirstColumn", new PagingAction(false, false, false, true));
        actionMapUIResource.put("selectLastColumn", new PagingAction(false, true, false, false));
        actionMapUIResource.put("scrollUpExtendSelection", new PagingAction(true, false, true, false));
        actionMapUIResource.put("scrollDownExtendSelection", new PagingAction(true, true, true, false));
        actionMapUIResource.put("selectFirstColumnExtendSelection", new PagingAction(true, false, false, true));
        actionMapUIResource.put("selectLastColumnExtendSelection", new PagingAction(true, true, false, false));
        actionMapUIResource.put("selectFirstRow", new PagingAction(false, false, true, true));
        actionMapUIResource.put("selectLastRow", new PagingAction(false, true, true, true));
        actionMapUIResource.put("selectFirstRowExtendSelection", new PagingAction(true, false, true, true));
        actionMapUIResource.put("selectLastRowExtendSelection", new PagingAction(true, true, true, true));
        actionMapUIResource.put("selectNextColumnCell", new NavigationalAction(1, 0, true, false, true));
        actionMapUIResource.put("selectPreviousColumnCell", new NavigationalAction(-1, 0, true, false, true));
        actionMapUIResource.put("selectNextRowCell", new NavigationalAction(0, 1, true, false, true));
        actionMapUIResource.put("selectPreviousRowCell", new NavigationalAction(0, -1, true, false, true));
        actionMapUIResource.put("selectAll", new SelectAllAction());
        actionMapUIResource.put("cancel", new CancelEditingAction());
        actionMapUIResource.put("startEditing", new StartEditingAction());
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        if (this.table.getComponentOrientation().isLeftToRight()) {
            actionMapUIResource.put("scrollLeftChangeSelection", new PagingAction(false, false, false, false));
            actionMapUIResource.put("scrollRightChangeSelection", new PagingAction(false, true, false, false));
            actionMapUIResource.put("scrollLeftExtendSelection", new PagingAction(true, false, false, false));
            actionMapUIResource.put("scrollRightExtendSelection", new PagingAction(true, true, false, false));
        } else {
            actionMapUIResource.put("scrollLeftChangeSelection", new PagingAction(false, true, false, false));
            actionMapUIResource.put("scrollRightChangeSelection", new PagingAction(false, false, false, false));
            actionMapUIResource.put("scrollLeftExtendSelection", new PagingAction(true, true, false, false));
            actionMapUIResource.put("scrollRightExtendSelection", new PagingAction(true, false, false, false));
        }
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(defaultDragRecognizer);
        this.table.removeMouseMotionListener(defaultDragRecognizer);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    private Dimension createTableSize(long l2) {
        long l3;
        int n2 = 0;
        int n3 = this.table.getRowCount();
        if (n3 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n3 - 1, 0, true);
            n2 = rectangle.y + rectangle.height;
        }
        if ((l3 = Math.abs(l2)) > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l3, n2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l2);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl2;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.rowAtPoint(point2);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        int n4 = this.table.columnAtPoint((bl2 = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n5 = this.table.columnAtPoint(bl2 ? point2 : point);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n2, n3, n4, n5);
        this.paintCells(graphics, n2, n3, n4, n5);
    }

    private void paintGrid(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n5, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        if (this.table.getShowHorizontalLines()) {
            int n8 = rectangle3.x + rectangle3.width;
            n7 = rectangle3.y;
            n6 = n2;
            while (n6 <= n3) {
                graphics.drawLine(rectangle3.x, (n7 += this.table.getRowHeight(n6)) - 1, n8 - 1, n7 - 1);
                ++n6;
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n7 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n6 = rectangle3.x;
                int n9 = n4;
                while (n9 <= n5) {
                    int n10 = tableColumnModel.getColumn(n9).getWidth();
                    graphics.drawLine((n6 += n10) - 1, 0, n6 - 1, n7 - 1);
                    ++n9;
                }
            } else {
                n6 = rectangle3.x + rectangle3.width;
                int n11 = n4;
                while (n11 < n5) {
                    int n12 = tableColumnModel.getColumn(n11).getWidth();
                    graphics.drawLine((n6 -= n12) - 1, 0, n6 - 1, n7 - 1);
                    ++n11;
                }
                graphics.drawLine(n6 -= tableColumnModel.getColumn(n5).getWidth(), 0, n6, n7 - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n2 = 0;
        while (n2 < tableColumnModel.getColumnCount()) {
            if (tableColumnModel.getColumn(n2) == tableColumn) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n2, int n3, int n4, int n5) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            int n7 = n2;
            while (n7 <= n3) {
                Rectangle rectangle = this.table.getCellRect(n7, n4, false);
                int n8 = n4;
                while (n8 <= n5) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n8);
                    int n9 = tableColumn2.getWidth();
                    rectangle.width = n9 - n6;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, n7, n8);
                    }
                    rectangle.x += n9;
                    ++n8;
                }
                ++n7;
            }
        } else {
            int n10 = n2;
            while (n10 <= n3) {
                int n11;
                Rectangle rectangle = this.table.getCellRect(n10, n4, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n4);
                if (tableColumn3 != tableColumn) {
                    n11 = tableColumn3.getWidth();
                    rectangle.width = n11 - n6;
                    this.paintCell(graphics, rectangle, n10, n4);
                }
                int n12 = n4 + 1;
                while (n12 <= n5) {
                    tableColumn3 = tableColumnModel.getColumn(n12);
                    n11 = tableColumn3.getWidth();
                    rectangle.width = n11 - n6;
                    rectangle.x -= n11;
                    if (tableColumn3 != tableColumn) {
                        this.paintCell(graphics, rectangle, n10, n12);
                    }
                    ++n12;
                }
                ++n10;
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n2, n3, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n2, int n3, TableColumn tableColumn, int n4) {
        int n5;
        int n6;
        int n7 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n2, n7, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n7, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n4;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n6 = rectangle3.x;
            int n8 = rectangle3.y;
            int n9 = n6 + rectangle3.width - 1;
            n5 = n8 + rectangle3.height - 1;
            graphics.drawLine(n6 - 1, n8, n6 - 1, n5);
            graphics.drawLine(n9, n8, n9, n5);
        }
        n6 = n2;
        while (n6 <= n3) {
            Rectangle rectangle4 = this.table.getCellRect(n6, n7, false);
            rectangle4.x += n4;
            this.paintCell(graphics, rectangle4, n6, n7);
            if (this.table.getShowHorizontalLines()) {
                graphics.setColor(this.table.getGridColor());
                Rectangle rectangle5 = this.table.getCellRect(n6, n7, true);
                rectangle5.x += n4;
                n5 = rectangle5.x;
                int n10 = rectangle5.y;
                int n11 = n5 + rectangle5.width - 1;
                int n12 = n10 + rectangle5.height - 1;
                graphics.drawLine(n5, n12, n11, n12);
            }
            ++n6;
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
            Component component = this.table.prepareRenderer(tableCellRenderer, n2, n3);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DropTarget dropTarget;
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation")) {
                InputMap inputMap = BasicTableUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(BasicTableUI.this.table, 1, inputMap);
                UIManager.getLookAndFeelDefaults().put("Table.actionMap", null);
                ActionMap actionMap = BasicTableUI.this.getActionMap();
                SwingUtilities.replaceUIActionMap(BasicTableUI.this.table, actionMap);
                JTableHeader jTableHeader = BasicTableUI.this.table.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.setComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                }
            } else if ("transferHandler".equals(string) && (dropTarget = BasicTableUI.this.table.getDropTarget()) instanceof UIResource) {
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TableDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                int n2;
                int n3;
                JTable jTable = (JTable)jComponent;
                int[] nArray = jTable.getSelectedRows();
                int[] nArray2 = jTable.getSelectedColumns();
                if (!jTable.getRowSelectionAllowed()) {
                    n3 = jTable.getRowCount();
                    nArray = new int[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        nArray[n2] = n2;
                        ++n2;
                    }
                }
                if (!jTable.getColumnSelectionAllowed()) {
                    n3 = jTable.getColumnCount();
                    nArray2 = new int[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        nArray2[n2] = n2;
                        ++n2;
                    }
                }
                return new TableTransferable(jTable, nArray, nArray2);
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        static class TableTransferable
        extends BasicTransferable {
            private int[] rows;
            private int[] cols;
            private JTable table;

            TableTransferable(JTable jTable, int[] nArray, int[] nArray2) {
                this.rows = nArray;
                this.cols = nArray2;
                this.table = jTable;
            }

            protected boolean isPlainSupported() {
                return this.isValid();
            }

            protected String getPlainData() {
                if (!this.isValid()) {
                    return "";
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < this.rows.length) {
                    int n3 = 0;
                    while (n3 < this.cols.length) {
                        Object object;
                        if (n3 > 0) {
                            stringBuffer.append("\t");
                        }
                        object = (object = this.table.getValueAt(this.rows[n2], this.cols[n3])) == null ? "" : object.toString();
                        stringBuffer.append(object);
                        ++n3;
                    }
                    stringBuffer.append("\n");
                    ++n2;
                }
                return stringBuffer.toString();
            }

            protected boolean isHTMLSupported() {
                return this.isValid();
            }

            protected String getHTMLData() {
                if (!this.isValid()) {
                    return "";
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>\n<table>");
                stringBuffer.append("\n<tr>");
                int n2 = 0;
                while (n2 < this.cols.length) {
                    stringBuffer.append("\n  <th id=" + this.cols[n2] + ">" + this.table.getColumnName(this.cols[n2]));
                    ++n2;
                }
                int n3 = 0;
                while (n3 < this.rows.length) {
                    stringBuffer.append("\n<tr id=" + this.rows[n3] + ">");
                    int n4 = 0;
                    while (n4 < this.cols.length) {
                        Object object = this.table.getValueAt(this.rows[n3], this.cols[n4]);
                        stringBuffer.append("\n  <td>" + object.toString());
                        ++n4;
                    }
                    ++n3;
                }
                stringBuffer.append("\n</table>\n</html>");
                return stringBuffer.toString();
            }

            private boolean isValid() {
                if (this.rows != null) {
                    int n2 = this.table.getRowCount();
                    int n3 = 0;
                    while (n3 < this.rows.length) {
                        if (this.rows[n3] >= n2) {
                            this.rows = null;
                            this.cols = null;
                            break;
                        }
                        ++n3;
                    }
                    if (this.cols != null) {
                        int n4 = this.table.getColumnCount();
                        int n5 = 0;
                        while (n5 < this.cols.length) {
                            if (this.cols[n5] >= n4) {
                                this.rows = null;
                                this.cols = null;
                                break;
                            }
                            ++n5;
                        }
                    }
                }
                return this.rows != null;
            }
        }
    }

    static class TableDropTargetListener
    extends BasicDropTargetListener {
        private int[] rows;
        private int[] cols;

        TableDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            this.rows = jTable.getSelectedRows();
            this.cols = jTable.getSelectedColumns();
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            jTable.clearSelection();
            int n2 = 0;
            while (n2 < this.rows.length) {
                jTable.addRowSelectionInterval(this.rows[n2], this.rows[n2]);
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.cols.length) {
                jTable.addColumnSelectionInterval(this.cols[n3], this.cols[n3]);
                ++n3;
            }
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTable jTable = (JTable)jComponent;
            int n2 = jTable.rowAtPoint(point);
            int n3 = jTable.columnAtPoint(point);
            if (n2 != -1) {
                jTable.setRowSelectionInterval(n2, n2);
            }
            if (n3 != -1) {
                jTable.setColumnSelectionInterval(n3, n3);
            }
        }
    }

    static class TableDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        TableDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            JTable jTable;
            if (super.isDragPossible(mouseEvent) && (jTable = (JTable)this.getComponent(mouseEvent)).getDragEnabled()) {
                Point point = mouseEvent.getPoint();
                int n2 = jTable.rowAtPoint(point);
                int n3 = jTable.columnAtPoint(point);
                if (n3 != -1 && n2 != -1 && jTable.isCellSelected(n2, n3)) {
                    return true;
                }
            }
            return false;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = BasicTableUI.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(BasicTableUI.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !BasicTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void setValueIsAdjusting(boolean bl2) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl2);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl2);
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !BasicTableUI.this.table.isEnabled();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n2 = BasicTableUI.this.table.rowAtPoint(point);
            int n3 = BasicTableUI.this.table.columnAtPoint(point);
            if (n3 == -1 || n2 == -1) {
                return;
            }
            if (BasicTableUI.this.table.editCellAt(n2, n3, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else if (BasicTableUI.this.table.isRequestFocusEnabled()) {
                BasicTableUI.this.table.requestFocus();
            }
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                boolean bl2 = mouseEvent.getID() == 501;
                this.setValueIsAdjusting(bl2);
                BasicTableUI.this.table.changeSelection(n2, n3, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                int n2 = BasicTableUI.this.table.rowAtPoint(point);
                int n3 = BasicTableUI.this.table.columnAtPoint(point);
                if (n3 == -1 || n2 == -1) {
                    return;
                }
                BasicTableUI.this.table.changeSelection(n2, n3, false, true);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int n2 = BasicTableUI.this.table.getRowCount();
            int n3 = BasicTableUI.this.table.getColumnCount();
            int n4 = BasicTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n5 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n4 < 0 || n4 >= n2 || n5 < 0 || n5 >= n3) {
                return;
            }
            Rectangle rectangle = BasicTableUI.this.table.getCellRect(n4, n5, false);
            BasicTableUI.this.table.repaint(rectangle);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            InputMap inputMap = BasicTableUI.this.table.getInputMap(0);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            inputMap = BasicTableUI.this.table.getInputMap(1);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            int n2 = BasicTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n3 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n2 != -1 && n3 != -1 && !BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.editCellAt(n2, n3)) {
                return;
            }
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && component != null && component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                inputMap = jComponent.getInputMap(0);
                Object object2 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                if (object == null) {
                    inputMap = jComponent.getInputMap(1);
                    Object object3 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                }
                if (object != null) {
                    Action action;
                    ActionMap actionMap = jComponent.getActionMap();
                    Action action2 = action = actionMap != null ? actionMap.get(object) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers())) {
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (!jTable.hasFocus()) {
                TableCellEditor tableCellEditor = jTable.getCellEditor();
                if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                    return;
                }
                jTable.requestFocus();
                return;
            }
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            int n2 = listSelectionModel.getAnchorSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            int n3 = listSelectionModel2.getAnchorSelectionIndex();
            jTable.editCellAt(n2, n3);
            Component component = jTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    private static class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            jTable.removeEditor();
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            jTable.selectAll();
        }
    }

    private static class PagingAction
    extends NavigationalAction {
        private boolean forwards;
        private boolean vertically;
        private boolean toLimit;

        private PagingAction(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            super(0, 0, false, bl2, false);
            this.forwards = bl3;
            this.vertically = bl4;
            this.toLimit = bl5;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (this.toLimit) {
                if (this.vertically) {
                    int n2 = jTable.getRowCount();
                    this.dx = 0;
                    this.dy = this.forwards ? n2 : -n2;
                } else {
                    int n3 = jTable.getColumnCount();
                    this.dx = this.forwards ? n3 : -n3;
                    this.dy = 0;
                }
            } else {
                int n4;
                if (!(jTable.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension dimension = jTable.getParent().getSize();
                ListSelectionModel listSelectionModel = this.vertically ? jTable.getSelectionModel() : jTable.getColumnModel().getSelectionModel();
                int n5 = n4 = this.extend ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getAnchorSelectionIndex();
                if (this.vertically) {
                    Rectangle rectangle = jTable.getCellRect(n4, 0, true);
                    rectangle.y = rectangle.y + (this.forwards ? dimension.height : -dimension.height);
                    this.dx = 0;
                    int n6 = jTable.rowAtPoint(rectangle.getLocation());
                    if (n6 == -1 && this.forwards) {
                        n6 = jTable.getRowCount();
                    }
                    this.dy = n6 - n4;
                } else {
                    Rectangle rectangle = jTable.getCellRect(0, n4, true);
                    rectangle.x = rectangle.x + (this.forwards ? dimension.width : -dimension.width);
                    int n7 = jTable.columnAtPoint(rectangle.getLocation());
                    if (n7 == -1 && this.forwards) {
                        n7 = jTable.getColumnCount();
                    }
                    this.dx = n7 - n4;
                    this.dy = 0;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        protected NavigationalAction(int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
            this.dx = n2;
            this.dy = n3;
            this.toggle = bl2;
            this.extend = bl3;
            this.inSelection = bl4;
        }

        private int clipToRange(int n2, int n3, int n4) {
            return Math.min(Math.max(n2, n3), n4 - 1);
        }

        private void moveWithinTableRange(JTable jTable, int n2, int n3, boolean bl2) {
            if (bl2) {
                this.leadRow = this.clipToRange(this.leadRow + n3, 0, jTable.getRowCount());
                this.leadColumn = this.clipToRange(this.leadColumn + n2, 0, jTable.getColumnCount());
            } else {
                this.anchorRow = this.clipToRange(this.anchorRow + n3, 0, jTable.getRowCount());
                this.anchorColumn = this.clipToRange(this.anchorColumn + n2, 0, jTable.getColumnCount());
            }
        }

        private int selectionSpan(ListSelectionModel listSelectionModel) {
            return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        }

        private int compare(int n2, ListSelectionModel listSelectionModel) {
            return this.compare(n2, listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex() + 1);
        }

        private int compare(int n2, int n3, int n4) {
            return n2 < n3 ? -1 : (n2 >= n4 ? 1 : 0);
        }

        private boolean moveWithinSelectedRange(JTable jTable, int n2, int n3, boolean bl2) {
            int n4;
            int n5;
            int n6;
            boolean bl3;
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            int n7 = this.anchorRow + n3;
            int n8 = this.anchorColumn + n2;
            int n9 = this.selectionSpan(listSelectionModel);
            boolean bl4 = bl3 = n9 * (n6 = this.selectionSpan(listSelectionModel2)) > 1;
            if (bl3) {
                n5 = this.compare(n7, listSelectionModel);
                n4 = this.compare(n8, listSelectionModel2);
            } else {
                n9 = jTable.getRowCount();
                n6 = jTable.getColumnCount();
                n5 = this.compare(n7, 0, n9);
                n4 = this.compare(n8, 0, n6);
            }
            this.anchorRow = n7 - n9 * n5;
            this.anchorColumn = n8 - n6 * n4;
            if (!bl2) {
                return this.moveWithinSelectedRange(jTable, n5, n4, true);
            }
            return bl3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            int n2 = this.anchorRow;
            int n3 = this.anchorColumn;
            if (jTable.isEditing() && !jTable.getCellEditor().stopCellEditing()) {
                return;
            }
            if (!this.inSelection) {
                this.moveWithinTableRange(jTable, this.dx, this.dy, this.extend);
                if (!this.extend) {
                    jTable.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(jTable, this.dx, this.dy, false)) {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, true, true);
            } else {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, false, false);
            }
        }
    }
}

