/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xml.dtm.ref.DTMNodeProxy;

public class PrintTraceListener
implements TraceListener {
    PrintWriter m_pw;
    public boolean m_traceTemplates = false;
    public boolean m_traceElements = false;
    public boolean m_traceGeneration = false;
    public boolean m_traceSelection = false;

    public PrintTraceListener(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    public void trace(TracerEvent tracerEvent) {
        switch (tracerEvent.m_styleNode.getXSLToken()) {
            case 78: {
                if (!this.m_traceElements) break;
                this.m_pw.print(tracerEvent.m_styleNode.getSystemId() + " Line #" + tracerEvent.m_styleNode.getLineNumber() + ", " + "Column #" + tracerEvent.m_styleNode.getColumnNumber() + " -- " + tracerEvent.m_styleNode.getNodeName() + ": ");
                ElemTextLiteral elemTextLiteral = (ElemTextLiteral)tracerEvent.m_styleNode;
                String string = new String(elemTextLiteral.getChars(), 0, elemTextLiteral.getChars().length);
                this.m_pw.println("    " + string.trim());
                break;
            }
            case 19: {
                if (!this.m_traceTemplates && !this.m_traceElements) break;
                ElemTemplate elemTemplate = (ElemTemplate)tracerEvent.m_styleNode;
                this.m_pw.print(elemTemplate.getSystemId() + " Line #" + elemTemplate.getLineNumber() + ", " + "Column #" + elemTemplate.getColumnNumber() + ": " + elemTemplate.getNodeName() + " ");
                if (null != elemTemplate.getMatch()) {
                    this.m_pw.print("match='" + elemTemplate.getMatch().getPatternString() + "' ");
                }
                if (null != elemTemplate.getName()) {
                    this.m_pw.print("name='" + elemTemplate.getName() + "' ");
                }
                this.m_pw.println();
                break;
            }
            default: {
                if (!this.m_traceElements) break;
                this.m_pw.println(tracerEvent.m_styleNode.getSystemId() + " Line #" + tracerEvent.m_styleNode.getLineNumber() + ", " + "Column #" + tracerEvent.m_styleNode.getColumnNumber() + ": " + tracerEvent.m_styleNode.getNodeName());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void selected(SelectionEvent var1_1) throws TransformerException {
        block11: {
            block12: {
                if (!this.m_traceSelection) break block11;
                var2_2 = var1_1.m_styleNode;
                var3_3 = var1_1.m_sourceNode;
                var4_4 = ((DTMNodeProxy)var3_3).getDTMNodeNumber();
                var5_5 = ((DTMNodeProxy)var3_3).getDTM().getSourceLocatorFor(var4_4);
                if (var5_5 != null) {
                    this.m_pw.println("Selected source node '" + var3_3.getNodeName() + "', at " + var5_5);
                }
                if (var1_1.m_styleNode.getLineNumber() == 0) {
                    var6_6 = var2_2.getParentElem();
                    if (var6_6 == var2_2.getStylesheetRoot().getDefaultRootRule()) {
                        this.m_pw.print("(default root rule) ");
                    } else if (var6_6 == var2_2.getStylesheetRoot().getDefaultTextRule()) {
                        this.m_pw.print("(default text rule) ");
                    } else if (var6_6 == var2_2.getStylesheetRoot().getDefaultRule()) {
                        this.m_pw.print("(default rule) ");
                    }
                    this.m_pw.print(var2_2.getNodeName() + ", " + var1_1.m_attributeName + "='" + var1_1.m_xpath.getPatternString() + "': ");
                } else {
                    this.m_pw.print(var1_1.m_styleNode.getSystemId() + " Line #" + var1_1.m_styleNode.getLineNumber() + ", " + "Column #" + var1_1.m_styleNode.getColumnNumber() + ": " + var2_2.getNodeName() + ", " + var1_1.m_attributeName + "='" + var1_1.m_xpath.getPatternString() + "': ");
                }
                if (var1_1.m_selection.getType() != 4) break block12;
                this.m_pw.println();
                var6_6 = var1_1.m_selection.iter();
                try {
                    var6_6 = var6_6.cloneWithReset();
                }
                catch (CloneNotSupportedException var7_7) {
                    this.m_pw.println("     [Can't trace nodelist because it it threw a CloneNotSupportedException]");
                    return;
                }
                var7_8 = var6_6.nextNode();
                if (-1 != var7_8) ** GOTO lbl41
                this.m_pw.println("     [empty node list]");
                break block11;
lbl-1000:
                // 1 sources

                {
                    var8_9 = var1_1.m_processor.getXPathContext().getDTM(var7_8);
                    this.m_pw.print("     ");
                    this.m_pw.print(Integer.toHexString(var7_8));
                    this.m_pw.print(": ");
                    this.m_pw.println(var8_9.getNodeName(var7_8));
                    var7_8 = var6_6.nextNode();
lbl41:
                    // 2 sources

                    ** while (-1 != var7_8)
                }
lbl42:
                // 1 sources

                break block11;
            }
            this.m_pw.println(var1_1.m_selection.str());
        }
    }

    public void generated(GenerateEvent generateEvent) {
        if (this.m_traceGeneration) {
            switch (generateEvent.m_eventtype) {
                case 1: {
                    this.m_pw.println("STARTDOCUMENT");
                    break;
                }
                case 2: {
                    this.m_pw.println("ENDDOCUMENT");
                    break;
                }
                case 3: {
                    this.m_pw.println("STARTELEMENT: " + generateEvent.m_name);
                    break;
                }
                case 4: {
                    this.m_pw.println("ENDELEMENT: " + generateEvent.m_name);
                    break;
                }
                case 5: {
                    String string = new String(generateEvent.m_characters, generateEvent.m_start, generateEvent.m_length);
                    this.m_pw.println("CHARACTERS: " + string);
                    break;
                }
                case 10: {
                    String string = new String(generateEvent.m_characters, generateEvent.m_start, generateEvent.m_length);
                    this.m_pw.println("CDATA: " + string);
                    break;
                }
                case 8: {
                    this.m_pw.println("COMMENT: " + generateEvent.m_data);
                    break;
                }
                case 7: {
                    this.m_pw.println("PI: " + generateEvent.m_name + ", " + generateEvent.m_data);
                    break;
                }
                case 9: {
                    this.m_pw.println("ENTITYREF: " + generateEvent.m_name);
                    break;
                }
                case 6: {
                    this.m_pw.println("IGNORABLEWHITESPACE");
                }
            }
        }
    }
}

