/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;

public class WalkingIterator
extends LocPathIterator {
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;

    WalkingIterator(Compiler compiler, int n2, int n3, boolean bl2) throws TransformerException {
        super(compiler, n2, n3, bl2);
        int n4 = Compiler.getFirstChildPos(n2);
        if (bl2) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, n4, 0);
        }
    }

    protected WalkingIterator(PrefixResolver prefixResolver) {
        super(prefixResolver);
    }

    public Object clone() throws CloneNotSupportedException {
        WalkingIterator walkingIterator = (WalkingIterator)super.clone();
        if (null != this.m_firstWalker) {
            walkingIterator.m_firstWalker = this.m_firstWalker.cloneDeep(walkingIterator, null);
        }
        return walkingIterator;
    }

    public void reset() {
        super.reset();
        if (null != this.m_firstWalker) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    public int nextNode() {
        if (null != this.m_cachedNodes) {
            if (this.m_next < this.m_cachedNodes.size()) {
                this.m_lastFetched = this.m_currentContextNode = this.m_cachedNodes.elementAt(this.m_next);
                int n2 = this.m_currentContextNode;
                this.incrementNextPosition();
                return n2;
            }
            if (this.m_foundLast) {
                this.m_lastFetched = -1;
                return -1;
            }
        }
        if (-1 == this.m_stackFrame) {
            if (-1 == this.m_firstWalker.getRoot()) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack variableStack = this.m_execContext.getVarStack();
        int n3 = variableStack.getStackFrame();
        variableStack.setStackFrame(this.m_stackFrame);
        if (-1 == this.m_firstWalker.getRoot()) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        int n4 = this.returnNextNode(this.m_firstWalker.nextNode());
        variableStack.setStackFrame(n3);
        return n4;
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final void setLastUsedWalker(AxesWalker axesWalker) {
        this.m_lastUsedWalker = axesWalker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public void detach() {
        this.m_lastUsedWalker = null;
        super.detach();
    }

    public void fixupVariables(Vector vector, int n2) {
        this.m_predicateIndex = -1;
        AxesWalker axesWalker = this.m_firstWalker;
        while (null != axesWalker) {
            axesWalker.fixupVariables(vector, n2);
            axesWalker = axesWalker.getNextWalker();
        }
    }
}

