/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MButtonPeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MCheckboxMenuItemPeer;
import sun.awt.motif.MCheckboxPeer;
import sun.awt.motif.MChoicePeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MDragSourceContextPeer;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MEmbeddedFramePeer;
import sun.awt.motif.MFileDialogPeer;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MLabelPeer;
import sun.awt.motif.MListPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MMouseDragGestureRecognizer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MPopupMenuPeer;
import sun.awt.motif.MRobotPeer;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MScrollbarPeer;
import sun.awt.motif.MTextAreaPeer;
import sun.awt.motif.MTextFieldPeer;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11Clipboard;
import sun.awt.motif.X11CustomCursor;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11InputMethod;
import sun.awt.motif.X11InputMethodDescriptor;
import sun.print.PrintJob2D;

public class MToolkit
extends SunToolkit
implements Runnable {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$motif$MToolkit == null ? (class$sun$awt$motif$MToolkit = MToolkit.class$("sun.awt.motif.MToolkit")) : class$sun$awt$motif$MToolkit);
    static final boolean useMotifChoiceWidget = true;
    X11Clipboard clipboard;
    X11Clipboard selection;
    protected static boolean dynamicLayoutSetting = false;
    public static final X11GraphicsConfig config = GraphicsEnvironment.isHeadless() ? null : (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    public static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.motif.MDataTransferer";
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    static /* synthetic */ Class class$sun$awt$motif$MToolkit;
    static /* synthetic */ Class class$java$awt$dnd$MouseDragGestureRecognizer;

    public MToolkit() {
        if (!GraphicsEnvironment.isHeadless()) {
            String string = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n2 = stackTraceElementArray.length - 1;
            if (n2 >= 0) {
                string = stackTraceElementArray[n2].getClassName();
            }
            if (string == null || string.equals("")) {
                string = "AWT";
            }
            this.init(string);
            SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
            Thread thread = new Thread(this, "AWT-Motif");
            thread.setPriority(6);
            thread.setDaemon(true);
            ThreadGroup threadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(threadGroup, new Runnable(){

                public void run() {
                    MToolkit.this.shutdown();
                }
            }, "Shutdown-Thread"));
            thread.start();
        }
    }

    public native void init(String var1);

    public native void run();

    private native void shutdown();

    public ButtonPeer createButton(Button button) {
        MButtonPeer mButtonPeer = new MButtonPeer(button);
        SunToolkit.targetCreatedPeer(button, mButtonPeer);
        return mButtonPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        MTextFieldPeer mTextFieldPeer = new MTextFieldPeer(textField);
        SunToolkit.targetCreatedPeer(textField, mTextFieldPeer);
        return mTextFieldPeer;
    }

    public LabelPeer createLabel(Label label) {
        MLabelPeer mLabelPeer = new MLabelPeer(label);
        SunToolkit.targetCreatedPeer(label, mLabelPeer);
        return mLabelPeer;
    }

    public ListPeer createList(List list) {
        MListPeer mListPeer = new MListPeer(list);
        SunToolkit.targetCreatedPeer(list, mListPeer);
        return mListPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        MCheckboxPeer mCheckboxPeer = new MCheckboxPeer(checkbox);
        SunToolkit.targetCreatedPeer(checkbox, mCheckboxPeer);
        return mCheckboxPeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        MScrollbarPeer mScrollbarPeer = new MScrollbarPeer(scrollbar);
        SunToolkit.targetCreatedPeer(scrollbar, mScrollbarPeer);
        return mScrollbarPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        MScrollPanePeer mScrollPanePeer = new MScrollPanePeer(scrollPane);
        SunToolkit.targetCreatedPeer(scrollPane, mScrollPanePeer);
        return mScrollPanePeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        MTextAreaPeer mTextAreaPeer = new MTextAreaPeer(textArea);
        SunToolkit.targetCreatedPeer(textArea, mTextAreaPeer);
        return mTextAreaPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        MChoicePeer mChoicePeer = null;
        mChoicePeer = new MChoicePeer(choice);
        SunToolkit.targetCreatedPeer(choice, mChoicePeer);
        return mChoicePeer;
    }

    public FramePeer createFrame(Frame frame) {
        MFramePeer mFramePeer = new MFramePeer(frame);
        SunToolkit.targetCreatedPeer(frame, mFramePeer);
        return mFramePeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        MCanvasPeer mCanvasPeer = new MCanvasPeer(canvas);
        SunToolkit.targetCreatedPeer(canvas, mCanvasPeer);
        return mCanvasPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        MPanelPeer mPanelPeer = new MPanelPeer(panel);
        SunToolkit.targetCreatedPeer(panel, mPanelPeer);
        return mPanelPeer;
    }

    public WindowPeer createWindow(Window window) {
        MWindowPeer mWindowPeer = new MWindowPeer(window);
        SunToolkit.targetCreatedPeer(window, mWindowPeer);
        return mWindowPeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        MDialogPeer mDialogPeer = new MDialogPeer(dialog);
        SunToolkit.targetCreatedPeer(dialog, mDialogPeer);
        return mDialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        MFileDialogPeer mFileDialogPeer = new MFileDialogPeer(fileDialog);
        SunToolkit.targetCreatedPeer(fileDialog, mFileDialogPeer);
        return mFileDialogPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = new MMenuBarPeer(menuBar);
        SunToolkit.targetCreatedPeer(menuBar, mMenuBarPeer);
        return mMenuBarPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        MMenuPeer mMenuPeer = new MMenuPeer(menu);
        SunToolkit.targetCreatedPeer(menu, mMenuPeer);
        return mMenuPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        MPopupMenuPeer mPopupMenuPeer = new MPopupMenuPeer(popupMenu);
        SunToolkit.targetCreatedPeer(popupMenu, mPopupMenuPeer);
        return mPopupMenuPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        MMenuItemPeer mMenuItemPeer = new MMenuItemPeer(menuItem);
        SunToolkit.targetCreatedPeer(menuItem, mMenuItemPeer);
        return mMenuItemPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        MCheckboxMenuItemPeer mCheckboxMenuItemPeer = new MCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.targetCreatedPeer(checkboxMenuItem, mCheckboxMenuItemPeer);
        return mCheckboxMenuItemPeer;
    }

    public MEmbeddedFramePeer createEmbeddedFrame(MEmbeddedFrame mEmbeddedFrame) {
        MEmbeddedFramePeer mEmbeddedFramePeer = new MEmbeddedFramePeer(mEmbeddedFrame);
        SunToolkit.targetCreatedPeer(mEmbeddedFrame, mEmbeddedFramePeer);
        return mEmbeddedFramePeer;
    }

    public FontPeer getFontPeer(String string, int n2) {
        return new MFontPeer(string, n2);
    }

    public void setDynamicLayout(boolean bl2) {
        dynamicLayoutSetting = bl2;
    }

    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupportedNative();
    }

    public native boolean isFrameStateSupported(int var1);

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public native int getScreenResolution();

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return new Insets(0, 0, 0, 0);
    }

    protected native int getScreenWidth();

    protected native int getScreenHeight();

    public FontMetrics getFontMetrics(Font font) {
        return super.getFontMetrics(font);
    }

    public native void sync();

    static boolean prepareScrImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (n2 == 0 || n3 == 0) {
            return true;
        }
        if (!(image instanceof X11Image)) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    static int checkScrImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (!(image instanceof X11Image)) {
            return 32;
        }
        X11Image x11Image = (X11Image)image;
        int n4 = n2 == 0 || n3 == 0 ? 32 : x11Image.getImageRep().check(imageObserver);
        return x11Image.check(imageObserver) | n4;
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n2, n3, imageObserver);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n2, n3, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, properties);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    public native void beep();

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.clipboard == null) {
            this.clipboard = new X11Clipboard("System", "CLIPBOARD");
        }
        return this.clipboard;
    }

    public Clipboard getSystemSelection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.selection == null) {
            this.selection = new X11Clipboard("Selection", "PRIMARY");
        }
        return this.selection;
    }

    public boolean getLockingKeyState(int n2) {
        if (n2 != 20 && n2 != 144 && n2 != 145 && n2 != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n2);
    }

    public native boolean getLockingKeyStateNative(int var1);

    public native void loadSystemColors(int[] var1);

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return MDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        if ((class$java$awt$dnd$MouseDragGestureRecognizer == null ? (class$java$awt$dnd$MouseDragGestureRecognizer = MToolkit.class$("java.awt.dnd.MouseDragGestureRecognizer")) : class$java$awt$dnd$MouseDragGestureRecognizer).equals(clazz)) {
            return new MMouseDragGestureRecognizer(dragSource, component, n2, dragGestureListener);
        }
        return null;
    }

    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new X11InputMethodDescriptor();
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return X11InputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new X11CustomCursor(image, point, string);
    }

    public Dimension getBestCursorSize(int n2, int n3) {
        return X11CustomCursor.getBestCursorSize(Math.max(1, n2), Math.max(1, n3));
    }

    public int getMaximumCursorColors() {
        return 2;
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                System.err.println("cannot load system cursor: " + string2);
                return null;
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.lazilyLoadDynamicLayoutSupportedProperty(string);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String string) {
        boolean bl2 = this.isDynamicLayoutSupportedNative();
        return new Boolean(bl2);
    }

    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
    }

    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new MRobotPeer(graphicsDevice.getDefaultConfiguration());
    }

    public native Component getComponentFromNativeWindowHandle(int var1);

    private native int getNativeWindowHandleFromPeer(MComponentPeer var1);

    public int getNativeWindowHandleFromComponent(Component component) {
        ComponentPeer componentPeer = component.getPeer();
        while (componentPeer != null && !(componentPeer instanceof MComponentPeer)) {
            if ((component = component.getParent()) == null) {
                return 0;
            }
            componentPeer = component.getPeer();
        }
        if (componentPeer == null) {
            return 0;
        }
        return this.getNativeWindowHandleFromPeer((MComponentPeer)componentPeer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

