/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class UnicodeDecoder
extends CharsetDecoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int NONE = 0;
    protected static final int BIG = 1;
    protected static final int LITTLE = 2;
    private final int expectedByteOrder;
    private int currentByteOrder;
    private final Surrogate.Generator sgg = new Surrogate.Generator();

    public UnicodeDecoder(Charset charset, int n2) {
        super(charset, 0.5f, 1.0f);
        this.expectedByteOrder = this.currentByteOrder = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n2;
        block9: {
            CoderResult coderResult2;
            block11: {
                CoderResult coderResult3;
                n2 = byteBuffer.position();
                try {
                    while (true) {
                        char c2;
                        if (byteBuffer.remaining() <= 1) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block9;
                        }
                        int n3 = byteBuffer.get() & 0xFF;
                        int n4 = byteBuffer.get() & 0xFF;
                        if (this.currentByteOrder == 0) {
                            c2 = (char)(n3 << 8 | n4);
                            if (c2 == '\ufeff') {
                                this.currentByteOrder = 1;
                                n2 += 2;
                                continue;
                            }
                            if (c2 == '\ufffe') {
                                this.currentByteOrder = 2;
                                n2 += 2;
                                continue;
                            }
                            this.currentByteOrder = 1;
                        }
                        if ((c2 = this.currentByteOrder == 1 ? (char)(n3 << 8 | n4) : (char)(n4 << 8 | n3)) == '\ufffe') {
                            coderResult3 = CoderResult.malformedForLength(2);
                            Object var9_10 = null;
                            break;
                        }
                        if (!charBuffer.hasRemaining()) {
                            coderResult2 = CoderResult.UNDERFLOW;
                            break block11;
                        }
                        n2 += 2;
                        charBuffer.put(c2);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    byteBuffer.position(n2);
                    throw throwable;
                }
                byteBuffer.position(n2);
                return coderResult3;
            }
            Object var9_11 = null;
            byteBuffer.position(n2);
            return coderResult2;
        }
        Object var9_12 = null;
        byteBuffer.position(n2);
        return coderResult;
    }

    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }
}

