/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.RDN;
import sun.security.x509.RFC822Name;

public class X500Name
implements GeneralNameInterface,
Principal {
    private String dn;
    private String rfc1779Dn;
    private String rfc2253Dn;
    private String canonicalDn;
    private RDN[] names;
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] SURNAME_DATA = new int[]{2, 5, 4, 4};
    private static final int[] SERIALNUMBER_DATA = new int[]{2, 5, 4, 5};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] GIVENNAME_DATA = new int[]{2, 5, 4, 42};
    private static final int[] INITIALS_DATA = new int[]{2, 5, 4, 43};
    private static final int[] GENERATIONQUALIFIER_DATA = new int[]{2, 5, 4, 44};
    private static final int[] DNQUALIFIER_DATA = new int[]{2, 5, 4, 46};
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    private static final int[] DOMAIN_COMPONENT_DATA = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    private static final int[] userid_data = new int[]{0, 9, 2342, 19200300, 100, 1, 1};
    public static ObjectIdentifier commonName_oid;
    public static ObjectIdentifier countryName_oid;
    public static ObjectIdentifier localityName_oid;
    public static ObjectIdentifier orgName_oid;
    public static ObjectIdentifier orgUnitName_oid;
    public static ObjectIdentifier stateName_oid;
    public static ObjectIdentifier streetAddress_oid;
    public static ObjectIdentifier title_oid;
    public static ObjectIdentifier DNQUALIFIER_OID;
    public static ObjectIdentifier SURNAME_OID;
    public static ObjectIdentifier GIVENNAME_OID;
    public static ObjectIdentifier INITIALS_OID;
    public static ObjectIdentifier GENERATIONQUALIFIER_OID;
    public static ObjectIdentifier ipAddress_oid;
    public static ObjectIdentifier DOMAIN_COMPONENT_OID;
    public static ObjectIdentifier userid_oid;
    public static ObjectIdentifier SERIALNUMBER_OID;

    public X500Name(String string) throws IOException {
        this.parseDN(string);
    }

    public X500Name(String string, String string2) throws IOException {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (string2.equalsIgnoreCase("RFC2253")) {
            this.parseRFC2253DN(string);
        } else if (string2.equalsIgnoreCase("DEFAULT")) {
            this.parseDN(string);
        } else {
            throw new IOException("Unsupported format " + string2);
        }
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string4));
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string6));
    }

    public X500Name(RDN[] rDNArray) throws IOException {
        if (rDNArray == null) {
            this.names = null;
        } else {
            this.names = new RDN[rDNArray.length];
            int n2 = 0;
            while (n2 < rDNArray.length) {
                if (rDNArray[n2] == null) {
                    throw new IOException("Cannot create an X500Name");
                }
                this.names[n2] = (RDN)rDNArray[n2].clone();
                ++n2;
            }
        }
    }

    public X500Name(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        this.parseDER(derInputStream);
    }

    public X500Name(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parseDER(derInputStream);
    }

    public boolean equals(Object object) {
        if (object instanceof X500Name) {
            return this.equals((X500Name)object);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        if (this.names != null) {
            int n4 = 0;
            while (n4 < this.names.length) {
                n2 += this.names[n4].hashCode() * n3++;
                ++n4;
            }
        }
        return n2;
    }

    public synchronized boolean equals(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (x500Name == null) {
            return false;
        }
        if (this.names == null) {
            return x500Name.names == null;
        }
        if (x500Name.names == null) {
            return false;
        }
        if (this.names.length != x500Name.names.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.names.length) {
            if (!this.names[n2].equals(x500Name.names[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(X500Principal x500Principal) {
        if (x500Principal == null) {
            return false;
        }
        String string = this.getRFC2253CanonicalName();
        String string2 = x500Principal.getName("CANONICAL");
        return string.equals(string2);
    }

    private String getString(DerValue derValue) throws IOException {
        if (derValue == null) {
            return null;
        }
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.tag);
        }
        return string;
    }

    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute(countryName_oid);
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute(orgName_oid);
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute(commonName_oid);
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute(localityName_oid);
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute(stateName_oid);
        return this.getString(derValue);
    }

    public String getDomain() throws IOException {
        DerValue derValue = this.findAttribute(DOMAIN_COMPONENT_OID);
        return this.getString(derValue);
    }

    public String getDNQualifier() throws IOException {
        DerValue derValue = this.findAttribute(DNQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getSurname() throws IOException {
        DerValue derValue = this.findAttribute(SURNAME_OID);
        return this.getString(derValue);
    }

    public String getGivenName() throws IOException {
        DerValue derValue = this.findAttribute(GIVENNAME_OID);
        return this.getString(derValue);
    }

    public String getInitials() throws IOException {
        DerValue derValue = this.findAttribute(INITIALS_OID);
        return this.getString(derValue);
    }

    public String getGeneration() throws IOException {
        DerValue derValue = this.findAttribute(GENERATIONQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getIP() throws IOException {
        DerValue derValue = this.findAttribute(ipAddress_oid);
        return this.getString(derValue);
    }

    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getRFC1779Name() {
        if (this.rfc1779Dn == null) {
            this.generateRFC1779DN();
        }
        return this.rfc1779Dn;
    }

    public String getRFC2253Name() {
        if (this.rfc2253Dn != null) {
            return this.rfc2253Dn;
        }
        if (this.names == null || this.names.length == 0) {
            this.rfc2253Dn = "";
            return this.rfc2253Dn;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.names.length - 1;
        while (n2 >= 0) {
            if (n2 < this.names.length - 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.names[n2].toRFC2253String());
            --n2;
        }
        this.rfc2253Dn = new String(stringBuffer);
        return this.rfc2253Dn;
    }

    public String getRFC2253CanonicalName() {
        if (this.canonicalDn != null) {
            return this.canonicalDn;
        }
        if (this.names == null || this.names.length == 0) {
            this.canonicalDn = "";
            return this.canonicalDn;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.names.length - 1;
        while (n2 >= 0) {
            if (n2 < this.names.length - 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.names[n2].toRFC2253String(true));
            --n2;
        }
        this.canonicalDn = new String(stringBuffer);
        return this.canonicalDn;
    }

    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        DerValue derValue = null;
        if (this.names != null) {
            int n2 = 0;
            while (n2 < this.names.length) {
                derValue = this.names[n2].findAttribute(objectIdentifier);
                if (derValue != null) break;
                ++n2;
            }
        }
        return derValue;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = null;
        byte[] byArray = derInputStream.toByteArray();
        try {
            derValueArray = derInputStream.getSequence(5);
        }
        catch (IOException iOException) {
            if (byArray == null) {
                derValueArray = null;
            }
            DerValue derValue = new DerValue(48, byArray);
            byArray = derValue.toByteArray();
            derValueArray = new DerInputStream(byArray).getSequence(5);
        }
        if (derValueArray == null) {
            this.names = null;
        } else {
            this.names = new RDN[derValueArray.length];
            int n2 = 0;
            while (n2 < derValueArray.length) {
                this.names[n2] = new RDN(derValueArray[n2]);
                ++n2;
            }
        }
    }

    public void emit(DerOutputStream derOutputStream) throws IOException {
        this.encode(derOutputStream);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.names != null) {
            int n2 = 0;
            while (n2 < this.names.length) {
                this.names[n2].encode(derOutputStream2);
                ++n2;
            }
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.names != null) {
            int n2 = 0;
            while (n2 < this.names.length) {
                this.names[n2].encode(derOutputStream2);
                ++n2;
            }
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    private void parseDN(String string) throws IOException {
        RDN rDN;
        String string2;
        if (string == null || string.length() == 0) {
            this.names = null;
            return;
        }
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        String string3 = string.trim();
        int n4 = 0;
        int n5 = string3.indexOf(44);
        int n6 = string3.indexOf(59);
        while (n5 >= 0 || n6 >= 0) {
            int n7 = n6 < 0 ? n5 : (n5 < 0 ? n6 : Math.min(n5, n6));
            if (n7 > 0 && string3.charAt(n7 - 1) != '\\' && (n3 += X500Name.countQuotes(string3, n4, n7)) != 1) {
                string2 = string3.substring(n2, n7).trim();
                rDN = new RDN(string2);
                vector.addElement(rDN);
                n2 = n7 + 1;
                n3 = 0;
            }
            n4 = n7 + 1;
            n5 = string3.indexOf(44, n4);
            n6 = string3.indexOf(59, n4);
        }
        string2 = string3.substring(n2).trim();
        rDN = new RDN(string2);
        vector.addElement(rDN);
        int n8 = vector.size();
        this.names = new RDN[n8];
        Enumeration enumeration = vector.elements();
        int n9 = n8 - 1;
        while (enumeration.hasMoreElements()) {
            this.names[n9--] = (RDN)enumeration.nextElement();
        }
    }

    private void parseRFC2253DN(String string) throws IOException {
        RDN rDN;
        String string2;
        if (string.length() == 0) {
            this.names = null;
            return;
        }
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(44);
        while (n4 >= 0) {
            if (n4 > 0 && string.charAt(n4 - 1) != '\\') {
                string2 = string.substring(n2, n4);
                rDN = new RDN(string2, "RFC2253");
                vector.addElement(rDN);
                n2 = n4 + 1;
            }
            n3 = n4 + 1;
            n4 = string.indexOf(44, n3);
        }
        string2 = string.substring(n2);
        rDN = new RDN(string2, "RFC2253");
        vector.addElement(rDN);
        int n5 = vector.size();
        this.names = new RDN[n5];
        Enumeration enumeration = vector.elements();
        int n6 = n5 - 1;
        while (enumeration.hasMoreElements()) {
            this.names[n6--] = (RDN)enumeration.nextElement();
        }
    }

    static int countQuotes(String string, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (string.charAt(n5) == '\"' && n5 == n2 || string.charAt(n5) == '\"' && string.charAt(n5 - 1) != '\\') {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    private void generateDN() {
        String string = null;
        if (this.names != null) {
            int n2 = this.names.length - 1;
            while (n2 >= 0) {
                string = string == null ? this.names[n2].toString() : string + ", " + this.names[n2].toString();
                --n2;
            }
        }
        this.dn = string == null ? "" : string;
    }

    private void generateRFC1779DN() {
        String string = null;
        if (this.names != null) {
            int n2 = this.names.length - 1;
            while (n2 >= 0) {
                string = string == null ? this.names[n2].toRFC1779String() : string + ", " + this.names[n2].toRFC1779String();
                --n2;
            }
        }
        this.rfc1779Dn = string == null ? "" : string;
    }

    static ObjectIdentifier intern(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier.equals(commonName_oid)) {
            return commonName_oid;
        }
        if (objectIdentifier.equals(countryName_oid)) {
            return countryName_oid;
        }
        if (objectIdentifier.equals(localityName_oid)) {
            return localityName_oid;
        }
        if (objectIdentifier.equals(stateName_oid)) {
            return stateName_oid;
        }
        if (objectIdentifier.equals(streetAddress_oid)) {
            return streetAddress_oid;
        }
        if (objectIdentifier.equals(orgName_oid)) {
            return orgName_oid;
        }
        if (objectIdentifier.equals(orgUnitName_oid)) {
            return orgUnitName_oid;
        }
        if (objectIdentifier.equals(title_oid)) {
            return title_oid;
        }
        if (objectIdentifier.equals(ipAddress_oid)) {
            return ipAddress_oid;
        }
        if (objectIdentifier.equals(PKCS9Attribute.EMAIL_ADDRESS_OID)) {
            return PKCS9Attribute.EMAIL_ADDRESS_OID;
        }
        if (objectIdentifier.equals(DOMAIN_COMPONENT_OID)) {
            return DOMAIN_COMPONENT_OID;
        }
        if (objectIdentifier.equals(DNQUALIFIER_OID)) {
            return DNQUALIFIER_OID;
        }
        if (objectIdentifier.equals(SURNAME_OID)) {
            return SURNAME_OID;
        }
        if (objectIdentifier.equals(GIVENNAME_OID)) {
            return GIVENNAME_OID;
        }
        if (objectIdentifier.equals(INITIALS_OID)) {
            return INITIALS_OID;
        }
        if (objectIdentifier.equals(GENERATIONQUALIFIER_OID)) {
            return GENERATIONQUALIFIER_OID;
        }
        if (objectIdentifier.equals(userid_oid)) {
            return userid_oid;
        }
        if (objectIdentifier.equals(SERIALNUMBER_OID)) {
            return SERIALNUMBER_OID;
        }
        return objectIdentifier;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 4) {
            if (generalNameInterface.getType() == 1) {
                n2 = -1;
                if (this.names != null) {
                    int n3 = 0;
                    while (n3 < this.names.length) {
                        DerValue derValue = this.names[n3].findAttribute(PKCS9Attribute.EMAIL_ADDRESS_OID);
                        if (derValue != null) {
                            RFC822Name rFC822Name;
                            try {
                                rFC822Name = new RFC822Name(derValue.getAsString());
                            }
                            catch (IOException iOException) {
                                break;
                            }
                            n2 = rFC822Name.constrains((RFC822Name)generalNameInterface);
                            break;
                        }
                        ++n3;
                    }
                }
            } else {
                n2 = -1;
            }
        } else {
            n2 = ((X500Name)generalNameInterface).equals(this) ? 0 : (((X500Name)generalNameInterface).names == null ? 2 : (this.names == null ? 1 : (((X500Name)generalNameInterface).isWithinSubtree(this) ? 1 : (this.isWithinSubtree((X500Name)generalNameInterface) ? 2 : 3))));
        }
        return n2;
    }

    private synchronized boolean isWithinSubtree(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (x500Name == null) {
            return false;
        }
        if (x500Name.names == null) {
            return true;
        }
        if (this.names == null) {
            return false;
        }
        if (this.names.length < x500Name.names.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < x500Name.names.length) {
            if (!this.names[n2].equals(x500Name.names[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        if (this.names == null) {
            return 0;
        }
        return this.names.length;
    }

    public X500Name commonAncestor(X500Name x500Name) {
        if (x500Name == null || x500Name.names == null || this.names == null) {
            return null;
        }
        int n2 = x500Name.names.length;
        int n3 = this.names.length;
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        int n4 = n3 < n2 ? n3 : n2;
        int n5 = 0;
        while (n5 < n4) {
            if (!this.names[n5].equals(x500Name.names[n5])) {
                if (n5 != 0) break;
                return null;
            }
            ++n5;
        }
        RDN[] rDNArray = new RDN[n5];
        int n6 = 0;
        while (n6 < n5) {
            rDNArray[n6] = this.names[n6];
            ++n6;
        }
        X500Name x500Name2 = null;
        try {
            x500Name2 = new X500Name(rDNArray);
        }
        catch (IOException iOException) {
            return null;
        }
        return x500Name2;
    }

    static {
        try {
            commonName_oid = new ObjectIdentifier(commonName_data);
            SERIALNUMBER_OID = new ObjectIdentifier(SERIALNUMBER_DATA);
            countryName_oid = new ObjectIdentifier(countryName_data);
            localityName_oid = new ObjectIdentifier(localityName_data);
            orgName_oid = new ObjectIdentifier(orgName_data);
            orgUnitName_oid = new ObjectIdentifier(orgUnitName_data);
            stateName_oid = new ObjectIdentifier(stateName_data);
            streetAddress_oid = new ObjectIdentifier(streetAddress_data);
            title_oid = new ObjectIdentifier(title_data);
            DNQUALIFIER_OID = new ObjectIdentifier(DNQUALIFIER_DATA);
            SURNAME_OID = new ObjectIdentifier(SURNAME_DATA);
            GIVENNAME_OID = new ObjectIdentifier(GIVENNAME_DATA);
            INITIALS_OID = new ObjectIdentifier(INITIALS_DATA);
            GENERATIONQUALIFIER_OID = new ObjectIdentifier(GENERATIONQUALIFIER_DATA);
            ipAddress_oid = new ObjectIdentifier(ipAddress_data);
            DOMAIN_COMPONENT_OID = new ObjectIdentifier(DOMAIN_COMPONENT_DATA);
            userid_oid = new ObjectIdentifier(userid_data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

