/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactIntArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactIntArray() {
        this(0);
    }

    public CompactIntArray(int n2) {
        this.values = new int[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n3 = 0;
        while (n3 < 65536) {
            this.values[n3] = n2;
            ++n3;
        }
        n3 = 0;
        while (n3 < 512) {
            this.indices[n3] = (short)(n3 << 7);
            this.hashes[n3] = 0;
            ++n3;
        }
        this.isCompact = false;
    }

    public CompactIntArray(short[] sArray, int[] nArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n2 = 0;
        while (n2 < 512) {
            short s2 = sArray[n2];
            if (s2 < 0 || s2 >= nArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n2;
        }
        this.indices = sArray;
        this.values = nArray;
        this.isCompact = true;
    }

    public int elementAt(char c2) {
        return this.values[(this.indices[c2 >> 7] & 0xFFFF) + (c2 & 0x7F)];
    }

    public void setElementAt(char c2, int n2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = n2;
        this.touchBlock(c2 >> 7, n2);
    }

    public void setElementAt(char n2, char c2, int n3) {
        if (this.isCompact) {
            this.expand();
        }
        int n4 = n2;
        while (n4 <= c2) {
            this.values[n4] = n3;
            this.touchBlock(n4 >> 7, n3);
            ++n4;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            while (n6 < this.indices.length) {
                this.indices[n6] = -1;
                n2 = this.blockTouched(n6) ? 1 : 0;
                if (n2 == 0 && n5 != -1) {
                    this.indices[n6] = n5;
                } else {
                    int n7 = 0;
                    int n8 = 0;
                    n8 = 0;
                    while (n8 < n3) {
                        if (this.hashes[n6] == this.hashes[n8] && Utility.arrayRegionMatches(this.values, n4, this.values, n7, 128)) {
                            this.indices[n6] = (short)n7;
                            break;
                        }
                        ++n8;
                        n7 += 128;
                    }
                    if (this.indices[n6] == -1) {
                        System.arraycopy(this.values, n4, this.values, n7, 128);
                        this.indices[n6] = (short)n7;
                        this.hashes[n8] = this.hashes[n6];
                        ++n3;
                        if (n2 == 0) {
                            n5 = (short)n7;
                        }
                    }
                }
                ++n6;
                n4 += 128;
            }
            n2 = n3 * 128;
            int[] nArray = new int[n2];
            System.arraycopy(this.values, 0, nArray, 0, n2);
            this.values = nArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public int[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactIntArray compactIntArray = (CompactIntArray)super.clone();
            compactIntArray.values = (int[])this.values.clone();
            compactIntArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactIntArray.hashes = (int[])this.hashes.clone();
            }
            return compactIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactIntArray compactIntArray = (CompactIntArray)object;
        int n2 = 0;
        while (n2 < 65536) {
            if (this.elementAt((char)n2) != compactIntArray.elementAt((char)n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        int n4 = 0;
        while (n4 < this.values.length) {
            n2 = n2 * 37 + this.values[n4];
            n4 += n3;
        }
        return n2;
    }

    private void expand() {
        if (this.isCompact) {
            this.hashes = new int[512];
            int[] nArray = new int[65536];
            int n2 = 0;
            while (n2 < 65536) {
                int n3;
                nArray[n2] = n3 = this.elementAt((char)n2);
                this.touchBlock(n2 >> 7, n3);
                ++n2;
            }
            n2 = 0;
            while (n2 < 512) {
                this.indices[n2] = (short)(n2 << 7);
                ++n2;
            }
            this.values = nArray;
            this.isCompact = false;
        }
    }
}

