/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class CompactShortArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    static final int BLOCKSHIFT = 7;
    static final int BLOCKCOUNT = 128;
    static final int INDEXSHIFT = 9;
    static final int INDEXCOUNT = 512;
    static final int BLOCKMASK = 127;
    private short[] values;
    private short[] indices;
    private int[] hashes;
    private boolean isCompact;
    short defaultValue;

    public CompactShortArray() {
        this(0);
    }

    public CompactShortArray(short s2) {
        this.values = new short[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n2 = 0;
        while (n2 < 65536) {
            this.values[n2] = s2;
            ++n2;
        }
        n2 = 0;
        while (n2 < 512) {
            this.indices[n2] = (short)(n2 << 7);
            this.hashes[n2] = 0;
            ++n2;
        }
        this.isCompact = false;
        this.defaultValue = s2;
    }

    public CompactShortArray(short[] sArray, short[] sArray2, short s2) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n2 = 0;
        while (n2 < 512) {
            short s3 = sArray[n2];
            if (s3 < 0 || s3 >= sArray2.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n2;
        }
        this.indices = sArray;
        this.values = sArray2;
        this.isCompact = true;
        this.defaultValue = s2;
    }

    public short elementAt(char c2) {
        return this.values[(this.indices[c2 >> 7] & 0xFFFF) + (c2 & 0x7F)];
    }

    public void setElementAt(char c2, short s2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = s2;
        this.touchBlock(c2 >> 7, s2);
    }

    public void setElementAt(char n2, char c2, short s2) {
        if (this.isCompact) {
            this.expand();
        }
        int n3 = n2;
        while (n3 <= c2) {
            this.values[n3] = s2;
            this.touchBlock(n3 >> 7, s2);
            ++n3;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            while (n6 < this.indices.length) {
                this.indices[n6] = -1;
                n2 = this.blockTouched(n6) ? 1 : 0;
                if (n2 == 0 && n5 != -1) {
                    this.indices[n6] = n5;
                } else {
                    int n7 = 0;
                    int n8 = 0;
                    n8 = 0;
                    while (n8 < n3) {
                        if (this.hashes[n6] == this.hashes[n8] && CompactShortArray.arrayRegionMatches(this.values, n4, this.values, n7, 128)) {
                            this.indices[n6] = (short)n7;
                        }
                        ++n8;
                        n7 += 128;
                    }
                    if (this.indices[n6] == -1) {
                        System.arraycopy(this.values, n4, this.values, n7, 128);
                        this.indices[n6] = (short)n7;
                        this.hashes[n8] = this.hashes[n6];
                        ++n3;
                        if (n2 == 0) {
                            n5 = (short)n7;
                        }
                    }
                }
                ++n6;
                n4 += 128;
            }
            n2 = n3 * 128;
            short[] sArray = new short[n2];
            System.arraycopy(this.values, 0, sArray, 0, n2);
            this.values = sArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    public static final boolean arrayRegionMatches(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        int n7 = n2;
        while (n7 < n5) {
            if (sArray[n7] != sArray2[n7 + n6]) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public short[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactShortArray compactShortArray = (CompactShortArray)super.clone();
            compactShortArray.values = (short[])this.values.clone();
            compactShortArray.indices = (short[])this.indices.clone();
            return compactShortArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactShortArray compactShortArray = (CompactShortArray)object;
        int n2 = 0;
        while (n2 < 65536) {
            if (this.elementAt((char)n2) != compactShortArray.elementAt((char)n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        int n4 = 0;
        while (n4 < this.values.length) {
            n2 = n2 * 37 + this.values[n4];
            n4 += n3;
        }
        return n2;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    private void expand() {
        if (this.isCompact) {
            short[] sArray = new short[65536];
            int n2 = 0;
            while (n2 < 65536) {
                sArray[n2] = this.elementAt((char)n2);
                ++n2;
            }
            n2 = 0;
            while (n2 < 512) {
                this.indices[n2] = (short)(n2 << 7);
                ++n2;
            }
            this.values = null;
            this.values = sArray;
            this.isCompact = false;
        }
    }

    static /* synthetic */ short[] access$000(CompactShortArray compactShortArray) {
        return compactShortArray.indices;
    }

    public class Iterator {
        int nextIndex = -1;
        int index = -1;
        short nextValue;
        short value;
        short iUntouched = (short)-1;
        boolean touched = true;
        short defValue;

        Iterator() {
            this.defValue = CompactShortArray.this.defaultValue;
            CompactShortArray.this.compact();
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            this.nextIndex = this.index;
            var1_1 = true;
            if (this.index == this.nextIndex) ** GOTO lbl18
            return true;
lbl-1000:
            // 1 sources

            {
                if ((this.nextIndex & 127) == 0) {
                    var2_2 = this.nextIndex >> 7;
                    if (CompactShortArray.access$000(CompactShortArray.this)[var2_2] == this.iUntouched) {
                        this.nextIndex += 127;
                        continue;
                    }
                    if (this.iUntouched == -1 && !this.touched) {
                        this.iUntouched = CompactShortArray.access$000(CompactShortArray.this)[var2_2 - 1];
                    } else {
                        this.touched = false;
                    }
                }
                this.nextValue = CompactShortArray.this.elementAt((char)this.nextIndex);
                if (this.nextValue == this.defValue) continue;
                this.touched = true;
                break;
lbl18:
                // 3 sources

                ** while (++this.nextIndex < 65535)
            }
lbl19:
            // 2 sources

            return this.nextIndex < 65535;
        }

        public char next() {
            if (this.index == this.nextIndex && !this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.index = this.nextIndex;
            this.value = this.nextValue;
            return (char)this.index;
        }

        public short shortValue() {
            return this.value;
        }
    }
}

