/****************************
 Change a contacts' nickname
 (c) 1999 Jeremy Wise
 GnomeICU
*****************************/

#include "common.h"
#include "changenick.h"
#include "gnomeicu.h"
#include "util.h"
#include "v7snac13.h"

/*** Local function declarations ***/
static void change_nick( GtkWidget *widget, gpointer data );
static void change_nick_clicked( GnomeDialog *dialog, gint button, gpointer data );

/*** Global functions ***/
void change_nick_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;
	GtkWidget *label2;
	GtkWidget *entry1;
	GtkWidget *combo_entry1;
	GSList *contact;

	gchar *str;

#ifdef TRACE_FUNCTION
	g_print( "change_nick_window\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if (contact == NULL)
		return;

	window = gnome_dialog_new (_("GnomeICU: Rename User"),
				   GNOME_STOCK_BUTTON_OK,
				   GNOME_STOCK_BUTTON_CANCEL,
				   NULL);
	gnome_dialog_set_default (GNOME_DIALOG (window), 0);
	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Rename_User", "GnomeICU");
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);

	str = g_strdup_printf (_("Please enter a new alias for %s:"),
	                       kontakt->nick);

	label2 = gtk_label_new (str);
	g_free (str);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(window)->vbox),
	                    label2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

	entry1 = gnome_entry_new ("gnomeicu_renames");
	gtk_widget_show (entry1);
	gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(window)->vbox),
	                    entry1, FALSE, FALSE, 0);

	combo_entry1 = gnome_entry_gtk_entry (GNOME_ENTRY (entry1));
	gtk_entry_set_text (GTK_ENTRY (combo_entry1), kontakt->nick);
	gtk_entry_set_max_length (GTK_ENTRY (combo_entry1), 19);
	gnome_dialog_editable_enters (GNOME_DIALOG(window),
				      GTK_EDITABLE (combo_entry1));
	gtk_signal_connect (GTK_OBJECT (combo_entry1), "changed",
	                    GTK_SIGNAL_FUNC (change_nick),
	                    contact);

	gtk_object_set_data (GTK_OBJECT (window), "oldnick",
	                     g_strdup (kontakt->nick));
	gtk_signal_connect (GTK_OBJECT (window), "clicked",
	                    GTK_SIGNAL_FUNC (change_nick_clicked),
	                    contact);

	gtk_widget_show_all( window );
}

/*** Local functions ***/
void change_nick( GtkWidget *widget, gpointer data )
{
	gchar *new_nick;
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "change_nick\n" );
#endif

	g_return_if_fail (data != NULL);
	contact = (GSList *) data;

	new_nick = gtk_entry_get_text( GTK_ENTRY( widget ) );

	strncpy( kontakt->nick, new_nick, sizeof(kontakt->nick) );

	if( kontakt->info->window != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_alias ),
		                    new_nick );
	
	gtk_clist_set_text( GTK_CLIST( MainData->lb_userwin ),
	                    kontakt->lb_index, 1, new_nick );
}

void change_nick_clicked( GnomeDialog *dialog, gint button, gpointer data )
{
	gchar *nick;
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "change_nick_clicked\n" );
#endif

	g_return_if_fail (data != NULL);
	contact = (GSList *) data;

	if (button == GNOME_OK) {
          v7_update_nickname (kontakt->gid, kontakt->uid, kontakt->uin,
                              kontakt->nick, sizeof(kontakt->nick));
          return;
        }

	nick = (gchar*)gtk_object_get_data( GTK_OBJECT( dialog ), "oldnick" );
	strncpy( kontakt->nick, nick, sizeof(kontakt->nick) );

	gtk_clist_set_text( GTK_CLIST( MainData->lb_userwin ),
	                    kontakt->lb_index, 1, nick );
	if( kontakt->info->window != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_alias ),
		                    nick );
	g_free( nick );
}
