#ifndef __BASE_IO_H__
#define __BASE_IO_H__

#include <glib.h>

extern char      * data_dir;
extern char      * download_dir;
extern int         acache_max_megs;
extern gboolean    acache_flush_on_exit;
extern gboolean    break_thread_when_subject_changes;
extern const gboolean * const _quote_chars;

#define is_quote_char(uch) (_quote_chars[(uch)])

void base_prefs_init (const char * data_dir,
                      const char * download_dir,
                      const char * quote_prefix_chars,
                      int          acache_max_megs,
                      gboolean     acache_flush_on_exit,
		      gboolean     break_thread_when_subject_changes);

#endif
