/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Pan - A Newscrossposter for X
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __FILTER_CROSSPOST_H_
#define __FILTER_CROSSPOST_H_

#include <pan/filters/filter.h>

extern const gchar * FILTER_CROSSPOST_CLASS_ID;
#define FILTER_CROSSPOST(a) ((FilterCrosspost*)filter_cast((Filter*)a,FILTER_CROSSPOST_CLASS_ID))

typedef struct _FilterCrosspost   FilterCrosspost;

struct _FilterCrosspost
{
	/* parent class */
	Filter parent;

	/* line count class */
	gint minimum_crosspost_count;
};

/**
***  PUBLIC
**/

Filter*      filter_crosspost_new             (void);


#endif
