/***************************************************************************
                            kde_GUSOut.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_GUSOUT
#define KDE_GUSOUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Gravis Ultrasound synthesizer output class . This class is used to send midi
 events to synthesizers on GUS cards.

 GUSOut inherits @ref MidiOut and supports the same simple API.

 The recommended way to use this class is by using a @ref DeviceManager
 object, and use the @ref DeviceManager::setPatchesToUse() member which will
 call the @ref #setPatchesToUse() member in this class.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to GUS synths.
*/

/** 
 Constructor. See @ref MidiOut::MidiOut() for more information.
     
*/
kde_GUSOut * kde_new_GUSOut(int d, int total);

/** 
 Destructor.
     
*/
void kde_del_GUSOut( kde_GUSOut* p );

/** 
 See @ref MidiOut::openDev()
     
*/
void kde_GUSOut_openDev(kde_GUSOut* instPointer,int sqfd);

/** 
 See @ref MidiOut::closeDev()
     
*/
void kde_GUSOut_closeDev(kde_GUSOut* instPointer);

/** 
 See @ref MidiOut::initDev()
     
*/
void kde_GUSOut_initDev(kde_GUSOut* instPointer);

/** 
 See @ref MidiOut::noteOn()
     
*/
void kde_GUSOut_noteOn(kde_GUSOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref MidiOut::noteOff()
     
*/
void kde_GUSOut_noteOff(kde_GUSOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref MidiOut::keyPressure()
     
*/
void kde_GUSOut_keyPressure(kde_GUSOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref MidiOut::chnPatchChange()
     
*/
void kde_GUSOut_chnPatchChange(kde_GUSOut* instPointer,unsigned char chn, unsigned char patch);

/** 
 See @ref MidiOut::chnPressure()
     
*/
void kde_GUSOut_chnPressure(kde_GUSOut* instPointer,unsigned char chn, unsigned char vel);

/** 
 See @ref MidiOut::chnPitchBender()
     
*/
void kde_GUSOut_chnPitchBender(kde_GUSOut* instPointer,unsigned char chn, unsigned char lsb, unsigned char msb);

/** 
 See @ref MidiOut::chnController()
     
*/
void kde_GUSOut_chnController(kde_GUSOut* instPointer,unsigned char chn, unsigned char ctl, unsigned char v);

/** 
 It's an empty function, as GUS synths don't support System Exclusive
 messages
     
*/
void kde_GUSOut_sysex(kde_GUSOut* instPointer,unsigned char* data, unsigned long size);

/** 
 See @ref DeviceManager::setPatchesToUse() . All the information about this
 member is explained there because it's (for now) just a simple call to this
 function when the device used is a GUS device, and you're supposed to use
 a DeviceManager object instead of a GUSOut object except in rare ocassions.

*/
void kde_GUSOut_setPatchesToUse(kde_GUSOut* instPointer,int* patchesused);

/** 
 Loads a single patch on the synthesizer memory.

*/
int kde_GUSOut_loadPatch(kde_GUSOut* instPointer,int pgm);

/** 
 Returns p if the patch with number p has been correctly loaded.
 In the case it hasn't been loaded, it returns the number of another patch
 that is loaded and that should be used instead.

*/
int kde_GUSOut_patch(kde_GUSOut* instPointer,int p);

/** 
 Sets the directory where the GUS patches are stored, that is, where the
 acpiano.pat, ... files can be found.

 It will store a copy of the parameter, so you should delete the memory
 used by the parameter you passed.
     
*/
void kde_GUSOut_setGUSPatchesDirectory( char* dir);

#endif
