/***************************************************************************
                            kde_KDirSize.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDIRSIZE
#define KDE_KDIRSIZE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Computes a directory size (similar to "du", but doesn't give the same results
 since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 
 @short 
 Computes a directory size (similar to "du", but doesn't give the same results
 since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 
*/

/** 

*/
//KIO::filesize_t kde_KDirSize_totalSize(kde_KDirSize* instPointer);

/** 
 Asynchronous method. Connect to the result signal.
 This one lists a single directory.
   
*/
kde_KDirSize* kde_KDirSize_dirSizeJob( kde_KURL* directory);

/** 
 Asynchronous method. Connect to the result signal.
 This one lists the items from @p lstItems.
 The reason we asks for items instead of just urls, is so that
 we directly know if the item is a file or a directory,
 and in case of a file, we already have its size.
   
*/
kde_KDirSize* kde_KDirSize_dirSizeJob1( kde_KFileItemList* lstItems);

/** 
 Synchronous method - you get the result as soon as
 the call returns.
   
*/
//KIO::filesize_t kde_KDirSize_dirSize( kde_KURL* directory);
kde_KDirSize * kde_new_KDirSize(kde_KURL* directory);
kde_KDirSize * kde_new_KDirSize1(kde_KFileItemList* lstItems);
void kde_del_KDirSize( kde_KDirSize* p );

/** 

   
*/
void kde_KDirSize_setSync(kde_KDirSize* instPointer);
void kde_KDirSize_startNextJob(kde_KDirSize* instPointer,kde_KURL* url);
void kde_KDirSize_slotResult(kde_KDirSize* instPointer,kde_Job* job);
//void kde_KDirSize_slotEntries(kde_KDirSize* instPointer,kde_Job* arg1, kde_UDSEntryList* arg2);
void kde_KDirSize_processList(kde_KDirSize* instPointer);

#endif
