/***************************************************************************
                            kde_KPanelExtension.h -  description
                             -------------------
    begin                : Tue Mar 19 20:11:49 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Mar 19 20:11:49 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPANELEXTENSION
#define KDE_KPANELEXTENSION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Implements a panel extension.

 Panel extensions

 Note: For security and stability reasons the panel won't load
 untrusted third party extensions directly into its namespace but via an
 external wrapper process.

 The panel locates available extensions by searching for extension desktop
 files in (ALL_KDEDIRS)/share/apps/kicker/extensions. Every panel extension should
 install a desktop file there to be recognised by the panel.

 Besides standard keys like "Name", "Comment" and "Icon" there are
 two panel extension specific keys:

 Used by the panel to locate the extension DSO (Dynamic Shared Object)
 Example: X-KDE-Library=libexampleextension

 Similar to @ref KApplication and @ref KUniqueApplication there are
 two types of panel extensions. Use unique extensions when it makes no
 sence to run more than one instance of an extension in the panel. A
 good example for unique extensions is the taskbar extension.  Use normal
 extensions when you need instance specific configuration. An example
 is a subpanel extension where you might want to run more than one instances.
 X-KDE-UniqueExtension is a boolean key which defaults
 to "false".  Example: X-KDE-UniqueExtension=true

 Back to panel extension DSOs, the following conventions are used for KDE:
 Name:    lib<extensionname>extension.la
 LDFLAGS: -module -no-undefined

 To implement a panel extension it is not enough to write a class
 inheriting from KPanelExtension but you also have to provide a
 factory function in your DSO.  A sample factory function could look
 like this:

 <pre>

 extern "C"
 {
     KPanelExtension* init(QWidget *parent, const QString& configFile)
     {
         KGlobal::locale()->insertCatalogue("exampleextension");
         return new ExampleExtension(configFile, KPanelExtension::Normal,
                       KPanelExtension::About | KPanelExtension::Help | KPanelExtension::Preferences,
                       parent, "exampleextension");
     }
 }

 </pre>

 Note: Don't change the factory function signature or the panel will
 fail to load your extension.

 @author Matthias Elter <elter@kde.org>

 @short KDE Panel Extension class.
*/
#define KPANELEXTENSION_Normal	0
#define KPANELEXTENSION_Stretch	0
#define KPANELEXTENSION_About	1
#define KPANELEXTENSION_Help	2
#define KPANELEXTENSION_Preferences	4
#define KPANELEXTENSION_ReportBug	8
#define KPANELEXTENSION_Left	0
#define KPANELEXTENSION_Right	0
#define KPANELEXTENSION_Top	1
#define KPANELEXTENSION_Bottom	2
#define KPANELEXTENSION_LeftTop	0
#define KPANELEXTENSION_Center	0
#define KPANELEXTENSION_RightBottom	1

/** 
 Constructs a KPanelExtension just like any other widget.

*/
kde_KPanelExtension * kde_new_KPanelExtension(qt_QString * configFile, int t, int actions, qt_QWidget * parent, char* name);

/** 
 Destructor.

*/
void kde_del_KPanelExtension( kde_KPanelExtension* p );

/** 
 Returns the prefered size for a given Position.

 Every extension should reimplement this function.

 Depending on the panel position the extensions can choose a prefered size for that
 location in the Window Manager Dock. Please note that the size can not be larger than the
 maxsize given by the handler.

*/
qt_QSize * kde_KPanelExtension_sizeHint(kde_KPanelExtension* instPointer,int arg1, qt_QSize * maxsize);

/** 
 Always use this @ref KConfig object to save/load your extensions configuration.

 For unique extensions this config object will write to a config file called
 <extensionname>rc in the users local KDE directory.

 For normal extensions this config object will write to a instance specific config file
 called <extensionname><instanceid>rc in the users local KDE directory.

*/
kde_KConfig* kde_KPanelExtension_config(kde_KPanelExtension* instPointer);

/** 

*/
int kde_KPanelExtension_type(kde_KPanelExtension* instPointer);

/** 

*/
int kde_KPanelExtension_actions(kde_KPanelExtension* instPointer);

/** 
 Generic action dispatcher. Called  when the user selects an item
 from the extensions RMB menu.

 Reimplement this function to handle actions.

 For About, Help, Preferences and ReportBug use the convenience handlers
 ref about(), help(), preferences(), reportBug()

*/
void kde_KPanelExtension_action(kde_KPanelExtension* instPointer,int a);

/** 
 Reimplement this function to set a prefered dock position for your extension.
 The extension manager will try to place new instances of this extension according
 to this setting.

*/
int kde_KPanelExtension_preferedPosition(kde_KPanelExtension* instPointer);

/** 

*/
void kde_KPanelExtension_setPosition(kde_KPanelExtension* instPointer,int p);

/** 

*/
void kde_KPanelExtension_setAlignment(kde_KPanelExtension* instPointer,int a);

/** 
 Is called when the user selects "About" from the extensions RMB menu.
 Reimplement this function to launch a about dialog.

 Note that this is called only when your extension supports the About action.
 See @ref Action.

*/
void kde_KPanelExtension_about(kde_KPanelExtension* instPointer);

/** 
 Is called when the user selects "Help" from the extensions RMB menu.
 Reimplement this function to launch a manual or help page.

 Note that this is called only when your extension supports the Help action.
 See @ref Action.

*/
void kde_KPanelExtension_help(kde_KPanelExtension* instPointer);

/** 
 Is called when the user selects "Preferences" from the extensions RMB menu.
 Reimplement this function to launch a preferences dialog or kcontrol module.

 Note that this is called only when your extension supports the preferences action.
 See @ref Action.

*/
void kde_KPanelExtension_preferences(kde_KPanelExtension* instPointer);

/** 
 Is called when the user selects "Report bug" from the applet's RMB menu.
 Reimplement this function to launch a bug reporting dialog.

 Note that this is called only when your applet supports the ReportBug
 action.
 See @ref Action.

*/
void kde_KPanelExtension_reportBug(kde_KPanelExtension* instPointer);

/** 

*/
int kde_KPanelExtension_position(kde_KPanelExtension* instPointer);

/** 

*/
int kde_KPanelExtension_alignment(kde_KPanelExtension* instPointer);

/** 

*/
int kde_KPanelExtension_orientation(kde_KPanelExtension* instPointer);

/** 
 This extension has changed its position.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
void kde_KPanelExtension_positionChange(kde_KPanelExtension* instPointer,int arg1);

/** 
 This extension has changed its alignment.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
void kde_KPanelExtension_alignmentChange(kde_KPanelExtension* instPointer,int arg1);
void kde_KPanelExtension_virtual_hook(kde_KPanelExtension* instPointer,int identifier, void* data);

#endif
