/***************************************************************************
                            kde_KRFCDate.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRFCDATE
#define KDE_KRFCDATE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The KRFCDate class contains functions related to the parsing of dates.

 @author Waldo Bastian <bastian@kde.org>
 
 @short 
 The KRFCDate class contains functions related to the parsing of dates.
*/

/** 
 This function tries to parse a string containing a date/time in any
 of the formats specified by RFC822, RFC850, RFC1036, RFC1123 and RFC2822.

 If the date/time could not be parsed, 0 is returned.  If the
 parsed date is epoch, then epoch+1 is returned so that a valid
 date will not be confused with an improper date string.

 The date/time returned is converted to UTC.

    
*/
long kde_KRFCDate_parseDate( qt_QString * date);

/** 
 This function tries to parse a string containing a date/time in 
 any of the formats specified by http://www.w3.org/TR/NOTE-datetime

 This is a subset of the formats specified in ISO8601.

 If the date/time could not be parsed, 0 is returned.  If the
 parsed date is epoch, then epoch+1 is returned so that a valid
 date will not be confused with an improper date string.

 The date/time returned is converted to UTC.

    
*/
long kde_KRFCDate_parseDateISO8601( qt_QString * date);

/** 
 Returns the local timezone offset to UTC in seconds

   
*/
int kde_KRFCDate_localUTCOffset( );

/** 
 Returns a string representation of the given date and time formated
 in conformance to RFC2822.

   
*/
qt_QCString* kde_KRFCDate_rfc2822DateString( long utcTime, int utcOffset);

/** 
 Returns a string representation of the given date and time formated
 in conformance to RFC2822.

 Provided for convenience, the function is equivalent to
 rfc2822DateString(t, localUTCOffset()).

   
*/
qt_QCString* kde_KRFCDate_rfc2822DateString1( long utcTime);

#endif
