/***************************************************************************
                            kde_KURL.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURL
#define KDE_KURL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Represents and parses a URL.

 A prototypical URL looks like:
 <pre>
   protocol:/user:password@hostname:port/path/to/file.ext#reference
 </pre>

 KURL has some restrictions regarding the path
 encoding. KURL works internally with the decoded path and
 and encoded query. For example,
 <pre>
 http://localhost/cgi-bin/test%20me.pl?cmd=Hello%20you
 </pre>
 would result in a decoded path "/cgi-bin/test me.pl"
 and in the encoded query "?cmd=Hello%20you".
 Since path is internally always encoded you may @em not use
 "%00" in the path, although this is OK for the query.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Represents and parses a URL.
*/

/** 
 Constructs an empty URL.
   
*/
kde_KURL * kde_new_KURL();

/** 
 Destructs the KURL object.
   
*/
void kde_del_KURL( kde_KURL* p );

/** 
 Usual constructor, to construct from a string.

*/
kde_KURL * kde_new_KURL1(qt_QString * url, int encoding_hint);

/** 
 Constructor taking a char * @p url, which is an _encoded_ representation
 of the URL, exactly like the usual constructor. This is useful when
 then URL, in its encoded form, is strictly ascii.
   
*/
kde_KURL * kde_new_KURL2(char* url, int encoding_hint);

/** 
 Constructor taking a QCString @p url, which is an _encoded_ representation
 of the URL, exactly like the usual constructor. This is useful when
 then URL, in its encoded form, is strictly ascii.
   
*/
kde_KURL * kde_new_KURL3(qt_QCString* url, int encoding_hint);

/** 
 Copy constructor.
   
*/
kde_KURL * kde_new_KURL4(kde_KURL* u);

/** 
 Converts from a @ref QUrl.
   
*/
kde_KURL * kde_new_KURL5(qt_QUrl* u);

/** 
 Constructor allowing relative URLs.

*/
kde_KURL * kde_new_KURL6(kde_KURL* _baseurl, qt_QString * _rel_url, int encoding_hint);

/** 
 Returns the protocol for the URL (i.e., file, http, etc.).

*/
qt_QString * kde_KURL_protocol(kde_KURL* instPointer);

/** 
 Sets the protocol for the URL (i.e., file, http, etc.)

*/
void kde_KURL_setProtocol(kde_KURL* instPointer,qt_QString * _txt);

/** 
 Returns the decoded user name (login, user id, ...) included in the URL.

*/
qt_QString * kde_KURL_user(kde_KURL* instPointer);

/** 
 Sets the user name (login, user id, ...) included in the URL.

 Special characters in the user name will appear encoded in the URL.

*/
void kde_KURL_setUser(kde_KURL* instPointer,qt_QString * _txt);

/** 
 Test to see if this URL has a user name included in it.

*/
int kde_KURL_hasUser(kde_KURL* instPointer);

/** 
 Returns the decoded password (corresponding to @ref user()) included in the URL.

*/
qt_QString * kde_KURL_pass(kde_KURL* instPointer);

/** 
 Sets the password (corresponding to @ref user()) included in the URL.

 Special characters in the password will appear encoded in the URL.

*/
void kde_KURL_setPass(kde_KURL* instPointer,qt_QString * _txt);

/** 
 Test to see if this URL has a password included in it.

*/
int kde_KURL_hasPass(kde_KURL* instPointer);

/** 
 Returns the decoded hostname included in the URL.

*/
qt_QString * kde_KURL_host(kde_KURL* instPointer);

/** 
 Sets the hostname included in the URL.

 Special characters in the hostname will appear encoded in the URL.

*/
void kde_KURL_setHost(kde_KURL* instPointer,qt_QString * _txt);

/** 
 Test to see if this URL has a hostname included in it.

*/
int kde_KURL_hasHost(kde_KURL* instPointer);

/** 
 Returns the port number included in the URL.
 If there is no port number specified in the URL, returns 0.

*/
unsigned short kde_KURL_port(kde_KURL* instPointer);

/** 
 Sets the port number included in the URL.

*/
void kde_KURL_setPort(kde_KURL* instPointer,unsigned short _p);

/** 
 Returns the current decoded path. This does @em not include the query.
   
*/
qt_QString * kde_KURL_path(kde_KURL* instPointer);

/** 

*/
qt_QString * kde_KURL_path1(kde_KURL* instPointer,int _trailing);

/** 
 path This is considered to be decoded. This means: %3f does not become decoded
      and the ? does not indicate the start of the query part.
      The query is not changed by this function.
   
*/
void kde_KURL_setPath(kde_KURL* instPointer,qt_QString * path);

/** 
 Test to see if this URL has a path is included in it.

*/
int kde_KURL_hasPath(kde_KURL* instPointer);

/** 
 Resolves "." and ".." components in path.

 Some servers seem not to like the removal of extra '/'
 even though it is against the specification in RFC 2396.
   
*/
void kde_KURL_cleanPath(kde_KURL* instPointer,int cleanDirSeparator);

/** 
 This is useful for HTTP. It looks first for '?' and decodes then.
 The encoded path is the concatenation of the current path and the query.

*/
void kde_KURL_setEncodedPathAndQuery(kde_KURL* instPointer,qt_QString * _txt, int encoding_hint);
void kde_KURL_setEncodedPath(kde_KURL* instPointer,qt_QString * _txt, int encoding_hint);

/** 

*/
qt_QString * kde_KURL_encodedPathAndQuery(kde_KURL* instPointer,int _trailing, int _no_empty_path, int encoding_hint);

/** 

 The query should start with a '?'. If it doesn't '?' is prepended.

*/
void kde_KURL_setQuery(kde_KURL* instPointer,qt_QString * _txt, int encoding_hint);

/** 

*/
qt_QString * kde_KURL_query(kde_KURL* instPointer);

/** 
 The reference is @em never decoded automatically.
   
*/
qt_QString * kde_KURL_ref(kde_KURL* instPointer);

/** 
 Sets the reference part (everything after '#').

*/
void kde_KURL_setRef(kde_KURL* instPointer,qt_QString * _txt);

/** 

*/
int kde_KURL_hasRef(kde_KURL* instPointer);

/** 

*/
qt_QString * kde_KURL_htmlRef(kde_KURL* instPointer);

/** 

*/
qt_QString * kde_KURL_encodedHtmlRef(kde_KURL* instPointer);

/** 
 Sets the HTML-style reference.

*/
void kde_KURL_setHTMLRef(kde_KURL* instPointer,qt_QString * _ref);

/** 

*/
int kde_KURL_hasHTMLRef(kde_KURL* instPointer);

/** 

*/
int kde_KURL_isValid(kde_KURL* instPointer);

/** 

   
*/
int kde_KURL_isMalformed(kde_KURL* instPointer);

/** 

*/
int kde_KURL_isLocalFile(kde_KURL* instPointer);

/** 
 Adds encoding information to url.
   
*/
void kde_KURL_setFileEncoding(kde_KURL* instPointer,qt_QString * encoding);

/** 
 Returns encoding information from url.

*/
qt_QString * kde_KURL_fileEncoding(kde_KURL* instPointer);

/** 

*/
int kde_KURL_hasSubURL(kde_KURL* instPointer);

/** 
 Adds to the current path.
 Assumes that the current path is a directory. @p _txt is appended to the
 current path. The function adds '/' if needed while concatenating.
 This means it does not matter whether the current path has a trailing
 '/' or not. If there is none, it becomes appended. If @p _txt
 has a leading '/' then this one is stripped.

*/
void kde_KURL_addPath(kde_KURL* instPointer,qt_QString * _txt);

/** 
 Returns the value of a certain query item.

*/
qt_QString * kde_KURL_queryItem(kde_KURL* instPointer,qt_QString * _item);

/** 
 In comparison to @ref addPath() this function does not assume that the current path
 is a directory. This is only assumed if the current path ends with '/'.

 Any reference is reset.

*/
void kde_KURL_setFileName(kde_KURL* instPointer,qt_QString * _txt);

/** 

*/
qt_QString * kde_KURL_fileName(kde_KURL* instPointer,int _ignore_trailing_slash_in_path);

/** 

*/
qt_QString * kde_KURL_directory(kde_KURL* instPointer,int _strip_trailing_slash_from_result, int _ignore_trailing_slash_in_path);

/** 
 Changes the directory by descending into the given directory.
 It is assumed the current URL represents a directory.
 If @p dir starts with a "/" the
 current URL will be "protocol://host/dir" otherwise @p _dir will
 be appended to the path. @p _dir can be ".."
 This function won't strip protocols. That means that when you are in
 file:/dir/dir2/my.tgz#tar:/ and you do cd("..") you will
 still be in file:/dir/dir2/my.tgz#tar:/

*/
int kde_KURL_cd(kde_KURL* instPointer,qt_QString * _dir);

/** 

*/
qt_QString * kde_KURL_url(kde_KURL* instPointer,int _trailing, int encoding_hint);

/** 

*/
qt_QString * kde_KURL_prettyURL(kde_KURL* instPointer,int _trailing);

/** 
 Test to see if the KURL is empty.

*/
int kde_KURL_isEmpty(kde_KURL* instPointer);

/** 
 This function is useful to implement the "Up" button in a file manager for example.
 @ref cd() never strips a sub-protocol. That means that if you are in
 file:/home/x.tgz#gzip:/#tar:/ and hit the up button you expect to see
 file:/home. The algorithm tries to go up on the right-most URL. If that is not
 possible it strips the right most URL. It continues stripping URLs.
   
*/
kde_KURL* kde_KURL_upURL(kde_KURL* instPointer);

/** 
 Compares this url with @p u.

*/
int kde_KURL_cmp(kde_KURL* instPointer,kde_KURL* u, int ignore_trailing);

/** 

*/
int kde_KURL_isParentOf(kde_KURL* instPointer,kde_KURL* u);

/** 
 Splits nested URLs like file:/home/weis/kde.tgz#gzip:/#tar:/kdebase
 A URL like http://www.kde.org#tar:/kde/README.hml#ref1 will be split in
 http://www.kde.org and tar:/kde/README.html#ref1.
 That means in turn that "#ref1" is an HTML-style reference and not a new sub URL.
 Since HTML-style references mark
 a certain position in a document this reference is appended to every URL.
 The idea behind this is that browsers, for example, only look at the first URL while
 the rest is not of interest to them.

*/
//kde_List kde_KURL_split( qt_QString * _url);

/** 
 A convenience function.
   
*/
//kde_List kde_KURL_split1( kde_KURL* _url);

/** 
 Reverses @ref split(). Only the first URL may have a reference. This reference
 is considered to be HTML-like and is appended at the end of the resulting
 joined URL.
   
*/
//kde_KURL* kde_KURL_join( kde_List* _list);

/** 
 Convenience function.

 Convert unicoded string to local encoding and use %-style
 encoding for all common delimiters / non-ascii characters.

*/
qt_QString * kde_KURL_encode_string( qt_QString * str, int encoding_hint);

/** 
 Convenience function.

 Convert unicoded string to local encoding and use %-style
 encoding for all common delimiters / non-ascii characters
 as well as the slash '/'.

*/
qt_QString * kde_KURL_encode_string_no_slash( qt_QString * str, int encoding_hint);

/** 
 Convenience function.

 Decode %-style encoding and convert from local encoding to unicode.

 Reverse of encode_string()

*/
qt_QString * kde_KURL_decode_string( qt_QString * str, int encoding_hint);

/** 
 Convenience function.

 Returns whether '_url' is likely to be a "relative" URL instead of
 an "absolute" URL.

*/
int kde_KURL_isRelativeURL( qt_QString * _url);
void kde_KURL_reset(kde_KURL* instPointer);
void kde_KURL_parse(kde_KURL* instPointer,qt_QString * _url, int encoding_hint);

#endif
