/***************************************************************************
                            kde_KURLLabel.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURLLABEL
#define KDE_KURLLABEL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A label class that supports displaying an active hyperlink.

 KURLLabel is a drop-in replacement for QLabel that handles text
 in a fashion similar to how an HTML widget handles hyperlinks.  The
 text can be underlined (or not) and set to different colors.  It
 can also "glow" (cycle colors) when the mouse passes over it.

 KURLLabel also provides signals for several events, including
 the mouse leaving and entering the text area and all forms of
 mouse clicking.

 A typical usage would be something like so:

 <PRE>
     KURLLabel *address = new KURLLabel(this);
     address->setText("My homepage");
     address->setURL("http://www.home.com/~me");
     connect(address, SIGNAL(leftClickedURL(const QString&)),
                      SLOT(processMyURL(const QString&)));
 </PRE>

 In this example, the text "My homepage" would be displayed
 as blue, underlined text.  When the mouse passed over it, 
 it would "glow" red.  When the user clicks on the text, the
 signal @ref leftClickedURL() would be emitted with "http://www.home.com/~me"
 as its argument.

 
 @author Peter Putzer <putzer@kde.org> (Rewrite)

 @version $Id: kde_KURLLabel.h,v 1.3 2002/02/21 00:43:13 rdale Exp $

 @short A drop-in replacement for QLabel that displays hyperlinks.

*/

/** 
 Default constructor.

 Use @ref #setURL() and @ref #setText() or @ref QListView::setPixmap()
 to set the resp. properties.
   
*/
kde_KURLLabel * kde_new_KURLLabel(qt_QWidget * parent, char* name);

/** 
 Convenience constructor.

 @p parent and @p name are passed to @ref QLabel.
   
*/
kde_KURLLabel * kde_new_KURLLabel1(qt_QString * url, qt_QString * text, qt_QWidget * parent, char* name);

/** 
 Destructs the label.
   
*/
void kde_del_KURLLabel( kde_KURLLabel* p );

/** 
 Returns the URL.
   
*/
qt_QString * kde_KURLLabel_url(kde_KURLLabel* instPointer);

/** 
 Returns the current tooltip text.
   
*/
qt_QString * kde_KURLLabel_tipText(kde_KURLLabel* instPointer);

/** 

*/
int kde_KURLLabel_useTips(kde_KURLLabel* instPointer);

/** 

*/
int kde_KURLLabel_useCursor(kde_KURLLabel* instPointer);

/** 
 When this is on, the text will switch to the selected 
 color whenever the mouse passes over it.
   
*/
int kde_KURLLabel_isGlowEnabled(kde_KURLLabel* instPointer);

/** 
 This feature is very similar to the "glow" feature in that the color of the
 label switches to the selected color when the cursor passes
 over it. In addition, underlining is turned on for as
 long as the mouse is overhead. Note that if "glow" and
 underlining are both already turned on, this feature
 will have no visible effect.
   
*/
int kde_KURLLabel_isFloatEnabled(kde_KURLLabel* instPointer);

/** 

*/
qt_QPixmap * kde_KURLLabel_altPixmap(kde_KURLLabel* instPointer);

/** 
 Turns on or off the underlining.

  When this is on, the
 text will be underlined.  By default, it is @p true.
   
*/
void kde_KURLLabel_setUnderline(kde_KURLLabel* instPointer,int on);

/** 
 Sets the URL for this label to @p url.

*/
void kde_KURLLabel_setURL(kde_KURLLabel* instPointer,qt_QString * url);

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/
void kde_KURLLabel_setFont(kde_KURLLabel* instPointer,qt_QFont * arg1);

/** 
 Turns on or off the tool tip feature.

 When this is on, the URL will be displayed as a
 tooltip whenever the mouse passes passes over it.
 By default, it is @p false.
   
*/
void kde_KURLLabel_setUseTips(kde_KURLLabel* instPointer,int on);

/** 
 Specifies what text to display when tooltips are turned on.

 If this is not used, the tip will default to the URL.

*/
void kde_KURLLabel_setTipText(kde_KURLLabel* instPointer,qt_QString * tip);

/** 
 Sets the highlight color.

 This is the default foreground
 color (non-selected).  By default, it is @p blue.
   
*/
void kde_KURLLabel_setHighlightedColor(kde_KURLLabel* instPointer,qt_QColor * highcolor);

/** 
 This is an overloaded version for convenience.

*/
void kde_KURLLabel_setHighlightedColor1(kde_KURLLabel* instPointer,qt_QString * highcolor);

/** 
 Sets the selected color.

 This is the color the text will change
 to when either a mouse passes over it and "glow" mode is on or
 when it is selected (clicked).  By default, it is @p red.
   
*/
void kde_KURLLabel_setSelectedColor(kde_KURLLabel* instPointer,qt_QColor * selcolor);

/** 
 This is an overloaded version for convenience.

*/
void kde_KURLLabel_setSelectedColor1(kde_KURLLabel* instPointer,qt_QString * selcolor);

/** 
 Turns the custom cursor feature on or off.

 When this is on, the cursor will change to a custom cursor
 (default is a "pointing hand") whenever the cursor passes
 over the label. By default, it is on.

*/
void kde_KURLLabel_setUseCursor(kde_KURLLabel* instPointer,int on, qt_QCursor * cursor);

/** 
 Turns on or off the "glow" feature. 

 When this is on, the text will switch to the
 selected color whenever the mouse
 passes over it. By default, it is @p true.
   
*/
void kde_KURLLabel_setGlow(kde_KURLLabel* instPointer,int glow);

/** 
 Turns on or off the "float" feature.

 This feature is very similar to the "glow" feature in
 that the color of the label switches to the selected 
 color when the cursor passes over it. In addition,
 underlining is turned on for as long as the mouse is overhead.
 Note that if "glow" and underlining are both already turned
 on, this feature will have no visible effect.
 By default, it is @p false.
   
*/
void kde_KURLLabel_setFloat(kde_KURLLabel* instPointer,int do_float);

/** 
 Sets the "alt" pixmap. 

 This pixmap will be displayed when the
 cursor passes over the label.  The effect is similar to the
 trick done with 'onMouseOver' in javascript.

*/
void kde_KURLLabel_setAltPixmap(kde_KURLLabel* instPointer,qt_QPixmap * altPix);

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/

/** 
 Overridden for internal reasons; the API remains unaffected.
   
*/

#endif
