/***************************************************************************
                            kde_PtyProcess.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_PTYPROCESS
#define KDE_PTYPROCESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Synchronous communication with tty programs.

 PtyProcess provides synchronous communication with tty based programs. 
 The communications channel used is a pseudo tty (as opposed to a pipe) 
 This means that programs which require a terminal will work.
 
 @short 
 Synchronous communication with tty programs.
*/
kde_PtyProcess * kde_new_PtyProcess();
void kde_del_PtyProcess( kde_PtyProcess* p );

/** 
 Forks off and execute a command. The command's standard in and output 
 are connected to the pseudo tty. They are accessible with @ref #readLine 
 and @ref #writeLine.

*/
//int kde_PtyProcess_exec(kde_PtyProcess* instPointer,qt_QCString* command, QCStringList args);

/** 
 Reads a line from the program's standard out. Depending on the @em block 
 parameter, this call blocks until a single, full line is read. 

*/
qt_QCString* kde_PtyProcess_readLine(kde_PtyProcess* instPointer,int block);

/** 
 Writes a line of text to the program's standard in.

*/
void kde_PtyProcess_writeLine(kde_PtyProcess* instPointer,qt_QCString* line, int addNewline);

/** 
 Puts back a line of input.

*/
void kde_PtyProcess_unreadLine(kde_PtyProcess* instPointer,qt_QCString* line, int addNewline);

/** 
 Sets the exit string. If a line of program output matches this,
 @ref #waitForChild() will terminate the program and return.
     
*/
void kde_PtyProcess_setExitString(kde_PtyProcess* instPointer,qt_QCString* exit);

/** 
 Waits for the child to exit. See also @ref #setExitString.
     
*/
int kde_PtyProcess_waitForChild(kde_PtyProcess* instPointer);

/** 
 Waits until the pty has cleared the ECHO flag. This is usefull 
 when programs write a password prompt before they disable ECHO.
 Disabling it might flush any input that was written.
     
*/
int kde_PtyProcess_WaitSlave(kde_PtyProcess* instPointer);

/**  Enables/disables local echo on the pseudo tty. 
*/
int kde_PtyProcess_enableLocalEcho(kde_PtyProcess* instPointer,int enable);

/**  Enables/disables terminal output. Relevant only to some subclasses. 
*/
void kde_PtyProcess_setTerminal(kde_PtyProcess* instPointer,int terminal);

/**  Overwrites the password as soon as it is used. Relevant only to
 some subclasses. 
*/
void kde_PtyProcess_setErase(kde_PtyProcess* instPointer,int erase);

/**  Set additinal environment variables. 
*/
//void kde_PtyProcess_setEnvironment(kde_PtyProcess* instPointer,QCStringList env);

/**  Returns the filedescriptor of the process. 
*/
int kde_PtyProcess_fd(kde_PtyProcess* instPointer);

/**  Returns the pid of the process. 
*/
int kde_PtyProcess_pid(kde_PtyProcess* instPointer);

#endif
