package org.kde.koala;
import org.kde.qt.*;


/** {@link DCOPClient} emits these signals */
public interface DCOPClientSignals {

/** 
 Indicates that the formerly registered application <code>appId</code> has
 been removed.

 You need to call {@link DCOPClient#setNotifications} first, to tell the {@link DCOPServer} that you want to get these events.
   
*/
	void applicationRemoved( String appId );
	void destroyed( QObject obj );

/** 
 Indicates that the process of establishing DCOP communications failed
 in some manner.

  Usually attached to a dialog box or some other visual
 aid.
   
*/
	void attachFailed( String msg );

/** 
 Indicates that user input shall be blocked or released,
 depending on the argument.

 The signal is emitted whenever the client has to wait too long
 (i.e. more than 1/10 of a second) for an answer to a
 synchronous call. In that case, it will enter a local event
 loop to keep the GUI updated until finally an answer arrives.

 In KDE, the {@link KApplication} object connects to this signal to be
 able to block any user input (i.e. mouse and key events) while
 we are waiting for an answer. If we did not do this, the
 application might end up in an illegal state, as a keyboard
 shortcut or a mouse action might cause another dcop call to be
 issued.
   
*/
	void blockUserInput( boolean arg1 );

/** 
 Indicates that the application <code>appId</code> has been registered with
 the server we are attached to.

 You need to call {@link DCOPClient#setNotifications} first, to tell the {@link DCOPServer}
 that you want to get these events.
   
*/
	void applicationRegistered( String appId );
}

