/***************************************************************************
                            HTMLLinkElement.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> LINK </code> element specifies a link to an external
 resource, and defines this document's relationship to that resource
 (or vice versa). See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#edef-LINK">
 LINK element definition </a> in HTML 4.0.

 
 @short 
 The <code> LINK </code> element specifies a link to an external
 resource, and defines this document's relationship to that resource
 (or vice versa).
*/
public class HTMLLinkElement extends HTMLElement  {
	protected HTMLLinkElement(Class dummy){super((Class) null);}

	private native void newHTMLLinkElement();
	public HTMLLinkElement() {
		super((Class) null);
		newHTMLLinkElement();
	}
	private native void newHTMLLinkElement( HTMLLinkElement other);
	public HTMLLinkElement( HTMLLinkElement other) {
		super((Class) null);
		newHTMLLinkElement( other);
	}
	private native void newHTMLLinkElement( DOMNode other);
	public HTMLLinkElement( DOMNode other) {
		super((Class) null);
		newHTMLLinkElement( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Enables/disables the link. This is currently only used for
 style sheet links, and may be used to activate or deactivate
 style sheets.

     
*/
	public native boolean disabled();

/** 
 see {@link disabled}
     
*/
	public native void setDisabled( boolean arg1);

/** 
 The character encoding of the resource being linked to. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-charset">
 charset attribute definition </a> in HTML 4.0.

     
*/
	public native String charset();

/** 
 see {@link charset}
     
*/
	public native void setCharset( String arg1);

/** 
 The URI of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-href">
 href attribute definition </a> in HTML 4.0.

     
*/
	public native String href();

/** 
 see {@link href}
     
*/
	public native void setHref( String arg1);

/** 
 Language code of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-hreflang">
 hreflang attribute definition </a> in HTML 4.0.

     
*/
	public native String hreflang();

/** 
 see {@link hreflang}
     
*/
	public native void setHreflang( String arg1);

/** 
 Designed for use with one or more target media. See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.html#adef-media">
 media attribute definition </a> in HTML 4.0.

     
*/
	public native String media();

/** 
 see {@link media}
     
*/
	public native void setMedia( String arg1);

/** 
 Forward link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rel">
 rel attribute definition </a> in HTML 4.0.

     
*/
	public native String rel();

/** 
 see {@link rel}
     
*/
	public native void setRel( String arg1);

/** 
 Reverse link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rev">
 rev attribute definition </a> in HTML 4.0.

     
*/
	public native String rev();

/** 
 see {@link rev}
     
*/
	public native void setRev( String arg1);

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">
 target attribute definition </a> in HTML 4.0.

     
*/
	public native String target();

/** 
 see {@link target}
     
*/
	public native void setTarget( String arg1);

/** 
 Advisory content type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-type-A">
 type attribute definition </a> in HTML 4.0.

     
*/
	public native String type();

/** 
 see {@link type}
     
*/
	public native void setType( String arg1);

/** 
 Introduced in DOM Level 2
 This method is from the LinkStyle interface

 The style sheet.
     
*/
	public native StyleSheet sheet();
}
