/***************************************************************************
                            KIntNumInput.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KIntNumInput combines a {@link QSpinBox} and optionally a {@link QSlider}
 with a label to make an easy to use control for setting some integer
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KIntNumInput, designed specifically for
 the situation when there are several KIntNumInputs in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses {@link KIntValidator} validator class. KIntNumInput enforces the
 value to be in the given range, and can display it in any base
 between 2 and 36.

 See {@link KIntNumInputSignals} for signals emitted by KIntNumInput.

 See {@link KIntNumInputEventHandling} for event handlers to override in subclasses of KIntNumInput.

 @version $Id: KIntNumInput.java,v 1.5 2002/01/31 04:48:57 rdale Exp $
 
 @short An input widget for integer numbers, consisting of a spinbox and a slider.

*/
public class KIntNumInput extends KNumInput  {
	protected KIntNumInput(Class dummy){super((Class) null);}

	private native void newKIntNumInput( QWidget parent, String name);

/** 
 Constructs an input control for integer values
 with base 10 and initial value 0.
     
*/
	public KIntNumInput( QWidget parent, String name) {
		super((Class) null);
		newKIntNumInput( parent, name);
	}
	private native void newKIntNumInput();
	public KIntNumInput() {
		super((Class) null);
		newKIntNumInput();
	}
	private native void newKIntNumInput( int value, QWidget parent, int base, String name);

/** 
 Constructor
 It constructs a QSpinBox that allows the input of integer numbers
 in the range of -INT_MAX to +INT_MAX. To set a descriptive label,
 use setLabel(). To enforce the value being in a range and optionally to
 attach a slider to it, use setRange().

*/
	public KIntNumInput( int value, QWidget parent, int base, String name) {
		super((Class) null);
		newKIntNumInput( value, parent, base, name);
	}
	private native void newKIntNumInput( int value);
	public KIntNumInput( int value) {
		super((Class) null);
		newKIntNumInput( value);
	}
	private native void newKIntNumInput( KNumInput below, int value, QWidget parent, int base, String name);

/** 
 Constructor

 the difference to the one above is the "below" parameter. It tells
 this instance that it is visually put below some other KNumInput widget.
 Note that these two KNumInput's need not to have the same parent widget
 or be in the same layout group.
 The effect is that it'll adjust it's layout in correspondence
 with the layout of the other KNumInput's (you can build an arbitary long
 chain).

*/
	public KIntNumInput( KNumInput below, int value, QWidget parent, int base, String name) {
		super((Class) null);
		newKIntNumInput( below, value, parent, base, name);
	}
	private native void newKIntNumInput( KNumInput below, int value);
	public KIntNumInput( KNumInput below, int value) {
		super((Class) null);
		newKIntNumInput( below, value);
	}

/** 
 Destructor

     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native int value();

/** 

*/
	public native String suffix();

/** 

*/
	public native String prefix();

/** 

*/
	public native String specialValueText();

/** 

*/
	public native void setRange( int min, int max, int step, boolean slider);
	public native void setRange( int min, int max);

/** 
 Sets the minimum value.
     
*/
	public native void setMinValue( int min);

/** 

*/
	public native int minValue();

/** 
 Sets the maximum value.
     
*/
	public native void setMaxValue( int max);

/** 

*/
	public native int maxValue();

/** 
 Sets the special value text. If set, the SpinBox will display
 this text instead of the numeric value whenever the current
 value is equal to minVal(). Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
	public native void setSpecialValueText( String text);

/** 
 This method returns the minimum size necessary to display the
 control. The minimum size is enough to show all the labels
 in the current font (font change may invalidate the return value).

*/
	public native QSize minimumSizeHint();

/** 
 Sets the value of the control.
     
*/
	public native void setValue( int arg1);

/** 
 Sets the suffix to <code>suffix.</code>
 Use String.null to disable this feature.
 Formatting has to be provided (e.g. a space separator between the
 prepended <code>value</code> and the suffix's text has to be provided
 as the first character in the suffix).

*/
	public native void setSuffix( String suffix);

/** 
 Sets the prefix to <code>prefix.</code>
 Use String.null to disable this feature.
 Formatting has to be provided (see above).

*/
	public native void setPrefix( String prefix);

/** 
 sets focus to the edit widget and marks all text in if mark == true

     
*/
	public native void setEditFocus( boolean mark);
	public native void setEditFocus();
}
