/***************************************************************************
                            KNotifyClient.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This namespace provides a method for issuing events to a KNotifyServer
 call KNotifyClient.event("eventname"); to issue it.
 On installation, there should be a file called
 $KDEDIR/share/apps/appname/eventsrc which contains the events.

 The file looks like this:
 <pre>
 [!Global!]
 IconName=Filename (e.g. kdesktop, without any extension)
 Comment=FriendlyNameOfApp

 [eventname]
 Name=FriendlyNameOfEvent
 Comment=Description Of Event
 default_sound=filetoplay.wav
 default_presentation=1
  ...
 </pre>
 default_presentation contains these ORed events:
	None=0, Sound=1, Messagebox=2, Logfile=4, Stderr=8

 You can also use the "nopresentation" key, with any the presentations
 ORed.  Those that are in that field will not appear in the kcontrol
 module.  This was intended for software like KWin to not allow a window-opening
 that opens a window (e.g., allowing to disable KMessageBoxes from appearing)
 If the user edits the eventsrc file manually, it will appear.  This only
 affects the KcmNotify.

 You can also use the following events, which are system controlled
 and do not need to be placed in your eventsrc:

<ul>
 <li>cannotopenfile
 <li>notification
 <li>warning
 <li>fatalerror
 <li>catastrophe
</ul>

 @author Charles Samuels <charles@kde.org>
 
 @short 
 This namespace provides a method for issuing events to a KNotifyServer
 call KNotifyClient::event("eventname"); to issue it.
*/
public class  KNotifyClient implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KNotifyClient(Class dummy){}


/** 
 This starts the KNotify Daemon, if it's not already started.
 This will be useful for games that use sound effects. Run this
 at the start of the program, and there won't be a pause when it is
 first triggered.

*/
	public native boolean startDaemon();

/** 
 This should be the most used method in here.
 Call it by KNotifyClient.event("EventName");
 It will use KApplication.kApplication.dcopClient() to communicate to
 the server

*/
	public native boolean event( String message, String text);
	public native boolean event( String message);

/** 
 Allows to easily emit standard events.

*/
	public native boolean event( int event, String text);
	public native boolean event( int event);

/** 
 Will fire an event that's not registered.

*/
	public native boolean userEvent( String text, int present, int level, String sound, String file);
	public native boolean userEvent();

/** 
 This is a simple substitution for QApplication.beep().
 It simply calls
 <pre>
 KNotifyClient.event( KNotifyClient.notification, reason );
 </pre>
	 
*/
	public native void beep( String reason);
	public native void beep();

/** 
 Gets the presentation associated with a certain event name
 Remeber that they may be ORed:
 if (present & KNotifyClient.Sound) { [Yes, sound is a default] }	
	 
*/
	public native int getPresentation( String eventname);

/** 
 Gets the default file associated with a certain event name
 The control panel module will list all the event names
 This has the potential for being slow.
	 
*/
	public native String getFile( String eventname, int present);

/** 
 Gets the default presentation for the event of this program.
 Remember that the Presentation may be ORed.  Try this:
 if (present & KNotifyClient.Sound) { [Yes, sound is a default] }
	 
*/
	public native int getDefaultPresentation( String eventname);

/** 
 Gets the default File for the event of this program.
 It gets it in relation to present.
 Some events don't apply to this function ("Message Box")
 Some do (Sound)
	 
*/
	public native String getDefaultFile( String eventname, int present);

/** 
 Shortcut to KNotifyClient.Instance.current() :)

*/
	public native KInstanceInterface instance();
	public static final int Default = -1;
	public static final int None = 0;
	public static final int Sound = 1;
	public static final int Messagebox = 2;
	public static final int Logfile = 4;
	public static final int Stderr = 8;
	public static final int Notification = 1;
	public static final int Warning = 2;
	public static final int Error = 4;
	public static final int Catastrophe = 8;
	public static final int cannotOpenFile = 0;
	public static final int notification = 1;
	public static final int warning = 2;
	public static final int fatalError = 3;
	public static final int catastrophe = 4;
}
