/***************************************************************************
                            KCharSelect.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCHARSELECT_H
#define KCHARSELECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QVBox.h>

/**

 A Widget which allows the user to select a character of a
 specified font in a table

 You can specify the font whoes characters should be displayed via
 @ref -setFont. Using @ref -enableFontCombo you can allow the
 user to choose the font from a combob-box. As only 256 characters
 are displayed at once in the table, using the spinbox on the top
 the user can choose starting from which chracater the table
 displayes them. This spinbox also can be enabled or disabled using
 @ref -enableTableSpinBox.

 KCharSelect supports keyboard and mouse navigation. Click+Move
 selects always the character below the mouse cursor. Using the
 arrow keys the focus mark is moved around and with pressing RETURN
 or SPACE the cell which contains the focus mark gets selected.

 To get the current selected character, use the @ref -chr
 method. You can set the character which should be displayed with
 @ref -setChar and the table number which should be displayed with
 @ref -setTableNum.

 @author Reginald Stadlbauer <reggie@kde.org>
 
 @version $Id: KCharSelect.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short Character-Selection Widget.
*/
@interface KCharSelect : QVBox 

/** 
 Constructor. @p font specifies which font should be displayed, @p
 chr which character should be selected and @p tableNum specifies
 the number of the table which should be displayed.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name font: (NSString *)font chr: (unichar *)chr tableNum: (int)tableNum;
- initWithWidget: (QWidget *)parent name: (NSString *)name ;

/** 
 Reimplemented.
     
*/
- (QSize*) sizeHint;

/** 
 Sets the font which is displayed to @p font
     
*/
- setFont: (NSString *)font;

/** 
 Sets the currently selected character to @p chr.
     
*/
- setChar: (unichar *)chr;

/** 
 Sets the currently displayed table to @p tableNum.
     
*/
- setTableNum: (int)tableNum;

/** 
 Returns the currently selected character.
     
*/
- (unichar*) chr;

/** 
 Returns the currently displayed font.
     
*/
- (NSString *) font;

/** 
 Returns the currently displayed table
     
*/
- (int) tableNum;

/** 
 If @p e is set to TRUE, the combobox which allows the user to
 select the font which should be displayed is enabled, else
 disabled.
     
*/
- enableFontCombo: (BOOL)e;

/** 

 If @p e is set to TRUE, the spinbox which allows the user to
 specify which characters of the font should be displayed, is
 enabled, else disabled.
     
*/
- enableTableSpinBox: (BOOL)e;

/** 
 Returns wether the font combobox on the top is enabled or
 disabled.

*/
- (BOOL) isFontComboEnabled;

/** 
 Returns wether the table spinbox on the top is enabled or
 disabled.

*/
- (BOOL) isTableSpinBoxEnabled;
- fillFontCombo;
- fontSelected: (NSString *)_font;
- tableChanged: (int)_value;
- charHighlighted: (unichar *)c;
- charHighlighted;
- charActivated: (unichar *)c;
- charActivated;
- charFocusItemChanged;
- charFocusItemChanged: (unichar *)c;
- charTableUp;
- charTableDown;
- slotDoubleClicked;
//+ cleanupFontDatabase;
@end

/** Override these methods in subclasses of KCharSelect to customise event handling behaviour */
@protocol KCharSelectEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
