/***************************************************************************
                            KFontCombo.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFONTCOMBO_H
#define KFONTCOMBO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KComboBox.h>

/**

 A combobox that lists the available fonts.

 The items are painted using the respective font itself, so the user
 can easily choose a font based on its look. This can be turned off
 globally if the user wishes so.

 @author Malte Starostik <malte.starostik@t-online.de>

 @version $Id: KFontCombo.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short A combobox to choose a font.
*/
@interface KFontCombo : KComboBox 

/** 
 Constructor

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;

/** 
 Constructor that takes an already initialzed font list

*/
- initWithArray: (NSArray *)fonts parent: (QWidget *)parent name: (NSString *)name;
- initWithArray: (NSArray *)fonts parent: (QWidget *)parent ;

/** 
 Destructor
     
*/
- (void) dealloc;

/** 
 Sets the font list.

*/
- setFonts: (NSArray *)fonts;

/** 
 Sets the currently selected font.

*/
- setCurrentFont: (NSString *)family;

/** 

*/
- (NSString *) currentFont;

/** 
 Sets the listed fonts to bold or normal.

*/
- setBold: (BOOL)bold;

/** 
 Returns the current bold status.

*/
- (BOOL) bold;

/** 
 Sets the listed fonts to italic or regular.

*/
- setItalic: (BOOL)bold;

/** 
 Returns the current italic status

*/
- (BOOL) italic;

/** 
 Sets the listed fonts to underlined or not underlined

*/
- setUnderline: (BOOL)bold;

/** 
 Returns the current underline status

*/
- (BOOL) underline;

/** 
 Sets the listed fonts to striked out or not

*/
- setStrikeOut: (BOOL)bold;

/** 
 Returns the current strike out status

*/
- (BOOL) strikeOut;

/** 
 Sets the listed fonts' size

*/
- setSize: (int)size;

/** 
 Returns the current font size

*/
- (int) size;
- setCurrentItem: (int)i;

/** 
 Returns the user's setting of whether the items should be painted
 in the respective fonts or not

*/
+ (BOOL) displayFonts;

/** 
 Updated the combo's @ref -listBox to reflect changes made to the
 fonts' attributed
     
*/
- updateFonts;
@end

/** Override these methods in subclasses of KFontCombo to customise event handling behaviour */
@protocol KFontComboEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
