#ifndef COMMON_FIELD_H
#define COMMON_FIELD_H

#include <qlcdnumber.h>

#include "kgameprogress.h"

#include "lib/mp_simple_board.h"
#include "base/field.h"
#include "types.h"


class ShowNextPiece;
class GiftShower;
class Shadow;
class LCD;

class Field : public MPSimpleBoard, public BaseField
{
 Q_OBJECT
 public:
    Field(QWidget *parent);
    ~Field();

    QSizePolicy sizePolicy() const;

 public slots:
	void pMoveLeft();
	void pMoveRight();
	void pDropDown();
	void pOneLineDown();
	void pRotateLeft();
	void pRotateRight();

    void settingsChanged();

 private slots:
    void scoreUpdatedSlot(int score) { scoreUpdated(score); }

 private:
    ShowNextPiece *showNext;
    LCDList       *showLevel;
    QLabel        *prevName, *nextName, *labShowNext;
    KGameProgress     *prevHeight, *nextHeight;
	GiftShower    *giftReceived, *giftSent;
	Shadow        *shadow;
    KCanvasRootPixmap *_snRootPixmap;
    ClientPlayData _cpd;

    void _init(bool AI, bool multiplayer, bool server, bool first,
               const QString &name);
    void showOpponents(bool show);
    void showNextPiece(bool show);
    void showShadow(bool show);

    void _initFlag(QDataStream &);
	void _playFlag(QDataStream &);
    void _pauseFlag(bool pause);
	void _stopFlag(bool gameover) { BaseField::stop(gameover); }
	void _dataOut(QDataStream &);
	void _gameOverDataOut(QDataStream &);
	void _initDataOut(QDataStream &) {}

    KExtHighscores::Score currentScore() const;
};

#endif
