/***************************************************************************
                          kscribble.h  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCRIBBLE_H
#define KSCRIBBLE_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstrlist.h>
#include <qworkspace.h>

// include files for KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kimgio.h>

// forward declaration of the KScribble classes
class KScribbleDoc;
class KScribbleView;

/**
  * The base class for KScribble application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. In initView(), your main view is created as the MDI child window manager.
  * Child windows are created in createClient(), which gets a document instance as it's document to
  * display whereby one document can have several views.The MDI child is an instance of KScribbleView,
  * the document an instance of KScribbleDoc.
  * KScribbleApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.1 code generation
  */
class KScribbleApp : public KTMainWindow
{
  Q_OBJECT

  public:
    /** construtor of KScribbleApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    KScribbleApp();
    ~KScribbleApp();
    /** enables menuentries/toolbar items
     */
    void enableCommand(int id_);
    /** disables menuentries/toolbar items
     */
    void disableCommand(int id_);
    /** opens a file specified by commandline option
     */
    void openDocumentFile(const char *file=0);

  protected:
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this overridden function retrieves all modified documents
     * from the open document list and asks the user to select which files to save before exiting the application.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);
		/** event filter to catch close events for MDI child windows and is installed in createClient() on every child window.
			* Closing a window calls the eventFilter first which removes the view from the connected documents' view list. If the
			* last view is going to be closed, the eventFilter() tests if the document is modified; if yes, it asks the user to
			* save the document. If the document title contains "Untitled", slotFileSaveAs() gets called to get a save name and path.
		 */
		virtual bool eventFilter(QObject* object, QEvent* event);
		/** creates a new child window. The document that will be connected to it
		 * has to be created before and the instances filled, with e.g. openDocument().
		 * Then call createClient() to get a new MDI child window.
     * @see KScribbleDoc#addView
     * @see KScribbleDoc#openDocument
     * @param doc pointer to the document instance that the view will
     * be connected to.
     */
		void createClient(KScribbleDoc* doc);
    /** accepts drag events for images */
    virtual void dragEnterEvent( QDragEnterEvent* );
    /** accepts drops and opens a new document
      * for each drop */
    virtual void dropEvent( QDropEvent* );

  private slots:
  	/** sets the main application window title each time the active MDI child window changes. */
		void setWndTitle(QWidget*);
    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
    void statusCallback(int id_);
    /** add a opened file to the recent file list and update recent file menu*/
    void addRecentFile(const QString &file);
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(int id_);
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
		/** closes all documents and quits the application.*/
    void slotFileQuit();
		/** reverts the last user action for the active window */
    void slotEditUndo();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** clears the current document */
    void slotEditClearAll();
    /** sets the pen width */
    void slotPenBrush();
    /** sets the pen color */
    void slotPenColor();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
		/** creates a new view for the document in the active child window and adds the new view to the
		 * list of views the document maintains.
		 */
		void slotWindowNewWindow();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);
  	/** gets called when the window menu is activated; recreates the window menu with all opened window titles. */
    void windowMenuAboutToShow();
    /** activates the MDI child widget when it gets selected from the window menu. */
    void windowMenuActivated( int id );

  private:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
     * @see KAccel
     */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
     */
    void initMenuBar();
    /** this creates the toolbars.
     */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();

    /** Creates the main view of the KTMainWindow instance and initializes the MDI view area including any needed
    	* connections.
     */
    void initView();

    /** contains the recently used filenames */
    QStrList recentFiles;

    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;
    /** the recent file menu containing the last five opened files */
    QPopupMenu *pRecentFileMenu;
		/** the file menu */
		QPopupMenu* pFileMenu;
		/** the edit menu */
		QPopupMenu* pEditMenu;
		/** the pen menu */
    QPopupMenu* pPenMenu;		
		/** the view menu */
		QPopupMenu* pViewMenu;
    /** the window menu */
    QPopupMenu *pWindowMenu;
		/** pWorkspace is the MDI frame widget that handles MDI child widgets. Inititalized in
		 * initView()
		 */
    QWorkspace *pWorkspace;
		/** the printer instance */
    QPrinter *printer;
		/** a counter that gets increased each time the user creates a new document with "File"->"New" */
    int untitledCount;
    /** a list of all open documents. If the last window of a document gets closed, the installed eventFilter
     * removes this document from the list. The document list is checked for modified documents when the user
     * is about to close the application. */
    QList<KScribbleDoc> *pDocList;	

};
 
#endif // KSCRIBBLE_H
