/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rcsid[] = "@(#)$Id: ypmaplist.c,v 1.6 1994/01/02 20:08:15 root Exp $";
/*
 * $Author: root $
 * $Log: ypmaplist.c,v $
 * Revision 1.6  1994/01/02  20:08:15  root
 * Added GPL notice
 *
 * Revision 1.5  1994/01/01  21:53:24  root
 * Only needed, when YP_LIBC is defined
 *
 * Revision 1.4  1993/12/31  18:17:33  root
 * *** empty log message ***
 *
 * Revision 1.3  1993/12/31  18:15:54  root
 * *** empty log message ***
 *
 * Revision 1.2  1993/12/31  18:11:33  root
 * *** empty log message ***
 *
 * Revision 1.1  1993/12/31  18:08:55  root
 * Initial revision
 *
 */

#ifdef YP_LIBC
#include <rpc/rpc.h>
#include <rpc/xdr.h>
#include <rpcsvc/yp_prot.h>
#include <rpcsvc/ypclnt.h>

static CLIENT * UdpClient, TcpClient;

static inline
struct ypresp_maplist *
ypproc_maplist_2(argp, clnt)
        char *argp;
        CLIENT *clnt;
{
        static struct ypresp_maplist res;
	static struct timeval TIMEOUT={ 25, 0 };
 
        bzero(&res, sizeof(res));
        if (clnt_call(clnt, YPPROC_MAPLIST, xdr_domainname, argp, xdr_ypresp_maplist, &res, TIMEOUT) != RPC_SUCCESS) {
                return (NULL);
        }
        return (&res);
}
 
int

_yp_maplist(char *DomainName, struct ypmaplist **OutMaplist)
{
   struct ypresp_maplist *resp;
   struct ypmaplist *m;
   struct ypmaplist *r=NULL;
   struct dom_binding *ysd=NULL;
   int Status;

   do {
#if 0
      if (UdpClient==NULL)
         if (Status=yp_bind(DomainName)) return(Status);
#else
      __yp_dobind(DomainName, &ysd);
      UdpClient=ysd->dom_client;
#endif
      if ((resp=ypproc_maplist_2(DomainName, UdpClient))==NULL) {
         clnt_perror(UdpClient, "_yp_maplist");
         yp_unbind(DomainName);
      }
   } while(resp==NULL);
   if (resp->status!=YP_TRUE) {
      Status=ypprot_err(resp->status);
   } else {
      Status=0;
      for (m=resp->list; m; m=m->ypml_next) {
         struct ypmaplist *rr=r;
         r=malloc(sizeof (struct ypmaplist));
         if (!r) {
            Status=YP_YPERR;
            break;
         }
#if 0
         r->ypml_name=malloc(strlen(m->ypml_name)+1);
         if (!r->ypml_name) {
            Status=YP_YPERR;
            break;
         }
#endif
         strncpy(r->ypml_name, m->ypml_name, sizeof (r->ypml_name));
         r->ypml_next=rr;
      }
      (*OutMaplist)=NULL;
      if (!Status) while (r) {
         struct ypmaplist *rr=r->ypml_next;
         r->ypml_next=*OutMaplist;
         (*OutMaplist)=r;
         r=rr;
      }
   }
   clnt_freeres(UdpClient, xdr_ypresp_maplist, resp);
   yp_unbind(DomainName);

   return(Status);
}
#endif
